package org.pizarra.helpers {
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.events.*;
	
	public class SoundPlayer extends EventDispatcher{
		
		private var url:String;
		private var soundClip:Sound;
		private var ready: Boolean = false;
		
		// Generate the audio
		public function SoundPlayer(url: String) {

			this.url = url;
			soundClip = new Sound();
			soundClip.load(new URLRequest(url));
			soundClip.addEventListener(Event.COMPLETE, soundLoaded);
			soundClip.addEventListener(IOErrorEvent.IO_ERROR, onSoundIOError, false, 0, true);
		}
		
		public function Play() {
			soundClip.play();
		}
		
		function onSoundIOError (e:IOErrorEvent)
		{
			trace("An Error Occured and it looked like this.", e.text);
		}

		private function soundLoaded(ev: Event) {
			ready = true;
			dispatchEvent(new Event(Event.COMPLETE));
		}
		
		public function get Length(): int { return soundClip.length; }
	}
}