﻿package org.pizarra.graficos.trayectoria {
	import flash.display.Sprite;
	import flash.geom.Point;
	import org.pizarra.configuracion.Settings;
	
	public class BezierEntity extends Sprite {
		
		public function BezierEntity(puntos: Array, init: Point):void { 
			
			var pointArray = new Array();
			var dibujo = new Array();
			var elem = new Array();
			//var numPoints = _path.nPuntos;
			var numPoints = puntos.length - 1;
			var oData = new Object();
			
			for(var i:int = 1; i <= numPoints; i++){
				pointArray.push(puntos[i].punto);
				elem[i] = new Object();
				elem[i]["x"] = puntos[i].punto.x;
				elem[i]["y"] = puntos[i].punto.y;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(init.x, init.y);
			var point_1: Point = puntos[0].punto;
			elem[i] = new Object();
			elem[i]["x"] = point_1.x;
			elem[i]["y"] = point_1.y;
			dibujo.push(elem[i]);
			
			for(i = 0; i < pointArray.length; i++){
				oData["x"+i] = pointArray[i].x;
				oData["y"+i] = pointArray[i].y;
				oData["dx"+i] = ((i+1) == numPoints) ? point_1.x : pointArray[(i+1)].x;
				oData["dy"+i] = ((i+1) == numPoints) ? point_1.y : pointArray[(i+1)].y;
				oData["cx"+i] = (oData["x"+i]+oData["dx"+i])/2;
				oData["cy"+i] = (oData["y"+i]+oData["dy"+i])/2;
			}
			
			
			graphics.lineStyle(Settings.Line_ThickNess, Settings.Bez_color, 50);
			graphics.moveTo(point_0.x, point_0.y);
			for ( i=0; i < numPoints; i++) {
				graphics.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);
			}
			graphics.lineTo(point_1.x, point_1.y);
			
			/*if (_path.tipo == Trayectorias.T_CIRCULAR_DIS) {
				var dl = new DashedLine(dibujoBezier,1,5);
				dl.lineStyle(3,0x000000,1);
				dl.moveTo(point_0.x, point_0.y);
				for (i=0; i<numPoints; i++) {
					dl.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);		
				}
				dl.lineTo(point_1.x, point_1.y);
			}*/
		}	
	}
}