package org.pizarra.graficos {
	import fl.controls.Label;
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.text.*;
	import org.pizarra.configuracion.Tema;
	
	public class ImageButton extends Sprite {
		
		
		private var l: Loader = new Loader();
		private var disableSprite: Sprite = new Sprite();
		private var text: Label = new Label();
		private var Enabled: Boolean = true;
		
		public function ImageButton(url: String) {
			//	Load the image
			
			LoadImage(url);
			//LoadText(name);
			//DrawBackground();
			CreateDisabler();
			buttonMode = true;
		}
		
		/*	PUBLIC
		 **/
		public function set Enable(state: Boolean) {
			disableSprite.visible = !state;
		}
		 
		
		/*	PRIVATE FUNCTIONS
		 **/
		private function LoadImage(url: String): void {
			
			l.load(new URLRequest(url));
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			addChild(l);
		}
		
		private function LoadText(name: String): void {
			
			var myTextFormat:TextFormat = new TextFormat();
			myTextFormat.align = TextFormatAlign.CENTER;
			myTextFormat.size = 15;

			text.text = name;
			text.y = 40;
			text.x = 0;
			text.setStyle("textFormat", myTextFormat);
			text.width = 80;
			text.buttonMode = true;
			addChild(text);
		}
		
		private function DrawBackground() {
			
			//	Background
			this.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			this.graphics.beginFill(Tema.ButtonBackground);
            this.graphics.drawRoundRect(0, 0, 80, 55,20,20);
            this.graphics.endFill();
			
		}
		
		private function CreateDisabler(): void {
			
			disableSprite = new Sprite();
			disableSprite.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			disableSprite.graphics.beginFill(Tema.ButtonBackground, 0.5);
            disableSprite.graphics.drawRoundRect(0, 0, 80, 55,20,20);
            disableSprite.graphics.endFill();
			addChild(disableSprite);
			disableSprite.visible = false;
			disableSprite.addEventListener(MouseEvent.CLICK, clicked);
		}
		
		/*	HANDLERS
		 **/
		private function imgLoaded(event:Event):void {
			l.width = 40;
			l.height = 40;
		}
		
		private function clicked(event:Event): void {
			event.stopImmediatePropagation();
			event.stopPropagation();
		}
	}
}