﻿package org.pizarra.graficos {
	import fl.controls.Label;
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.IOErrorEvent;
	import flash.net.URLRequest;
	import flash.text.*;
	import org.pizarra.configuracion.Tema;
	import org.pizarra.util.Ficheros;
	
	public class Image extends Sprite {
		
		private var l: Loader = new Loader();
		private var disableSprite: Sprite = new Sprite();
		private var text: Label = new Label();
		private var Enabled: Boolean = true;
		private var _width: Number = 100.0;
		private var _height: Number = 100.0;
		
		public function Image(url: String, w: Number, h: Number) {
			//	Load the image
			_width = w;
			_height = h;
			LoadImage(url);
			//LoadText(name);
			//DrawBackground();
			CreateDisabler();
			//buttonMode = true;
		}
		
		/*	PUBLIC
		 **/
		public function set Enable(state: Boolean) {
			disableSprite.visible = !state;
		}
		 
		
		/*	PRIVATE FUNCTIONS
		 **/
		private function LoadImage(url: String): void {
			
			l.load(new URLRequest(url));
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			l.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, errorLoading);
			addChild(l);
		}
		
		private function LoadText(name: String): void {
			
			var myTextFormat:TextFormat = new TextFormat();
			myTextFormat.align = TextFormatAlign.CENTER;
			myTextFormat.size = 15;

			text.text = name;
			text.y = 40;
			text.x = 0;
			text.setStyle("textFormat", myTextFormat);
			text.width = 80;
			text.buttonMode = true;
			addChild(text);
		}
		
		private function DrawBackground() {
			
			//	Background
			this.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			this.graphics.beginFill(Tema.ButtonBackground);
            this.graphics.drawRoundRect(0, 0, 80, 55,20,20);
            this.graphics.endFill();
			
		}
		
		private function CreateDisabler(): void {
			
			disableSprite = new Sprite();
			disableSprite.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			disableSprite.graphics.beginFill(Tema.ButtonBackground, 0.5);
            disableSprite.graphics.drawRoundRect(0, 0, 80, 55,20,20);
            disableSprite.graphics.endFill();
			addChild(disableSprite);
			disableSprite.visible = false;
			disableSprite.addEventListener(MouseEvent.CLICK, clicked);
		}
		
		/*	HANDLERS
		 **/
		private function imgLoaded(event:Event):void {
			//l.x = 20;
			l.width = _width;
			l.height = _height;
		}
		
		private function errorLoading(ev: IOErrorEvent){
			trace("Error loading");
			// try to load default image
			l.load(new URLRequest(Ficheros.IMG_NOTFOUND));
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
		}
		
		private function clicked(event:Event): void {
			event.stopImmediatePropagation();
			event.stopPropagation();
		}
	}
}