﻿package org.pizarra.View{	

	import fl.events.SliderEvent;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import fl.controls.Slider;
	import fl.controls.SliderDirection;
	import fl.controls.Label;
	import org.pizarra.Animation.AnimationHelper;
	import org.pizarra.Animation.ExerciseAnimation;
	import org.pizarra.Entity.*;
	import org.pizarra.View.*;
	import org.pizarra.graficos.Image;
	import org.pizarra.graficos.ImageButton;
	import org.pizarra.graficos.TextImageButton;
	import org.pizarra.helpers.SoundPlayer;
	import org.pizarra.Pizarra;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.util.Constantes;
	import org.pizarra.Util;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filesystem.File;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import fl.transitions.*;
	import fl.transitions.easing.*;
	import org.pizarra.util.*;
	import com.greensock.*;
	import org.pizarra.configuracion.Tema;
	import fl.controls.TextInput;
	import fl.controls.CheckBox;
	
	import flash.utils.ByteArray;
	import com.adobe.images.PNGEncoder;
	import flash.display.BitmapData;
	import flash.net.URLRequestHeader;
	import flash.net.URLLoader;
	import flash.net.URLRequestMethod;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import flash.desktop.NativeApplication;
	import org.pizarra.graficos.Separator;
	
	public class VisorView extends View{
		
		private var p: Pizarra;
		private var pnBotonera: MovieClip;
		private var pnVideo: Sprite;
		private var fondo: Loader;
		
		private var _atras: Loader;
		private var _delante: Loader;
		private var _pausa: Loader;
		private var _play: Loader;
		private var _reverse: Loader;
		private var _slider: Slider,
					sliderSpeed: Slider;
					
		private var speedLabel: Label = new Label(),
					progressLabel: Label = new Label();
		
		private var ej: EjercicioBE;
		private var Elements: Array = new Array();
		
		private var btnInfo, btnBack, btnLoad: TextImageButton;
		private var els: Array = new Array();
		
		private var infoPanel: MovieClip = new MovieClip();
		private var cbShowPaths: CheckBox = new CheckBox()
					, cbShowPoints: CheckBox = new CheckBox();
		var ex :ExerciseAnimation;
		
		var img: Image = new Image(Ficheros.IMG_INFO, 100,100);
		var imgBD: BitmapData = new BitmapData(100,100);
		
		private var txtText: TextInput = new TextInput();
		private var txtName: Label = new Label()
					, txtInfo: Label = new Label();
		
		public function VisorView(piz: Pizarra): void {
			super((piz.urlEjercicio != null && piz.urlEjercicio != "")
				   ? "Importado" : "");
				 // ? "Importado" : piz.hEjercicios[piz.ejercicioSeleccionado].nombre);
			this.p = piz;
			inicializaComponentes();
			_play.addEventListener(MouseEvent.CLICK, play_Click);
			_pausa.addEventListener(MouseEvent.CLICK, pause_Click);
			_atras.addEventListener(MouseEvent.CLICK, atras_Click);
			_delante.addEventListener(MouseEvent.CLICK, delante_Click);
			_reverse.addEventListener(MouseEvent.CLICK, reverse_Click);
			slider.addEventListener(SliderEvent.CHANGE, changeTime);
			
			if(piz.urlEjercicio != null && piz.urlEjercicio != "") {
				
			} else {
				if(piz.ejercicioSeleccionado != null && piz.ejercicioSeleccionado != ""){
					ej = piz.hEjercicios[piz.ejercicioSeleccionado];
					ex = new ExerciseAnimation();
					ex.Init(ej, p.hFondos[ej.fondo], p.hElementos, p.UnsortedAcciones);
					ex.addEventListener(Event.COMPLETE, finishedLoading);
					ex.addEventListener(Event.CHANGE, frameChange);
					ex.x = 100; ex.y = 100;
					addChild(ex);
				}
			}

			//	Create info Panel
			createInfoPanel();
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function inicializaComponentes(){
			creaPanel();
			dibujaSlider();
			posicionaComandos();
			posicionaBotones();
			
			var myFormat: TextFormat = new TextFormat();
			myFormat.font = "Arial";
			myFormat.size = Tema.lblSize;
			myFormat.bold = true;
			myFormat.color = Tema.lblColor;
			
			cbShowPaths.label = "Muestra Trayectorias";
			cbShowPaths.width = 150;
			cbShowPaths.x = 20; cbShowPaths.y = 70;
			cbShowPaths.selected = true;
			cbShowPaths.addEventListener(Event.CHANGE, cbShowPaths_Change);
			cbShowPaths.textField.autoSize = TextFieldAutoSize.LEFT;
			cbShowPaths.setStyle("textFormat", myFormat);
			this.addChild(cbShowPaths);
			
			cbShowPoints.label = "Muestra Puntos";
			cbShowPoints.x = 400; cbShowPoints.y = 70;
			cbShowPoints.selected = true;
			cbShowPoints.textField.autoSize = TextFieldAutoSize.LEFT;
			cbShowPoints.setStyle("textFormat", myFormat);
			cbShowPoints.addEventListener(Event.CHANGE, cbShowPoints_Change);
			this.addChild(cbShowPoints);
			
			speedLabel.text = "X1";
			
			this.addChild(speedLabel);
		}
		
		private function creaPanel(){
			pnBotonera = new MovieClip(); 
			this.addChild(pnBotonera);
			pnBotonera.x = 200;
			pnBotonera.y = 500;
		}
		
		private function dibujaSlider(){
			_slider = new Slider();
			this.addChild(_slider);
			_slider.snapInterval = 100;
			_slider.minimum = 0.0;
			_slider.x = 50;
			_slider.y = 560;
			_slider.width = 900;
			_slider.liveDragging = true;
			
			sliderSpeed = new Slider();
			sliderSpeed.minimum = 0.5;
			sliderSpeed.maximum = 2.0;
			sliderSpeed.snapInterval = 0.5;
			sliderSpeed.value = 1.0;
			sliderSpeed.width = 200;
			sliderSpeed.x = 50;
			sliderSpeed.y = 575;
			sliderSpeed.liveDragging = true;
			sliderSpeed.addEventListener(Event.CHANGE, function(ev: Event){
				speedLabel.text = "X" + sliderSpeed.value;
				if(ex != null){
					ex.Speed = sliderSpeed.value;
				}
			});
			this.addChild(sliderSpeed);
			
			speedLabel.text = "X1";
			speedLabel.x = 270;
			speedLabel.y = 575;
			speedLabel.setStyle("textFormat", Tema.formatoLabel);
			this.addChild(speedLabel);
			
			progressLabel.text = "--:-- / --:--";
			progressLabel.x = 800;
			progressLabel.y = 575;
			progressLabel.setStyle("textFormat", Tema.formatoLabel);
			this.addChild(progressLabel);
		}
		
		private function posicionaComandos(){
			
			_atras = new Loader(); 
			var urlReq:URLRequest = new URLRequest(Ficheros.IMG_VISOR_ATRAS);
			_atras.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_atras.load(urlReq);
			pnBotonera.addChild(_atras);
			
			_delante = new Loader(); 
			urlReq = new URLRequest(Ficheros.IMG_VISOR_DELANTE);
			_delante.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_delante.load(urlReq);
			pnBotonera.addChild(_delante);
			
			_pausa = new Loader(); 
			urlReq = new URLRequest(Ficheros.IMG_VISOR_PAUSA);
			_pausa.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_pausa.load(urlReq);
			pnBotonera.addChild(_pausa);
			
			_play = new Loader(); 
			urlReq = new URLRequest(Ficheros.IMG_VISOR_PLAY);
			_play.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_play.load(urlReq);
			pnBotonera.addChild(_play);
			
			_reverse = new Loader(); 
			urlReq = new URLRequest(Ficheros.IMG_VISOR_REVERSE);
			_reverse.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			_reverse.load(urlReq);
			pnBotonera.addChild(_reverse);
		}
		
		private function posicionaBotones(){
			
			btnLoad = new TextImageButton(Ficheros.IMG_OPENAUDIOFILE, "Abrir" );
			
			btnLoad.x = 780; btnLoad.y = 4;
			this.addChild(btnLoad);
			
			btnInfo = new TextImageButton(Ficheros.IMG_INFO, "Info" );
			btnInfo.x = 860; btnInfo.y = 4;
			this.addChild(btnInfo);
			
			btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Salir" );
			btnBack.x = 940; btnBack.y = 4;
			btnBack.addEventListener(MouseEvent.CLICK, function(e:MouseEvent){
					NativeApplication.nativeApplication.exit(0);
			});
			this.addChild(btnBack);
			
		}		
		
		private function LoadElements() {
			
			//	Calcula proporcion
			var f: FondoBE = p.hFondos[ej.fondo];
			var prop: Number = f.altura / f.altura_m;
			if (ej.escenas.length == 0) return;
			var escena: EscenaBE = ej.escenas[1];
			
			//var tl: TimelineLite = new TimelineLite();
			new SoundPlayer("C:\\Users\\Pots\\Documents\\piz\\audios\\audio_27_1.mp3").Play();
			for each(var m: MovimientoBE in escena.movimientos) {
				var el: ElementoBE = p.hElementos[m.elemento];
				var img: Image = new Image(el.imagen, el.altura * prop, el.anchura * prop);
				img.x = fondo.x + m.inicio.x;
				img.y = fondo.y + m.inicio.y;
				addChild(img);
				els.push(img);
				//for each (var tr: TrayectoriaBE in m.trayectoria) {
				//	tl.append(new TweenLite(img, 0.5, { x:tr.punto.x, y: tr.punto.y } ));
				//}
			}
			trace("els: " + els.length);
			AnimationHelper.GetExerciseAnimation(ej, els);
			//AnimationHelper.ExportaAnimacion(ej, "C:\\Users\\Pots\\Documents\\piz\\audios\\video.flv", 10);
			/*var tl: TimelineLite = new TimelineLite();
			
			for (var i = 1; i < ej.escenas.length; i++ ) {
				
				var esc: EscenaBE = ej.escenas[i];
				for (var j = 0; j < esc.movimientos; j++  ) {
					
					var m: MovimientoBE = esc.movimientos[j];
					for each (var tr: TrayectoriaBE in m.trayectoria) {
						tl.append(new TweenLite(els[j], esc.duracion, { x:tr.punto.x, y: tr.punto.y } ));
					}
				}
			}*/
		}
		
		private function createInfoPanel(){
			
			infoPanel.graphics.beginFill(Tema.backgroundA, 1);
			infoPanel.graphics.drawRect(0, 0, 500, 200);
            infoPanel.graphics.endFill();
			infoPanel.x = 500; infoPanel.y = 100;
			infoPanel.alpha = 0;
			this.addChild(infoPanel);
			
			var lblExeName: Label = new Label();
			lblExeName.text = "Nombre:";
			lblExeName.x = 10; lblExeName.y = 10;
			lblExeName.setStyle("textFormat", Tema.formatoLabel);
			infoPanel.addChild(lblExeName);
			
			txtName.text = "";
			txtName.x = 100; txtName.y = 10;
			txtName.width = 300;
			txtName.setStyle("textFormat", Tema.formatoLabel);
			infoPanel.addChild(txtName);
			
			var lblExeInfo: Label = new Label();
			lblExeInfo.text = "Info:";
			lblExeInfo.x = 10; lblExeInfo.y = 30;
			lblExeInfo.setStyle("textFormat", Tema.formatoLabel);
			infoPanel.addChild(lblExeInfo);
			
			txtInfo.text = "";
			txtInfo.x = 100; txtInfo.y = 30;
			txtInfo.width = 300;
			txtInfo.setStyle("textFormat", Tema.formatoLabel);
			infoPanel.addChild(txtInfo);
			
			var lblText: Label = new Label();
			lblText.text = "Texto:";
			lblText.x = 10; lblText.y = 80;
			lblText.setStyle("textFormat", Tema.formatoLabel);
			infoPanel.addChild(lblText);
			
			txtText.x = 100; txtText.y = 80;
			txtText.width = 200; txtText.height = 40;
			infoPanel.addChild(txtText);
			
			//	Separator
			infoPanel.addChild(new Separator(500, 5, 0, 0));
			infoPanel.addChild(new Separator(500, 5, 0, 200));
			infoPanel.addChild(new Separator(5, 200, 0, 0));
			infoPanel.addChild(new Separator(5, 200, 495, 0));
		}
		
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function dibujaTerreno(){
			pnVideo = new Sprite(); this.addChild(pnVideo);
			fondo = new Loader(); 
			var urlReq:URLRequest = new URLRequest(p.fondoEjercicio.url);
			fondo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			fondo.load(urlReq);
			pnVideo.addChild(fondo);
		}
		
		public function ShowInfoPanel(){
			new Tween(infoPanel,"alpha",None.easeNone,0,1,1,true);
		}
		
		public function HideInfoPanel(){
			new Tween(infoPanel,"alpha",None.easeNone,1,0,1,true);
		}
		
		public function IniciaAnimacion(ej: EjercicioBE): void{
			this.ej = ej;
			this.Title = ej.nombre;
			this.txtName.text = ej.nombre;
			this.txtInfo.text = ej.info;
			this.addChild(btnLoad);
			this.addChild(btnInfo);
			this.addChild(btnBack);
			ex = new ExerciseAnimation();
			ex.addEventListener(Event.COMPLETE, animation_Completed);
			ex.Init(ej, p.hFondos[ej.fondo], p.hElementos, p.UnsortedAcciones);
			ex.addEventListener(Event.COMPLETE, finishedLoading);
			ex.addEventListener(Event.CHANGE, frameChange);
			ex.addEventListener("Scene_Change", sceneChange);
			ex.x = 100; ex.y = 100;
			this.addChild(ex);
			this.addChild(infoPanel);
			txtText.text = ej.escenas[1].texto;
		}
		
		private function animation_Completed(ev: Event): void{
			_slider.maximum = ex.Length * 1000;
		}
		
		private function sceneChange(ev: Event): void{
			txtText.text = ej.escenas[ex.Scene].texto;
		}
		
		public function PrepareForImport(): void {
			if(ex != null){
				ex.Stop();
				this.removeChild(ex);
			}
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function imgLoaded(event:Event):void{
			
			switch(event.target.loader){
				case _atras:
					Util.posiciona(_atras,0,0,50,50);
					break;
				case _delante:
					Util.posiciona(_delante,60,0,50,50);
					break;
				case _pausa:
					Util.posiciona(_pausa,120,0,50,50);
					break;
				case _play:
					Util.posiciona(_play,180,0,50,50);
					break;
				case _reverse:
					Util.posiciona(_reverse,240,0,50,50);
					break;
				case fondo: 
					fondo.x = 100;
					fondo.y = 100;
					break;
				default:	trace("error cargando botonera");
			}
		}
		
		private function muestraBotonera(event:Event):void{
			if(event.currentTarget == event.target)
				TransitionManager.start(pnBotonera,{type:Fade, duration:1, direction:Transition.IN})
		}
		
		private function ocultaBotonera(event:Event):void{
			if(event.currentTarget == event.target)
				TransitionManager.start(pnBotonera,{type:Fade,duration:1 , direction:Transition.OUT})
		}
		
		private function play_Click(event:Event) {
			if(ex != null){
				ex.Play();
			}
		}
		
		private function pause_Click(event:Event) {
			if(ex != null){
				ex.Stop();
			}
		}
		
		private function atras_Click(event:Event) {
			if(ex != null){
				ex.CurrentProgress = 0.0;
				slider.value = ex.CurrentProgress * 1000;
			}
		}
		
		private function delante_Click(event:Event) {
			if(ex != null){
				ex.CurrentProgress = ex.Length * 1000;
				slider.value = ex.CurrentProgress * 1000;
			}
		}
		
		private function reverse_Click(event:Event) {
			if(ex != null){
				ex.Reverse();
			}
		}
		
		private function frameChange(event:Event) {
			if(ex != null){
				slider.value = ex.CurrentProgress * 1000;
				updateProgressLabel();
			}
		}
		
		private function updateProgressLabel(): void {
			var str: Array = new Array(),
					str2: Array = new Array();
				str = (ex.CurrentProgress + "").split(".");
				str2 = (ex.Length + "").split(".");
				try{
					progressLabel.text = (str[0] + "." + str[1].substr(0,2)) + " / " + (str2[0] + "." + str2[1].substr(0,2));
				}catch(err: Error){}
		}
		
		private function finishedLoading(event:Event) {
			if(ex != null){
				_slider.maximum = ex.Length * 1000;
			}
		}
		
		private function changeTime(event: Event) {
			if(ex != null){
				ex.CurrentProgress = slider.value;
				txtText.text = ej.escenas[ex.Scene].texto;
				updateProgressLabel();
			}
		}
		
		private function cbShowPaths_Change(ev: Event): void{
			if(ex != null){
				ex.ShowPaths = cbShowPaths.selected;
			}
		}
		
		private function cbShowPoints_Change(ev: Event): void{
			if(ex != null){
				ex.ShowPoints = cbShowPoints.selected;
			}
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get atras(): Loader { return _atras; }
		public function get delante(): Loader { return _delante; }
		public function get pausa(): Loader { return _pausa; }
		public function get play(): Loader { return _play; }
		public function get reverse(): Loader { return _reverse; }
		public function get slider(): Slider { return _slider; }
		public function get BtnInfo(): TextImageButton { return btnInfo; }
		public function get Animation(): ExerciseAnimation { return ex; }
		public function get BtnLoad(): TextImageButton {return btnLoad;}
		
		private function volver(event: Event){
			//dispatchEvent(new Event(Eventos.BACK));
			//UploadImage();
		}
		
		private function UploadImage(): void{
			
    		imgBD.draw(img);
			var imgBA: ByteArray;
			var enc: PNGEncoder = new PNGEncoder();
			imgBA = PNGEncoder.encode(imgBD);
   
			var sendHeader: URLRequestHeader = new URLRequestHeader("Content-type","application/octet-stream");
		 
			var sendReq:URLRequest = new URLRequest("http://pfc.webpots.org/ws/uploadImage.php");
			sendReq.requestHeaders.push(sendHeader);
			sendReq.method = URLRequestMethod.POST;
			sendReq.data = imgBA;
		 
			var sendLoader:URLLoader = new URLLoader();
			sendLoader.addEventListener(Event.COMPLETE, imageSentHandler);
			sendLoader.addEventListener(flash.events.IOErrorEvent.IO_ERROR, io_error);
			sendLoader.load(sendReq);
		}
		
		private function imageSentHandler(ev: Event){
			//trace(ev.target.data);
		}
		private function io_error(ev: Event){
			trace("error");
		}
	}
}