﻿package org.pizarra.Data{
	
	import flash.geom.Point;
	import flash.utils.Dictionary;
	import org.pizarra.Entity.*;
	import org.pizarra.Estado;
	import org.pizarra.Util;

	public class DibujoLibre {
		
		private var _trazos: Array;
		private var _titulo: String;
		private var _id: String;
		private var _idsElementos: Array;
		private var _elementos: Dictionary;
		private var _estados: Dictionary;
		private var _fechaCreacion: String;
		private var _fechaModificacion: String;
		private var _deporte: String;
		private var _fondo: String;
		private var _info: String;
		
		public function DibujoLibre() {
			_trazos = new Array();
			_titulo = "";
			_info = "";
			_id = Util.nuevoId();
			_idsElementos = new Array();
			_elementos = new Dictionary();
			_estados = new Dictionary();
			_fondo = "BE975BAC-06A6-09BC-C272-8B2E17F20DEE";
		}
		
		public function add(t: Trazo) { _trazos.push(t); }
		
		public function addElemento(id: String, elemento: String, estado: Estado) { 
			_idsElementos.push(id);
			_elementos[id] = elemento;
			_estados[id] = estado;
			//trace("Añadido elemento: " + id + " del tipo " + elemento);
		}
		
		public function moveElemento(id: String, estado: Estado) { 
			_estados[id] = estado;
		}
		
		public function newTrazo() {
			_trazos[_trazos.length] = new Trazo();
		}
		
		public function get trazos():Array { return _trazos; }
		
		public function get fechaCreacion():String { return _fechaCreacion; }
		public function set fechaCreacion(fecha: String):void  { _fechaCreacion = fecha }
		
		public function get fechaModificacion():String { return _fechaModificacion; }
		public function set fechaModificacion(fecha: String):void  { _fechaModificacion = fecha }
		
		public function get titulo(): String { return _titulo; }
		public function set titulo(t: String) { _titulo = t; }
		
		public function get deporte():String { return _deporte; }
		public function set deporte(dep: String): void { _deporte = dep; }
		
		public function get fondo():String { return _fondo; }
		public function set fondo(fon: String): void { _fondo = fon; }
		
		public function get id():String { return _id; }
		public function set id(i: String): void { _id = i; }
		
		public function get info():String { return _info; }
		public function set info(i: String): void { _info = i; }
		
		public function get idsElementos():Array { return _idsElementos; }
		
		public function get elementos():Dictionary { return _elementos; }
		
		public function get estados():Dictionary { return _estados; }
		
		public function get ultimoTrazo(): Trazo {
			return _trazos[_trazos.length - 1];
		}
		
		public function audita() {
			var i : int = 1;
			for each(var t: Trazo in _trazos) {
				trace("Trazo " + i);
				t.audita();
				i++;
			}
		}
	}
}