﻿package org.pizarra.DAL {	
	
	import flash.data.SQLConnection;
	import flash.data.SQLStatement;
	import flash.data.SQLResult;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	//import org.pizarra.Elemento;
	import org.pizarra.Entity.*;
	import org.pizarra.util.*;
	import org.pizarra.Util;
	
	public class ElementoDA{
		
		private var con: SQLConnection;
		private var result:SQLResult;
		private var temaEntity: TemaBE = new TemaBE();
		
		public function ElementoDA(bdRef: SQLConnection) {
			con = bdRef;
		}
		
		
		public function getElementosEstaticos(deportes: Array): Array {
			
			var elementos: Array = new Array();
			var i: int = 0;
			var elemento: ElementoBE;
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			try {
				
				for each(var dep: DeporteBE in deportes) {
					selectStmt.text =  "select Id, Nombre, IdDeporte, IdTipoElemento, Imagen, ";
					selectStmt.text += " Wm, Hm "; 
					selectStmt.text += " from " + DBConstants.T_ELEMENTOS;
					selectStmt.text += " where IdDeporte = @IdDeporte and IdTipoElemento = @IdTipo";
					selectStmt.parameters["@IdDeporte"] = dep.id;
					selectStmt.parameters["@IdTipo"] = Constantes.TIPO_ESTATICO;
					selectStmt.execute();
					result = selectStmt.getResult();
					elementos[i] = new Array();
					for each(var row in result.data) {
						elemento = new ElementoBE(row['Id'],
												row['Nombre'],
												row['IdTipoElemento'],
												Ficheros.BASE_URL + row['Imagen'],
												row['Hm'],
												row['Wm']);
						//	get acciones						
						elemento.acciones = getAcciones(elemento.id);						
						elementos[i].push(elemento);
					}
					i++;
				}
			}catch (error) {
				Util.subTrace("SELECT error:" + error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
			}
			return elementos;
		}
		
		public function getElementosDinamicos(deportes: Array): Array {
			
			var elementos: Array = new Array();
			var i: int = 0;
			var elemento: ElementoBE;
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			try {
				
				for each(var dep: DeporteBE in deportes) {
					selectStmt.text =  "select Id, Nombre, IdDeporte, IdTipoElemento, Imagen, ";
					selectStmt.text += " Wm, Hm "; 
					selectStmt.text += " from " + DBConstants.T_ELEMENTOS;
					selectStmt.text += " where IdDeporte = @IdDeporte and IdTipoElemento = @IdTipo";
					selectStmt.parameters["@IdDeporte"] = dep.id;
					selectStmt.parameters["@IdTipo"] = Constantes.TIPO_DINAMICO;
					selectStmt.execute();
					result = selectStmt.getResult();
					elementos[i] = new Array();
					for each(var row in result.data) {
						elemento = new ElementoBE(row['Id'],
												row['Nombre'],
												row['IdTipoElemento'],
												Ficheros.BASE_URL + row['Imagen'],
												row['Hm'],
												row['Wm']);
						//	get acciones						
						elemento.acciones = getAcciones(elemento.id);
						elementos[i].push(elemento);
					}
					i++;
				}
			}catch (error) {
				Util.subTrace("SELECT error:" + error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
			}
			return elementos;
		}
		
		public function getAcciones(idElemento: String):Array {
			
			var acciones: Array = new Array();
			var accion: AccionBE;
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			try {
				selectStmt.text =  "select Id, IdElemento, Nombre, Url ";
				selectStmt.text += " from " + DBConstants.T_ACCIONES;
				selectStmt.text += " where IdElemento = @IdElemento";
				selectStmt.parameters["@IdElemento"] = idElemento;
				selectStmt.execute();
				result = selectStmt.getResult();
				for each(var row in result.data) {
					accion = new AccionBE();
					accion.id = row['Id'];
					accion.elemento = row['IdElemento'];
					accion.nombre = row['Nombre'];
					accion.url = row['Url'];
					acciones.push(accion);
				}
			}catch (error) {
				Util.subTrace("SELECT error:" + error.getStackTrace() + "error.message:" + error.message +"error.details:" + error.details);
			}
			return acciones;
		}
	}
}