﻿package org.pizarra.DAL {	
	
	import flash.data.SQLConnection;
	import flash.data.SQLStatement;
	import flash.data.SQLResult;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	import org.pizarra.Entity.*;
	import org.pizarra.util.*;
	import org.pizarra.Util;
	
	public class AccionDA{
		
		private var con: SQLConnection;
		private var result:SQLResult;
		private var accionEntity: AccionBE = new AccionBE();
		
		public function AccionDA(bdRef: SQLConnection) {
			con = bdRef;
		}

		public function GetAcciones(): Array {
			
			var acciones: Array = new Array();

			var selectStmt: SQLStatement = new SQLStatement();
			try {
				selectStmt.sqlConnection = con;
				selectStmt.text =  "select Id, IdElemento, Nombre, url ";
				selectStmt.text += " from " + DBConstants.T_ACCIONES;
				selectStmt.text += " order by Nombre";
				selectStmt.execute();
				result = selectStmt.getResult();
				for each(var row in result.data) {
					accionEntity = new AccionBE();
					accionEntity.id = String(row['Id']);
					accionEntity.elemento = String(row['IdElemento']);
					accionEntity.nombre = String(row['Nombre']);
					accionEntity.url = String(row['Url']);
					acciones.push(accionEntity);
				}
			}catch (error) {
				Util.subTrace("SELECT error:" + error + "error.message:" + error.message +"error.details:" + error.details);
			}
			return acciones;
		}
		
		public function GetAccionesDictionary(): Dictionary{
			var acciones: Array = this.GetAcciones();
			var accionesDict: Dictionary = new Dictionary();
			for each( var el in acciones){
				if(accionesDict[el.elemento] == null){
					accionesDict[el.elemento] = new Array();
				}
				accionesDict[el.elemento].push(el);
			}
			return accionesDict;
		}
		
		public function GetUnsortedAccionesDictionary(): Dictionary{
			var acciones: Array = this.GetAcciones();
			var accionesDict: Dictionary = new Dictionary();
			for each(var el: AccionBE in acciones){
				accionesDict[el.id] = el;
			}
			return accionesDict;
		}
	}
}