﻿package org.pizarra.Controller{	

	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.Event;
	import org.pizarra.Entity.EjercicioBE;
	import org.pizarra.Entity.FondoBE;
	import org.pizarra.Pizarra;
	import org.pizarra.graficos.Alert;
	import org.pizarra.Data.Convert;
	import org.pizarra.util.Eventos;
	import flash.display.Sprite;  
    import flash.media.Sound;  
    import flash.net.URLRequest;  
    import flash.media.SoundChannel; 
	import org.pizarra.Util;
	import org.pizarra.View.VisorView;
	import org.pizarra.Converters.ExerciseConverter;
	import flash.net.URLLoader;
	import flash.filesystem.File;
	import flash.net.FileFilter;

	public class VisorController extends EventDispatcher{
		
		private var p: Pizarra;
		private var ej: EjercicioBE;
		
		private var snd:Sound = new Sound();  
        private var channel:SoundChannel = new SoundChannel();  
		private var audios: Array = new Array();
		private var audiosLoader: Array = new Array();
		private var audiosCargado: Array = new Array();
		private var audiosDuracion: Array = new Array();
		private var visor: VisorView;
		private var infoPanelVisible = false;
		
		public function VisorController(piz: Pizarra, visor: VisorView ): void {

			this.visor = visor;
			this.p = piz;
			Alert.init(p.stage);
			init();
			
			//visor.play.addEventListener(MouseEvent.CLICK, play);
			visor.BtnInfo.addEventListener(MouseEvent.CLICK, BtnInfo_Click);
			visor.BtnLoad.addEventListener(MouseEvent.CLICK, function(e:MouseEvent){
				var f: File = File.desktopDirectory;
				var filtro:FileFilter = new FileFilter("Ejercicios", "*.piz");
				f.browseForOpen("Ejercicios de pizarra",[filtro]);
				f.addEventListener(Event.SELECT, seleccionado_piz); 
			});
			
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init(){
			
			if (p.urlEjercicio == "" && p.ejercicioSeleccionado != null) {	//	From exercise selector
				ej = p.hEjercicios[p.ejercicioSeleccionado];
				trace("viendo ejercicio :" + ej.id);
				ej.imprime_ejercicio();
			}
			if(p.urlEjercicio != null && p.urlEjercicio != ""){						//	Must read the file
				importaEjercicio();
			}
			//visor.dibujaTerreno();
		}
		
		public function getFondo(): FondoBE {
			return p.hFondos[ej.fondo];
		}
		
		public function loadAudios() {
			trace("Escenas n " + ej.escenas.length);
			for (var i: int = 1; i< ej.escenas.length; i++ ) {
				if (ej.escenas[i].audio != "") {
					try{
						trace("Cargando audio " + ej.escenas[i].audio);
						audiosLoader[i] = new Sound();
						audiosLoader[i].addEventListener(Event.COMPLETE, audioLoaded);
						audiosLoader[i].load(new URLRequest(ej.escenas[i].audio));  
						//channel = snd.play();
					}catch (error) {
						Util.subTrace("Error cargando audio");
					}
				}
			}
		}
		
		public function GetExerciseName(): String {
			return ej.nombre;
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function importaEjercicio(){
			var xmlLoader:URLLoader = new URLLoader();
			xmlLoader.load(new URLRequest(p.urlEjercicio));
			xmlLoader.addEventListener(Event.COMPLETE, doImportaEjercicio);
		}
		
		private function doImportaEjercicio(ev: Event): void{
			var ej: XMLList = new XMLList(ev.target.data);
			ej = ej.ejercicio;
			var ejBe: EjercicioBE = ExerciseConverter.ParseXmlToEjercicioBE(ej);
			visor.IniciaAnimacion(ejBe);			
		}
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		function seleccionado_piz(e:Event){
			visor.PrepareForImport();
			p.urlEjercicio = e.target.nativePath;
			this.init();
		}
		
		private function audioLoaded(e: Event) {
			trace("cargado audio");
		}
		
		private function wrongType(event: Event){
			Alert.show("Tipo de fichero Incorrecto", {background:"blur"});
		}
		private function errorImport(event: Event){
			Alert.show("Error Importando Fichero", {background:"blur"});
		}
		private function finImport(event: Event){
			Alert.show("Importado Correctamente", {background:"blur"});
		}
		
		//	Handle Show info event
		private function BtnInfo_Click(ev: MouseEvent){
			if(infoPanelVisible){
				visor.HideInfoPanel();
			}else{
				visor.ShowInfoPanel();
			}
			infoPanelVisible = !infoPanelVisible;
		}

		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
		
		
	}
}