/*
 * Decompiled with CFR 0.152.
 */
import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncodingAttributes;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AudioRecorder02
extends JFrame {
    AudioFormat audioFormat;
    TargetDataLine targetDataLine;
    final JButton captureBtn = new JButton("Captura");
    final JButton stopBtn = new JButton("Stop");
    final JPanel btnPanel = new JPanel();
    final ButtonGroup btnGroup = new ButtonGroup();
    final JRadioButton aifcBtn = new JRadioButton("AIFC");
    final JRadioButton aiffBtn = new JRadioButton("AIFF");
    final JRadioButton auBtn = new JRadioButton("AU", true);
    final JRadioButton sndBtn = new JRadioButton("SND");
    final JRadioButton waveBtn = new JRadioButton("WAVE");
    final JFileChooser chooser = new JFileChooser();
    String nombre;
    BD bd = new BD();

    public static void main(String[] args) {
        new AudioRecorder02();
    }

    public AudioRecorder02() {
        this.captureBtn.setEnabled(true);
        this.stopBtn.setEnabled(false);
        this.nombre = this.bd.get_nombre();
        this.captureBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AudioRecorder02.this.captureBtn.setEnabled(false);
                AudioRecorder02.this.stopBtn.setEnabled(true);
                AudioRecorder02.this.captureAudio();
            }
        });
        this.stopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AudioRecorder02.this.captureBtn.setEnabled(true);
                AudioRecorder02.this.stopBtn.setEnabled(false);
                AudioRecorder02.this.targetDataLine.stop();
                AudioRecorder02.this.targetDataLine.close();
            }
        });
        this.getContentPane().add(this.captureBtn);
        this.getContentPane().add(this.stopBtn);
        this.btnGroup.add(this.aifcBtn);
        this.btnGroup.add(this.aiffBtn);
        this.btnGroup.add(this.auBtn);
        this.btnGroup.add(this.sndBtn);
        this.btnGroup.add(this.waveBtn);
        this.getContentPane().add(this.btnPanel);
        this.getContentPane().setLayout(new FlowLayout());
        this.setTitle("Grabaci\u00f3n de audio");
        this.setDefaultCloseOperation(3);
        this.setSize(300, 120);
        this.setVisible(true);
    }

    private void captureAudio() {
        try {
            this.audioFormat = this.getAudioFormat();
            DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
            new CaptureThread().start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private AudioFormat getAudioFormat() {
        float sampleRate = 8000.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    class CaptureThread
    extends Thread {
        CaptureThread() {
        }

        public void run() {
            AudioFileFormat.Type fileType = null;
            File audioFile = null;
            BD bd = new BD();
            fileType = AudioFileFormat.Type.WAVE;
            audioFile = new File("temp.wav");
            try {
                AudioRecorder02.this.targetDataLine.open(AudioRecorder02.this.audioFormat);
                AudioRecorder02.this.targetDataLine.start();
                AudioSystem.write(new AudioInputStream(AudioRecorder02.this.targetDataLine), fileType, audioFile);
                AudioRecorder02.this.nombre = bd.get_nombre();
                File source = new File("temp.wav");
                File target = new File("audios/audio_" + AudioRecorder02.this.nombre + ".mp3");
                AudioAttributes audio = new AudioAttributes();
                audio.setCodec("libmp3lame");
                audio.setBitRate(new Integer(128000));
                audio.setChannels(new Integer(2));
                audio.setSamplingRate(new Integer(44100));
                EncodingAttributes attrs = new EncodingAttributes();
                attrs.setFormat("mp3");
                attrs.setAudioAttributes(audio);
                Encoder encoder = new Encoder();
                encoder.encode(source, target, attrs);
                source.delete();
                bd.actualiza();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

