USE [accede]
GO

/****** Object:  StoredProcedure [dbo].[SpCitasGetTelefonosSolicitante]    Script Date: 09/06/2010 16:33:58 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
=============================================
Autor:       Deloitte 
Creada:      06/09/2010
Description: Obtiene los telfonos del solicitante.
Input:       @Expediente -> Numero de Expediente
OutPut:      Telfonos indicados para el solicitante.
=============================================
*/
CREATE PROCEDURE [dbo].[SpCitasGetTelefonosSolicitante]
	-- Add the parameters for the stored procedure here
	@Expediente VARCHAR(14)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT	E.SolTelefono AS FIJO, E.SolMovil AS MOVIL
	FROM	Expedientes E
	WHERE E.Expediente = @Expediente
END

GO



USE [Accede]
GO

/****** Object:  StoredProcedure [dbo].[SpCitasIsHoraLibreValorador]    Script Date: 09/20/2010 12:14:22 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author: Deloitte       
-- CREATE  date: 09/20/2010
-- Description:   Obtener Datos de las citas para la confirmacin de los Valoradores
-- Input: @Valorador - Valorador del que se extraen las citas
-- =============================================
CREATE PROCEDURE [dbo].[SpCitasIsHoraLibreValorador] 
      @Valorador CHAR(36),
      @HInicio SMALLDATETIME,
      @HFin SMALLDATETIME,
      @Dia SMALLDATETIME
AS
BEGIN

      SET NOCOUNT ON;
      (SELECT     AN.Id 
            FROM  Valoradores VA
                        INNER JOIN AnotacionAgenda AN
                        ON (VA.Id = AN.IdValorador)
                        INNER JOIN ExpCitas CI
                        ON (CI.IdAnotacionAgenda = AN.Id)
            WHERE VA.Id = @Valorador AND
                        CI.Activa = 1 AND
                        ((@HInicio BETWEEN AN.HInicio AND AN.HFin)
                        OR (@HFin BETWEEN AN.HInicio AND AN.HFin)) AND
                        DAY(AN.FInicio) = DAY(@Dia) AND
                        MONTH(AN.FInicio) = MONTH(@Dia) AND
                        YEAR(AN.FInicio) = YEAR(@Dia))
      UNION ALL
      SELECT      AN.Id 
            FROM  Valoradores VA
                        INNER JOIN AnotacionAgenda AN
                        ON (VA.Id = AN.IdValorador)
            WHERE VA.Id = @Valorador AND
                        AN.Motivo <>'020' AND
                        ((@HInicio BETWEEN AN.HInicio AND AN.HFin)
                        OR (@HFin BETWEEN AN.HInicio AND AN.HFin)) AND
                        (DAY(@Dia) >= DAY(AN.FInicio) AND 
                        DAY(@Dia) <=DAY(AN.FFin))
      
END

GO


USE [accede]
GO

/****** Object:  StoredProcedure [dbo].[SpCitasGetValoradorAsignado]    Script Date: 09/20/2010 12:03:21 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
=============================================
Autor:       Deloitte 
Creada:      20/09/2010
Description: Obtiene el nombre del valorador asignado a la cita.
Input:       @IdCita -> Identificador de la cita
OutPut:      ID: Identificador del valorador asignado.
			 NOMBRE: Nombre del valorador asignado.
=============================================
*/
CREATE PROCEDURE [dbo].[SpCitasGetValoradorAsignado]
	-- Add the parameters for the stored procedure here
	@IdCita CHAR(36)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT	V.Id AS ID, V.Nombre + ' ' + V.Apellido1 + ' ' + V.Apellido2 AS NOMBRE
	FROM	ExpCitas C
	INNER JOIN AnotacionAgenda AA ON C.IdAnotacionAgenda = AA.Id
	INNER JOIN Valoradores V ON AA.IdValorador = V.Id
	WHERE C.Id  = @IdCita AND C.Activa = 1
END

GO


/****** Object:  StoredProcedure [dbo].[SpCitasGetCitasRealizadasExpediente]    Script Date: 09/22/2010 16:52:27 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
=============================================
Autor:       Deloitte 
Creada:      22/09/2010
Description: Obtiene todas las citas realizadas en el expediente.
Input:       @Expediente -> Numero de Expediente
OutPut:      Informacin de las citas ya realizadas.
=============================================
*/
CREATE PROCEDURE [dbo].[SpCitasGetCitasRealizadasExpediente]
	-- Add the parameters for the stored procedure here
	@Expediente VARCHAR(14)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT E.Id, E.Fecha, E.Hora, AE.Descripcion AS Estado, V.Nombre + ' ' + V.Apellido1 + ' ' + V.Apellido2 AS Valorador
	FROM ExpCitas E 
	INNER JOIN AnotacionAgenda AA ON E.IdAnotacionAgenda = AA.Id
	INNER JOIN Valoradores V ON AA.IdValorador = V.Id
	INNER JOIN AuxEstados AE ON AE.Codigo = E.IdEstado
	WHERE E.IdEstado = '010' AND E.Expediente = @Expediente AND E.Activa = 1
END

GO