﻿package org.pizarra.video{	

	import fl.transitions.Tween;
	import fl.transitions.TweenEvent;
	import fl.transitions.easing.*;
	import org.pizarra.Ejercicio;
	import org.pizarra.Movimiento;
	import org.pizarra.Escena;
	import org.pizarra.util.Registrador_Interfaz;
	import org.pizarra.video.SimpleFlvWriter;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.graficos.Mensaje_Central;
	import flash.geom.Point;
	import flash.display.DisplayObjectContainer;
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.media.SoundChannel;
	import flash.display.BitmapData;
	import com.greensock.*; 
	import com.greensock.easing.*;
	import com.greensock.plugins.*;
	import flash.filesystem.*;
	import flash.display.Bitmap;
	import 	fl.controls.Slider;

	//	Audio
	import flash.display.Sprite;
	import flash.net.URLRequest;
	import flash.media.Sound;
	import flash.media.SoundLoaderContext;
	
	//
	import org.pizarra.video.SimpleFlvWriter;
	
	public class Reproductor{
	
		var l: Loader = new Loader();
		var ls: Array = new Array();
		var video: MovieClip = new MovieClip();
		var panel: DisplayObjectContainer;
		var elementos: Array = new Array();
		var esc: Escena;
		var mov: Movimiento;
		var twex: Array = new Array();
		var twey: Array = new Array();
		var mcs: Array = new Array();
		var n_escena: int;
		var escena_final: int;
		var animando: Boolean = false;
		var ej: Ejercicio;
		
		private var fondos_deportes: Array;
		private var elementos_deportes: Array;
		private var jugadores: Array;
		private var i,j: int;
		private var reg: Registrador_Interfaz;
		private var tiempo: Array = new Array();
		private var num_paso: Array = new Array();
		private var calidad: int;
		
		//////VIDEO
		//private var bData:BitmapData = new BitmapData(600, 450, true);
		private var bData:BitmapData;
		private var cont_f: int=0;
		private var myFile: File = File.desktopDirectory;
		//private var myWriter: SimpleFlvWriter;
		private var grabacion: Boolean = false;
		
		/////AUDIO
		private var so:Sound;
		private var url:URLRequest;
		private var buffer:SoundLoaderContext;
		private var ini:Number;
		private var loop:Number;
		
		private var audios: Array = new Array();
		private var audios_car: Array = new Array();
		
		private var visible: Boolean;
		
		private var _tiempo: Slider;
		
		var myTimeline: Array = new Array();
		//TimelineLite = new TimelineLite({paused:true});
		var myWriter:SimpleFlvWriter = SimpleFlvWriter.getInstance();
		
		var m: Mensaje_Central ;//= new Mensaje_Central("Exportando vídeo, por favor espere", panel);
		var pos: Point;
		//	Constructor del reproductor
		//	Guarda los elementos necesarios apra el ciclo de vida
		//	Pone a cargar los audios en caso de haberlos
		public function Reproductor(ejercicio: Ejercicio, 
									pos: Point, 
									panel: DisplayObjectContainer, 
									reg: Registrador_Interfaz,
									tiempo: Slider,
									visible: Boolean=true): void{
			ej = ejercicio;
			_tiempo = tiempo;
			this.pos = pos;
			this.reg = reg;
			this.panel = panel;
			video.x = 0;	video.y = 0;
			video.doubleClickEnabled = true;
			var f:File = File.documentsDirectory;
			
			if(visible){	panel.addChild(video);	/*reg.add_elemento(video);*/	}
			
			var es: Escena;
			var algun_audio: Boolean = false;
			
			for(var i = 1; i< ej.num_escenas(); i++){				//	Para todas las escenas
				es = ej.get_escena(i);
				if((es.audio != null) && (es.audio.length >0) && (es.audio != undefined)){
					f = f.resolvePath("piz\\audios\\" + es.audio);
					trace(f.nativePath);
					audios[i] = new Sound();
					audios_car[i]= false;	algun_audio = true;
					var req:URLRequest = new URLRequest(f.nativePath);
					try {
						audios[i].load(req);
						audios[i].addEventListener(Event.COMPLETE, cargado);
					}
					catch (err:Error) {	trace(err.message);	}
				}else{
					audios_car[i] = true;
				}
			}
			if(algun_audio == false){
				calcula_tiempos();
			}
		}
		
		private function cargado(e:Event){
			
			var falta_alguno: Boolean= false;
			//trace("cargado " + audios.indexOf(e.target) );
			audios_car[audios.indexOf(e.target)] = true;
			for(var i = 1; i<ej.num_escenas(); i++){
				if(audios_car[i] == false){	falta_alguno = true;	}
				//trace(i + "  " + audios_car[i]);
			}
			if(falta_alguno == false){
				calcula_tiempos();
			}
		}
		
		public function configura(e_d: Array, f_d: Array, jug: Array){
		
			this.fondos_deportes = f_d;
			this.elementos_deportes = e_d;
			this.jugadores = jug;
		}
		
		public function calcula_tiempos(){
			var t_total: Number = 0;
			for(i= 1; i<ej.num_escenas(); i++){
				t_total += ej.get_escena(i).duracion_total(audios[i]);
			}
			trace("tiempo_total = " + t_total);
			_tiempo.maximum = t_total;
		}
		
		public function inicia(){
			
			var f: Fondo = fondos_deportes[0][0];	//	MONTO EL FONDO
			l.load(new URLRequest(f.url+".png"));
			/*video.x = (1024 - f.anchura) / 2;
			video.y = (600 - f.altura) / 2;*/
			video.x = pos.x;
			video.y = pos.y;
			video.addChild(l);
			
			esc = ej.get_escena(1);
			for(j = 0; j<esc.num_movimientos(); j++){	
				mcs[j]= new MovieClip();
				ls[j] = new Loader();
				mcs[j].addChild(ls[j]);
				video.addChild(mcs[j]);	
				myTimeline[j]= new TimelineLite({paused:true});
				if(j == 0){
					myTimeline[j]= new TimelineLite({paused:true, onUpdate: cambio_frame});
				}
			}
			n_escena = 1;	posiciona(n_escena);
			/*if(visible){
				panel.addChild(video);	reg.add_elemento(video);
			}*/
			genera_transiciones();
			TweenPlugin.activate([BezierThroughPlugin, BezierPlugin]);
		}
		
		public function cierra_fichero(){
			myWriter.closeFile();
		}
		
		private function tramita_audio(param1: int){
			trace("par " + param1);
			var channel:SoundChannel;
			if(audios[param1] != null){
				channel = audios[param1].play();
			}
		}
		
		public function genera_transiciones(){
			
			var es: Escena;
			var mov: Movimiento;
			var t: Number;
			var k,i,j,l: int = 0;
			var dibujo = new Array();
			
			for(i = 1; i< ej.num_escenas(); i++){				//	Para todas las escenas
				es = ej.get_escena(i);
				if(es.tipo == 0){		//	MOVIMIENTOS CONCURRENTES
					genera_animacion_concurrente(es);
				}
				if(es.tipo == 1){		//	MOVIMIENTOS ESCALONADOS	
					genera_animacion_escalonada(es);
				}
			}
		}
		
		private function genera_animacion_concurrente(es: Escena){
			var t: Number;
			var k,i,j,l: int = 0;
			var dibujo = new Array();
			//	j: Movimiento
			//	k: punto de trayectoria
			for(j= 0; j< es.num_movimientos(); j++){		//	Para todos los movimientos de cada una de ellas
				mov = es.get_movimiento(j);
				t = es.duracion / ( mov.get_trayectorias().length); 
				/*
				 *		ZIGZAG
				 */
				if(mov.get_tipo() == 1){		
					trace(mov.get_trayectorias().length + " " + t);
					for(k = 0; k< mov.get_trayectorias().length; k++){
						if((j==0) && (k==0)){
							myTimeline[j].append( new TweenLite(mcs[j], t, 
														{x:(mov.get_trayectoria(k).x -(mcs[j].width/2)), y:(mov.get_trayectoria(k).y -(mcs[j].height/2)), 
															onStart: tramita_audio, onStartParams:[i]}) );
						}else{
							myTimeline[j].append( new TweenLite(mcs[j], t, {x:(mov.get_trayectoria(k).x -(mcs[j].width/2)), y:(mov.get_trayectoria(k).y -(mcs[j].height/2)) }) );
						}
					}	
				}
				/*
				 *		BEZIER
				 */
				if(mov.get_tipo() == 2){		
					dibujo = genera_bezier(mov);
					if(j==0){
						myTimeline[j].append(TweenMax.to(mcs[j], es.duracion, {bezier: dibujo, onStart: tramita_audio, onStartParams:[i]}));
					}else{
						myTimeline[j].append(TweenMax.to(mcs[j], es.duracion, {bezier: dibujo}));
					}
				}
			}
		}
		
		function genera_animacion_escalonada(es: Escena){
			var t: Number;
			var k,i,j,l: int = 0;
			var dibujo = new Array();
			//	j: Movimiento
			//	k: punto de trayectoria
			for(j = 0; j< es.num_movimientos(); j++){		//	Para todos los movimientos de cada una de ellas
				for(l=0; l <es.num_movimientos(); l++){		//	Again
					/*
				 	 *		MOVIMIENTOS PROPIAMENTE DICHOS
				 	 */
					if(j == l){		//	Movimiento bueno
						mov = es.get_movimiento(j);
						t = es.duracion / ( mov.get_trayectorias().length); trace(mov.get_trayectorias().lenght + " " + t);
						/*
				 		 *		ZIGZAG
				 		 */
						if(mov.get_tipo() == 1){		
							for(k = 0; k< mov.get_trayectorias().length; k++){
								myTimeline[l].append( new TweenLite(mcs[l], t, {x:(mov.get_trayectoria(k).x -(mcs[l].width/2)), y:(mov.get_trayectoria(k).y -(mcs[l].height/2)) }) );
							}	//	Paso al final
						}
						/*
				 		 *		BEZIER
				 		 */
						if(mov.get_tipo() == 2){		
							dibujo = genera_bezier(mov);
							if(j==0){
								myTimeline[j].append(TweenMax.to(mcs[j], es.duracion, {bezier: dibujo, onStart: tramita_audio, onStartParams:[i]}));
							}else{
								myTimeline[j].append(TweenMax.to(mcs[j], es.duracion, {bezier: dibujo}));
							}
						}
					/*
				 	 *		RELLENOS
				 	 */
					}else{			
						myTimeline[l].append( new TweenLite(mcs[l], es.duracion, {scaleX:1}) );
					}
				}
			}
		}
		
		private function genera_bezier(m: Movimiento){
			
			var dibujo: Array = new Array();
			var elem = new Array();
			var tr : Array = m.get_trayectorias();
			
			for(var i:int = 1; i<=tr.length-1; i++){
				elem[i] = new Object();
				elem[i]["x"] = tr[i].x;
				elem[i]["y"] = tr[i].y;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(m.get_x_ini(),m.get_y_ini());
			var point_1: Point = new Point(tr[0].x,tr[0].y); 
			elem[i] = new Object();
			elem[i]["x"] = point_1.x;
			elem[i]["y"] = point_1.y;
			dibujo.push(elem[i]);
			return dibujo;
		}
		
		
		//	Posiciona al comienzo de la escena i
		public function posiciona(i: int){
		
			var j: int; 
			esc = ej.get_escena(i);n_escena = i;
			for(j = 0; j < esc.num_movimientos(); j++){	
				mov = esc.get_movimiento(j);
				if(mov.get_elemento() >= 1000){
					//trace("url: " + url_jugador(mov.get_elemento()));
					ls[j].load(new URLRequest("C:/Users/Pots/Desktop/caras/"+url_jugador(mov.get_elemento())+".png"));
					ls[j].x = j;
					ls[j].contentLoaderInfo.addEventListener(Event.COMPLETE, img_loaded);
				}else{
					//trace("url: " + url_elemento(mov.get_elemento()));
					ls[j].load(new URLRequest( url_elemento(mov.get_elemento())));
					ls[j].x = 0; ls[j].y = 0;
					mcs[j].x = mov.get_x_ini()  - (mcs[j].width /2) ;		
					mcs[j].y = mov.get_y_ini()  - (mcs[j].height /2);
				}
			}
		}
		
		public function posiciona_seg(sec:Number){
			for(i = 0; i < myTimeline.length; i++){
				myTimeline[i].gotoAndStop(sec);
			}
		}
		
		function img_loaded(event:Event):void{
			var j: int = event.target.loader.x;
			var bmp: Bitmap = new Bitmap();
			bmp = event.target.loader.content as Bitmap;
			bmp.width = 50;	bmp.height = 50;
			bmp.x = 0; bmp.y = 0;
			mcs[j].x = ej.get_escena(n_escena).get_movimiento(j).get_x_ini();		
			mcs[j].y = mov.get_y_ini();
		}
		
		private function url_jugador(id: int): String{
			
			for(var i: int = 0; i< jugadores.length; i++){
				if(jugadores[i][0] == id){
					return jugadores[i][2];
				}
			}
			return "nada";
		}
		
		private function url_elemento(id: int): String{
			
			for(var i: int = 0; i< elementos_deportes[ej.nDeporte].length; i++){
				if( elementos_deportes[ej.nDeporte][i].id == id){
					return elementos_deportes[ej.nDeporte][i].imagen;
				}
			}
			return "nada";
		}
		
		public function play(){
			
			for(var i: int = 0; i< myTimeline.length; i++){
				myTimeline[i].play();
			}
		}
		
		public function pause(){
			
			for(var i: int = 0; i< myTimeline.length; i++){
				myTimeline[i].pause();
			}
		}
		
		public function resume(){
			
			for(var i: int = 0; i< myTimeline.length; i++){
				myTimeline[i].play();
			}
		}
		
		public function stop(){

			for(var i: int = 0; i< myTimeline.length; i++){
				myTimeline[i].gotoAndStop(0);
			}
		}
		
		function cambio_frame(){
			_tiempo.value = myTimeline[0].totalDuration * myTimeline[0].currentProgress;
		}
		
		public function graba(calidad: int){
		//cONFIG DEL VÍDEO
			this.calidad = calidad;
			m = new Mensaje_Central("Exportando vídeo, por favor espere", panel);
			myFile.browseForSave("Video name");
			myFile.addEventListener(Event.SELECT,seleccionado);
		}
		
		public function seleccionado(e:Event){
			var f: Fondo = fondos_deportes[0][0];
			bData = new BitmapData(f.anchura, f.altura, true);
			myFile.nativePath +=".flv";
			myWriter.createFile(myFile, f.anchura,f.altura, calidad, _tiempo.maximum);
			_graba();
		}
		
		public function _graba(){
			var dur: Number = _tiempo.maximum;
			var paso: Number = 1/calidad;
			var act: Number = paso;			
			while(act<dur){
				posiciona_seg(act);
				bData.draw(video);
				myWriter.saveFrame( bData );
				act += paso;	//trace(act);
				m.actualiza();
			}
			myWriter.closeFile();
			m.remove();
		}
		
		/*
		 * 		COMIENZO DE TRATAMIENTO DEL SONIDO
		 */
		public function reproduce(url: String){
		
			var snd:Sound = new Sound();
			var channel:SoundChannel;
			var req:URLRequest = new URLRequest(url);
            
            try {
                snd.load(req);
				snd.addEventListener(Event.COMPLETE, audio_cargado);
                channel = snd.play();
            }
            catch (err:Error) {
                trace(err.message);
            }
            channel.addEventListener(Event.SOUND_COMPLETE, final_sonido);
		}
		
		public function audio_cargado(e: Event){
			trace("audio cargado");
			trace(e.target.length);
		}

		public function final_sonido(e: Event){
			trace("fin cancion");
		}
		/*
		 * 		FIN DE TRATAMIENTO DEL SONIDO
		 */
		 public function get_video(): MovieClip{
			trace("return");
			return video; 
		 }
		 
		
	}
}