﻿package org.pizarra.video{	

	import jp.maaash.ObjectDetection.ObjectDetector;	
	import jp.maaash.ObjectDetection.ObjectDetectorEvent;	
	import jp.maaash.ObjectDetection.ObjectDetectorOptions;	
	import com.greensock.easing.Cubic;
	import com.greensock.*;
	import flash.net.URLRequest;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.TimerEvent;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.utils.Timer;
	import flash.media.Video;
	import flash.media.Camera;
	import flash.geom.Matrix;
	import flash.utils.ByteArray;
	import flash.filesystem.*;
	import com.adobe.images.PNGEncoder;
	import flash.display.BlendMode;
	import flash.geom.Rectangle;

	public class Foto{
		
		var p: Sprite;
		const __noFaceTimeout : int = 500;
		
		//how often to analyze the webcam image
		const __faceDetectInterval : int = 50;
		
		//color of the rectangle
		const __rectColor : int = 0xff0000;

		var _detector    :ObjectDetector;
		var _options     :ObjectDetectorOptions;
		var _bmpTarget   :Bitmap;

		var _detectionTimer : Timer;
		
		var _rects:Array;
		
		var _video : Video;
		var _noFaceTimer : Timer;
		
		var cameraContainer : Sprite;
		
		private var jugadores: Array;
		var camera : Camera;
		
		public function Foto(p: Sprite, jugadores: Array): void{
			
			this.p=p;
			this.jugadores = jugadores;
			
			_noFaceTimer = new Timer( __noFaceTimeout );
			_noFaceTimer.addEventListener( TimerEvent.TIMER , _noFaceTimer_timer);
			_rects = new Array( );
			_detectionTimer = new Timer( __faceDetectInterval );
			_detectionTimer.addEventListener( TimerEvent.TIMER , _detectionTimer_timer);
			_detectionTimer.start();
			
			_initDetector();
			_setupCamera();
			_detector.addEventListener( ObjectDetectorEvent.DETECTION_COMPLETE , _detection_complete );
		}
		
		function _setupCamera() : void{
			
			var index:int = 0;
			for ( var i : int = 0 ; i < Camera.names.length ; i ++ ) {
                
				if ( Camera.names[ i ] == "USB Video Class Video" ) {
					index = i;
				}
			}
			
			camera  = Camera.getCamera( String( index ) );
			camera.setMode(320, 240, 24);
            
			if (camera != null) {
				_video = new Video( camera.width , camera.height );
				_video.attachCamera( camera );
				p.addChild( _video );
				//registrador.add_elemento(_video);
				
			} else {
				trace( "You need a camera." );
			}
			
		}

		/**
		 * Called when No faces are found after __noFaceTimeout time
		 */
		function _noFaceTimer_timer (event : TimerEvent) : void {
			
			_noFaceTimer.stop();
			
			for (var i : int = 0; i < _rects.length; i++) {
					
					TweenLite.to( _rects[i] , .5, {
						alpha:0,
						x:_rects[i].x + _video.x, 
						y:_rects[i].y,
						ease:Cubic.easeOut	
					} );					
				}
		}

		/**
		 * Creates a rectangle
		 */
		function _createRect() : Sprite{
			
			var rectContainer : Sprite = new Sprite();
			rectContainer.graphics.lineStyle( 2 , __rectColor , 1 );
			rectContainer.graphics.beginFill(0x000000,0);
			rectContainer.graphics.drawRect(0, 0, 100, 100);
			return rectContainer;
			
		}
		
		/**
		 * Evalutates the webcam video for faces on a timer
		 */		
		function _detectionTimer_timer (event : TimerEvent) : void {
			
			_bmpTarget = new Bitmap( new BitmapData( _video.width, _video.height, false ) );
			_bmpTarget.bitmapData.draw( _video );
			_detector.detect( _bmpTarget );
		}


		/**
		 * Fired when a detection is complete
		 */
		function _detection_complete (event : ObjectDetectorEvent) : void {
			
			//no faces found
			if(event.rects.length == 0) return;
			
			//stop the no-face timer and start back up again
			_noFaceTimer.stop( );
			_noFaceTimer.start();
			
			//loop through faces found			
			for (var i : int = 0; i < event.rects.length ; i++) {
				
				//create rectangles if needed
				if(_rects[i] == null){
					_rects[i] = _createRect();
					p.addChild(_rects[i]);
				}
				
				//Animate to new size
				TweenLite.to( _rects[i] , .5, {
					alpha:1,
					x:event.rects[i].x*_video.scaleX + _video.x,
					y:event.rects[i].y*_video.scaleY,
					width:event.rects[i].width*_video.scaleX,
					height:event.rects[i].height*_video.scaleY,
					ease:Cubic.easeOut	
				} );
				
			}
			
			//hide the rest of the rectangles
			if(event.rects.length < _rects.length){
				for (var j : int = event.rects.length; j < _rects.length; j++) {
					TweenLite.to( _rects[j] , .5, {
						alpha:0,
						x:_rects[j].x,
						y:_rects[j].y,
						ease:Cubic.easeOut	
					} );					
				}
			}
		}
		
		/**
		 * Initializes the detector
		 */
		function _initDetector () : void {
			
			_detector = new ObjectDetector;
			_detector.options = getDetectorOptions( );
			_detector.loadHaarCascades( "face.zip" );
			
		}
		
		/**
		 * Gets dector options
		 */		
		function getDetectorOptions () : ObjectDetectorOptions {
			
			_options = new ObjectDetectorOptions;
			_options.min_size = 50;
			_options.startx = ObjectDetectorOptions.INVALID_POS;
			_options.starty = ObjectDetectorOptions.INVALID_POS;
			_options.endx = ObjectDetectorOptions.INVALID_POS;
			_options.endy = ObjectDetectorOptions.INVALID_POS;
			return _options;
			
		}
		
		public function para_reconocimiento(){
			_detectionTimer.stop();
			_detectionTimer.removeEventListener( TimerEvent.TIMER , _detectionTimer_timer);
			_detector.removeEventListener( ObjectDetectorEvent.DETECTION_COMPLETE , _detection_complete );
			camera = null;
			_video.attachCamera(null);
		}
		
		public function toma_foto(mc: MovieClip, id: String){
			
			var coef: Number = 0.6;
			var altura: Number = _rects[0].height + (coef * _rects[0].height );
			var anchura: Number = _rects[0].width + (coef * _rects[0].width ) ;
			var _x: Number = _rects[0].x - (coef * _rects[0].width )/2;
			var _y: Number = _rects[0].y - (coef * _rects[0].height )/2;
			var m:Matrix = new Matrix();
			var bmd:BitmapData = new BitmapData(anchura,altura,false);
			
			p.removeChild(_rects[0]);
			m.translate(-_x,-_y);
			bmd.draw(p,m,null,BlendMode.NORMAL,new Rectangle(0,0,anchura,altura),true);
			var ba:ByteArray = PNGEncoder.encode(bmd);
			var file:File = File.documentsDirectory.resolvePath("piz/caras/" + id +".png" );
			var fileStream:FileStream = new FileStream();
			fileStream.open(file,FileMode.WRITE);
			fileStream.writeBytes(ba);
			fileStream.close();
			//selected
			var rectContainer : Sprite = new Sprite();
			rectContainer.graphics.lineStyle( 4 , __rectColor , 1 );
			rectContainer.graphics.beginFill(0x000000,0);
			rectContainer.graphics.drawRect(_x, _y, anchura, altura);
			p.addChild(rectContainer);
			
			bmd = new BitmapData(anchura,altura,false);
			bmd.draw(p,m,null,BlendMode.NORMAL,new Rectangle(0,0,anchura,altura),true);
			ba = PNGEncoder.encode(bmd);
			var file2 = File.documentsDirectory.resolvePath("piz/caras/" + id +"_sel.png" );
			fileStream = new FileStream();
			fileStream.open(file2,FileMode.WRITE); fileStream.writeBytes(ba);	fileStream.close();
			
			var l: Loader = new Loader();
			l.load(new URLRequest(file.nativePath));
			mc.addChild(l);
		}
	}
}

/*





*/