package org.pizarra.io {	
	
	import flash.data.SQLConnection;
	import flash.data.SQLStatement;
	import flash.data.SQLResult;
	import deng.fzip.FZip;
	import deng.fzip.FZipFile;
	import flash.events.*;
	import flash.net.URLRequest;
	import org.pizarra.util.Constantes;
	
	public class ImportadorDeportesDA{
		
		private var con: SQLConnection;
		private var result:SQLResult;
		
		public function ImportadorDeportesDA(bdRef: SQLConnection) {
			con = bdRef;
		}
		
		public function importaDeporte(deporte: XML): String {
			
			//	Comienza la transaccion
			con.begin();
			try {
				var id: String = deporte.general.id.toString();
				if (!existeDeporte(id)) {
					//	Inserta Acciones
					insertaAcciones(deporte.actions.action);
					//	Inserta Deporte
					insertaDeporte(deporte.general);
					//	Inserta Elementos
					insertaElementos(deporte.elements.element,id);
					//	Inserta Terrenos
					insertaTerrenos(deporte.terrains.terrain, id);
				}else {
					trace("El deporte ya existe");
					con.rollback();
					return "El deporte ya existe";
				}
			}catch (error) {
				con.rollback();
				trace("Error :"+ error.message +" Details: "+ error.details);
				return "Error :"+ error.message +" Details: "+ error.details;
			}
			con.commit();
			return "";
		}
		
		//	Inserta las acciones asociadas a los deportes
		private function insertaAcciones(acciones: XMLList) {

			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			for each (var accion:XML in acciones) {
				insertStmt.text =  "insert into acciones (id, accion) ";
				insertStmt.text += "values( @id, @accion )";
				insertStmt.parameters["@id"] = accion.id.toString();
				insertStmt.parameters["@accion"] = accion.nombre.toString();
				insertStmt.execute();
			}
		}
		
		//	Inserta la información general del deporte en la base de datos
		private function insertaDeporte(deporte: XMLList) {
			//trace(deporte);
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			insertStmt.text =  "insert into Deporte (id, nombre, thumb) ";
			insertStmt.text += "values( @id, @nombre, @thumb )";
			insertStmt.parameters["@id"] = deporte.id.toString();
			insertStmt.parameters["@nombre"] = deporte.name.toString();
			insertStmt.parameters["@thumb"] = deporte.file.toString();
			insertStmt.execute();
		}
		
		private function insertaElementos(elementos: XMLList, id: String) {
			
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			for each (var elemento:XML in elementos) {
				insertaElemento(elemento, insertStmt);
				insertStmt = new SQLStatement();
				insertStmt.sqlConnection = con;
				insertaRelacionElementoDeporte(elemento, id , insertStmt);
				insertaAccionesElemento(elemento);
			}
		}
		
		private function insertaAccionesElemento(elemento: XML) {
			
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			for each (var accion: XML in elemento.elementActions.accion) {
				insertStmt.text =  "insert into puedeHacer (id_elemento, id_accion) ";
				insertStmt.text += "values( @id_elemento, @id_accion )";
				insertStmt.parameters["@id_elemento"] = elemento.id.toString();
				insertStmt.parameters["@id_accion"] = accion.toString();
				insertStmt.execute();
			}
		}
		
		private function insertaElemento(elemento: XML, insertStmt: SQLStatement) {
			
			insertStmt.text =  "insert into elemento"; 
			insertStmt.text += "(id_elemento, nombre, tipo, imagen, anchura, altura) ";
			insertStmt.text += "values( @id, @name, @tipo, @imagen, @wm, @hm )";
			insertStmt.parameters["@id"] = elemento.id.toString();
			insertStmt.parameters["@name"] = elemento.name.toString();
			insertStmt.parameters["@tipo"] = Constantes.COD_TIPO_DINAMICO;
			insertStmt.parameters["@imagen"] = elemento.file.toString();
			insertStmt.parameters["@wm"] = elemento.wm.toString();
			insertStmt.parameters["@hm"] = elemento.hm.toString();
			insertStmt.execute();
		}
		
		private function insertaRelacionElementoDeporte(elemento: XML,id: String, insertStmt: SQLStatement) {
			
			insertStmt.text =  "insert into tiene_elementos"; 
			insertStmt.text += "(id_elemento, deporte) ";
			insertStmt.text += "values( @id_elemento, @id_deporte )";
			insertStmt.parameters["@id_elemento"] = elemento.id.toString();
			insertStmt.parameters["@id_deporte"] = id;
			insertStmt.execute();
		}
		
		private function insertaTerrenos(terrenos: XMLList, id: String) {
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			for each (var terreno:XML in terrenos) {
				insertaTerreno(terreno, insertStmt);
				insertaRelacionTerrenoDeporte(terreno, id);
			}
		}
		
		private function insertaRelacionTerrenoDeporte(terreno: XML, id:String) {
			
			var insertStmt: SQLStatement = new SQLStatement();
			insertStmt.sqlConnection = con;
			insertStmt.text =  "insert into tiene_fondos (Deporte, id_fondo) ";
			insertStmt.text += "values( @id_deporte, @id_fondo )";
			insertStmt.parameters["@id_deporte"] = id;
			insertStmt.parameters["@id_fondo"] = terreno.id.toString();
			insertStmt.execute();
		}
		
		private function insertaTerreno(terreno: XML, insertStmt: SQLStatement) {
			insertStmt.text =  "insert into fondo";
			insertStmt.text += " (Id, nombre, imagen, anchura, altura, m_ancho, m_alto) ";
			insertStmt.text += "values( @id, @name, @img, @wpx, @hpx, @wm, @hm )";
			insertStmt.parameters["@id"] = terreno.id.toString();
			insertStmt.parameters["@name"] = terreno.name.toString();
			insertStmt.parameters["@img"] = terreno.file.toString();
			insertStmt.parameters["@wpx"] = 800;
			insertStmt.parameters["@hpx"] = 400;
			insertStmt.parameters["@wm"] = int(terreno.wm.toString());
			insertStmt.parameters["@hm"] = int(terreno.hm.toString());
			insertStmt.execute();
		}
		//	Test if the sport exists in the database
		private function existeDeporte(id: String): Boolean {
			
			var selectStmt: SQLStatement = new SQLStatement();
			selectStmt.sqlConnection = con;
			selectStmt.text = "select id from Deporte where id = @id";
			selectStmt.parameters["@id"] = id;
			try{
				selectStmt.execute();
			}catch (error){
				return "SELECT error:" + error + "error.message:"+ error.message +"error.details:"+ error.details;
			}
			result = selectStmt.getResult();
			//	Hay resultados?
			return result.data;
		}
	}
}