package org.pizarra.io {	
	
	import flash.data.SQLConnection;
	import deng.fzip.FZip;
	import deng.fzip.FZipFile;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.net.URLRequest;
	import org.pizarra.util.Eventos;
	import flash.filesystem.*;
	
	public class ImportadorDeportes extends EventDispatcher{
		
		private var bdRef: SQLConnection;
		private var zip:FZip;
		private var da: ImportadorDeportesDA;
		private var resultado: String = "";
		private var panel: Sprite;
		
		//	Parámetros
		private var _id: String;
		private var _nombre: String;
		private var _file: String;
		private var _elementos: String;
		
		//var thumb: Sprite = new Sprite();
		private var th: Loader = new Loader();
		
		public function ImportadorDeportes(con: SQLConnection, panel: Sprite) {
			bdRef = con;
			this.panel = panel;
			da = new ImportadorDeportesDA(bdRef);
		}
		
		public function carga(file:String) {
			zip = new FZip();
			zip.addEventListener(Event.COMPLETE, onCompleteCarga);
			zip.load(new URLRequest(file));
		}
		
		public function importa(file: String) {
			zip = new FZip();
			zip.addEventListener(Event.COMPLETE, onComplete);
			zip.load(new URLRequest(file));
		}
		
		//	HANDLERS
		private function onCompleteCarga(evt:Event):void {
			//	busca los metadatos del deporte
			try{
				var file:FZipFile= zip.getFileByName("deporte.xml");
				var xml = new XML(file.content);
				_id = xml.general.id.toString();
				_nombre = xml.general.name.toString();
				//	Get elementos
				_elementos = "";
				for each (var elemento:XML in xml.elements.element) {
					_elementos += elemento.name.toString() +  " ";
				}
				file = zip.getFileByName("uploads/" + xml.general.file.toString());
				_file = writeFile(file);
				
			}catch (error) {
				resultado = "Error :" + error.message +" Details: "+ error.details;
			}
			//	Prepara los parámetros de la carga
			dispatchEvent(new Event(Eventos.FINISHED_LOAD));
		}
		
		//	Inserta los elementos en la base de datos
		private function onComplete(evt:Event):void {
			var i: uint = 0;
			
			trace("zip con n: " + zip.getFileCount() + " elementos");
			while (i < zip.getFileCount()) {
				file = zip.getFileAt(i);
				trace("nombre: " + file.filename);
				i++;
				var outFile:File = File.documentsDirectory; // dest folder is desktop
				outFile = outFile.resolvePath("piz/" + file.filename);  // name of file to write
				var outStream:FileStream = new FileStream();
				outStream.open(outFile, FileMode.WRITE);
				outStream.writeBytes(file.content, 0, file.content.length);
				outStream.close();
			}
			var file:FZipFile;
			file = zip.getFileByName("deporte.xml");
			var xml = new XML(file.content);
			resultado = da.importaDeporte(xml);			
			//	Lo anade a los vectores
			
			//	Dispatch the result
			dispatchEvent(new Event(Eventos.FINISHED_IMPORT));
		}
		
		private function writeFile(file: FZipFile):String {
			var outFile:File = File.documentsDirectory; // dest folder is desktop
			outFile = outFile.resolvePath(file.filename);  // name of file to write
			var outStream:FileStream = new FileStream();
			outStream.open(outFile, FileMode.WRITE);
			outStream.writeBytes(file.content, 0, file.content.length);
			outStream.close();
			return outFile.nativePath;
		}
		
		/*private function loadThumb(filename: String) {
			
			var urlReq:URLRequest = new URLRequest(filename);
			th.contentLoaderInfo.addEventListener(Event.COMPLETE, cargadoThumb);
			th.load(urlReq);
		}
		
		private function cargadoThumb(e: Event) {
			th.width = 100;
			th.height = 100;
			panel.addChild(th);
		}*/
		
		//	GETTERS AND SETTERS
		public function get msg(): String { return resultado; }
		public function get id(): String { return _id; }
		public function get nombre(): String { return _nombre; }
		public function get file(): String { return _file; }
		public function get elementos(): String {return _elementos;}
	}
}