﻿package org.pizarra.graficos {
	import fl.controls.Label;
	import flash.display.*;
	import flash.events.MouseEvent;
	import org.pizarra.Trayectoria;
	import org.pizarra.util.*;
	import flash.utils.Dictionary;
	import org.pizarra.graficos.trayectoria.*;
	import flash.geom.Point;
	import flash.events.*;
	import org.pizarra.configuracion.Tema;
	
	public class TrayectoriaSprite extends Sprite {
		
		private var pointSprites: Array = new Array();
		private var actionSprites: Array = new Array();
		private var lineSprites: Array = new Array();
		private var ref: Sprite;
		private var element: Elemento_Concreto; 
		private var type: int;
		private var actionLabel: Action;
		private var currentTrayectoria: Array = new Array();
		
		private var _text: String = "";
		private var _points: Array;
		
		private var _hadListener: Boolean = false;
		
		
		public function TrayectoriaSprite(reference: Sprite, el: Elemento_Concreto) {
			this.ref = reference;
			this.element = el;
			actionLabel = new Action("");
			_points = new Array();
		}
		
		public function StartPath(type : int) {
			
			//	Clean in case another path was created
			CleanDisplay();
			this.type = type;
			pointSprites = new Array();
			lineSprites = new Array();
			currentTrayectoria = new Array();
			ref.addEventListener(MouseEvent.CLICK, dot_Click);
			_hadListener = true;
		}
		
		public function ContinuePath() {
			ref.addEventListener(MouseEvent.CLICK, dot_Click);
			_hadListener = true;
		}
		
		public function StopPath() {
			ref.removeEventListener(MouseEvent.CLICK, dot_Click);
			_hadListener = false;
		}
		
		public function CleanDisplay() {
			trace(pointSprites.length + " _ " + lineSprites.length)
			for (var i = 0; i < pointSprites.length; i++ ) {
				if (ref.contains(pointSprites[i])) {
					ref.removeChild(pointSprites[i]);
				}
			}
			for (var i = 0; i < lineSprites.length; i++ ) {
				if (ref.contains(lineSprites[i])) {
					ref.removeChild(lineSprites[i]);
				}
			}
		}
		
		/*	Action
		 =========================================================================**/
		public function SetAction(action: String) {
			if (action == actionLabel.Name) {
				actionLabel.Name = "";
			}else {
				actionLabel.Name = action;
			}
			actionLabel.x = element.x + element.width/2; 
			actionLabel.y = element.y + element.height/2;
			this.addChild(actionLabel);
		}
		
		public function UpdateAction() {
			actionLabel.x = element.x + element.width/2; 
			actionLabel.y = element.y + element.height/2;
		}
		
		
		/*	Paths
		 =============================================================================**/
		private function dot_Click(ev:MouseEvent):void {
			
			var insertedPoint: Punto = new Punto(ev.localX, ev.localY);
			
			if (type == Acciones.ZIGZAG_DIS || type == Acciones.ZIGZAG) {
				
				//	Tengo un sprite para la trayectoria
				pointSprites.push(insertedPoint);
				ref.addChild(insertedPoint);
				//	Guarda el punto
				drawLine(new Point(ev.localX, ev.localY));
				
				currentTrayectoria.push(new Point(ev.localX, ev.localY));
				insertedPoint.addEventListener(MouseEvent.MOUSE_DOWN, StartDragPoint);
				insertedPoint.addEventListener(MouseEvent.MOUSE_UP, StopDragPoint);			
				insertedPoint.addEventListener(MouseEvent.MOUSE_MOVE, BalancePath);			
			}
			
			if (type == Acciones.CIRCULAR || type == Acciones.CIRCULAR_DIS){ 
				
				//	Point
				pointSprites.push(insertedPoint);
				ref.addChild(insertedPoint);
				insertedPoint.addEventListener(MouseEvent.MOUSE_DOWN, StartDragPoint);
				insertedPoint.addEventListener(MouseEvent.MOUSE_UP, StopDragPoint);			
				insertedPoint.addEventListener(MouseEvent.MOUSE_MOVE, BalancePath);	
				
				//	Tengo un sprite para la trayectoria
				//pathSprite[activeElement.Id].addChild(new Punto(ev.localX, ev.localY));
				currentTrayectoria.push(new Point(ev.localX, ev.localY));
				if(currentTrayectoria.length > 1){
					//	remove previous bezier
					ref.removeChild(lineSprites[lineSprites.length - 1]);
					lineSprites = new Array();
				}
				if (type == Acciones.CIRCULAR) {
					var stPoint: Point = new Point(element.x + element.width / 2, element.y + element.height / 2);
					lineSprites.push(new Bezier(currentTrayectoria, stPoint ));
				}else {
					var stPoint: Point = new Point(element.x + element.width / 2, element.y + element.height / 2);
					lineSprites.push(new BezierDiscontinuo(currentTrayectoria, stPoint));
				}
				ref.addChild(lineSprites[lineSprites.length - 1]);
			}
			_points.push(new Point(ev.localX, ev.localY));
			//	Bring points to the pront
			PointsToFront();
		}
		
		private function drawLine(p: Point) {
			
			var init, fin : Point;
			if( currentTrayectoria.length==0 ){		
				//	Primer punto desde el centro del elemento
				init = new Point(element.x + element.width / 2, element.y + element.height / 2);
			}else {		
				//	siguientes puntos desde el anterior
				init = currentTrayectoria[currentTrayectoria.length-1];
			}
			fin = p;
			
			//	Draws the line
			if (type == Acciones.ZIGZAG) {
				lineSprites.push(new Linea(init, fin));
			}
			if (type == Acciones.ZIGZAG_DIS) {
				
				lineSprites.push(new LineaDiscontinua(init, fin));
			}
			ref.addChild(lineSprites[lineSprites.length - 1]);
		}
		
		private function PointsToFront(): void {
		 	
			for (var i = 0; i < pointSprites.length; i++ ) {
				if (pointSprites[i] is Punto) {
					ref.addChild(pointSprites[i]);
				}
			}
			ref.addChild(element);
		}
		
		private function StartDragPoint(e: Event) {
			//
			var punto: Punto = e.target as Punto;
			var i: uint = pointSprites.indexOf(punto); 
			punto.Dragging = true;
			punto.startDrag();
		}
		
		private function StopDragPoint(e: Event) {
			if (_hadListener) { 
				ref.addEventListener(MouseEvent.CLICK, dot_Click);
			}
			var punto: Punto = e.target as Punto;
			var i: uint = pointSprites.indexOf(punto); 
			_points[i] = new Point(punto.x, punto.y);
			punto.Dragging = false;
			punto.stopDrag();
		}
		
		private function BalancePath(e: Event) {
			var punto: Punto = e.target as Punto;
			var i: uint = pointSprites.indexOf(punto); 
			
			currentTrayectoria[i] = new Point(punto.x, punto.y);
			if(punto.Dragging){
				if (type == Acciones.ZIGZAG || type == Acciones.ZIGZAG_DIS){ 
					
					lineSprites[i].End = new Point(punto.x, punto.y);
					if (i < lineSprites.length-1) {
						lineSprites[i+1].Init = new Point(punto.x, punto.y);
					}
				}
				if (type == Acciones.CIRCULAR || type == Acciones.CIRCULAR_DIS) { 
					if(currentTrayectoria.length > 1){//	remove previous bezier
						ref.removeChild(lineSprites[lineSprites.length - 1]);
						lineSprites = new Array();
					}
					if (type == Acciones.CIRCULAR) {
						lineSprites.push(new Bezier(currentTrayectoria,new Point(element.x + element.width/2, element.y + element.height / 2)));
					}else {
						lineSprites.push(new BezierDiscontinuo(currentTrayectoria, new Point(element.x + element.width/2, element.y + element.height / 2)));
					}
					ref.addChild(lineSprites[lineSprites.length - 1]);
				}
			}
			ref.addChild(punto);
		}
		
		public function DrawCompletePath() {
			
			lineSprites = new Array();
			pointSprites = new Array();
			if(type != Acciones.ZIGZAG && type != Acciones.ZIGZAG_DIS 
			   && type != Acciones.CIRCULAR && type != Acciones.CIRCULAR_DIS )
			   return;
			   
			if(type == Acciones.ZIGZAG || type == Acciones.ZIGZAG_DIS){
				
				for (var i = 0; i < _points.length; i++ ) {
					var init, fin: Point;
					
					if (i == 0 && element != null) {
						init = new Point(element.x + element.width / 2, element.y + element.height / 2);
					}else {
						init = _points[i - 1];
					}
					if(element == null){
						init = _points[0];
					}
					fin = _points[i];
					
					if (type == Acciones.ZIGZAG) {
						lineSprites.push(new Linea(init, fin));
					}
					if (type == Acciones.ZIGZAG_DIS) {	
						lineSprites.push(new LineaDiscontinua(init, fin));
					}
					ref.addChild(lineSprites[lineSprites.length - 1]);
					
					pointSprites.push(new Punto(_points[i].x, _points[i].y));
					/*pointSprites[pointSprites.length-1].addEventListener(MouseEvent.MOUSE_DOWN, StartDragPoint);
					pointSprites[pointSprites.length-1].addEventListener(MouseEvent.MOUSE_UP, StopDragPoint);			
					pointSprites[pointSprites.length-1].addEventListener(MouseEvent.MOUSE_MOVE, BalancePath);*/
					ref.addChild(pointSprites[pointSprites.length-1]);
				}
			}else{
				currentTrayectoria = _points;
				for (var i = 0; i < _points.length; i++ ) {
					pointSprites.push(new Punto(_points[i].x, _points[i].y));
					/*pointSprites[pointSprites.length-1].addEventListener(MouseEvent.MOUSE_DOWN, StartDragPoint);
					pointSprites[pointSprites.length-1].addEventListener(MouseEvent.MOUSE_UP, StopDragPoint);			
					pointSprites[pointSprites.length-1].addEventListener(MouseEvent.MOUSE_MOVE, BalancePath);*/
					ref.addChild(pointSprites[pointSprites.length-1]);
				}
				
				var init: Point = (element == null)
									? new Point(_points[0].x, _points[0].y)
									: new Point(element.x + element.width/2, element.y + element.height / 2);
				
				if (type == Acciones.CIRCULAR) {
					//lineSprites.push(new Bezier(_points, new Point(element.x + element.width/2, element.y + element.height / 2)));
					lineSprites.push(new Bezier(_points, init));
				}else {
					//lineSprites.push(new BezierDiscontinuo(_points,new Point(element.x + element.width/2, element.y + element.height / 2)));
					lineSprites.push(new BezierDiscontinuo(_points,init));
				}
				ref.addChild(lineSprites[lineSprites.length - 1]);
			}
		}	
		
		public function Enable():void{
			for (var i = 0; i < _points.length; i++ ) {
				pointSprites[i].addEventListener(MouseEvent.MOUSE_DOWN, StartDragPoint);
				pointSprites[i].addEventListener(MouseEvent.MOUSE_UP, StopDragPoint);			
				pointSprites[i].addEventListener(MouseEvent.MOUSE_MOVE, BalancePath);
			}
		}
		
		public function Disable():void{
			for (var i = 0; i < _points.length; i++ ) {
				pointSprites[i].removeEventListener(MouseEvent.MOUSE_DOWN, StartDragPoint);
				pointSprites[i].removeEventListener(MouseEvent.MOUSE_UP, StopDragPoint);			
				pointSprites[i].removeEventListener(MouseEvent.MOUSE_MOVE, BalancePath);
			}
		}
		
		/*	Getters & setters
		 =============================================================================**/
		public function get Path(): Trayectoria {
			var tray: Trayectoria = new Trayectoria(new Point(1, 1));
			tray.Type = type;
			tray.Puntos = _points;
			return tray;
		}
		
		public function SetPath(tray: Trayectoria) {
			if(tray != null){
				_points = tray.Puntos;
				type = tray.Type;
				DrawCompletePath();
			}
		}
		
	
	}
}