﻿
package org.pizarra.graficos{
	
	import flash.display.DisplayObjectContainer;
	import fl.controls.DataGrid;
	import fl.controls.dataGridClasses.DataGridColumn;
	import fl.controls.ScrollPolicy;
	import fl.data.DataProvider;
	import flash.display.Sprite;
	import flash.geom.Point;
	import org.pizarra.Data.DibujoLibre;
	
	public class Selector_Libres extends Sprite{

		private var libres: Array;
		private var grid: DataGrid;
		
		private var dp: DataProvider; 
		private var col_id:DataGridColumn;
		private var col_nombre:DataGridColumn;
		private var col_info: DataGridColumn;
		private var col_fecha:DataGridColumn;
		private var col_modificacion:DataGridColumn;
		
		private var ANCHO_ID: int = 30;
		private var ANCHO_FECHA: int = 60;
		private var POS_X: int = 100;
		private var POS_Y: int = 170;
		private var NUM_REGISTROS: int = 15;
		private var ANCHURA: int = 700;
		
	
		public function Selector_Libres(dibujos: Array){
			grid = new DataGrid();
			libres = dibujos;
			monta_columnas();
			monta_datos();
			empaqueta();
			addChild(grid);
		}
		
		private function monta_columnas(){
			
			col_id = new DataGridColumn("ID");
			col_nombre = new DataGridColumn("Nombre");
			col_info = new DataGridColumn("Info");
			col_fecha = new DataGridColumn("Creacion");
			col_modificacion = new DataGridColumn("Modificacion");
			col_id.width = ANCHO_ID;
			/*col_fecha.width = ANCHO_FECHA; 
			col_fecha.resizable= false; 
			col_id.resizable=false;*/
			
		}
		
		private function monta_datos(){
			
			var i: int;
			dp = new DataProvider();
			//for (i = 0; i < ejercicios.length; i++) {
			for each(var dib: DibujoLibre in libres){
				dp.addItem({ID: dib.id, 
							Nombre: dib.titulo, 
							Info: dib.info, 
							Creacion: dib.fechaCreacion,
							Modificacion: dib.fechaModificacion});
			}
		}
		
		private function empaqueta(){
			
			
			grid.addColumn(col_id);
			grid.addColumn(col_nombre);
			grid.addColumn(col_info);
			grid.addColumn(col_fecha);
			grid.addColumn(col_modificacion);
			grid.dataProvider = dp;
			grid.width = ANCHURA;
			grid.rowCount = NUM_REGISTROS;
			grid.verticalScrollPolicy = ScrollPolicy.ON;
			grid.move(POS_X, POS_Y);
		}
		
		public function set_multiple(){
			grid.allowMultipleSelection = true;
		}
		
		public function set_posicion(p: Point){
			POS_X = p.x;
			POS_Y = p.y;
			grid.move(POS_X, POS_Y);
		}
		
		public function repinta(){
			
			monta_columnas();
			monta_datos();
			empaqueta();
		}
		
		public function get_grid(): DataGrid{
			return grid;
		}
		
		public function nuevos_datos(data: Array){
			dp = new DataProvider();
			for each(var dib: DibujoLibre in data){
				dp.addItem({ID: dib.id, 
							Nombre: dib.titulo, 
							Info: dib.info, 
							Creacion: dib.fechaCreacion,
							Modificacion: dib.fechaModificacion});
			}
			grid.dataProvider = dp;
		}
		
		public function get dataGrid(): DataGrid{
			return grid;
		}
	}
}