﻿
package org.pizarra.graficos{
	
	import flash.display.DisplayObjectContainer;
	import fl.controls.DataGrid;
	import fl.controls.dataGridClasses.DataGridColumn;
	import fl.controls.ScrollPolicy;
	import fl.data.DataProvider;
	import flash.display.MovieClip;
	import flash.geom.Point;
	import org.pizarra.Data.DibujoLibre;
	import org.pizarra.util.Constantes;
	
	public class Selector_Ejercicios extends MovieClip{

		private var ejercicios: Array;
		private var filtrados: Array;
		private var filtro: String;
		
		private var panel: DisplayObjectContainer;
		private var grid: DataGrid;
		
		private var dp: DataProvider = new DataProvider(); 
		private var col_id, col_image:DataGridColumn;
		private var col_nombre:DataGridColumn;
		private var col_info: DataGridColumn;
		private var col_tipo: DataGridColumn;
		private var col_fecha:DataGridColumn;
		
		private var ANCHO_ID: int = 30;
		private var ANCHO_FECHA: int = 150;
		private var ANCHO_TIPO: int = 100;
		private var POS_X: int = 100;
		private var POS_Y: int = 170;
		private var NUM_REGISTROS: int = 15;
		private var ANCHURA: int = 750;
		private var ALTURA: int = 350;
		
		public function Selector_Ejercicios(){
			monta_columnas();
			empaqueta();
			filtro = "";
		}
		
		private function monta_columnas(){

			var col_image:DataGridColumn = new DataGridColumn("data");
			//col_image.cellRenderer = LoaderCellRenderer;
			col_id = new DataGridColumn("ID");
			col_id.visible = false;
			col_nombre = new DataGridColumn("Nombre");
			col_info = new DataGridColumn("Info");
			col_tipo = new DataGridColumn("Tipo");
			col_fecha = new DataGridColumn("Fecha");
			col_id.width = ANCHO_ID;
			col_tipo.width = ANCHO_TIPO;
			col_tipo.resizable = false;
			col_fecha.width = ANCHO_FECHA; 
			col_fecha.resizable= false; 
			col_id.resizable=false;
		}
		
		private function monta_datos(){
			
			dp = new DataProvider();
			for (var i: int = 0; i < filtrados.length; i++) {
				dp.addItem(filtrados[i]);		
			}
			grid.dataProvider = dp;
			grid.sortItemsOn("Nombre");
		}
		
		public function addDibujos(dibujos: Array ) {
			var dp: DataProvider = grid.dataProvider;
			for (var i: int = 0; i < dibujos.length; i++) {
				var dib: DibujoLibre = dibujos[i];
				dp.addItem( {data: "http://www.helpexamples.com/flash/images/image1.jpg",
							ID: dib.id, 
							Nombre: dib.titulo, 
							Info: dib.info, 
							Tipo: Constantes.DISPOSICION,
							Fecha: dib.fechaCreacion});
			}
			grid.sortItemsOn("Nombre");
		}
		
		private function empaqueta(){
			
			grid = new DataGrid();
			grid.addColumn(col_id);
			grid.addColumn(col_nombre);
			grid.addColumn(col_info);
			grid.addColumn(col_tipo);
			grid.addColumn(col_fecha);
			grid.dataProvider = dp;
			grid.width = ANCHURA;
			grid.height = ALTURA;
			grid.rowCount = NUM_REGISTROS;
			grid.verticalScrollPolicy = ScrollPolicy.ON;
			this.addChild(grid);
		}
		
		public function set_multiple(){
			grid.allowMultipleSelection = true;
		}
		
		public function set_posicion(p: Point){
			POS_X = p.x;
			POS_Y = p.y;
			grid.move(POS_X, POS_Y);
		}
		
		public function pinta(){
			panel.addChild(grid);
		}
		
		public function muestra() {
			grid.visible = true;
		}
		
		public function oculta() {
			grid.visible = false;
		}
		
		public function repinta(){
			
			monta_columnas();
			monta_datos();
			empaqueta();
		}
		
		public function get_grid(): DataGrid{
			return grid;
		}
		
		public function nuevos_datos(data: Array){
			dp = new DataProvider();
			for(var i=0; i<data.length; i++){
				dp.addItem({ID: data[i].id, 
							Nombre: data[i].get_nombre(), 
							Info: data[i].get_info(), 
							Fecha: data[i].get_fecha()});
			}
			grid.dataProvider = dp;
		}
		
		public function get SelectedId():String {
			return grid.selectedItem["ID"];
		}
		
		/*
		 * PUBLIC INTERFACE
		 **/
		//	Assing the data source
		public function set DataSource(ejs: Array) {
			ejercicios = ejs;
			filtrados = ejs;
		}
		
		//	bind the data to the control and display it
		public function DataBind(): void {
			//	Filter values
			filtrados = new Array();
			for (var i: int = 0; i < ejercicios.length; i++) {
				if ((ejercicios[i].Nombre.toLowerCase().indexOf(filtro) != -1)	
					|| (ejercicios[i].Info.toLowerCase().indexOf(filtro) != -1)	
					|| (ejercicios[i].Tipo.toLowerCase().indexOf(filtro) != -1)	) {
						filtrados.push(ejercicios[i]);
					}
			}	
			monta_datos();
		}
		
		public function set Filter( filter: String): void {
			this.filtro = filter.toLowerCase();
		}
	}
}