﻿package org.pizarra.graficos{	
	
	import fl.containers.ScrollPane; 
	import fl.controls.listClasses.ImageCell;
	import fl.controls.ScrollPolicy; 
	import fl.controls.DataGrid; 
	import fl.data.DataProvider; 
	import flash.display.*;
	import flash.geom.Point;
	import flash.events.*;
	import flash.net.*;
	import flash.utils.Dictionary;
	import fl.transitions.*;
	import org.pizarra.Estado;
	import org.pizarra.events.LTPosicionesClickEvent;
	import org.pizarra.events.LTTrayectoriasClickEvent;
	import org.pizarra.util.Ficheros;
	import org.pizarra.Entity.*;
	
	//Transiciones
	import fl.transitions.*;
	import fl.transitions.easing.*; 
	import org.pizarra.configuracion.Preferencias;
	
	public class Linea_Tiempo extends Sprite{
		
		/*
		 *		CONFIGURACIÓN DEL ELEMENTO:
		 *		Todos los tamaños en pixels
		 */
		private var posicion: Point = new Point(10,500);
		private var altura: int = 95;
		private var anchura: int = 1000;
		private var color: int = 0xCCCCCC;					//	Color del fondo
		
		private var ALTURA_THUMB: int = 95;
		private var ANCHURA_THUMB: int;
		private var ANCHURA_TRANS: uint = 20;
		
		//private var url_transicion: String ="img/genericas/transicion.png";
		//private var url_transicion_sel: String ="img/genericas/transicion sel.png";
		/*
		 *		ATRIBUTOS
		 */
		private var _scroll:ScrollPane = new ScrollPane(); 	//	Panel de desplazamiento
		private var _linea:Sprite = new Sprite();			//	Panel propiamente dicho
		private var contenedor: DisplayObjectContainer;		//	Panel de la escena donde dibujar la linea de tiempo
		
		private var n_imagenes: uint = 0;
		private var n_transiciones: uint = 0;
		private var actual: uint = 0;
		
		private var loa = new Array();  
		private var loa_sel = new Array();
		private var thumbs: Array = new Array();
		private var paths: Array = new Array();
		private var elementImages: Array = new Array();
		private var thumbs_t: Array = new Array();
		private var sel: Sprite = new Sprite();
		
		//	Para saber que elementos esta seleccionados, guardo en enteros
		//	Se codifica el no seleccionado como -1
		private var t_sel: int = -1;	//	Transcion seleccionada
		private var p_sel: int = -1;	//	Posicionamiento seleccionado
		
		private var pref: Preferencias;
		
		
		//	Handle dynamic Timeline
		//	Escenas (reference to the Controller that keeps the state)
		private var escenas: Array;		//	states
		private var trayectorias: Array; //	paths
		private var elementos: Array;	//	element ids
		private var items: Array;		//	Element type
		private var urls: Dictionary;	//	element metadata
		
		private var urlFondo: String;
		
		
		/*
		 *		CONSTRUCTOR
		 */
		public function Linea_Tiempo(w: uint,p: Preferencias, urlFondo): void{
			
			this.urlFondo = urlFondo;
			dibuja_fondo(this.anchura);    
			_scroll.source = _linea; 
			_scroll.setSize(anchura, altura); 
			_scroll.move(posicion.x, posicion.y); 
			_scroll.horizontalScrollPolicy = "auto";
			_scroll.verticalScrollPolicy = "auto";
			addChild(_scroll);

			if(p.tablet == false){
				_scroll.addEventListener(MouseEvent.MOUSE_OVER, over);
				_scroll.addEventListener(MouseEvent.MOUSE_OUT, out);
				_scroll.horizontalScrollPolicy = "off";
				_scroll.verticalScrollPolicy = "off";
			}
			ANCHURA_THUMB = w;
			
			sel.graphics.lineStyle( 1, 0xFF0000 );
			sel.graphics.drawRect( 0, 0, ANCHURA_THUMB-1, ALTURA_THUMB-1);
			sel.graphics.endFill();
		}
		
		/*
		 *		MÉTODOS
		 */
		private function dibuja_fondo(anchura: uint):void { 
			_linea.graphics.beginFill(color, 1); 
			_linea.graphics.drawRect(0, 0, anchura, altura); 
			_linea.graphics.endFill();  
		}
		
		public function over(e: MouseEvent){ _scroll.horizontalScrollPolicy = "auto"; }
		
		public function out(e: MouseEvent){ _scroll.horizontalScrollPolicy = "off"; }
		
		public function add(): Sprite{
			//	Test si se ha de redimensionar la pantalla
			if((n_imagenes + 1) * (ANCHURA_THUMB + ANCHURA_TRANS) > anchura){
				dibuja_fondo((n_imagenes + 1) * (ANCHURA_THUMB + ANCHURA_TRANS));
				_scroll.update();
			}
			
			elimina_anterior_seleccion();
			thumbs[n_imagenes] = new Sprite();
			thumbs[n_imagenes].x = n_imagenes * (ANCHURA_THUMB + ANCHURA_TRANS);
			thumbs[n_imagenes].addChild(new Image(urlFondo,ANCHURA_THUMB,ALTURA_THUMB));
			thumbs[n_imagenes].addChild(sel);
			thumbs[n_imagenes].addEventListener(MouseEvent.CLICK, clickPosiciones);
			elementImages[n_imagenes] = new Array();
			_linea.addChild(thumbs[n_imagenes]);
			t_sel = -1;	p_sel = n_transiciones;
			n_imagenes ++;

			return thumbs[n_imagenes-1];

		}
		
		public function CreateNewScene(){
			//	Test si se ha de redimensionar la pantalla
			if((n_imagenes + 1) * (ANCHURA_THUMB + ANCHURA_TRANS) > anchura){
				dibuja_fondo((n_imagenes + 1) * (ANCHURA_THUMB + ANCHURA_TRANS));
				_scroll.update();
			}
		
			removePreviousSelection();
			thumbs[n_imagenes] = new Sprite();
			thumbs[n_imagenes].x = n_imagenes * (ANCHURA_THUMB);
			thumbs[n_imagenes].addChild(new Image(urlFondo,ANCHURA_THUMB,ALTURA_THUMB));
			thumbs[n_imagenes].addChild(sel);
			thumbs[n_imagenes].addEventListener(MouseEvent.CLICK, Scene_Click);
			elementImages[n_imagenes] = new Array();
			_linea.addChild(thumbs[n_imagenes]);
			t_sel = -1;	p_sel = n_transiciones;
			n_imagenes ++;
			
			//	Add Path sprites
			
			this.SelectScene(n_transiciones);
			
			return thumbs[n_imagenes-1];
		}
		
		public function actualiza(image: Bitmap, n: int){
			
			image.width = ANCHURA_THUMB; image.height = ALTURA_THUMB;
			thumbs[n-1].removeChildAt(0);
			thumbs[n-1].addChild(image);
		}
		
		public function add_t(): MovieClip{
	
			//	Precargo las imagenes, tanto seleccionada como no seleccionada
			loa_sel[n_transiciones]= new Loader();
			loa_sel[n_transiciones].load(new URLRequest(Ficheros.IMG_TRANS_SEL));
			loa_sel[n_transiciones].x = n_imagenes * ANCHURA_THUMB + (n_imagenes - 1 )* ANCHURA_TRANS;
			loa[n_transiciones] = new Loader();
			loa[n_transiciones].load(new URLRequest(Ficheros.IMG_TRANS));
			loa[n_transiciones].x = n_imagenes * ANCHURA_THUMB + (n_imagenes - 1 )* ANCHURA_TRANS;  
			
			thumbs_t[n_transiciones] = new MovieClip();
			thumbs_t[n_transiciones].addChild(loa_sel[n_transiciones]);
			thumbs_t[n_transiciones].addEventListener(MouseEvent.CLICK, clickTrayectorias);
			_linea.addChild(thumbs_t[n_transiciones]);
			
			elimina_anterior_seleccion();
			t_sel = n_transiciones;	p_sel = -1;
			n_transiciones ++;

			return thumbs_t[n_transiciones-1];
		}
		
		private function elimina_anterior_seleccion(){
			if(t_sel != -1){
				thumbs_t[t_sel].removeChildAt(loa_sel[t_sel]);
				thumbs_t[t_sel].addChild(loa[t_sel]);
			}
			if(p_sel != -1){
				thumbs[p_sel].removeChild(sel);
			}
		}
		
		private function removePreviousSelection(): void{
			if(t_sel != -1){
				thumbs_t[t_sel].removeChildAt(loa_sel[t_sel]);
				thumbs_t[t_sel].addChild(loa[t_sel]);
			}
		}
		
		public function selecciona2(s: MovieClip): uint{
			
			var elem: uint = thumbs.indexOf(s);
			
			elimina_anterior_seleccion();
			thumbs[elem].addChild(sel);		//	Selecciona
			t_sel = -1;	p_sel = elem;
			return elem + 1;
		}		
		
		public function selecciona(el: int): uint{
			elimina_anterior_seleccion();
			thumbs[el].addChild(sel);		//	Selecciona
			t_sel = -1;	p_sel = el;
			return el + 1;
		}		
		
		public function selecciona_t(el: int): uint{
			
			if(el == -1){//	elemento ya seleccionado
				return t_sel+1;
			}else{
				elimina_anterior_seleccion();
				t_sel = el;	p_sel = -1;
				thumbs_t[el].removeChildAt(0);
				thumbs_t[el].addChild(loa_sel[el]);
			}
			return el + 1;
		}		
		
		public function selecciona_t2(l: Loader): uint{
			
			var elem: int = loa.indexOf(l);
			if(elem == -1){//	elemento ya seleccionado
				return t_sel+1;
			}else{
				elimina_anterior_seleccion();
				t_sel = elem;	p_sel = -1;
				thumbs_t[elem].removeChildAt(0);
				thumbs_t[elem].addChild(loa_sel[elem]);
				//trace("p: " + p_sel + " t: " + t_sel);
			}
			return elem + 1;
		}	
				
		//	LISTENERS
		public function clickPosiciones(e: Event) {
			selecciona(thumbs.indexOf(e.currentTarget));
			this.dispatchEvent( new LTPosicionesClickEvent(thumbs.indexOf(e.currentTarget) + 1));
		}
		
		public function Scene_Click(e: Event) {
			var el: uint = thumbs.indexOf(e.currentTarget);
			removePreviousSelection();
			thumbs[el].addChild(sel);		//	Selecciona
			t_sel = -1;	p_sel = el;
			//selecciona(thumbs.indexOf(e.currentTarget));
			this.dispatchEvent( new LTPosicionesClickEvent(thumbs.indexOf(e.currentTarget) + 1));
		}
		
		public function SelectScene(n:uint): void{
			removePreviousSelection();
			thumbs[n].addChild(sel);		//	Selecciona
			t_sel = -1;	p_sel = n;
			this.Update();
		}
		
		public function clickTrayectorias(e: Event) {
			selecciona_t(loa.indexOf(e.target));
			this.dispatchEvent( new LTTrayectoriasClickEvent(loa.indexOf(e.target) + 1));
		}
		
		//	Update the positions
		public function Update(): void {
			for (var i = 1; i < escenas.length; i++ ) {
			//	For every scene
				for (var j = 0; j < elementos.length; j++ ) {
				//	For every element
					var estado: Estado = escenas[i][elementos[j]];
					elementImages[i-1][j].x = estado.posicion.x * this.ANCHURA_THUMB / 800;
					elementImages[i-1][j].y = estado.posicion.y * this.ALTURA_THUMB / 400;
					elementImages[i-1][j].rotation = estado.rotacion;
				}
			}
		}
		
		public function RemoveScene(n: uint): void{
			_linea.removeChild(thumbs[thumbs.length-1]);
			n_imagenes--;
			Update();
		}
		
		
		//	Reload the images
		public function Reload(): void {
			//	Remove all the elements
			for ( var i = 1; i < this.numChildren; i++) {
				this.removeChildAt(i);
			}
			
			for (var i = 1; i < escenas.length; i++ ) {
			//	For every scene
				for (var j = 0; j < elementos.length; j++ ) {
				//	For every element
					var estado: Estado = escenas[i][elementos[j]];
					var element: ElementoBE = urls[items[j]];
					var wThumb: Number = 10;
					var hThumb: Number = 10;
					//	Clear the element
					if ( elementImages[i-1][j] != null 
						&& thumbs[i-1].contains(elementImages[i - 1][j])) {
						thumbs[i-1].removeChild(elementImages[i - 1][j]);
					}
					elementImages[i-1][j] = new Image(element.imagen, wThumb, hThumb);
					elementImages[i-1][j].x = estado.posicion.x * this.ANCHURA_THUMB / 800;
					elementImages[i-1][j].y = estado.posicion.y * this.ALTURA_THUMB / 400;
					elementImages[i-1][j].rotation = estado.rotacion;
					thumbs[i - 1].addChild( elementImages[i-1][j] );
				}
			}
		}
		
		
		
		/*
		 *		GETTERS Y SETTERS
		 */
		public function get scroll():Sprite{ return _scroll; }
		public function get sprite():Sprite { return _linea;	}
		
		public function set Escenas(value: Array): void { escenas = value; }
		public function set Trayectorias(value: Array): void { trayectorias = value; }
		public function set Elementos(value: Array): void { elementos = value; }
		public function set Urls(value: Dictionary): void { urls = value; }
		public function set Items(value: Array): void { items = value; }
	}
}



