﻿package org.pizarra.graficos{	
	
	//		GENERALES
	import flash.events.*;
	import flash.display.MovieClip;
	import flash.display.Bitmap;
	import flash.net.URLRequest;
	import flash.display.Loader;
	import flash.geom.Point;
	import flash.display.Shape;
	
	//		PIZARRA
	import org.pizarra.util.Semaforo;
	import org.pizarra.Estado
	import org.pizarra.util.GUID;
	
	//		TEMPORIZADORES
	import flash.utils.Timer;
    import flash.events.TimerEvent;
	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.text.*;
	
	//		CLONACION DE OBJETOS
	import flash.net.registerClassAlias;
	import flash.utils.ByteArray;
	
	//		ANIMACIONES
	/*import fl.transitions.Tween;
	import fl.transitions.TweenEvent;
	import fl.transitions.easing.*;*/
	
	
	import flash.net.URLRequest;
	import flash.ui.*;
			 
	import com.greensock.*; 
	import com.greensock.easing.*;
	import com.greensock.plugins.*;
		
	import com.dncompute.graphics.GraphicsUtil;
		
	import org.pizarra.graficos.DashedLine;
	import org.pizarra.graficos.Draw;
		
	import fl.controls.Slider;
	import org.pizarra.graficos.DrawingShapes;
	import org.pizarra.Entity.*;
	import org.pizarra.util.Eventos;
	
	import org.pizarra.events.ElementAddedEvent;
	import org.pizarra.events.ElementMoveEvent;
	import org.pizarra.Util;
	import org.pizarra.util.Constantes;
	
	public class Elemento_Concreto extends Sprite {
	
		//	EVENTOS
		public static const ROTAR: String = "ROTAR";
		public static const ZIGZAG: String = "ZIGZAG";
		public static const ZIGZAG_DIS: String = "ZIGZAG_DIS";
		public static const CIRCULAR: String = "CIRCULAR";
		public static const CIRCULAR_DIS: String = "CIRCULAR_DIS";
		public static const CONTINUE: String = "CONTINUE";
		public static const DELETE_PATH: String = "DELETE_PATH";
		public static const ACTION: String = "ACTION";
		
		public static const DELETE: String = "DELETE";
		public static const DELETE_ANTERIORES: String = "DELETE_ANTERIORES";
		public static const DELETE_POSTERIORES: String = "DELETE_POSTERIORES";
		
		
		
		//	CONSTANTES
		/**/private var ERROR_X: int = -1000;
		/**/private var ERROR_Y: int = -1000;
		/**/private var PUNTO_ERROR: Point = new Point(ERROR_X, ERROR_Y);
		/**/private var ROTACION_ERROR: uint = 0;
		private var INVISIBLE: Point = new Point(-1000,-1000);
		private var PANEL_X: int = 160;
		private var PANEL_Y: int = 50;
		private var anchura: int;
		private var altura: int;
		
		//	ATRIBUTOS
		//	Master properties
		public var Id: String;
		public var Guid: String;
		
		public var _id: int;					//	Id individual de la instancia
		public var id: String;

		public var IdElemento: String;
		private var id_elemento: String;		//	ID del elemento que representa
		private var _nombre: String;			//	etiqueta de la instancia
		private var url: String;			//	imagen
		
		//	MODELO
		private var instances;					//	Referencia a la lista de instancias del elementos
		private var escena_actual: int = 1;
		private var disp: Array;				//	Almacena una referencia a las disposiciones
		private var data: Array = new Array();	//	Datos para las transiciones
		private var tr: Array = new Array();
		private var num_paso: int = 0;
		private var tiempo: Number = 0.0;
		
		private var eliminados_listeners: Boolean = false;
		private var _x: int;
		private var _y: int;
		private var posiciones: Array = new Array();	/***************/
		private var _el: ElementoBE;
		private var f_x: Number;
		private var f_y:Number;
		//	VISTA
		private var mc: MovieClip;				//	Dibujo del elemento en sí
		private var principal: Sprite;		//	Panel de dibujo de la escena
		private var panel_animacion: MovieClip;	//	Panel de la animación en la vista previa
		private var mc_tr: MovieClip = new MovieClip();	//	MovieClip para la trayectoria
		private var mc_bez: MovieClip = new MovieClip();
		private var etiqueta:TextField;
		private var f: Shape = new Shape();							//	Forma del fondo
		private var circles: Array = new Array();					//	Array de movieClips con lso puntos de la trayectoria 
		private var lineas: Array = new Array();
		private var t: Trayectorias;
		
		//	AUXILIARES
		private var loader,loader2:Loader;
		var bmp:Bitmap = new Bitmap();
		var bmp2:Bitmap = new Bitmap();
		private var tipo_tray: Array = new Array();
		
		//	OBJETOS
		private var semaforo: Semaforo;
		
		var cierre: Loader = new Loader();
		var contextual:ContextMenu = new ContextMenu();
		
		private var contextualTransiciones:ContextMenu = new ContextMenu();
		private var contextualPosiciones:ContextMenu = new ContextMenu();
		
		var dibujo = new Array();
		var panel: Stage;
		
		//	MENUS CONTEXTUALES
		var t_lineal:ContextMenuItem = new ContextMenuItem("Trayectoria lineal" );
		var t_circular:ContextMenuItem = new ContextMenuItem("Trayectoria circular");
		var t_circular_disc:ContextMenuItem = new ContextMenuItem("Circular Discontinua");
		var t_zigzag:ContextMenuItem = new ContextMenuItem("Trayectoria zigzag" );
		var t_zigzag_disc:ContextMenuItem = new ContextMenuItem("Zigzag Discontinuo" );
		var cont_trayectoria:ContextMenuItem = new ContextMenuItem( "Continuar Trayectoria" );
		var eliminar_tran:ContextMenuItem = new ContextMenuItem( "Eliminar Trayectoria" );
		
		var s: Slider;
		
		/***	NUEVAS	**/
		//	Creo una variable de estado de error para utilizar una referencia a la misma y no nuevos objetos cada vez que la necesite
		private var ESTADO_ERROR: Estado = new Estado(PUNTO_ERROR,ROTACION_ERROR);
		
		private var posicionado: Boolean = false;	//	Si el elemento se ha posicionado(1a vez)
		
		private var acciones: Array = new Array();
		private var ultimaAccionPulsada: AccionBE;
		
		/*
		 *		ACCIONES SOBRE EL ELEMENTO CONCRETO
		 *		INSERTAR NUEVO 	-	Si hay escenas anteriores se posiciona a error
		 *						-	Si no las hay se rellena el vector con la posición
		 *		MOVER ELEMENTO	-	Si hay trayectoria anterior, actualizar el último punto
		 */
		private var anterior_pos: Point = new Point(-1,-1);
		/*
		 *		CONSTRUCTOR
		 *		Pasa los parámetros
		 */
		public function Elemento_Concreto(	el: ElementoBE,
										  	f_x: Number,
										  	f_y: Number,
											panel: Stage){				//	semáforo
	
			this.id_elemento = el.id;
			this.IdElemento = el.id;
			this.Id = GUID.create();
			this._nombre = el.nombre;
			this.url = el.imagen;
			this.anchura = el.anchura * f_x;
			this.altura = el.altura * f_y;

			this.panel = panel;
			_el = el;
			this.f_x = f_x;
			this.f_y = f_y;
			this.id = el.id;// Util.nuevoId();
			
			//	ACCION INSERTAR NUEVO
			/*if(semaforo.escena>1){		//	No estoy en la última escena
				trace("------------------------------------------------------");
				trace("el( " + _id + " tipo: " + _el.id + " ) Completa las primeras");
				for(var i: int = 1; i < semaforo.escena; i++){
					trace("-- Completo posicion " + i);
					posiciones[i] = ESTADO_ERROR;
					tr[i]= new Array();
				}
			}*/
			//	No puedo completar hacia delante aún porque no se la posición
		
			//PANEL_X = principal.x;
			//PANEL_Y = principal.y;
			
			//principal.addChild(mc_tr);		//	Añado el panel de trayectorias del objeto	
			//principal.addChild(mc_bez);		//	Añado también el de los beziers
			
			//tr[semaforo.escena]= new Array();	//	Inicializo el vector de trayectorias de la primera escena
			/*cierre.addEventListener(MouseEvent.CLICK, fin_trayectoria); 
			cierre.addEventListener(IOErrorEvent.IO_ERROR, errorCarga);
			cierre.load(new URLRequest("img/app/done.png"));*/
			anade_listeners();
			this.buttonMode = true;
			loader = new Loader(); 
			var urlReq:URLRequest = new URLRequest(_el.imagen);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, errorCarga);
			loader.load(urlReq);
			menuContextualPosiciones();
			menuContextualTransiciones();
			contextMenu = contextualPosiciones;
		}		
		
		
		/*
		 *	Dibuja el elemento en el movieclip y la posicion indicadas
		 *	por los parámetros. PRIMERA VEZ, despues se utiliza REPINTA()
		 */
		public function dibuja(lugar: Sprite, x: int, y: int){
			
			mc = new MovieClip();
			mc.doubleClickEnabled = true;	//	Habilita el doble click
			principal.addChild(mc);
			mc.x=x; mc.y=y;
			anade_listeners();
			
			//	Completo hacia adelante
			/*if(semaforo.escena < semaforo.ultima){		//	Relleno hacia delante con la posicion
				trace("------------------------------------------------------");
				trace("el( " + _id + " tipo: " + _el.id + " ) Completa las siguientes");
				//var i: int = semaforo.ultima;
				for(var i: int = semaforo.escena+1; i <= semaforo.ultima; i++){
					trace("- - Completo posicion " + i);
					posiciones[i] = new Estado(new Point(x,y),0);
					tr[i] = new Array();
				}
			}*/
			//	Se carga la imagen
			loader = new Loader(); 
			var urlReq:URLRequest = new URLRequest(_el.imagen);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, errorCarga);
			loader.load(urlReq);
			acciones_mov();
			
		}	
		
		function errorCarga(e: IOErrorEvent) {
			trace("Error cargando");
		}
			
		//	Fuerza el inicio del drag en el nuevo elemento
		//	Llamado la primera vez
		function start_drag(){	
			this.startDrag();	
		}
		
		//	Se pulsa el elemento, se empieza el arrastre
		function pulsado(event:Event):void {	
			//	Salva el estado anterior
			if (posicionado) {
				//	Solamente si esta posicionado
				anterior_pos = new Point(this.x, this.y);
			}
			this.addEventListener( MouseEvent.MOUSE_MOVE, movido);
			this.startDrag();	
		}

		private function fuera_de_rango():Boolean{
			/*if((mc.x - semaforo.fondo_x)<0) return true;
			if((mc.y - semaforo.fondo_x)<0) return true;
			if(mc.x > (principal.width - semaforo.fondo_x)) return true;
			if(mc.y > (principal.height - semaforo.fondo_y)) return true;*/
			return false;
		}
		
		//	Se suelta el elemento
		function soltado(event:Event):void{
			this.removeEventListener( MouseEvent.MOUSE_MOVE, movido);
			//	Stop the drag on the element
			this.stopDrag();
			if (!posicionado) {
				//	First time
				anadidoElemento();
			}else {
				//	Moved
				movidoElemento();
			}
			
		}
		
		//	Se suelta el elemento
		function movido(event:Event):void {
			movidoElemento();
		}
		
		//	Called when the element is dropped in the scene
		private function anadidoElemento() {
			//	Anuncia que se ha anadido correctamente
			this.dispatchEvent(new ElementAddedEvent(this));
			posicionado = true;
		}
		
		//	Called when the element is moved
		private function movidoElemento() {
			this.dispatchEvent(new ElementMoveEvent(this));
		}
		
		private function equilibra_trayectorias(){
			
			//	Equilibro por detrás
			//	El movimiento anterior debe terminar en la posición nueva
			if((semaforo.escena != 1) && (_el.tipo == "dinamico")){
				
				if(tr[semaforo.escena-1].length >0){	//	Ya tiene trayectoria
					tr[semaforo.escena-1].push(new Point(mc.x,mc.y));
				}else{	//	No tenía trayectoria
					tr[semaforo.escena-1][0] = new Point(mc.x,mc.y);
				}
			}
			//	Equilibro por delante
			if((semaforo.escena != semaforo.ultima) && (_el.tipo == "dinamico")){
				tr[semaforo.escena+1][0] = new Point(mc.x,mc.y);
			}
			
			//	He movido un elemento y tengo que recalcular la anterior trayectoria
			/*if((semaforo.escena != 1) && (_el.tipo == "dinamico")){	//	En la escena primera no tiene posicion anterior
				if((tr[semaforo.escena - 1] == null) || (tr[semaforo.escena - 1].length == 0) ){	
					tr[semaforo.escena - 1] = new Array();		//	No tenia asignada trayectoria
					tr[semaforo.escena - 1].push(new Point(mc.x,mc.y));
					tipo_tray[semaforo.escena - 1] = 1;
					trace("Equilibro - creo nueva");
				}else{	//	Cambio el ultimo elemento
					trace("Equilibro - actualizo el ultimo punto");
					if((tipo_tray[semaforo.escena - 1] == 1) || (tipo_tray[semaforo.escena - 1] == 3)){	//	zigzag
						tr[semaforo.escena - 1][tr[semaforo.escena - 1].length-1] = new Point(mc.x,mc.y);
					}
					if((tipo_tray[semaforo.escena - 1] == 2) || (tipo_tray[semaforo.escena - 1] == 4)){	//	zigzag
						tr[semaforo.escena - 1][0] = new Point(mc.x,mc.y);
					}
					//tr[semaforo.escena - 1][tr[semaforo.escena - 1].length-1] = new Point(mc.x,mc.y);
				}
			}*/
		}
					
		private function completa_atras():void{
			trace("completa ATRÁS ");
			for(var i: int = 1; i < semaforo.escena; i++){
				posiciones[i] = new Estado(new Point(ERROR_X,ERROR_Y),0);
				tr[i]= new Array();
			}
		}
		
		private function completa_delante():void{
			trace("completa ADELANTE");
			var i: int = semaforo.ultima;
			while(posiciones[i] == null){
				posiciones[i] = new Estado(new Point(mc.x,mc.y),0);
				tr[i] = new Array();
				i--;
			}
		}
					
		//	Dibuja la imagen y la etiqueta
		function imgLoaded(event:Event):void{
			
			// 	Lo dibuja a través de un bitmap para poder redimensionarla
			if(posicionado){this.removeChild(bmp);}
			bmp = new Bitmap();
			bmp = loader.content as Bitmap;
			bmp.width = _el.anchura * f_x;
			bmp.height = _el.altura * f_y;
			//##########
			//bmp.x = -(bmp.width / 2);
			//bmp.y = -(bmp.height / 2);
			bmp.x = 0;
			bmp.y = 0;
			this.addChild(bmp);
			
			//	Dibuja la etiqueta
			/*if(posicionado){ this.removeChild(etiqueta);	}
			etiqueta = new TextField();
			etiqueta.autoSize = TextFieldAutoSize.LEFT;
			//etiqueta.text = _nombre;
			this.addChild(etiqueta);*/
		}
		
		
	/*
	 *		COMIENZO DE DIBUJO DE LAS TRAYECTORIAS
	 */
		
		
		public function pulsa_circulo(e: Event){
			e.target.startDrag();
			principal.addEventListener(MouseEvent.MOUSE_MOVE, mueve_circulo);
			//if(tipo_tray[semaforo.escena] == 1)
				//principal.removeEventListener(MouseEvent.CLICK, click_zigzag);
				//principal.removeEventListener(MouseEvent.CLICK, click);
			//if(tipo_tray[semaforo.escena] == 2)
				//principal.removeEventListener(MouseEvent.CLICK, click_circular);
				//principal.removeEventListener(MouseEvent.CLICK, click);
		}
		
		public function suelta_circulo(e: Event){
			
			e.target.stopDrag();
			principal.removeEventListener(MouseEvent.MOUSE_MOVE, mueve_circulo);
			var i: int = circles.indexOf(e.target);
			/*tr[semaforo.escena][i] = new Point(e.target.x,e.target.y);
			if(tipo_tray[semaforo.escena] == 1){
				elimina_t();
				dibuja_trayectoria(true);
				principal.addEventListener(MouseEvent.CLICK, click_zigzag);
			}
			if(tipo_tray[semaforo.escena] == 2){
				dibuja_bezier();
				principal.addEventListener(MouseEvent.CLICK, click_circular);
			}*/
		}
		
		public function redibuja_lineas(i: int){
			//Mueve las líneas anterior y posterior si existe;
			//trace(i + " " + lineas.length);
			if(i == 0){	//	Primer punto
				//trace("primer punto");
				mc_tr.removeChild(lineas[i]);
				dibuja_linea(new Point(mc.x,mc.y),tr[semaforo.escena][i],i);
			}else{
				//trace("otro punto");
				mc_tr.removeChild(lineas[i]);
				dibuja_linea(tr[semaforo.escena][i-1],tr[semaforo.escena][i],i);
			}
			if((lineas.length - 1) > i){
				mc_tr.removeChild(lineas[i+1]);
				dibuja_linea(tr[semaforo.escena][i],tr[semaforo.escena][i+1],i+1);
			}
			//trace(i + " " + lineas.length);
		}
		
		public function mueve_circulo(e: MouseEvent){
			
			var p: Point;
			var i: int = circles.indexOf(e.target);
			
			if(i != -1){
				tr[semaforo.escena][i] = new Point(e.target.x,e.target.y);
				if(tipo_tray[semaforo.escena] == 1){
					redibuja_lineas(i);
				}
				if(tipo_tray[semaforo.escena] == 2){
					dibuja_bezier();
				}
			}
		}
		
		
		public function dibuja_bezier_dis():void{
			
			principal.removeChild(mc_bez);
			mc_bez = new MovieClip();
			principal.addChild(mc_bez);
			
			var pointArray = new Array();
			dibujo = new Array();
			var elem = new Array();
			var numPoints = tr[semaforo.escena].length-1;
			var oData = new Object();
			
			for(var i:int = 1; i<=numPoints; i++){
				pointArray.push(tr[semaforo.escena][i]);
				elem[i] = new Object();
				elem[i]["x"] = tr[semaforo.escena][i].x;
				elem[i]["y"] = tr[semaforo.escena][i].y;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(mc.x,mc.y);
			var point_1: Point = tr[semaforo.escena][0];
			elem[i] = new Object();
			elem[i]["x"] = point_1.x;
			elem[i]["y"] = point_1.y;
			dibujo.push(elem[i]);
			
			for(i = 0; i<pointArray.length; i++){
				oData["x"+i] = pointArray[i].x;
				oData["y"+i] = pointArray[i].y;
				oData["dx"+i] = ((i+1) == numPoints) ? point_1.x : pointArray[(i+1)].x;
				oData["dy"+i] = ((i+1) == numPoints) ? point_1.y : pointArray[(i+1)].y;
				oData["cx"+i] = (oData["x"+i]+oData["dx"+i])/2;
				oData["cy"+i] = (oData["y"+i]+oData["dy"+i])/2;
			}

			var dl = new DashedLine(mc_bez,1,5);
			dl.lineStyle(3,0x000000,1);
			dl.moveTo(point_0.x, point_0.y);
			for (i=0; i<numPoints; i++) {
				dl.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);		
			}
			dl.lineTo(point_1.x, point_1.y);
			
		}
		
		
		public function dibuja_trayectoria(listeners:Boolean=false){
			
			var i: int = 0; 
			var test: Boolean;
			elimina_t();
			if((tipo_tray[semaforo.escena] == 1) || (tipo_tray[semaforo.escena] == 3) ){
				circles = new Array();	lineas = new Array();
				if((tr[semaforo.escena].length > 0)){
					//trace(tr[semaforo.escena].length+" puntos");
					for(var j: int = 0; j < tr[semaforo.escena].length; j++){
						if( (j == 0) && (tipo_tray[semaforo.escena] == 1)){		//	Primer punto desde el centro del elemento
							dibuja_linea(new Point(mc.x,mc.y), new Point(tr[semaforo.escena][0].x,tr[semaforo.escena][0].y), i+1);
						}
						if( (j == 0) && (tipo_tray[semaforo.escena] == 3)){		//	Primer punto desde el centro del elemento
							dibuja_linea_dis(new Point(mc.x,mc.y), new Point(tr[semaforo.escena][0].x,tr[semaforo.escena][0].y), i+1);
						}
						if(j>0){		//	siguiente puntos desde el anterior
							var init: Point = new Point(tr[semaforo.escena][j-1].x,tr[semaforo.escena][j-1].y);
							var fin: Point = new Point(tr[semaforo.escena][j].x,tr[semaforo.escena][j].y);
							if(tipo_tray[semaforo.escena] == 1){
								dibuja_linea(init, fin, i+1);
							}else{
								dibuja_linea_dis(init, fin, i+1);
							}
						}
						dibuja_punto(tr[semaforo.escena][j].x,tr[semaforo.escena][j].y,i,listeners);
						i++;
					}
					puntos_al_frente();
				}
			}else if((tipo_tray[semaforo.escena] == 2) || (tipo_tray[semaforo.escena] == 4)){
				if((tr[semaforo.escena].length > 1)){
					//trace(tr[semaforo.escena].length+" puntos");
					if(tipo_tray[semaforo.escena] == 2){
						dibuja_bezier();
					}else{
						dibuja_bezier_dis();}
					circles = new Array();
					for(i=0; i< tr[semaforo.escena].length; i++){
						dibuja_punto(tr[semaforo.escena][i].x,tr[semaforo.escena][i].y,i,listeners);
					}
					puntos_al_frente();
				}
			}
			principal.addChild(mc);
		}
				

	/*
	 *		FIN DE DIBUJO DE LAS TRAYECTORIAS
	 */
	 
		public function actualiza_etiqueta(texto: String){	etiqueta.text = texto; this._nombre = texto;	/*trace("t:" + tr);*/}
		
		public function rota_etiqueta_izda(n: int = 5){	etiqueta.rotation +=n;	}
		
		public function rota_etiqueta_dcha(n: int = 5){	etiqueta.rotation -=n;	}
		
		public function elimina(){	mc.x = ERROR_X;	mc.y = ERROR_Y;}
		
		public function toogle_trayectorias(a: Boolean){	this.mc_tr.visible = a;	}
		
		//	Añade los listeners
		private function anade_listeners(){	
			//this.addEventListener( MouseEvent.MOUSE_DOWN, pulsado);
			this.addEventListener( MouseEvent.MOUSE_UP, soltado);
			
			/*if(semaforo.prefs.tablet == true){
				this.doubleClickEnabled = true;
				this.addEventListener( MouseEvent.DOUBLE_CLICK, doble);
			}*/
		}
		
		private function doble(e: MouseEvent){
			
			if(semaforo.fase == 1){
				contextual.display(panel, e.stageX, e.stageY);
			}
		}
		
		private function completa_posiciones():void{
			
			var i: int = 1;
			while(posiciones[i] == null){
				posiciones[i]=new Estado(new Point(ERROR_X,ERROR_Y),0);
				i++;
			}
		}
		
		public function bloquea() {	
			this.buttonMode = false;
			removeEventListener( MouseEvent.MOUSE_DOWN, pulsado);	
		}
		
		public function activa() {	
			this.buttonMode = true;
			addEventListener( MouseEvent.MOUSE_DOWN, pulsado);	
		}
		
		//	Guarda en la escena pasada como parámetro la posición actual del elemento 
		public function salva_posicion(n): void{
			posiciones[n] = new Estado(new Point(mc.x,mc.y),mc.rotacion);
		}
		
		public function nueva_posicion():void{
			var p: Point;
			if(tr[semaforo.ultima].length>0){	//	trayectoria previa
				if((tipo_tray[semaforo.ultima] == 1) || (tipo_tray[semaforo.ultima] == 3))
					p= tr[semaforo.ultima][tr[semaforo.ultima].length-1];
				if((tipo_tray[semaforo.ultima] == 2) || (tipo_tray[semaforo.ultima] == 4))
					p= tr[semaforo.ultima][0];
				posiciones[semaforo.ultima+1] = new Estado(p,posiciones[semaforo.ultima].rotacion);
			}else{
				posiciones[semaforo.ultima+1] = new Estado(new Point(mc.x,mc.y),mc.rotacion);
			}
			tr[semaforo.ultima+1] = new Array();
			//tr[semaforo.ultima+1].push(posiciones[semaforo.ultima+1].posicion);
		}
		
		//	Comprueba que no haya una trayectoria en edición
		public function fin_tray():void{
			if(principal.contains(cierre))
				fin_trayectoria(null);
		}
		
		
		//	Redibuja la escena, para ello redibuja todos los componentes
		//	Obtiene la información del movimiento a dibujar en el array datos, con formato estandar
		//	Actualiza también el contador de la escena
		public function redibuja(escena: int){
			
			elimina_t();
			mc.x = posiciones[escena].posicion.x;	
			mc.y = posiciones[escena].posicion.y;
			mc.rotation = posiciones[escena].rotacion;
			
			if((mc.x == ERROR_X) && (mc.y == ERROR_Y)){
				mc.visible = false;
			}else{
				mc.visible = true;
			}
		}
		
	/*
	 *	COMIENZO Funciones para el manejo de MENUS CONTEXTUALES
	 */
		
		
		
		
		//	Genera y asigna al movieClip el menu contextual para dicho elemento en fase de posicionamiento
		public function acciones_mov(){
			
			contextual = new ContextMenu();
			var op_rotacion:ContextMenuItem = new ContextMenuItem("Rotar");
			var op_eliminar:ContextMenuItem = new ContextMenuItem("Eliminar");
			var op_eliminar_ant:ContextMenuItem = new ContextMenuItem("Eliminar anteriores");
			var op_eliminar_pos:ContextMenuItem = new ContextMenuItem("Eliminar posteriores");
			//op_rotacion.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, rotar );
			op_eliminar.separatorBefore = true;
			op_eliminar.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, eliminar );
			op_eliminar_ant.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, eliminar_ant );
			op_eliminar_pos.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, eliminar_post );
			contextual.hideBuiltInItems();
			contextual.customItems.push(op_rotacion,op_eliminar,op_eliminar_ant,op_eliminar_pos);
			mc.contextMenu = contextual;
		}
		
		//	CALLBACKS PARA LOS MENUS CONTEXTUALES
		public function eliminar(e: Event){
			
			/*var i: uint = instances.indexOf(this);
			trace("elimino"+i);
			instances.splice(i,1);
			elimina();*/
			this.dispatchEvent(new Event(DELETE));
		}
		
		public function eliminar_ant(e: Event){
			
			/*for(var i: int = 1; i< semaforo.escena; i++){
				posiciones[i].posicion = INVISIBLE;
			}*/
			this.dispatchEvent(new Event(DELETE_ANTERIORES));
		}
		
		public function eliminar_post(e: Event){
			
			/*for(var i: int = semaforo.escena; i<= semaforo.ultima; i++){
				posiciones[i].posicion = INVISIBLE;
			}*/
			this.dispatchEvent(new Event(DELETE_POSTERIORES));
		}
		
		function continuar(e:Event){
			for(var i: int = 0; i< circles.length; i++){	//	elimino los listeners de los circulos
				circles[i].addEventListener(MouseEvent.MOUSE_DOWN, pulsa_circulo);
				circles[i].addEventListener(MouseEvent.MOUSE_UP, suelta_circulo);
				circles[i].buttonMode = true;
				circles[i].useHandCursor =true;
			}
			if(tipo_tray[semaforo.escena]==1){
				//principal.addEventListener(MouseEvent.CLICK, click);
				principal.addChild(cierre);
			}
			if(tipo_tray[semaforo.escena]==2){
				//principal.addEventListener(MouseEvent.CLICK, click);
				principal.addChild(cierre);
			}
		}
		
		function eliminar_trayectoria(e:Event){
			tr[semaforo.escena] = new Array();
			elimina_t();
			fin_trayectoria(null);
			eliminar_tran.enabled=false;
			cont_trayectoria.enabled = false;
		}
		
		public function remove_click_listener(){
			if(principal.hasEventListener(MouseEvent.CLICK)){
				fin_trayectoria(null);
			}
		}
		
		function elimina_t_listeners(){
			for(var i = 0; i<instances.length; i++){
				instances[i].remove_click_listener();
			}
		}
		
		//		EVENTOS DEL MENU CONTEXTUAL

		
		

	/*
	 *	FIN Funciones para el manejo de MENUS CONTEXTUALES
	 */
	 
	 
	/*
	 *	COMIENZO Funciones para la gestión de TRAYECTORIAS
	 */
	 	private function finaliza_ediciones(){
			for(var i = 0; i< instances.length; i++){
				fin_trayectoria(null);
			}
		}
	 
	 	public function fin_trayectoria(e:Event){
			
			if(principal.contains(cierre)){
				principal.removeChild(cierre);
				//principal.removeEventListener(MouseEvent.CLICK,click);
				for(var i: int = 0; i< circles.length; i++){	//	elimino los listeners de los circulos
					circles[i].removeEventListener(MouseEvent.MOUSE_DOWN, pulsa_circulo);
					circles[i].removeEventListener(MouseEvent.MOUSE_UP, suelta_circulo);
					circles[i].buttonMode = false;
					circles[i].useHandCursor = false;
				}
			}
			//	Finalizo la generacion de una trayectoria, en caso de haber una escena posterior debo actualizar el punto inicial
			if((semaforo.escena < semaforo.ultima) && (tr[semaforo.escena].length > 0)){
				if((tipo_tray[semaforo.escena] == 1)||(tipo_tray[semaforo.escena] == 3))
					posiciones[semaforo.escena+1].posicion = tr[semaforo.escena][tr[semaforo.escena].length-1];
				if((tipo_tray[semaforo.escena] == 2)||(tipo_tray[semaforo.escena] == 4))
					posiciones[semaforo.escena+1].posicion = tr[semaforo.escena][0];
			}
		}
		/*private function click(e: MouseEvent){
			if((e.target != cierre) && (circles.indexOf(e.target) == -1)){			//	No añado un nodo nuevo cuando el destino es el cierre
				switch(tipo_tray[semaforo.escena]){
					case 1:	add_nodo(new Point(e.stageX,e.stageY -5));
							break;
					case 2:	add_nodo_circular(new Point(e.stageX,e.stageY -5));
							break;
					case 3:	add_nodo(new Point(e.stageX,e.stageY -5));
							break;
					case 4:	add_nodo_circular(new Point(e.stageX,e.stageY -5));
							break;
					default:
					
				}
				eliminar_tran.enabled=true;
				cont_trayectoria.enabled = true;
			}
		}*/
		
		private function add_nodo(p: Point){
						
			var i: int = circles.length;
			var init,fin: Point;
			
        	dibuja_punto(p.x - PANEL_X,p.y - PANEL_Y,i,true); 
			tr[semaforo.escena].push(new Point(circles[i].x,circles[i].y));	//	Almacena la coordenada

			if( tr[semaforo.escena].length == 1 ){		//	Primer punto desde el centro del elemento
				init = new Point(mc.x,mc.y);
				fin = new Point(tr[semaforo.escena][tr[semaforo.escena].length-1].x,tr[semaforo.escena][tr[semaforo.escena].length-1].y);
				if(tipo_tray[semaforo.escena]==1)
					dibuja_linea(init, fin, i);
				if(tipo_tray[semaforo.escena]==3)
					dibuja_linea_dis(init, fin, i);
				principal.addChild(mc);
			}
			if(tr[semaforo.escena].length>1){		//	siguiente puntos desde el anterior
				init = new Point(tr[semaforo.escena][tr[semaforo.escena].length-2].x,tr[semaforo.escena][tr[semaforo.escena].length-2].y);
				fin = new Point(tr[semaforo.escena][tr[semaforo.escena].length-1].x,tr[semaforo.escena][tr[semaforo.escena].length-1].y);
				if(tipo_tray[semaforo.escena]==1)
					dibuja_linea(init, fin, i);
				if(tipo_tray[semaforo.escena]==3)
					dibuja_linea_dis(init, fin, i);
				mc_tr.addChild(circles[i-1]);
			}
			mc_tr.addChild( circles[i] );
			puntos_al_frente();
		}
		
		private function puntos_al_frente(){
			for(var i: int = 0; i< circles.length; i++){
				mc_tr.addChild(circles[i]);
			}
		}
		
		private function add_nodo_circular(p: Point){
			
			var i: int = circles.length;
			dibuja_punto(p.x - PANEL_X,p.y - PANEL_Y,i,true);
			tr[semaforo.escena].push(new Point(circles[i].x,circles[i].y));	//	Almacena la coordenada
			if( tr[semaforo.escena].length > 1 ){		//	Primer punto desde el centro del elemento
				if(tipo_tray[semaforo.escena]==2)
					dibuja_bezier();
				if(tipo_tray[semaforo.escena]==4)
					dibuja_bezier_dis();
			} 
			mc_tr.addChild( circles[i] );
		}
		
		//	Elimina los movie clips de las trayectorias
		public function elimina_t(){
			principal.removeChild(mc_tr);
			principal.removeChild(mc_bez);
			mc_tr = new MovieClip();
			mc_bez = new MovieClip();
			principal.addChild(mc_tr);
			principal.addChild(mc_bez);
		}
	/*
	 *	FIN Funciones para la gestión de TRAYECTORIAS
	 */
	 
	 //	DIBUJOS DE LÍNEAS Y BEZIERS
	 	public function dibuja_bezier():void{
			
			principal.removeChild(mc_bez);
			mc_bez = new MovieClip();
			principal.addChild(mc_bez);
			
			var pointArray = new Array();
			dibujo = new Array();
			var elem = new Array();
			var numPoints = tr[semaforo.escena].length-1;
			var oData = new Object();
			
			for(var i:int = 1; i<=numPoints; i++){
				pointArray.push(tr[semaforo.escena][i]);
				elem[i] = new Object();
				elem[i]["x"] = tr[semaforo.escena][i].x;
				elem[i]["y"] = tr[semaforo.escena][i].y;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(mc.x,mc.y);
			var point_1: Point = tr[semaforo.escena][0];
			elem[i] = new Object();
			elem[i]["x"] = point_1.x;
			elem[i]["y"] = point_1.y;
			dibujo.push(elem[i]);
			
			for(i = 0; i<pointArray.length; i++){
				oData["x"+i] = pointArray[i].x;
				oData["y"+i] = pointArray[i].y;
				oData["dx"+i] = ((i+1) == numPoints) ? point_1.x : pointArray[(i+1)].x;
				oData["dy"+i] = ((i+1) == numPoints) ? point_1.y : pointArray[(i+1)].y;
				oData["cx"+i] = (oData["x"+i]+oData["dx"+i])/2;
				oData["cy"+i] = (oData["y"+i]+oData["dy"+i])/2;
			}
			mc_bez.graphics.lineStyle(1, semaforo.prefs.bez_color, 50);
			mc_bez.graphics.moveTo(point_0.x, point_0.y);
			for (i=0; i<numPoints; i++) {
				mc_bez.graphics.curveTo(oData["x"+i], oData["y"+i],oData["cx"+i], oData["cy"+i]);
			}
			mc_bez.graphics.lineTo(point_1.x, point_1.y);
		}
	 
	 	public function dibuja_punto(x: int, y: int, i: int,listeners: Boolean){
			//	Punto
			circles[i] = new MovieClip(); 						
			circles[i].graphics.beginFill( 0xff0000 , 1 );
			circles[i].graphics.lineStyle( 1, 0x000000 );
			circles[i].graphics.drawCircle( 0 , 0 , 5 );
			circles[i].graphics.endFill();
			circles[i].x = x;	circles[i].y = y;
			mc_tr.addChild( circles[i] );
			if(listeners){
				circles[i].addEventListener(MouseEvent.MOUSE_DOWN, pulsa_circulo);
				circles[i].addEventListener(MouseEvent.MOUSE_UP, suelta_circulo);
				circles[i].buttonMode = true;
				circles[i].useHandCursor =true;
			}
		}
	
		public function dibuja_linea(init: Point, fin: Point, i: int){
			
			lineas[i] = new MovieClip();
			lineas[i].graphics.lineStyle(1,0x000000);
			lineas[i].graphics.beginFill(semaforo.prefs.line_color);
			GraphicsUtil.drawArrow(
					lineas[i].graphics,
					new Point(init.x+5,init.y+5),
					new Point(fin.x-5,fin.y-5));
			mc_tr.addChild(lineas[i]);
		}
		
		public function dibuja_linea_dis(init: Point, fin: Point, i: int){
			
			lineas[i] = new MovieClip();
			lineas[i].graphics.lineStyle(3,semaforo.prefs.line_color);
			DrawingShapes.drawDash(lineas[i].graphics,init.x,init.y,fin.x,fin.y);
			mc_tr.addChild(lineas[i]);
		}
	
	
	
	
	
	//	FIN DIBUJOS DE LÍNEAS Y BEZIERS
	 
	 
	/*
	 *	GETTERS Y SETTERS
	 */
		
		public function get nombre(){	return _nombre;	}
	
		public function set escena(n: uint){	this.escena_actual = n;	}
		
		public function get_mc():MovieClip{return this.mc;}
		
		public function posicion(n: int): Point{	return posiciones[n].posicion;	}
		
		public function rotacion(n: int): int{	return posiciones[n].rotacion;	}
		
		public function tipo_trayectoria(n: int): int{	return tipo_tray[n];}
		
		public function get p_principal():Sprite{return principal;} 
		
		public function get bezier():MovieClip{return mc_bez;} 
		
		public function get get_semaforo():Semaforo{return semaforo;}
		
		public function get get_tr():Array{return tr;}
		
		public function transicion(n: int):Array{	
			
			if(tr[n] == null){	return new Array();
			}else{				return tr[n];	}
		}
		
		public function get get_ultima_x(){
			
			var i: int = tr.length - 1;
			var j: int = tr[i].length - 1;
			
			if(j == -1){	return mc.x;
			}else{	return tr[i][j].x;	}
		}
		
		public function get get_ultima_y(){
			
			var i: int = tr.length - 1;
			var j: int = tr[i].length - 1;
			if(j == -1){	return mc.y;
			}else{	return tr[i][j].y;	}
		}
		
		
		public function get get_transicion(){
			
			if(tr[semaforo.escena] == null){
				tr[semaforo.escena] = new Array();	
			}
			return tr[semaforo.escena]; 
		}
		
		
		//		Nuevas
		public function get anterior(): Point { return anterior_pos;}
		
		public function get guid(): String { return id; }
		
		//	Crea el menú contextual del elemento para la fase de posiciones
		public function menuContextualPosiciones() {
			
			contextualPosiciones = new ContextMenu();
			var op_rotacion:ContextMenuItem = new ContextMenuItem("Rotar");
			var op_eliminar:ContextMenuItem = new ContextMenuItem("Eliminar");
			var op_eliminar_ant:ContextMenuItem = new ContextMenuItem("Eliminar anteriores");
			var op_eliminar_pos:ContextMenuItem = new ContextMenuItem("Eliminar posteriores");
			op_rotacion.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, rotarHandler );
			op_eliminar.separatorBefore = true;
			op_eliminar.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, eliminar );
			op_eliminar_ant.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, eliminar_ant );
			op_eliminar_pos.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, eliminar_post );
			contextualPosiciones.hideBuiltInItems();
			contextualPosiciones.customItems.push(op_rotacion,op_eliminar,op_eliminar_ant,op_eliminar_pos);
			
			
			var i: int = 0;
			for each(var accion: AccionBE in _el.acciones) {
				
				acciones[i] = new ContextMenuItem(_el.acciones[i].nombre);
				if (i == 0) { acciones[i].separatorBefore = true; }
				acciones[i].addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, generalMenuHandler);
				contextualPosiciones.customItems.push(acciones[i]);	
				i++;
			}
		}
		
		public function generalMenuHandler(e: Event) {
			var n: int = acciones.indexOf(e.target);
			ultimaAccionPulsada = _el.acciones[n];
			dispatchEvent(new Event(ACTION));
		}
		
		public function get accion(): AccionBE { return ultimaAccionPulsada; }
		
		//	Genera  el menu contextual para dicho elemento en fase de transiciones
		public function menuContextualTransiciones(){
			
			contextualTransiciones = new ContextMenu();
			var rotacion:ContextMenuItem = new ContextMenuItem( "Rotar" );
			t_lineal = new ContextMenuItem( "Trayectoria lineal" );
			t_circular = new ContextMenuItem( "Circular" );
			t_circular_disc = new ContextMenuItem( "Circular Discontinua" );
			t_zigzag = new ContextMenuItem( "Zigzag" );
			t_zigzag_disc = new ContextMenuItem( "Zigzag Discontinuo" );
			cont_trayectoria = new ContextMenuItem( "Continuar Trayectoria" );
			eliminar_tran = new ContextMenuItem( "Eliminar Trayectoria" );
			t_circular.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, bezierHandler );
			t_zigzag.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, zigzagHandler );
			t_circular_disc.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, bezierDisHandler );
			t_zigzag_disc.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, zigzagDisHandler );
			/*if(tr[semaforo.escena] == null){
				cont_trayectoria.enabled = false;
			}else{
				cont_trayectoria.enabled = (tr[semaforo.escena].length > 0);
			}*/
			cont_trayectoria.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, continueHandler);
			eliminar_tran.enabled = cont_trayectoria.enabled ;
			eliminar_tran.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, eliminar_trayectoria);
			rotacion.separatorBefore = true;
			rotacion.addEventListener( ContextMenuEvent.MENU_ITEM_SELECT, rotarHandler );
			contextualTransiciones.hideBuiltInItems();
			//if(_el.tipo == "estatico"){
				//contextualTransiciones.customItems.push(rotacion);
			//}else{
				contextualTransiciones.customItems.push(t_zigzag,t_zigzag_disc, t_circular, t_circular_disc, cont_trayectoria, eliminar_tran, rotacion);
			//}
		}
		
		public function Select(): void{
			trace("select");
			dispatchEvent(new MouseEvent(MouseEvent.CLICK));
		}
		
		//	Establece el modelo de menu contextual dependiendo de lafase
		public function setMenuContextual(fase: int) {
			
			if (fase == Constantes.POSICIONAMIENTO) {
				this.contextMenu = contextualPosiciones;
			}else {
				this.contextMenu = contextualTransiciones;
			}
		}
		
		//	<CONTEXT_MENU_HANDLERS>
		//	Handles the rotation contextMenuItem click
		private function rotarHandler(e:Event) { this.dispatchEvent(new Event(ROTAR)); }
		//	Handles the zigzag contextMenuItem click
		private function zigzagHandler(e:Event){ this.dispatchEvent(new Event(ZIGZAG)); }
		//	Handles the dotted zigzag contextMenuItem click
		private function zigzagDisHandler(e:Event){ this.dispatchEvent(new Event(ZIGZAG_DIS)); }
		//	Handles the bezier contextMenuItem click
		private function bezierHandler(e:Event){ this.dispatchEvent(new Event(CIRCULAR)); }
		//	Handles the dotted Bezier contextMenuItem click
		private function bezierDisHandler(e:Event){ this.dispatchEvent(new Event(CIRCULAR_DIS)); }
		//	Handles the edit path contextMenuItem click
		private function continueHandler(e:Event){ this.dispatchEvent(new Event(CONTINUE)); }
		
		//	</CONTEXT_MENU_HANDLERS>
		
		public function get elemento(): ElementoBE { return _el; }
		
	/*
	 *	DEBUG
	 */
		public function escribe(orden: int = 0){
			trace("id: " + id + " - (" + mc.x + ", " + mc.y + ") - (" + id_elemento + ") et: \"" + _nombre + "\"");
			for(var i: int = 1; i< posiciones.length; i++){
				posiciones[i].escribe(i);
				trace(tr[i]);
			}
		}
	}
}