﻿package org.pizarra.graficos{	

	import org.pizarra.escenas.Model.EditorModel;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.events.*;
	import org.pizarra.events.*;
	import org.pizarra.util.Ficheros;
	
	public class ElementSelector extends Sprite {
		
		//	Panels
		private var s_dinamicos: Selector_Elementos;
		private var s_estaticos: Selector_Elementos;
		private var s_custom: Selector_Elementos;
		//	Eliminar el modelo si es posible
		private var m: EditorModel;
		
		//	Loaders de las imagenes
		private var staDesLoader: Loader = new Loader();
		private var staSelLoader: Loader = new Loader();
		private var dinDesLoader: Loader = new Loader();
		private var dinSelLoader: Loader = new Loader();
		private var cusDesLoader: Loader = new Loader();
		private var cusSelLoader: Loader = new Loader();
		//	Sprites de las imagenes
		private var staDes: Sprite = new Sprite();
		private var staSel: Sprite = new Sprite();
		private var dinDes: Sprite = new Sprite();
		private var dinSel: Sprite = new Sprite();
		private var cusDes: Sprite = new Sprite();
		private var cusSel: Sprite = new Sprite();
		
		public function ElementSelector( modelo: EditorModel ) {
			//	Set the model
			m = modelo;
			//	Create the elements
			s_estaticos = new Selector_Elementos(m);
			s_dinamicos = new Selector_Elementos(m);
			s_custom = new Selector_Elementos(m);
			drawButtons();
		}
		
		/*
		 * 	PRIVATE METHODS
		 */
		//	Create the menu swap buttons
		private function drawButtons() {
			//	pppEEELoader
			//	ppp = panel
			//	EEE = Estado
			staDesLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			staDesLoader.load(new URLRequest(Ficheros.IMG_STADES));
			staSelLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			staSelLoader.load(new URLRequest(Ficheros.IMG_STASEL));
			dinDesLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			dinDesLoader.load(new URLRequest(Ficheros.IMG_DINDES));
			dinSelLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			dinSelLoader.load(new URLRequest(Ficheros.IMG_DINSEL));
			cusDesLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			cusDesLoader.load(new URLRequest(Ficheros.IMG_CUSDES));
			cusSelLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			cusSelLoader.load(new URLRequest(Ficheros.IMG_CUSSEL));
		}
		
		private function deselecciona() {
			staDes.visible = false;
			staSel.visible = false;
			dinDes.visible = false;
			dinSel.visible = false;
			cusDes.visible = false;
			cusSel.visible = false;
			s_estaticos.visible = false;
			s_dinamicos.visible = false;
			s_custom.visible = false;
		}
		
		//	HANDLERS
		private function imgLoaded(e:Event):void{
			if (e.target.loader == staDesLoader) {
				staDes.addChild(staDesLoader);
				staDes.buttonMode = true;
				staDes.x = 0;	
				staDes.addEventListener(MouseEvent.CLICK, clickHandler);
				this.addChild(staDes);
				staDes.visible = false;
			}
			if (e.target.loader == staSelLoader) {
				staSel.addChild(staSelLoader);
				staSel.buttonMode = true;
				staSel.x = 0;	
				staSel.addEventListener(MouseEvent.CLICK, clickHandler);
				this.addChild(staSel);
			}
			if (e.target.loader == dinDesLoader) {
				dinDes.addChild(dinDesLoader);
				dinDes.buttonMode = true;
				dinDes.x = 56;	
				dinDes.addEventListener(MouseEvent.CLICK, clickHandler);
				this.addChild(dinDes);
			}
			if (e.target.loader == dinSelLoader) {
				dinSel.addChild(dinSelLoader);
				dinSel.buttonMode = true;
				dinSel.x = 56;	
				dinSel.addEventListener(MouseEvent.CLICK, clickHandler);
				addChild(dinSel);
				dinSel.visible = false;
			}
			if (e.target.loader == cusDesLoader) {
				cusDes.addChild(cusDesLoader);
				cusDes.buttonMode = true;
				cusDes.x = 112;	
				cusDes.addEventListener(MouseEvent.CLICK, clickHandler);
				addChild(cusDes);
			}
			if (e.target.loader == cusSelLoader) {
				cusSel.addChild(cusSelLoader);
				cusSel.buttonMode = true;
				cusSel.x = 112;	
				cusSel.addEventListener(MouseEvent.CLICK, clickHandler);
				addChild(cusSel);
				cusSel.visible = false;
			}
		}
		
		private function clickHandler(e: MouseEvent) {
			
			if (e.target == staDesLoader) {
				deselecciona();
				staSel.visible = true;
				dinDes.visible = true;
				cusDes.visible = true;
				s_estaticos.visible = true;
			}
			if (e.target == dinDesLoader) {
				deselecciona();
				staDes.visible = true;
				dinSel.visible = true;
				cusDes.visible = true;
				s_dinamicos.visible = true;
			}
			if (e.target == cusDesLoader) {
				deselecciona();
				staDes.visible = true;
				dinDes.visible = true;
				cusSel.visible = true;
				s_custom.visible = true;
			}
		}
		
		//	SETTERS
		//	Set the data for the dinamic Panel
		public function set dinamicosDataSource(data: Array) {
			s_dinamicos.dataSource = data;
			s_dinamicos.addEventListener(ElementAddedEvent.ADDED_ELEMENT, addedElement);
			s_dinamicos.addEventListener(ElementMoveEvent.MOVED_ELEMENT, movedElement);
			this.addChild(s_dinamicos);
			s_dinamicos.y = 40;
		}
		//	Set the data for the static Panel
		public function set estaticosDataSource(data: Array) {
			s_estaticos.dataSource = data;
			s_estaticos.addEventListener(ElementAddedEvent.ADDED_ELEMENT, addedElement);
			s_estaticos.addEventListener(ElementMoveEvent.MOVED_ELEMENT, movedElement);
			this.addChild(s_estaticos);
			s_estaticos.y = 40;		
		}
		//	Set the data for the custom Panel
		public function set playersDataSource(data: Array) {
			s_custom.playersDataSource = data;
			s_custom.addEventListener(ElementAddedEvent.ADDED_ELEMENT, addedElement);
			s_custom.addEventListener(ElementMoveEvent.MOVED_ELEMENT, movedElement);
			this.addChild(s_custom);
			s_custom.y = 40;
		}
		
		public function enable() {
			s_dinamicos.enable();
			s_estaticos.enable();
			s_custom.enable();
		}
		
		public function disable() {
			s_dinamicos.disable();
			s_estaticos.disable();
			s_custom.disable();
		}
		
		//	EVENTS
		function addedElement(e: ElementAddedEvent) {
			this.dispatchEvent(new ElementAddedEvent(e.element));
		}
		function movedElement(e: ElementMoveEvent) {
			this.dispatchEvent(new ElementMoveEvent(e.element));
		}
	}
}