﻿package org.pizarra.graficos
{
	import fl.transitions.Tween;
	import fl.transitions.easing.Strong;
	
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.*;
	import flash.geom.*;
	import flash.text.TextField;
	import flash.text.TextFormat;

	/**
	* @author Francisco Rosales
	* @site http://www.nessy.com.ar
	*/
	public class CoolButton extends Sprite
	{
		public var mainMC:Sprite = new Sprite();
		public var _width:uint = 100;
		public var _height:uint = 40;
		public var text:String = "default";
		public var onClick:Function;
		public var dispatchClickOnly:Boolean = true;
		private var baseMC:Sprite = new Sprite();
		private var overMC:Sprite = new Sprite();
		private var pressMC:Sprite = new Sprite();
		private var baseTxt:TextField;
		private var overTxt:TextField;
		private var pressTxt:TextField;
		private var rounded:uint = 17;
		public static var EVENT_CLICKED:String = "CLICKED";

		public function CoolButton(widthButton:uint = 100, heightButton:uint = 40)
		{
			_width = widthButton;
			_height = heightButton; 
			addChild(mainMC);
			mainMC.addChild(baseMC);
			mainMC.addChild(overMC);
			mainMC.addChild(pressMC);
			addEventListener(Event.ADDED_TO_STAGE, Display);
			buttonMode = true;
		}

		public function Display(evt:Event):void {
			buildBase();
			buildOver();
			buildPress();
			buildEvents();
		}

		private function _onClick():void {
			if(dispatchClickOnly){
				this.dispatchEvent(new Event(EVENT_CLICKED));
			} else {
				if(onClick!=null){
					onClick();
				}
			}
		}

		private function buildBase():void {
			var colors:Array = [ 0x656a70, 0x4d5359, 0xA6ACB2 ];
			var alphas:Array = [ 100, 100, 100];
			var ratios:Array = [ 0x00, 0xA0, 0xFF ];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(_width, _height, (Math.PI / 2), 0, 0);
			baseMC.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD);
            baseMC.graphics.drawRoundRect(0, 0, _width, _height, rounded, rounded);

			var _heightFX:uint = _height/1.8;
			colors = [ 0xffffff, 0x555555 ];
			alphas = [ 50, 100 ];
			ratios = [ 0x00, 0xFF ];
			matrix.createGradientBox(_width, _heightFX, (Math.PI / 2), 0, 0);
			baseMC.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD);
			baseMC.graphics.drawRoundRectComplex(0,0,_width,_heightFX,12,12,12,12);
			baseMC.graphics.endFill();

			var filterB:BevelFilter = new BevelFilter(1, 45, 0xffffff, 0.5, 0x5c5c5c, .8, 1.1, 2.5, 4, 3, "inner", false);
			var filterD:DropShadowFilter = new DropShadowFilter(0.5, 45, 0x000000, .5, 4, 4, 1, 3, false, false, false);
			baseMC.filters = [filterB, filterD];
			baseTxt = buildText( {
					width : _width,
					height : 18,
					text : text,
					color : 0xffffff
			} );
			baseMC.addChild(baseTxt);
			baseTxt.y = _height/2-baseTxt.height/2-0.5;
			baseMC.scale9Grid = getRectangleScale();
		}

		private function buildText(config:Object) : TextField{
			var text:String = (config.text != undefined)?config.text:"";
			var width:uint = (config.width != undefined)?config.width:120;
			var height:uint = (config.height != undefined)?config.height:18;
			var color:uint = (config.color != undefined)?config.color:0xffffff;
			var format:TextFormat = new TextFormat();
			format.font = "Arial";
			format.color = color;
			format.size = 15;
			format.align = "center";
            var txt:TextField = new TextField();
			txt.selectable = false;
			txt.width = width;
			txt.height = height;
			txt.defaultTextFormat = format;
			txt.text = text;
			return txt;
		}

		private function buildOver():void {
			var colors:Array = [ 0xC5CCD2, 0x838C93, 0xC2C6CA];
			var alphas:Array = [ 10, 100, 100 ];
			var ratios:Array = [ 0x00, 0xA0, 0xFF ];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(_width, _height, (Math.PI / 2), 0, 0);
			overMC.graphics.lineStyle(0, 0xD8DAD6, 100, true,"none", "round", "miter", 1);
			overMC.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD);
            overMC.graphics.drawRoundRect(0, 0, _width, _height, rounded, rounded);
			var _heightFX:uint = _height/1.8;
			colors = [ 0xffffff, 0x9ea6af];
			alphas = [ 50, 90 ];
			ratios = [ 0x00, 0xFF ];
			matrix.createGradientBox(_width, _heightFX, (Math.PI / 2), 0, 0);
			overMC.graphics.lineStyle(0, 0xEBECE7, 0);
			overMC.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD);
			overMC.graphics.drawRoundRectComplex(0,0,_width,_heightFX,12,12,12,12);
			overMC.graphics.endFill();
			var filterB:BevelFilter = new BevelFilter(1, 45, 0xffffff, 1, 0x5c5c5c, .8, 2, 2, 2, 3, "inner", false);
		    var filterG1:GlowFilter = new GlowFilter(0x3192ff, .8, 2, 2, 1, 3, false, false);
		    var filterG2:GlowFilter = new GlowFilter(0xffffff, 1, 10, 10, 1, 3, false, false);
			overMC.filters = [filterB,filterG2,filterG1];
			overTxt = buildText( {
					width : _width,
					height : 18,
					text : text,
					color : 0xffffff
			} );
			overMC.addChild(overTxt);
			overTxt.y = _height/2-overTxt.height/2;
			overMC.alpha = 0;
			overMC.scale9Grid = getRectangleScale();
		}

		private function buildPress():void {
			var colors:Array = [ 0xC5CCD2, 0x838C93, 0xC2C6CA];
			var alphas:Array = [ 10, 100, 100 ];
			var ratios:Array = [ 0x00, 0xA0, 0xFF ];
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(_width, _height, (Math.PI / 2), 0, 0);
			pressMC.graphics.lineStyle(0, 0xD8DAD6, 100, true,"none", "round", "miter", 1);
			pressMC.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD);
            pressMC.graphics.drawRoundRect(0, 0, _width, _height, rounded, rounded);
			var _heightFX:uint = _height/1.8;
			colors = [ 0xffffff, 0x9ea6af];
			alphas = [ 50, 90 ];
			ratios = [ 0x00, 0xFF ];
			matrix.createGradientBox(_width, _heightFX, (Math.PI / 2), 0, 0);
			pressMC.graphics.lineStyle(0, 0xEBECE7, 0);
			pressMC.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD);
			pressMC.graphics.drawRoundRectComplex(0,0,_width,_heightFX,12,12,12,12);
			pressMC.graphics.endFill();
			var filterB:BevelFilter = new BevelFilter(1, 45, 0xffffff, 1, 0x5c5c5c, .8, 2, 2, 2, 3, "inner", false);
		    var filterG1:GlowFilter = new GlowFilter(0xB0F260, .8, 2, 2, 1, 3, false, false);
		    var filterG2:GlowFilter = new GlowFilter(0xffffff, 1, 10, 10, 1, 3, false, false);
			pressMC.filters = [filterB,filterG2,filterG1];
			pressTxt = buildText( {
					width : _width,
					height : 18,
					text : text,
					color : 0xDEFC8C
				} );
			pressMC.addChild(pressTxt);
			pressTxt.y = _height/2-pressTxt.height/2;
			pressMC.alpha = 0;
			pressMC.scale9Grid = getRectangleScale();
		}

		private function buildEvents():void {
			var onRollOver:Function = function():void {
				var tween:Tween = new Tween(overMC, "alpha", Strong.easeOut, overMC.alpha, 1, 0.5, true);
			}
			var onRollOut:Function = function():void {
				var tween:Tween = new Tween(overMC, "alpha", Strong.easeOut, overMC.alpha, 0, 0.5, true);
				pressMC.alpha = 0;
			}
			var onPress:Function = function():void {
				var tween:Tween = new Tween(pressMC, "alpha", Strong.easeOut, pressMC.alpha, 1, 0.2, true);
			}
			var onRelease:Function = function():void {
				var tween:Tween = new Tween(pressMC, "alpha", Strong.easeOut, pressMC.alpha, 0, 0.5, true);
				_onClick();
			}
			pressMC.addEventListener(MouseEvent.MOUSE_OVER, onRollOver);
			pressMC.addEventListener(MouseEvent.MOUSE_OUT, onRollOut);
			pressMC.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			pressMC.addEventListener(MouseEvent.MOUSE_UP, onRelease);
		}
		public function setText(txt:String):void
		{
			text = txt;
			baseTxt.text = txt;
			overTxt.text = txt;
			pressTxt.text = txt;
		}
		
		public function setDimension(widthButton:uint, heightButton:uint):void
		{
			_width = (widthButton < 80)?80:widthButton;
			_height = (heightButton < 20)?20:heightButton;
			baseMC.width = _width;
			baseMC.height = _height;
			overMC.width = _width;
			overMC.height = _height;
			pressMC.width = _width;
			pressMC.height = _height;
		}
		
		private function getRectangleScale():Rectangle
		{
			return new Rectangle(rounded/2,rounded/2,_width-rounded,_height-rounded);
		}
	}
}