package org.pizarra.graficos {
	import fl.controls.Label;
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.text.*;
	import org.pizarra.configuracion.Tema;
	
	public class Action extends Sprite {
		
		
		private var l: Loader = new Loader();
		private var disableSprite: Sprite = new Sprite();
		private var text: Label = new Label();
		private var Enabled: Boolean = true;
		
		public function Action(name: String) {
			
			DrawBackground();
			LoadText(name);
			buttonMode = true;
			
		}
		
		/*	PUBLIC
		 **/
		public function set Enable(state: Boolean) {
			disableSprite.visible = !state;
		}
		 
		
		/*	PRIVATE FUNCTIONS
		 **/		
		private function LoadText(name: String): void {
			
			var myTextFormat:TextFormat = new TextFormat();
			myTextFormat.align = TextFormatAlign.CENTER;
			myTextFormat.size = 15;

			text.text = name;
			text.y = 2;
			text.x = 2;
			text.setStyle("textFormat", myTextFormat);
			text.buttonMode = true;
			addChild(text);
		}
		
		private function DrawBackground() {
			
			//	Background
			this.graphics.lineStyle(1, Tema.ButtonBorder,1,true, "normal", "square");
			this.graphics.beginFill(Tema.ButtonBackground);
            this.graphics.drawRoundRect(0, 0, text.width, 20,20,20);
            this.graphics.endFill();
			
		}
		
		public function get Name(): String { return text.text; }
		public function set Name(value: String): void { text.text = value; }
		
		
		/*	HANDLERS
		 **/

		
		private function clicked(event:Event): void {
			event.stopImmediatePropagation();
			event.stopPropagation();
		}
	}
}