﻿package org.pizarra.escenas.editor{	
	
import flash.display.*;
import fl.controls.*;
import flash.net.*;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.*;
import org.pizarra.configuracion.*;
import org.pizarra.util.*;
import flash.filesystem.*;
	
	public class PanelEscena extends Sprite {
		
		private var txtDuracion, txtAudio, txtTextoEscena: TextInput;
		private var lstTipos: ComboBox;
		private var btnOpen: Sprite = new Sprite();
		private var file: File = File.desktopDirectory;
		
		public function PanelEscena() {
			
			creaPanel();
		}
		
		public function creaPanel() {
			
			this.graphics.lineStyle(Tema.spanBorderWidth, Tema.spanBorderColor,1,true, "normal", "square");
			this.graphics.beginFill(Tema.spanBgA, 1);
			this.graphics.drawRoundRect(0, 0, Constantes.PANEL_W, Constantes.PANEL_H, 20, 20);
			this.graphics.endFill();
			
			//	Add labels
			this.addChild(creaLabel("ESCENA:", 100, 10));
			this.addChild(creaLabel("Duracion:", 100, 50));
			this.addChild(creaLabel("s", 250, 50));
			this.addChild(creaLabel("Tipo:", 100, 100));
			this.addChild(creaLabel("Audio:", 100, 150));
			this.addChild(creaLabel("Texto:", 100, 250));
			//	Add text inputs
			txtAudio = new TextInput();
			txtAudio.x = 200;
			txtAudio.y = 150;
			txtAudio.width = 300;
			txtAudio.addEventListener(Event.CHANGE, change);
			this.addChild(txtAudio);
			
			txtDuracion = new TextInput();
			txtDuracion.x = 200;
			txtDuracion.y = 50;
			txtDuracion.width = 30;
			txtDuracion.restrict = "0-9";
			txtDuracion.maxChars = 2;
			txtDuracion.text = Constantes.TIEMPO_ESCENA_DEFECTO;
			txtDuracion.addEventListener(Event.CHANGE, change);
			this.addChild(txtDuracion);
			
			lstTipos = new ComboBox();
			lstTipos.addItem({label: "Serie", Value:Constantes.SERIE});
			lstTipos.addItem({label: "Paralelo", Value:Constantes.PARALELO});
			lstTipos.move(200, 100);
			lstTipos.addEventListener(Event.CHANGE, change);
			this.addChild(lstTipos);
			
			txtTextoEscena = new TextInput();
			txtTextoEscena.x = 200;
			txtTextoEscena.y = 200;
			txtTextoEscena.width = 400;
			txtTextoEscena.height = 100;
			txtTextoEscena.addEventListener(Event.CHANGE, change);
			this.addChild(txtTextoEscena);
			
			var l: Loader = new Loader();
			l.load(new URLRequest(Ficheros.IMG_OPENAUDIOFILE));
			btnOpen.addChild(l);
			btnOpen.buttonMode = true;
			btnOpen.x = 520;
			btnOpen.y = 150;
			btnOpen.addEventListener(MouseEvent.CLICK, openHandler);
			this.addChild(btnOpen);
			
		}
		
		private function creaLabel(texto: String, x: int, y: int): TextField {
			var myFormat:TextFormat = new TextFormat();
			myFormat.size = 20;
			var lbl: TextField = new TextField();
			lbl.defaultTextFormat = myFormat;
			lbl.text = texto;
			lbl.textColor = Tema.lblColor; 
			lbl.x = x;
			lbl.y = y;
			return lbl;
		}
		
		private function change(e: Event) {
			dispatchEvent(new Event(Eventos.PNESCENA_CHANGE));
		}
		
		private function openHandler (e:MouseEvent) {
			file.browseForOpen("Importar Audio");
			file.addEventListener(Event.SELECT, fichero_sel);
		}
		
		function fichero_sel(e: Event) {
			txtAudio.text = file.nativePath;
			txtAudio.dispatchEvent(new Event( Event.CHANGE));
		}
		
		//	GETTERS
		public function get audio(): String { return txtAudio.text; }
		public function get duracion(): int { return int(txtDuracion.text); }
		public function get tipo(): String { return lstTipos.selectedItem["Value"].toString(); }
		public function get texto(): String { return txtTextoEscena.text; }
		
		//	SETTERS
		public function set audio(val: String): void {  txtAudio.text = val != null ? val : ""; }
		public function set duracion(val: int): void { txtDuracion.text = val;}
		public function set tipo(val: String): void { lstTipos.selectedItem = ["Value", val != null ? val : ""]; }
		public function set texto(val: String): void { txtTextoEscena.text = val != null ? val : "";; }
		
	}
}