﻿package org.pizarra.escenas.editor{	

	import fl.controls.Slider;
	import fl.controls.TextArea;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import fl.controls.Label;
	import fl.controls.TextInput;
	import flash.text.TextField;
	import flash.utils.Dictionary;
	import org.pizarra.graficos.Elemento_Concreto;
	import org.pizarra.graficos.ElementSelector;
	import org.pizarra.graficos.Linea_Tiempo;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.*;
	import org.pizarra.graficos.Selector_Elementos;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.graficos.ElementSelector;
	import org.pizarra.events.*;
	import flash.ui.*;
	import flash.display.BlendMode;
	import org.pizarra.helpers.*;
	import org.pizarra.configuracion.*;
	import org.pizarra.escenas.Model.EditorModel;
	
	public class FreeEditorView extends Sprite{
		
		//	Controlador
		private var logic: FreeEditorController;
		//	Modelo
		private var m: EditorModel;
		//	Buttons
		private var btnVolver: CoolButton;	//	Back
		private var btnGuardar: CoolButton;	//	Save
		private var btnAdd: Sprite;			//	Add
		private var btnPreview: Sprite;		//	Preview
		private var btnUndo: Sprite;		//	Undo
		private var btnRedo: Sprite;		//	Redo
		private var btnSave: Sprite;		//	Save
		
		private var bitmap: BitmapData;
		//	Components
		private var selectorElementos: ElementSelector;	//	Selector lateral
	
		
		private var fondo: Loader = new Loader(); 

		//	Panels
		private var pnEdicion: Sprite = new Sprite();
		
		//	Others
		private var titulo: TextInput = new TextInput(); 
		private var lblTitulo : TextField = new TextField();
		private var lblInfo : TextField = new TextField();
		private var info: TextArea = new TextArea();
		
		//	Elements
		private var elements: Dictionary = new Dictionary();
		private var pathSprite: Dictionary = new Dictionary(); 
		private var activeElement: Elemento_Concreto;
		private var currentAction: int;
		
		//	Vector de sprites
		private var trazos: Array = new Array();
		private var dibujo: Sprite = new Sprite();
		
		//	Constructor
		public function FreeEditorView( modelo: EditorModel): void{

			m = modelo;
			addChild(pnEdicion);
			pnEdicion.x = Constantes.PANEL_BASE.x;
			pnEdicion.y = Constantes.PANEL_BASE.y;
			m.pnEdicion = pnEdicion;
			addComponents();
			dibujaFondo();
			dibujaTerreno();
			posicionaBotones();
			addChild(dibujo);
			
			//this.addChild(new Titulo("Edición del Ejercicio", m.p.pref));
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		
		//	Componentes
		private function addComponents() {
			//	Add the element selector
			addElementSelector();
			//	Add top buttons
			addTopButtons();
			//	Listeners for the free hand drawing
			pnEdicion.addEventListener(MouseEvent.MOUSE_DOWN, empieza);
			
			//	Carga el título
			lblTitulo.defaultTextFormat = Tema.formatoLabel;
			lblTitulo.text = "Título "; 
			lblTitulo.width = 70;
			lblTitulo.x = 250;
			lblTitulo.y = 30;
			addChild(lblTitulo);
			
			titulo.addEventListener(Event.CHANGE, cambioTitulo);
			titulo.x = 300; 	titulo.y = 30;
			titulo.width = 400;
			addChild(titulo);
	
			//	Carga la info
			lblInfo.defaultTextFormat = Tema.formatoLabel;
			lblInfo.text = "Info ";
			lblInfo.x = 250; lblInfo.y = 480;
			addChild(lblInfo);
			
			info.addEventListener(Event.CHANGE, cambioInfo);
			info.x = 350; 	info.y = 480;
			info.width = 400;	info.height = 100;
			addChild(info);
		}
		
		private function empieza(e: MouseEvent) {
			var i: int = trazos.length;
			//	No quiero marcar cuando mueva los elementos
			if(!(e.target is Elemento_Concreto)){
				//	Adds the move listener
				pnEdicion.addEventListener(MouseEvent.MOUSE_MOVE, mouseTransition);
				Util.subTrace("++ Iniciado nuevo trazo");
				//	Start a new "trazo"
				trazos[i] = new Sprite();
				trazos[i].addEventListener(MouseEvent.MOUSE_UP, termina);
				pnEdicion.addEventListener(MouseEvent.MOUSE_UP, termina);
				addChild(trazos[i]);
				trazos[i].graphics.lineStyle(Tema.freeEditorLineWidth, Tema.lineColor);
				trazos[i].graphics.moveTo(e.stageX, e.stageY);
				//	Start the data writing
				logic.startTrazo();
			}
		}
		
		private function mouseTransition(e: MouseEvent) {
			trazos[trazos.length - 1].graphics.lineTo(e.stageX, e.stageY);
			logic.addPuntoATrazo(new Point(e.stageX - pnEdicion.x, e.stageY - pnEdicion.y));
		}
		
		private function termina(e: MouseEvent) {
			//	Removes the listener
			trazos[trazos.length - 1].removeEventListener(MouseEvent.MOUSE_UP, termina);
			pnEdicion.removeEventListener(MouseEvent.MOUSE_UP, termina);
			pnEdicion.removeEventListener(MouseEvent.MOUSE_MOVE, mouseTransition);
			Util.subTrace("++ Termina trazo");
		}
		
		
		
		//	Adds the element selector to the scene
		private function addElementSelector() {
		
			//	Create the selector element
			selectorElementos = new ElementSelector(m);
			//	Configure the element
			selectorElementos.dinamicosDataSource = m.p.dinamicos[m.p.dep_select];
			selectorElementos.playersDataSource = m.p.jugadores;
			selectorElementos.estaticosDataSource = m.p.estaticos[m.p.dep_select];
			//	Listen to events
			selectorElementos.addEventListener(ElementAddedEvent.ADDED_ELEMENT, addedElement);
			selectorElementos.addEventListener(ElementMoveEvent.MOVED_ELEMENT, movedElement);
			//	Add the element
			addChild(selectorElementos);
			selectorElementos.x = 10;
			selectorElementos.y = 65;
			
		}
		
		//	Fondo y terrenos
		private function dibujaFondo(){
			this.graphics.beginFill(m.p.pref.bgColor);
            this.graphics.drawRect(0, 0, Constantes.APP_WIDTH, Constantes.APP_HEIGHT);
            this.graphics.endFill();
		}		
		private function dibujaTerreno(){
			
			var urlReq:URLRequest = new URLRequest(m.p.fondoSeleccionado.url);
			fondo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			fondo.load(urlReq);
		}

		//	Botones
		private function posicionaBotones(){
			
			btnVolver = new CoolButton();
			btnVolver.text = "Salir";
			this.addChild(btnVolver);	
			btnVolver.x = 900;	btnVolver.y = 550;
			
			btnGuardar = new CoolButton();
			btnGuardar.text = "Guardar";
			this.addChild(btnGuardar);	
			btnGuardar.x = 900;	btnGuardar.y = 500;
			btnGuardar.visible = false;
		}
		private function addTopButtons() {

			loadUndoButton();
			loadRedoButton();
			loadSaveButton();
		}

		private function loadSaveButton() {
			var l: Loader = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, saveLoaded);
			l.load(new URLRequest(Ficheros.IMG_GUARDAR));
			btnSave = new Sprite();
			btnSave.addChild(l);
			btnSave.buttonMode = true;
			btnSave.addEventListener(MouseEvent.CLICK, save);
			btnSave.x = 14 * 64;
			this.addChild(btnSave);
			
		}
		
		private function loadUndoButton() {
			var l: Loader = new Loader();
			l.load(new URLRequest(Ficheros.IMG_UNDO));
			btnUndo = new Sprite();
			btnUndo.addChild(l);
			btnUndo.buttonMode = true;
			btnUndo.addEventListener(MouseEvent.CLICK, undo);
			btnUndo.x = 12 * 64;
			this.addChild(btnUndo);
			
		}
		private function loadRedoButton() {
			var l: Loader = new Loader();
			l.load(new URLRequest(Ficheros.IMG_REDO));
			btnRedo = new Sprite();
			btnRedo.addChild(l);
			btnRedo.buttonMode = true;
			btnRedo.addEventListener(MouseEvent.CLICK, redo);
			btnRedo.x = 13 * 64;
			this.addChild(btnRedo);
			
		}
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function imgLoaded(event:Event):void{

			pnEdicion.addChild(fondo);
			fondo.x = 0;
			fondo.y = 0;
		}
		
		private function saveLoaded(event:Event):void{
			event.target.loader.width = 64;
			event.target.loader.height = 64;
		}
		
		private function cambioTitulo(e: Event) {
			logic.actualizaTitulo(titulo.text);
		}
		
		private function cambioInfo(e: Event) {
			logic.actualizaInfo(info.text);
		}
		
		//	A new element has been added to the scene
		private function addedElement(e: ElementAddedEvent) {
			Util.subTrace("++ Added new element " + e.element.id + " to the scene");
			logic.addElement(e.element);
			elements[e.element.id] = e.element;
			//pathSprite[e.element.id] = new Sprite();
			//	Add the listeners for the context menus
			/*elements[e.element.id].addEventListener(Elemento_Concreto.ROTAR, rotarHandler);
			elements[e.element.id].addEventListener(Elemento_Concreto.ZIGZAG, pathHandler);
			elements[e.element.id].addEventListener(Elemento_Concreto.ZIGZAG_DIS, pathHandler);
			elements[e.element.id].addEventListener(Elemento_Concreto.CIRCULAR, pathHandler);
			elements[e.element.id].addEventListener(Elemento_Concreto.CIRCULAR_DIS, pathHandler);
			elements[e.element.id].addEventListener(Elemento_Concreto.CONTINUE, continueHandler);*/
		}
		//	An Existing element has been moved
		function movedElement(e: ElementMoveEvent) {
			Util.subTrace("+ Moved element " + e.element.id);
			logic.moveElement(e.element);
		}
		//	Save
		function save(e: MouseEvent) {
			logic.guardar(e);
		}
		//	Undo
		function undo(e: MouseEvent) {
			if(trazos.length > 0){
				Util.subTrace("-- Undo Remove last path");
				removeChild(trazos[trazos.length - 1]);
				trazos[trazos.length - 1] = null;
				trazos.length--;
			}else {
				Util.subTrace("== No hay trazos que deshacer");
			}
		}
		//	Redo
		function redo(e: MouseEvent) {
			Util.subTrace("Redo");
			logic.auditaTrazo();
		}

		
		//	PUBLIC
		public function setController(controlador: FreeEditorController) {
			logic = controlador;
			titulo.text = logic.getTitulo();
			info.text = logic.getInfo();
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		 public function get volver(): CoolButton{ return btnVolver; }
		 public function get guardar(): CoolButton{ return btnGuardar; }
		 
	}
}