﻿package org.pizarra.escenas.editor{	

	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.Event;
	import flash.geom.Point;
	import flash.utils.Dictionary;
	import org.pizarra.Data.DibujoLibre;
	import org.pizarra.Estado;
	import org.pizarra.graficos.Elemento_Concreto;
	import org.pizarra.Pizarra;
	import org.pizarra.escenas.View.EditorView;
	import org.pizarra.graficos.Alert;
	import org.pizarra.acciones.*;
	import org.pizarra.Trayectoria;
	import org.pizarra.util.Constantes;
	import org.pizarra.configuracion.*;

	public class FreeEditorController extends EventDispatcher{
		
		private var guardado: Boolean = false;
		
		private var p: Pizarra;
		private var editor: FreeEditorView;
		//	Elementos
		private var elementos: Array = new Array();
		private var escenas: Array = new Array();
		private var trayectorias: Array = new Array();
		
		//	Historial de acciones
		private var acciones: Array = new Array();
		private var accion: int = -1;
		
		//	Estado
		private var e_actual: int = 1;
		private var e_ultima: int = 1;
		private var fase_actual: int = Constantes.POSICIONAMIENTO;
		private var fase_ultima: int = Constantes.POSICIONAMIENTO;
		
		//	Trazos
		private var dibujo: DibujoLibre;
		
		public function FreeEditorController(piz: Pizarra, editor: FreeEditorView): void{
			
			this.p = piz;
			this.editor = editor;
			Alert.init(p.stage);
			editor.volver.addEventListener(MouseEvent.CLICK, volver);
			editor.guardar.addEventListener(MouseEvent.CLICK, guardar);
			editor.setController(this);
			dibujo = new DibujoLibre();
			var fecha: Date = new Date();
			dibujo.fechaCreacion = fecha.toString();
			dibujo.deporte = p.deporteSeleccionado;
			dibujo.info = p.nuevoDibujo.info;
			dibujo.titulo = p.nuevoDibujo.titulo;
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init() {
			//	Initialize the data structures
			escenas[e_actual] = new Dictionary();
			trayectorias[e_actual] = new Dictionary();
		}
		
		public function moveElement(e: Elemento_Concreto) {
			dibujo.moveElemento(e.id, new Estado(new Point(e.x, e.y), e.rotation));
		}
		
		public function rotateElement(e: Elemento_Concreto) {
			//acciones.push( new RotateAction(e.id, e_actual, new Point(e.x, e.y), e.anterior));
			accion ++; 
			//trace("historial " + accion);
			escenas[e_actual][e.guid] = new Estado(new Point(e.x,e.y),e.rotation);
		}
		
		public function addElement(e: Elemento_Concreto) {
			dibujo.addElemento(e.id, e.elemento.id, new Estado(new Point(e.x - e.width, e.y - e.height), e.rotation));
		}
		
		public function actualizaTitulo(titulo: String) {
			dibujo.titulo = titulo;
		}
		
		public function actualizaInfo(info: String) {
			dibujo.info = info;
		}
		
		public function newScene() {

			transitaEstado();	//	Intercambia la fase
			if (fase_actual == Constantes.POSICIONAMIENTO) {
				//	Crea la estructura de la nueva escena
				escenas[e_actual] = new Dictionary();
				trayectorias[e_actual] = new Dictionary();
				//	Rellena
				for each(var el: String in elementos) {
					setNextPosition(e_actual,el);
					//escenas[e_actual][el] = new Estado(
						//		new Point(0, 0), 0);
								//escenas[e_actual - 1][el].posicion
								//escenas[e_actual - 1][el].rotacion);
					trayectorias[e_actual][el] = new Trayectoria(escenas[e_actual][el].posicion);
				}
			}
		}
		
		//	Sets the position for the recently created scene
		private function setNextPosition(escena: int, id: String) {
			var posicion: Point;
			var rotacion: int;
			if (!trayectorias[escena - 1][id].isEmpty()) {
			//	La escena anterior tiene una trayectoria
			//	Must assign the last point
				posicion = trayectorias[escena - 1][id].last;
			}else {
			//	No tiene trayectoria
			//	Asigno la ultima posicion
				posicion = escenas[escena - 1][id].posicion;
			}
			escenas[escena][id] = new Estado(posicion, rotacion);
		}
		
		public function isSiguenteTrayectorias() {
			return fase_ultima == Constantes.POSICIONAMIENTO;
		}
		
		public function transitaEstado() {
			//	Cambia la fase y se posiciona en el ultima elemento (el creado)
			if (fase_ultima == Constantes.POSICIONAMIENTO) {
				fase_ultima = Constantes.TRAYECTORIAS;
			}else {
				fase_ultima = Constantes.POSICIONAMIENTO;
				e_ultima ++;
			}
			e_actual = e_ultima;
			fase_actual = fase_ultima;	
		}
		
		public function posiciona(escena: int, fase: int) {
			e_actual = escena;
			fase_actual = fase;
		}
		
		public function undo() {
			
			if (acciones[accion] is AddAction) {
				undoAdd();
				accion--;
			}
			if (acciones[accion] is MoveAction) {
				undoMove();			
				accion--; 
			}
			/**/
		}
		
		public function addPuntoATrazo(p: Point) {
			dibujo.ultimoTrazo.add(p);
		}
		
		public function startTrazo(){
			dibujo.newTrazo();
		}
		
		public function auditaTrazo() {
			dibujo.audita();
		}
		/*
		 * 	HANDLE SCENES
		 */
		public function escena( n: int): Dictionary {
			return escenas[n];
		}
		 
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function undoAdd() {
			var action: AddAction = acciones[accion];
			
			for each (var escena: Dictionary in escenas) {
				//trace(escena[action.id].rotacion + " " + action.id);
				delete escena[action.id];
			}
			
		}
		
		private function undoMove() {
			var action: MoveAction = acciones[accion];
			escenas[action.scene][action.id].posicion = action.end;
		}
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volver(event: Event) {
			if(!guardado){
				Alert.show("¿Desea salir sin guardar los cambios?", {buttons:["Sí", "No"], callback:handleResponse});

			}else {
				dispatchEvent(new Event("volver"));
			}
		}
		function handleResponse(response:String):void {
			if (response == "Sí") {
				dispatchEvent(new Event("volver"));
			}
		}
		public function guardar(event: Event) {
			var error: String;
			if (dibujo.titulo == "") {
				Alert.show("Debe introducir un título", {background:"blur"});
			}else {
				var fecha: Date = new Date();
				dibujo.fechaModificacion = fecha.toString();
				error = p.bd.escribeDibujoLibre(dibujo);
				if (error == "Dibujo Insertado correctamente") {
					p.dibujos.push(dibujo);	//	Carga el dibujo creado
					p.hDibujos[dibujo.id] = dibujo;	
					guardado = true;
				}
				Alert.show(error, {background:"blur"});
			}
			
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get escenaActual(): Dictionary {
			return escenas[e_actual];
		}
		public function get fase(): int { return fase_actual; }
		
		public function setPath(t: Trayectoria, id: String) {
			trayectorias[e_actual][id] = t;
		}
		
		public function getPath(id): Trayectoria {
			return trayectorias[e_actual][id];
		}
		
		public function muestraTrayectorias() {
			for each(var t: Trayectoria in trayectorias[e_actual]) {
				t.audita();
			}
		}
		
		public function getTitulo():String {
			return p.nuevoDibujo.titulo;
		}
		
		public function getInfo():String {
			return p.nuevoDibujo.info;
		}
	}
}