﻿package org.pizarra.escenas.editor{	

	import flash.events.*;
	import flash.geom.Point;
	import flash.utils.Dictionary;
	import org.pizarra.DAL.EjercicioDA;
	import org.pizarra.Entity.*;
	import org.pizarra.*;
	import org.pizarra.graficos.*;
	import org.pizarra.escenas.editor.EditorView;
	import org.pizarra.acciones.*;

	import org.pizarra.util.Constantes;

	public class EditorController extends EventDispatcher{
		
		private var p: Pizarra;
		private var editor: EditorView;
		private var ej: EjercicioBE;
		//	Elementos
		private var elementos: Array = new Array();	//	Represents id for the added element
		private var items:Array = new Array();		//	Represents ElementId for the different items
		private var escenas: Array = new Array();
		private var idEscenas: Array = new Array();
		private var idMovimientos: Array = new Array();
		private var trayectorias: Array = new Array();
		private var duraciones: Array = new Array();
		private var audios: Array = new Array();
		private var textos: Array = new Array();
		private var tipos: Array = new Array();
		private var etiquetas: Dictionary = new Dictionary();
		
		//	Historial de acciones
		private var acciones: Array = new Array();
		private var accion: int = -1;
		
		//	Estado
		private var e_actual: int = 1;
		private var e_ultima: int = 1;
		private var fase_actual: int = Constantes.POSICIONAMIENTO;
		private var fase_ultima: int = Constantes.POSICIONAMIENTO;
		
		
		public function EditorController(piz: Pizarra, editor: EditorView): void{
			
			p = piz;
			this.editor = editor;
			Alert.init(p.stage);
			editor.volver.addEventListener(MouseEvent.CLICK, volver);
			editor.guardar.addEventListener(MouseEvent.CLICK, guardar);
			editor.setController(this);
			ej = new EjercicioBE();
			ej.id = Util.nuevoId();
			ej.nombre = p.nombre;
			ej.info = p.informacion;
			ej.tipo = p.tipo_ejercicio;
			ej.fondo = p.fondoSeleccionado.id;
			ej.deporte = p.deporteSeleccionado;
			ej.fechaCreacion = new Date();
			editor.LineaTiempo.Escenas = escenas;
			editor.LineaTiempo.Elementos = elementos;
			editor.LineaTiempo.Urls = p.hElementos;
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init() {
			//	Initialize the data structures
			iniciaGeneralesEscena();
		}
		
		public function moveElement(e: Elemento_Concreto) {
			
			acciones.push( new MoveAction(e.Id, e_actual, new Point(e.x, e.y), e.anterior)); accion ++; 
			escenas[e_actual][e.Id] = new Estado(new Point(e.x, e.y), e.rotation);
			escenas[e_actual][e.Id].IdElemento = e.IdElemento;
			editor.LineaTiempo.Update();
		}
		
		public function rotateElement(e: Elemento_Concreto) {
			//acciones.push( new RotateAction(e.id, e_actual, new Point(e.x, e.y), e.anterior));
			accion ++; 
			//trace("historial " + accion);
			escenas[e_actual][e.guid] = new Estado(new Point(e.x,e.y),e.rotation);
		}
		
		public function addElement(e: Elemento_Concreto) {
		
			acciones.push( new AddAction(e.id) ); accion ++; 
			elementos.push(e.Id);		//	Add to the element id array
			items.push(e.IdElemento)	//	Add the model element
			
			//	Create the state
			//	todo handle insert in middle scene
			escenas[e_actual][e.Id] = new Estado(new Point(e.x, e.y), e.rotation);
			escenas[e_actual][e.Id].IdElemento = e.IdElemento;
			
			//	Create the path
			trayectorias[e_actual][e.Id] = new Trayectoria(new Point(e.x, e.y));
			etiquetas[e.Id] = e.elemento.nombre;
			//	Actualiza movimiento
			idMovimientos[e_actual][e.Id] = Util.nuevoId();
			
			//editor.LineaTiempo.Update();
			editor.LineaTiempo.Reload();
			
		}
		
		public function newScene() {

			transitaEstado();	//	Intercambia la fase
			if (fase_actual == Constantes.POSICIONAMIENTO) {
				//	Crea la estructura de la nueva escena
				iniciaGeneralesEscena();
				//	Rellena
				for each(var el: String in elementos) {
					setNextPosition(e_actual,el);
					trayectorias[e_actual][el] = new Trayectoria(escenas[e_actual][el].posicion);
				}
			}
			editor.LineaTiempo.Reload();
		}
		
		//	Sets the position for the recently created scene
		private function setNextPosition(escena: int, id: String) {
			var posicion: Point;
			var rotacion: int;
			if (!trayectorias[escena - 1][id].isEmpty()) {
			//	La escena anterior tiene una trayectoria
			//	Must assign the last point
				posicion = trayectorias[escena - 1][id].last;
				trace(posicion);
			}else {
			//	No tiene trayectoria
			//	Asigno la ultima posicion
				posicion = escenas[escena - 1][id].posicion;
			}
			escenas[escena][id] = new Estado(posicion, rotacion);
		}
		
		public function isSiguenteTrayectorias() {
			return fase_ultima == Constantes.POSICIONAMIENTO;
		}
		
		public function transitaEstado() {
			//	Cambia la fase y se posiciona en el ultima elemento (el creado)
			if (fase_ultima == Constantes.POSICIONAMIENTO) {
				fase_ultima = Constantes.TRAYECTORIAS;
			}else {
				fase_ultima = Constantes.POSICIONAMIENTO;
				e_ultima ++;
			}
			e_actual = e_ultima;
			fase_actual = fase_ultima;	
		}
		
		public function posiciona(escena: int, fase: int) {
			e_actual = escena;
			fase_actual = fase;
		}
		
		public function undo() {
			
			if (acciones[accion] is AddAction) {
				undoAdd();
				accion--; trace("Add historial " + accion);
			}
			if (acciones[accion] is MoveAction) {
				undoMove();			
				accion--; trace("Move historial " + accion);
			}
			/**/
		}
		
		/*
		 * 	HANDLE SCENES
		 */
		public function escena( n: int): Dictionary { return escenas[n]; }
		 
		public function actualizaGeneralesEscena(duracion: int, tipo: String, audio: String, texto: String) {
			duraciones[e_actual] = duracion;
			textos[e_actual] = texto;
			audios[e_actual] = audio;
			tipos[e_actual] = tipo;
		}
		
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function undoAdd() {
			var action: AddAction = acciones[accion];
			
			for each (var escena: Dictionary in escenas) {
				//trace(escena[action.id].rotacion + " " + action.id);
				delete escena[action.id];
			}
			trace("---> Removing element " + action.id);
			editor.eliminaElemento(action.id);
		}
		
		private function undoMove() {
			var action: MoveAction = acciones[accion];
			escenas[action.scene][action.id].posicion = action.end;
			trace("---> Move from " + action.start + " to " + action.end);
		}
		
		//	inicia las estructuras de datos para la nueva escena
		private function iniciaGeneralesEscena() {
			escenas[e_actual] = new Dictionary();
			trayectorias[e_actual] = new Dictionary();
			idEscenas[e_actual] = Util.nuevoId();
			idMovimientos[e_actual] = new Dictionary();
			trace("escena actual:  " + e_actual);
			for each(var el in elementos) {
				var estadoAnterior: Estado = escenas[e_actual - 1][el];
				escenas[e_actual][el] = new Estado(estadoAnterior.posicion, estadoAnterior.rotacion);
				escenas[e_actual][el].IdElemento = el;
				idMovimientos[e_actual][el] = Util.nuevoId();
				trace(el + "  -  " + idMovimientos[e_actual][el]);
			}
			duraciones[e_actual] = Constantes.TIEMPO_ESCENA_DEFECTO;
			textos[e_actual] = "";
			audios[e_actual] = "";
			tipos[e_actual] = Constantes.TIPO_ESCENA_DEFECTO;
		}
		
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volver(event: Event){
			dispatchEvent(new Event("volver"));
		}
		
		//	Save the currently editing EExercise
		private function guardar(event: Event){
			//	Audita el estado
			trace("************************************************");
			trace("              ESTADO	");
			trace("************************************************");
			trace("audios " + audios);
			trace("textos" + textos);
			trace("tipos" + tipos);
			trace("duraciones" + duraciones);
			for each(var elemento in elementos) {
				trace("---------------------------------");
				trace("Elemento :" + elemento);
				trace("---------------------------------");
				for (var i = 1; i < escenas.length; i++) {
					trace("Escena: " + i)
					trace("posicion: " + escenas[i][elemento].posicion);
					trace("trayectoria" + trayectorias[i][elemento].puntos);
				}
			}
			
			//	Parse scenes
			for (var i: int = 1; i < escenas.length; i++ ) {
			//	For each scene	
				var esc: EscenaBE = new EscenaBE();
				esc.id = idEscenas[i];
				esc.ejercicio = ej.id;
				esc.tipo = tipos[i];
				esc.orden = i;
				esc.duracion = duraciones[i];
				esc.audio = audios[i];
				esc.texto = textos[i];
				var j: int = 0;
				for each(var el in elementos) {
					var mov: MovimientoBE = new MovimientoBE();
					//mov.id = idMovimientos[i][el];
					mov.id = el;
					trace(i + " - " + el + " - " + mov.id);
					mov.escena = esc.id;
					mov.elemento = items[j];
					mov.tipo = null;
					mov.accion = null;
					mov.orden = j;
					mov.inicio = escenas[i][el].posicion;
					mov.rotacion = escenas[i][el].rotacion;
					mov.etiqueta = etiquetas[el];
					var k: int = 0;
					for each(var p: Point in trayectorias[i][el].puntos) {
						var tray: TrayectoriaBE = new TrayectoriaBE();
						tray.movimiento = mov.id;
						tray.orden = k;
						tray.punto = p;
						mov.trayectoria[k] = tray;
						k++;
					}
					esc.movimientos[j] = mov;
					j++;
				}
				ej.escenas[i] = esc;
			}
			
			var DA = new EjercicioDA(p.bd.conexion);
			var msg = DA.writeExercise(ej);
			if (msg == "Ejercicio Insertado correctamente"){
				this.p.ejercicios.push(ej);
				this.p.hEjercicios[ej.id] = ej;
			}
			Alert.show(msg, {background:"blur"});
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get escenaActual(): Dictionary { return escenas[e_actual]; }
		public function getEscena(i: int): Dictionary { return escenas[i]; }
		
		public function get ultima(): int { return e_ultima; }
		public function get fase(): int { return fase_actual; }
		public function get esc(): int { return e_actual; }
		
		public function setPath(t: Trayectoria, id: String) {
			trayectorias[e_actual][id] = t;
		}
		
		public function getPath(id): Trayectoria {
			return trayectorias[e_actual][id];
		}
		
		public function muestraTrayectorias() {
			for each(var t: Trayectoria in trayectorias[e_actual]) {
				t.audita();
			}
		}
		
		public function getAudio(): String { return audios[e_actual]; }
		public function getTexto(): String { return textos[e_actual]; }
		public function getTipo(): String { return tipos[e_actual]; }
		public function getDuracion(): int { return duraciones[e_actual]; }
		
	}
}