﻿package org.pizarra.escenas.View{	

	import fl.controls.Label;
	import fl.controls.TextArea;
	import fl.controls.TextInput;
	import fl.events.SliderEvent;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import fl.controls.Slider;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.utils.IExternalizable;
	import flash.utils.Timer;
	import org.pizarra.Data.DibujoLibre;
	import org.pizarra.Entity.*;
	import org.pizarra.escenas.View;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.Pizarra;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.util.Constantes;
	import org.pizarra.Util;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filesystem.File;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import fl.transitions.*;
	import fl.transitions.easing.*;
	import org.pizarra.graficos.Alert;
	import org.pizarra.Data.Trazo;
	import org.pizarra.configuracion.*;
	import flash.text.*;
	import org.pizarra.util.Eventos;

	public class VisorDibujosView extends View{
		
		private var p: Pizarra;
		private var BtnVolver: CoolButton;
		private var pnBotonera: MovieClip;
		private var pnDibujo: Sprite;
		private var fondo: Loader;
		private var trazos: Array = new Array();
		
		private var _atras: Loader;
		private var _delante: Loader;
		private var _pausa: Loader;
		private var _play: Loader;
		private var _reverse: Loader;
		private var _slider: Slider;
		
		private var elementos: Array = new Array();
		private var elementLoaders: Array = new Array();
		private var f_x: Number;
		private var f_y: Number;
		
		private var dibujo:DibujoLibre;
		private var fondoBE: FondoBE;
		
		private var trazoActual: uint = 0;
		private var puntoActual: uint = 0;
		private var timer: Timer;
		private var delay: Number = 50;	//	In miliseconds
		private var speed: Slider = new Slider();
		
		public function VisorDibujosView(piz: Pizarra): void{
		
			this.p = piz;
			Alert.init(p.stage);
			dibujo = p.hDibujos[p.ejercicioSeleccionado];
			fondoBE = p.hFondos[dibujo.fondo];
			super(dibujo.titulo);
			
			inicializaComponentes();
			
			dibujaTerreno();
			
			f_x =  fondoBE.anchura/ fondoBE.anchura_m;
			f_y = fondoBE.altura / fondoBE.anchura_m;

			cargaElementos();
			cargaInfo();
			
			//	Add slider
			speed.width = 100;
			speed.x = 1000;
			speed.y = 100;
			speed.rotation = 90;
			speed.snapInterval = 25;
			speed.minimum = 10;
			speed.value = delay;
			speed.maximum = 400;
			speed.liveDragging = true;
			speed.addEventListener(SliderEvent.CHANGE, changeSpeed);
			
			addChild(speed);
			
			//	Init sprites
			for(var i = 0; i < dibujo.trazos.length; i++ ) {
				trazos[i] = new Sprite();
				pnDibujo.addChild(trazos[i]);
			}
			
			timer = new Timer(delay, 1);
			dibujaSiguienteTrazo(null);
			timer.addEventListener(TimerEvent.TIMER_COMPLETE, dibujaSiguienteTrazo);
			timer.start();
			
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function inicializaComponentes(){
			creaPanel();
			posicionaBotones();
		}
		
		private function creaPanel(){
			pnBotonera = new MovieClip(); 
			this.addChild(pnBotonera);
			pnBotonera.x = 200;
			pnBotonera.y = 500;
		}
		
		
		private function posicionaBotones(){
			
			BtnVolver = new CoolButton();
			BtnVolver.text = "Volver";
			addChild(BtnVolver);	
			BtnVolver.x = 900;	BtnVolver.y = 550;
			BtnVolver.addEventListener(MouseEvent.CLICK, volver);
	
		}
		
		private function cargaElementos() {
			//var d: DibujoLibre = p.dibujoSeleccionado;
			var d: DibujoLibre = dibujo;
			var i: int = 0;
			for each(var id: String in d.idsElementos) {
				elementLoaders[i] = new Loader(); 
				var auxElemento: ElementoBE = p.hElementos[d.elementos[id]];
				elementos[i] = auxElemento;
				if (auxElemento != null) {
					elementLoaders[i].contentLoaderInfo.addEventListener(Event.COMPLETE, cargadoElemento);
					elementLoaders[i].load( new URLRequest(auxElemento.imagen) );
					elementLoaders[i].x = DX(d.estados[id].posicion.x);
					elementLoaders[i].y = DY(d.estados[id].posicion.y);
					pnDibujo.addChild(elementLoaders[i] );
				}
				i++;
			}
		}
		
		private function cargadoElemento(e: Event) {
			var i: int = elementLoaders.indexOf(e.target.loader);
			e.target.loader.width = elementos[i].anchura * f_x;
			e.target.loader.x += e.target.loader.width / 2;
			e.target.loader.height = elementos[i].altura * f_x;
			e.target.loader.y += e.target.loader.height / 2;
		}
		
		private function dibujaTrazos() {
			var i: int = 0;
			var j: int = 0;
			//var d: DibujoLibre = p.dibujoSeleccionado;
			var d: DibujoLibre = dibujo;
			
			for each(var t: Trazo in d.trazos) {
				trazos[i] = new Sprite();
				pnDibujo.addChild(trazos[i]);
				j = 0;
				for each(var p: Point in t.puntos) {
					if (j == 0 ) {
						trazos[i].graphics.lineStyle(Tema.freeEditorLineWidth, Tema.lineColor);
						trazos[i].graphics.moveTo(DX(p.x), DY(p.y));
					}
					trazos[i].graphics.lineTo(DX(p.x), DY(p.y));
					j++;
				}
				i++;
			}
		}
		
		private function changeSpeed(event:Event):void {
			delay = speed.value;
		}
		
		//	Dibuja el siguiente trazo y añade
		private function dibujaSiguienteTrazo(event: TimerEvent) {
			
			var i: int = trazoActual;
			var j: int = puntoActual;
			var d: DibujoLibre = dibujo;
			
			trace(i + " " + j);
			if (i >= dibujo.trazos.length) return;
			var t: Trazo = d.trazos[i];
			
			
			
			var p: Point = t.puntos[j];
			if (j == 0 ) {
				trazos[i].graphics.lineStyle(Tema.freeEditorLineWidth, Tema.lineColor);
				trazos[i].graphics.moveTo(DX(p.x), DY(p.y));
			}
			trazos[i].graphics.lineTo(DX(p.x), DY(p.y));
			
			puntoActual += 1;
			if (puntoActual >= t.puntos.length) {
				trazoActual += 1;
				puntoActual = 0;
			}
			timer.delay = delay;
			timer.start();
		}
		
		private function DX(x: int): int {
			return x + fondo.x;
		}
		private function DY(y: int): int {
			return y + fondo.y;
		}
		private function cargaInfo() {
			
			var d: DibujoLibre = dibujo;
			
			//	Carga el título
			var lblTitulo : TextField = new TextField();
			lblTitulo.defaultTextFormat = Tema.formatoLabel;
			lblTitulo.text = "Título "; 
			lblTitulo.width = 70;
			lblTitulo.x = 50;
			lblTitulo.y = 450;
			addChild(lblTitulo);
			
			var titulo: TextInput = new TextInput();
			//titulo.text = p.dibujoSeleccionado.titulo;
			titulo.text = d.titulo;
			titulo.x = 150; 	titulo.y = 450;
			titulo.width = 400;
			titulo.editable = false;
			addChild(titulo);
	
			//	Carga la info
			var lblInfo : TextField = new TextField();
			lblInfo.defaultTextFormat = Tema.formatoLabel;
			lblInfo.text = "Info ";
			lblInfo.x = 50; lblInfo.y = 480;
			addChild(lblInfo);
			
			var info: TextArea = new TextArea();
			//info.text = p.dibujoSeleccionado.info;
			info.text = d.info;
			info.editable = false;
			info.x = 150; 	info.y = 480;
			info.width = 400;	info.height = 100;
			addChild(info);
			
			//	Carga las fechas
			var lblFCreacion : TextField = new TextField();
			lblFCreacion.defaultTextFormat = Tema.formatoLabel;
			lblFCreacion.text = "Fecha Creación ";
			lblFCreacion.x = 550; lblFCreacion.y = 450;
			lblFCreacion.width = 150;
			addChild(lblFCreacion);
			
			var FCreacion: TextInput = new TextInput();
			//FCreacion.text = p.dibujoSeleccionado.fechaCreacion;
			FCreacion.text = d.fechaCreacion;
			FCreacion.editable = false;
			FCreacion.x = 690; 	FCreacion.y = 450;
			FCreacion.width = 250;	
			addChild(FCreacion);
			
			var lblFModificacion : TextField = new TextField();
			lblFModificacion.width = 150;
			lblFModificacion.defaultTextFormat = Tema.formatoLabel;
			lblFModificacion.text = "Fecha Modificación ";
			lblFModificacion.x = 550; lblFModificacion.y = 480;
			addChild(lblFModificacion);
			
			var FModificacion: TextInput = new TextInput();
			//FModificacion.text = p.dibujoSeleccionado.fechaModificacion;
			FModificacion.text = d.fechaModificacion;
			FModificacion.editable = false;
			FModificacion.x = 690; 	FModificacion.y = 480;
			FModificacion.width = 250;
			addChild(FModificacion);
			//	Carga thumb del deporte
			
		}
		
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function dibujaTerreno(): Boolean{
			/*var idFondo: String = p.dibujoSeleccionado.fondo;
			if (idFondo == "" || idFondo == null) { 
				return false;
			}*/
			try {
				pnDibujo = new Sprite();
				addChild(pnDibujo);
				fondo = new Loader(); 
				fondo.load( new URLRequest(p.hFondos[dibujo.fondo].url));
				fondo.x = 150; fondo.y = 40;
				pnDibujo.addChild(fondo);
				return true;
			}
			catch (err:Error)
			{
				Alert.show(err.message + err.getStackTrace());
				return false;
			}
			return true;
			/*pnVideo = new Sprite(); 
			this.addChild(pnVideo);
			fondo = new Loader(); 
			var urlReq:URLRequest = new URLRequest(p.fondoEjercicio.url);
			fondo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			fondo.load(urlReq);
			pnVideo.addChild(fondo);*/
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function imgLoaded(event:Event):void{
			
			switch(event.target.loader){
				case _atras:
					Util.posiciona(_atras,0,0,50,50);
					break;
				case _delante:
					Util.posiciona(_delante,60,0,50,50);
					break;
				case _pausa:
					Util.posiciona(_pausa,120,0,50,50);
					break;
				case _play:
					Util.posiciona(_play,180,0,50,50);
					break;
				case _reverse:
					Util.posiciona(_reverse,240,0,50,50);
					break;
				case fondo: 
					Util.posiciona(fondo,100,100,400,400);
					break;
				default:	trace("error cargando botonera");
			}
		}
		private function muestraBotonera(event:Event):void{
			if(event.currentTarget == event.target)
				TransitionManager.start(pnBotonera,{type:Fade, duration:1, direction:Transition.IN})
		}
		private function ocultaBotonera(event:Event):void{
			if(event.currentTarget == event.target)
				TransitionManager.start(pnBotonera,{type:Fade,duration:1 , direction:Transition.OUT})
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		private function volver(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		public function get atras(): Loader { return _atras; }
		public function get delante(): Loader { return _delante; }
		public function get pausa(): Loader { return _pausa; }
		public function get play(): Loader { return _play; }
		public function get reverse(): Loader { return _reverse; }
		public function get slider(): Slider { return _slider; }
	
	}
}