﻿package org.pizarra.escenas.View{	

	import fl.accessibility.LabelButtonAccImpl;
	import fl.controls.*;
	import fl.containers.*;
	import fl.events.SliderEvent;
	import flash.display.*;	
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.net.FileFilter;
	import fl.controls.Label;
	import fl.controls.TextInput;
	import org.pizarra.Entity.*;
	import org.pizarra.Util;
	import org.pizarra.Pizarra;
	import org.pizarra.util.*;
	import org.pizarra.graficos.*;
	import org.pizarra.escenas.View;
	import flash.events.MouseEvent;
	import org.pizarra.graficos.Alert;
	import org.pizarra.configuracion.*;
	import flash.filesystem.*;
	import org.pizarra.escenas.Controller.ThemeController;
	import fl.motion.Color;
	import flash.text.TextFormat;
	
	public class ThemeView extends View{
		
		private var comboTemas:ComboBox = new ComboBox();
		
		//	Model
		private var p: Pizarra;
		
		private var txtVideo: TextInput = new TextInput()
					, txtServer: TextInput = new TextInput()
					, txtPdf: TextInput = new TextInput();
		
		private var cpPointColor: ColorPicker = new ColorPicker()
					, cpBezColor: ColorPicker = new ColorPicker()
					, cpLineColor: ColorPicker = new ColorPicker();
					 
		private var cbTabletMode: CheckBox = new CheckBox();
		private var slCalidad: Slider = new Slider();
		
		//	Filesystem
		private var file: File = File.desktopDirectory;
		private var filtro: FileFilter = new FileFilter("Settings", "*." + Extensiones.SETTINGS);
		
		//	Controller
		private var logic: ThemeController;
		
		
		//	New
		private var btnImport, btnMakeDefault, btnDelete, btnBack, defaultMark, btnSave, btnNew: TextImageButton;
		private var scrollPanel: ScrollPane;
		private var scrollView: Sprite;
		private var lblName: Label = new Label()
				, lblBackgroundA: Label = new Label()
				, lblSecondBgA: Label = new Label();
		private var txtName: TextInput = new TextInput();
		private var nsLblSize: NumericStepper = new NumericStepper();
		private var cpBackgroundA: ColorPicker = new ColorPicker()
				, cpSecondBgA: ColorPicker = new ColorPicker()
				, cpSeparatorColor: ColorPicker = new ColorPicker()
				, cpLblColor: ColorPicker = new ColorPicker()
				, cpColorTitulo: ColorPicker = new ColorPicker()
				, cpColorBoton: ColorPicker = new ColorPicker()
				, cpColorBotonPulsado: ColorPicker = new ColorPicker()
				, cpColorBordeBoton: ColorPicker = new ColorPicker();
		
		public function ThemeView(piz: Pizarra): void{
			super("Temas");
			p = piz;
			Alert.init(p.stage);
			posicionaElementos();
			posicionaBotones();
			logic = new ThemeController(p, this);
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//	
		private function posicionaElementos(){
			
			updateComboTemas();
			
			//	Default Mark
			this.defaultMark = new TextImageButton(Ficheros.IMG_SELECT_DEFAULT, "Tema por defecto" );
			this.defaultMark.x = 910; this.defaultMark.y = 80;
			this.addChild(defaultMark);
			
			scrollView = new Sprite();
			drawBox(scrollView,Tema.backgroundA);
			
			lblName.text = "Nombre";
			lblName.setStyle("textFormat", Tema.formatoLabel);
			txtName.text = Tema.Name;
			SetElemento(lblName,txtName, 10,10,300,25);
			
			lblBackgroundA.text = "Fondo Principal";
			lblBackgroundA.setStyle("textFormat", Tema.formatoLabel);
			cpBackgroundA.selectedColor = Tema.backgroundA;
			SetElemento(lblBackgroundA,cpBackgroundA, 10,50,30,25);
			
			lblSecondBgA.text = "Fondo Secundario";
			lblSecondBgA.setStyle("textFormat", Tema.formatoLabel);
			cpSecondBgA.selectedColor = Tema.backgroundB;
			SetElemento(lblSecondBgA,cpSecondBgA, 10,90,30,25);
			
			var lblSeparatorColor: Label = new Label();
			lblSeparatorColor.text = "Color Separadores";
			lblSeparatorColor.setStyle("textFormat", Tema.formatoLabel);
			cpSeparatorColor.selectedColor = Tema.SeparatorColor;
			SetElemento(lblSeparatorColor,cpSeparatorColor, 10,130,30,25);
			
			var lblLabelColor: Label = new Label();
			lblLabelColor.text = "Color Etiquetas";
			lblLabelColor.setStyle("textFormat", Tema.formatoLabel);
			cpLblColor.selectedColor = Tema.lblColor;
			SetElemento(lblLabelColor,cpLblColor, 10,170,30,25);
			
			var lblLabelSize: Label = new Label();
			lblLabelSize.text = "Tamaño etiqueta";
			lblLabelSize.setStyle("textFormat", Tema.formatoLabel);
			nsLblSize.maximum = 20;
			nsLblSize.minimum = 10;
			nsLblSize.value = Tema.lblSize;
			SetElemento(lblLabelSize,nsLblSize, 10,210,60,25);
			
			var lblTitleColor: Label = new Label();
			lblTitleColor.text = "Color Título";
			lblTitleColor.setStyle("textFormat", Tema.formatoLabel);
			cpColorTitulo.selectedColor = Tema.colorTitulo;
			SetElemento(lblTitleColor,cpColorTitulo, 10,250,30,25);
			
			var lblButtonBg: Label = new Label();
			lblButtonBg.text = "Color Botón";
			lblButtonBg.setStyle("textFormat", Tema.formatoLabel);
			cpColorBoton.selectedColor = Tema.ButtonBackground;
			SetElemento(lblButtonBg,cpColorBoton, 10,290,30,25);
			
			var lblButtonSelectedBg: Label = new Label();
			lblButtonSelectedBg.text = "Color Botón pulsado";
			lblButtonSelectedBg.setStyle("textFormat", Tema.formatoLabel);
			cpColorBotonPulsado.selectedColor = Tema.ButtonBackgroundPressed;
			SetElemento(lblButtonSelectedBg,cpColorBotonPulsado, 10,330,30,25);
			
			var lblBordeBoton: Label = new Label();
			lblBordeBoton.text = "Color Borde Botón";
			lblBordeBoton.setStyle("textFormat", Tema.formatoLabel);
			cpColorBordeBoton.selectedColor = Tema.ButtonBorder;
			SetElemento(lblBordeBoton,cpColorBordeBoton, 10,370,30,25);
			
			scrollPanel = new ScrollPane();
			scrollPanel.source = this.scrollView;
			scrollPanel.setSize(800,400);
			scrollPanel.move(50,150);
			this.addChild(scrollPanel);
		}
		
		public function UpdateTema(): void{
			
			Tema.Name = txtName.text;
			Tema.backgroundA = cpBackgroundA.selectedColor;
			Tema.secondBgA = cpSecondBgA.selectedColor;
			Tema.SeparatorColor = cpSeparatorColor.selectedColor;
			Tema.lblColor = cpLblColor.selectedColor;
			Tema.lblSize = nsLblSize.value;
			Tema.colorTitulo = cpColorTitulo.selectedColor;
			Tema.ButtonBackground = cpColorBoton.selectedColor;
			Tema.ButtonBackgroundPressed = cpColorBotonPulsado.selectedColor;
			Tema.ButtonBorder = cpColorBordeBoton.selectedColor;
			
			var myFormat: TextFormat = new TextFormat();
			myFormat.size = Tema.lblSize;
			myFormat.color = Tema.lblColor;
			myFormat.font = "Arial Bold";
			Tema.formatoLabel = myFormat;
			
		}
		
		function drawBox(box:Sprite,color:uint):void { 
            box.graphics.beginFill(color, 1); 
            box.graphics.drawRect(0, 0, 785, 800); 
            box.graphics.endFill();         
		}
		
		private function SetElemento(lbl, obj, x, y, width, height) {
			Util.posiciona(lbl,x,y,200,24);
			Util.posiciona(obj,x + 200, y ,width,height);
			Util.setBackground(obj,p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			scrollView.addChild(lbl);
			scrollView.addChild(obj);
		}
		
		private function updateComboTemas() {
			comboTemas = new ComboBox();
			comboTemas.move(100, 100);
			comboTemas.width = 300;
			//comboTemas.addEventListener(Event.CHANGE, seleccionadoTema);
			for each(var tema: TemaBE in p.temas) {
				comboTemas.addItem({label: tema.name, Value: tema.id});
			}
			this.addChild(comboTemas);
			comboTemas.enabled = false;
		}
		
		public function refreshComboTemas() {
			this.removeChild(comboTemas);
			updateComboTemas();
		}
		
		private function posicionaBotones(){
			
			this.btnNew = new TextImageButton(Ficheros.IMG_ADD, "Nuevo" );
			this.btnNew.x = 540;	this.btnNew.y = 4;
			this.addChild(btnNew);
			
			this.btnSave = new TextImageButton(Ficheros.IMG_GUARDAR, "Guardar" );
			this.btnSave.x = 620;	this.btnSave.y = 4;
			this.addChild(btnSave);
			
			this.btnImport = new TextImageButton(Ficheros.IMG_IMPORT, "Importar" );
			this.btnImport.x = 700;	this.btnImport.y = 4;
			this.addChild(btnImport);
			
			this.btnMakeDefault = new TextImageButton(Ficheros.IMG_SELECT_DEFAULT, "Defecto" );
			this.btnMakeDefault.x = 780; this.btnMakeDefault.y = 4;
			this.addChild(btnMakeDefault);
			
			this.btnDelete = new TextImageButton(Ficheros.IMG_DELETE, "Borrar" );
			this.btnDelete.x = 860; this.btnDelete.y = 4;
			this.addChild(btnDelete);
			
			this.btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			this.btnBack.x = 940; this.btnBack.y = 4;
			this.btnBack.addEventListener(MouseEvent.CLICK, volverSettings);
			this.addChild(btnBack);
	
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volverSettings(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		
		private function importadoTema(event: Event){
			updateComboTemas();
		}
		
		/*private function seleccionadoTema(e: Event) {
			logic.seleccionaTema(comboTemas.selectedIndex);
			super.dibujaFondoLineal();
		}		*/
		
		private function SaveSettings(event: MouseEvent): void {
			//	Set the values on Settings
			Settings.Bez_color = cpBezColor.selectedColor;
			//Settings.Calidad =
			Settings.Line_color = cpLineColor.selectedColor;
			Settings.Pdf = txtPdf.text;
			Settings.Point_color = cpPointColor.selectedColor;
			Settings.Server = txtServer.text;
			Settings.Tablet = cbTabletMode.selected;
			Settings.Video = txtVideo.text;
			
			//p.pref.bez_color = Settings.Bez_color;
			
			try {
				p.bd.set_preferencias_from_Settings();
				Alert.show("Preferencias guardadas correctamente");
			}catch (err:Error)
			{
				Alert.show("Error guardando las preferencias en Base de datos");
			}
		}
		
		private function parameterChange(ev: Event){
			Alert("hey");
		}
		
		public function UpdateForm(theme: TemaBE): void{
			txtName.text = theme.name;
			cpBackgroundA.selectedColor = theme.backgroundA;
			cpSecondBgA.selectedColor = theme.secondBgA;
			super.dibujaFondoLineal();
			drawBox(scrollView,Tema.secondBgA);
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get BtnImport(): TextImageButton {return this.btnImport;}
		public function get BtnMakeDefault(): TextImageButton {return this.btnMakeDefault;}
		public function get BtnDelete(): TextImageButton {return this.btnDelete;}
		public function get BtnSave(): TextImageButton {return this.btnSave;}
		public function get BtnNew(): TextImageButton {return this.btnNew;}
		public function get CbThemes(): ComboBox {return this.comboTemas;}
		
		public function get CpMainBg(): ColorPicker {return this.cpBackgroundA;}
		public function get CpSecondBg(): ColorPicker {return this.cpSecondBgA;}
	}
}