﻿package org.pizarra.escenas.View{	

	import fl.accessibility.LabelButtonAccImpl;
	import fl.controls.CheckBox;
	import fl.controls.ColorPicker;
	import fl.controls.ComboBox;
	import fl.controls.*;
	import fl.events.SliderEvent;
	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.net.FileFilter;
	import fl.controls.Label;
	import fl.controls.TextInput;
	import org.pizarra.Entity.*;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.*;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.escenas.View;
	import org.pizarra.escenas.Controller.*;
	import flash.events.MouseEvent;
	import org.pizarra.graficos.Alert;
	import org.pizarra.configuracion.*;
	import flash.filesystem.*;
	import org.pizarra.graficos.TextImageButton;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import org.pizarra.graficos.Image;
	import org.pizarra.graficos.TrayectoriaSprite;
	import org.pizarra.Trayectoria;
	import flash.geom.Point;
	import flash.events.KeyboardEvent;
	
	public class SettingsView extends View{
		
		private var comboTemas:ComboBox = new ComboBox();
		
		//	Model
		private var p: Pizarra;
		
		private var txtVideo: TextInput = new TextInput()
					, txtServer: TextInput = new TextInput()
					, txtPdf: TextInput = new TextInput();
		private var cpPointColor: ColorPicker = new ColorPicker()
					 , cpBezColor: ColorPicker = new ColorPicker()
					 , cpLineColor: ColorPicker = new ColorPicker();
					 
		private var txtImageFlv: TextField = new TextField(),
					txtImagePdf: TextField = new TextField();
		
		private var cbTabletMode: CheckBox = new CheckBox()
					, cbShowPointsOnAnimation: CheckBox = new CheckBox()
					, cbShowPathOnAnimation: CheckBox = new CheckBox()
					, cbShowPathOnTimeline: CheckBox = new CheckBox()
					, cbOpenVideoAfterGenerating: CheckBox = new CheckBox()
					, cbOpenPdfAfterGenerating: CheckBox = new CheckBox();
		
		private var slCalidad: Slider = new Slider();
		
		//	Botones
		private var btnVolver: CoolButton;
		private var btnGuardar: CoolButton;
		private var btnAnadir: CoolButton;
		
		//	Filesystem
		private var file: File = File.desktopDirectory;
		private var filtro: FileFilter = new FileFilter("Settings", "*." + Extensiones.SETTINGS);
		
		//	Controller
		private var logic: SettingsController;
		
		private var btnBack, btnSave, btnUpdate, btnPing: TextImageButton;
		private var imgPingOk, imgPingError: Image;
		private var circularSprite, zigzagSprite: TrayectoriaSprite;
		
		public function SettingsView(piz: Pizarra): void{
			super("Preferencias");
			p = piz;
			Alert.init(p.stage);
			posicionaElementos();
			placeRibbonButtons();
			placeBaseImages();
			logic = new SettingsController(p, this);
			logic.Comprueba_conexion(false);
			p.stage.addEventListener(KeyboardEvent.KEY_UP, onKeyEvent);
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//	
		private function posicionaElementos(){
			
			var myFormat:TextFormat = new TextFormat();
			myFormat.size = 20;
			
			var lblVideo: TextField = new TextField();
			lblVideo.defaultTextFormat = myFormat;
			lblVideo.text = "Nombre vídeo";
			lblVideo.textColor = Tema.lblColor; 
			txtVideo.text = Settings.Video;
			txtVideo.addEventListener(Event.CHANGE, videoName_Change);
			//SetElemento(lblVideo, txtVideo, 50, 140, 400, 25);
			SetElemento(lblVideo, txtVideo, 50, 80, 400, 25);
			
			txtImageFlv.defaultTextFormat = myFormat;
			txtImageFlv.textColor = Tema.lblColor; 
			txtImageFlv.text = Settings.Video + ".flv";
			this.addChild(txtImageFlv);
			Util.posiciona(txtImageFlv,700,200,150,30);
			
			var lblPdf: TextField = new TextField();
			lblPdf.defaultTextFormat = myFormat;
			lblPdf.textColor = Tema.lblColor;
			lblPdf.text = "Nombre del Pdf";
			txtPdf.text = Settings.Pdf ;
			txtPdf.addEventListener(Event.CHANGE, pdfName_Change);
			SetElemento(lblPdf, txtPdf, 50, 120, 400, 25);
			
			txtImagePdf.defaultTextFormat = myFormat;
			txtImagePdf.textColor = Tema.lblColor; 
			txtImagePdf.text = Settings.Pdf + ".pdf";
			this.addChild(txtImagePdf);
			Util.posiciona(txtImagePdf,830,120,150,30);
			
			var lblServer: TextField = new TextField();
			lblServer.defaultTextFormat = myFormat;
			lblServer.textColor = Tema.lblColor;
			lblServer.text = "Url del Servidor";
			txtServer.text = Settings.Server;
			txtServer.addEventListener(Event.CHANGE, serverIp_Change);
			SetElemento(lblServer, txtServer, 50, 160, 400, 25);
			
			var lblPointColor: TextField = new TextField();
			lblPointColor.defaultTextFormat = myFormat;
			lblPointColor.textColor = Tema.lblColor;
			lblPointColor.text = "Color del punto";
			cpPointColor.selectedColor = Settings.Point_color;
			cpPointColor.addEventListener(Event.CHANGE, color_Change);
			SetElemento(lblPointColor, cpPointColor, 50, 200, 40, 25);
			
			var lblBezColor: TextField = new TextField();
			lblBezColor.defaultTextFormat = myFormat;
			lblBezColor.textColor = Tema.lblColor;
			lblBezColor.text = "Color del Bezier";
			cpBezColor.selectedColor = Settings.Bez_color;
			cpBezColor.addEventListener(Event.CHANGE, color_Change);
			SetElemento(lblBezColor, cpBezColor, 50, 240, 40, 25);
			
			var lblLineColor: TextField = new TextField();
			lblLineColor.defaultTextFormat = myFormat;
			lblLineColor.textColor = Tema.lblColor;
			lblLineColor.text = "Color de la Línea";
			cpLineColor.selectedColor = Settings.Line_color;
			SetElemento(lblLineColor, cpLineColor, 50, 280, 40, 25);

			var lblCalidad: TextField = new TextField();
			lblCalidad.defaultTextFormat = myFormat;
			lblCalidad.textColor = Tema.lblColor;
			lblCalidad.text = "Calidad del Vídeo";
			slCalidad.maximum = 50;
			slCalidad.minimum = 10;
			slCalidad.tickInterval = 5;
			slCalidad.liveDragging = true;
			slCalidad.snapInterval = 5;
			slCalidad.value = Settings.Calidad;
			slCalidad.addEventListener(SliderEvent.CHANGE, QualityChange);
			SetElemento(lblCalidad, slCalidad, 50, 320, 400, 10);
			
			var lblTabletMode: TextField = new TextField();
			lblTabletMode.defaultTextFormat = myFormat;
			lblTabletMode.textColor = Tema.lblColor;
			lblTabletMode.text = "Modo Tablet";
			cbTabletMode.selected = Settings.Tablet;
			cbTabletMode.enabled = false;
			SetElemento(lblTabletMode, cbTabletMode, 50, 360, 20, 20);
		
			var lblShowPointsOnAnimation: TextField = new TextField();
			lblShowPointsOnAnimation.defaultTextFormat = myFormat;
			lblShowPointsOnAnimation.textColor = Tema.lblColor;
			lblShowPointsOnAnimation.text = "Puntos en la animación";
			cbShowPointsOnAnimation.selected = Settings.ShowPointsOnAnimation;
			SetElemento(lblShowPointsOnAnimation, cbShowPointsOnAnimation, 50, 400, 20, 20);
			
			var lblShowPathOnAnimation: TextField = new TextField();
			lblShowPathOnAnimation.defaultTextFormat = myFormat;
			lblShowPathOnAnimation.textColor = Tema.lblColor;
			lblShowPathOnAnimation.text = "Trayectoria en Animación";
			cbShowPathOnAnimation.selected = Settings.ShowPathOnAnimation;
			SetElemento(lblShowPathOnAnimation, cbShowPathOnAnimation, 50, 440, 20, 20);
			
			var lblShowPathOnTimeline: TextField = new TextField();
			lblShowPathOnTimeline.defaultTextFormat = myFormat;
			lblShowPathOnTimeline.textColor = Tema.lblColor;
			lblShowPathOnTimeline.text = "Trayectoria en Línea ";
			cbShowPathOnTimeline.selected = Settings.ShowPathOnTimeline;
			SetElemento(lblShowPathOnTimeline, cbShowPathOnTimeline, 50, 480, 20, 20);
			
			var lblOpenPdf: TextField = new TextField();
			lblOpenPdf.defaultTextFormat = myFormat;
			lblOpenPdf.textColor = Tema.lblColor;
			lblOpenPdf.text = "Abre pdf al generarlo";
			cbOpenPdfAfterGenerating.selected = Settings.ShowPathOnTimeline;
			SetElemento(lblOpenPdf, cbOpenPdfAfterGenerating, 50, 520, 20, 20);
			
			var lblOpenVideo: TextField = new TextField();
			lblOpenVideo.defaultTextFormat = myFormat;
			lblOpenVideo.textColor = Tema.lblColor;
			lblOpenVideo.text = "Abre Vídeo al generarlo";
			cbOpenVideoAfterGenerating.selected = Settings.ShowPathOnTimeline;
			SetElemento(lblOpenVideo, cbOpenVideoAfterGenerating, 50, 560, 20, 20);
		}
		
		private function SetElemento(lbl, obj, x, y, width, height) {
			Util.posiciona(lbl,x,y,200,24);
			Util.posiciona(obj,x + 200, y ,width,height);
			Util.setBackground(obj,p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			addChild(lbl);
			addChild(obj);
		}
		
		private function placeBaseImages(){
			var pdfImage: Image = new Image(Ficheros.IMG_SETTINGS_PDF,64,64);
			pdfImage.x = 720; pdfImage.y = 140;
			
			var flvImage: Image = new Image(Ficheros.IMG_SETTINGS_FLV,64,64);
			flvImage.x = 850; flvImage.y = 140;
			
			
			imgPingOk = new Image(Ficheros.IMG_SETTINGS_PING_OK,32,32);
			imgPingOk.x = 650; imgPingOk.y = 160;
			imgPingOk.visible = false;
			
			imgPingError = new Image(Ficheros.IMG_SETTINGS_PING_ERROR,32,32);
			imgPingError.x = 620; imgPingError.y = 220;
			imgPingError.visible = false;
			
			CreateCircularSprite();
			CreateZigzagSprite();
			
			this.addChild(pdfImage);
			this.addChild(flvImage);
			this.addChild(imgPingOk);
			this.addChild(imgPingError);
		}
		
		private function placeRibbonButtons():void{
			
			this.btnUpdate = new TextImageButton(Ficheros.IMG_IMPORT, "Update" );
			this.btnUpdate.x = 690; this.btnUpdate.y = 4;
			this.addChild(btnUpdate);
			
			this.btnPing = new TextImageButton(Ficheros.IMG_EXP_SERVER, "Ping" );
			this.btnPing.x = 770; this.btnPing.y = 4;
			this.addChild(btnPing);
			
			this.btnSave = new TextImageButton(Ficheros.IMG_GUARDAR, "Guardar" );
			this.btnSave.x = 860; this.btnSave.y = 4;
			this.btnSave.addEventListener(MouseEvent.CLICK, SaveSettings);
			this.addChild(btnSave);
			
			this.btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			this.btnBack.x = 940; this.btnBack.y = 4;
			this.btnBack.addEventListener(MouseEvent.CLICK, volverSettings);
			this.addChild(btnBack);
			
		}
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volverSettings(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		
		private function SaveSettings(event: MouseEvent): void {
			//	Set the values on Settings
			Settings.Bez_color = cpBezColor.selectedColor;
			Settings.Line_color = cpLineColor.selectedColor;
			Settings.Pdf = txtPdf.text;
			Settings.Point_color = cpPointColor.selectedColor;
			Settings.Server = txtServer.text;
			Settings.Tablet = cbTabletMode.selected;
			Settings.Video = txtVideo.text;
			
			Settings.OpenPdfAfterGenerating = cbOpenPdfAfterGenerating.selected;
			Settings.OpenVideoAfterGenerating = cbOpenVideoAfterGenerating.selected;
			Settings.ShowPathOnAnimation = cbShowPathOnAnimation.selected;
			Settings.ShowPathOnTimeline = cbShowPathOnTimeline.selected;
			Settings.ShowPointsOnAnimation = cbShowPointsOnAnimation.selected;

			try {
				p.bd.set_preferencias_from_Settings();
				Alert.show("Preferencias guardadas correctamente");
			}catch (err:Error)
			{
				Alert.show("Error guardando las preferencias en Base de datos");
			}
		}
		
		/*
		 *		Handlers
		 */
		
		function onKeyEvent(e: KeyboardEvent):void{
			
			var character:String = String.fromCharCode(e.charCode);
			if (e.keyCode == 83 && e.ctrlKey){
				SaveSettings(null);
			}
		}
		
		private function QualityChange(event:SliderEvent) {
			trace(slCalidad.value);
		}
		
		private function pdfName_Change(ev: Event): void{
			txtImagePdf.text = txtPdf.text + ".pdf";
			if(txtPdf.text == ""){
				//txtPdf.border = true;
				//txtPdf.borderColor = 0xFF0000;
			}else{
				//txtPdf.border = false;
			}
		}
		
		private function videoName_Change(ev: Event): void{
			txtImageFlv.text = txtVideo.text + ".flv";
			if(txtVideo.text == ""){
				//txtVideo.border = true;
				//txtVideo.borderColor = 0xFF0000;
			}else{
				//txtVideo.border = false;
			}
		}
		
		private function serverIp_Change(ev: Event): void{
			imgPingError.visible = false;
			imgPingOk.visible = false;
		}
		
		private function color_Change(ev: Event): void{
			//	Refresh Images
			trace("Repaint");
			circularSprite.CleanDisplay();
			this.removeChild(circularSprite);
			CreateCircularSprite();
			
			zigzagSprite.CleanDisplay();
			this.removeChild(zigzagSprite);
			CreateZigzagSprite();
		}
		
		private function CreateCircularSprite(): void{
			//	Trayectorias
			var tr: Trayectoria = new Trayectoria(new Point(0,0));
			tr.tipo = Acciones.CIRCULAR;
			tr.addPunto(new Point(700,300));
			tr.addPunto(new Point(750,350));
			tr.addPunto(new Point(800,340));
			circularSprite = new TrayectoriaSprite(this, null);
			circularSprite.x = 700; circularSprite.y = 300;
			circularSprite.SetPath(tr);
			circularSprite.DrawCompletePath();
			this.addChild(circularSprite);
		}
		
		private function CreateZigzagSprite(): void{
			//	Trayectorias
			var tr: Trayectoria = new Trayectoria(new Point(0,0));
			tr.tipo = Acciones.ZIGZAG;
			tr.addPunto(new Point(800,300));
			tr.addPunto(new Point(850,350));
			tr.addPunto(new Point(900,340));
			zigzagSprite = new TrayectoriaSprite(this, null);
			zigzagSprite.x = 700; zigzagSprite.y = 300;
			zigzagSprite.SetPath(tr);
			zigzagSprite.DrawCompletePath();
			this.addChild(zigzagSprite);
		}
		
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get BtnPing(): TextImageButton { return this.btnPing; }
		public function get BtnUpdate(): TextImageButton { return this.btnUpdate; }
		public function get ImgPingOk(): Image {return imgPingOk;}
		public function get ImgPingError(): Image {return imgPingError;}
	}
}