﻿package org.pizarra.escenas.View{	

	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import fl.controls.TextInput;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import fl.controls.ComboBox;
	import org.pizarra.escenas.View;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.Selector_Terreno;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.configuracion.Tema;
	import org.pizarra.graficos.TextImageButton;
	import org.pizarra.util.Ficheros;
	import org.pizarra.graficos.Separator;
	
	public class PreEditorView extends View{
		
		private var p: Pizarra;

		private var btnBack, btnCreate: TextImageButton;
		
		private var txtNombre: TextInput;
		private var txtInformacion: TextInput;
		
		private var combo_deportes:ComboBox = new ComboBox();
		private var combo_tipos:ComboBox = new ComboBox();
		private var txt_errores:TextField = new TextField();
		private var st: Selector_Terreno;
		private var l_campo : Loader = new Loader(); 	//	Imágen del campo seleccionado
		private var l_deporte : Loader = new Loader(); 
		
		public function PreEditorView(piz: Pizarra){
			
			super("Crear Ejercicio");
			//super.dibujaSpan(670, 80, 300, 350);	//	Panel derecho
			//super.dibujaSpan(50, 100, 570, 320);	//	Panel data
			this.p = piz;
			posicionaElementosEstaticos();			//	Labels y text Fields
			posicionaElementosDinamicos();			//	rellena combos
			posicionaBotones();						//	Botones
			cargaFondos();	
			cargaThumbPrimerDeporte();
			this.addChild(new Separator(5, 400, 650, 70));
			this.addChild(new Separator(1024, 5, 0, 470));
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function posicionaElementosEstaticos() {
			
			var myFormat:TextFormat = new TextFormat();
			myFormat.size = Tema.lblSize;
			
			var lblDeporte: TextField = new TextField();
			lblDeporte.defaultTextFormat = myFormat;
			lblDeporte.text = "Deporte: ";
			lblDeporte.textColor = Tema.lblColor; 
			Util.posiciona(lblDeporte,60,110,200,26);
			this.addChild(lblDeporte);
			
			var lblTipo: TextField = new TextField();
			lblTipo.defaultTextFormat = myFormat;
			lblTipo.text = "Tipo: ";
			lblTipo.textColor = Tema.lblColor; 
			Util.posiciona(lblTipo,60,150,200,26);
			this.addChild(lblTipo);
			
			var lblNombre: TextField = new TextField(); 
			lblNombre.defaultTextFormat = myFormat;
			lblNombre.text = "Nombre del Ejercicio";
			lblNombre.textColor = Tema.lblColor; 
			Util.posiciona(lblNombre,60,200,200,26);
			this.addChild(lblNombre);
			
			var lblInformacion: TextField = new TextField(); 
			lblInformacion.defaultTextFormat = myFormat;
			lblInformacion.text = "Información";
			Util.posiciona(lblInformacion, 60, 253, 200, 26);
			lblInformacion.textColor = Tema.lblColor;  
			this.addChild(lblInformacion);
			
			txtNombre = new TextInput();
			Util.posiciona(txtNombre,250,200,320,25);
			Util.setBackground(txtNombre,p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			this.addChild(txtNombre);

			txtInformacion = new TextInput();
			Util.posiciona(txtInformacion,250,253,320,126);
			Util.setBackground(txtInformacion,p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			this.addChild(txtInformacion);
			
			//	DEBUG
			txtNombre.text = "nombre del ejercicio";
			txtInformacion.text = "info del ejercicio";
		}
		
		private function posicionaElementosDinamicos(){
			//	Creo y posiciono el combobox de deportes
			for each (var dep in p.deportes){
				combo_deportes.addItem( {label:dep.nombre, Value: dep.id });
			}
			combo_deportes.width = 200;
			combo_deportes.move(250, 110);
			this.addChild(combo_deportes);
			
			//	Load deporte Thumb
			
			//	Creo y posiciono el combobox de deportes
			combo_tipos.addItem({label: "Ejercicio", Value:Constantes.EJERCICIO});
			combo_tipos.addItem({label: "Jugada", Value:Constantes.JUGADA});
			combo_tipos.addItem({label: "Disposición Táctica", Value: Constantes.DISPOSICION});
			combo_tipos.width = 200;
			combo_tipos.move(250, 150);
			this.addChild(combo_tipos);
			
			st = new Selector_Terreno(this);
			for each (var fondo in p.fondos[p.dep_select]){
				st.add(fondo.url_thumb).addEventListener(MouseEvent.CLICK, click_terreno);
			}
			carga_seleccion(p.terr_select);
		}
		
		private function posicionaBotones(){
		
			btnCreate = new TextImageButton(Ficheros.IMG_ADD, "Crear" );
			btnCreate.x = 860; btnCreate.y = 4;
			addChild(btnCreate);
			
			btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			btnBack.x = 940; btnBack.y = 4;
			addChild(btnBack);
		}
		
	
		private function cargaThumbPrimerDeporte() {
			if (this.contains(l_deporte)) {
				this.removeChild(l_deporte);
			}
			if(p.deportes.length > 0 ){
				var url: String = p.deportes[0].thumb;
				l_deporte = new Loader(); 
				l_deporte.contentLoaderInfo.addEventListener(Event.COMPLETE, imgDeporteLoaded);
				l_deporte.load(new URLRequest(url));	
				this.addChild(l_deporte);
			}
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
	
		public function cargaFondos(){
			if(this.contains(st.scroll)){
				this.removeChild(st.scroll);
			}
			st = new Selector_Terreno(this);
			for each (var fondo in p.deportes[p.dep_select].fondos){
				st.add(fondo.url_thumb).addEventListener(MouseEvent.CLICK, click_terreno);
			}
		}
		
		public function carga_seleccion(n: int){
			if (this.contains(l_campo)) {
				this.removeChild(l_campo);
			}
			if( p.deportes[p.dep_select].fondos[n] != null ){
				var url: String = p.deportes[p.dep_select].fondos[n].url;
				l_campo = new Loader(); 
				var urlReq:URLRequest = new URLRequest(url);
				l_campo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
				l_campo.load(urlReq);	this.addChild(l_campo);
			}
		}
		
		public function cargaThumbDeporte() {
			
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function click_terreno(event: Event) {
			p.terr_select = st.loaders.indexOf(event.target);
			carga_seleccion(p.terr_select);
		}
		
		private function imgLoaded(event:Event):void{
			Util.posiciona(l_campo,730,250,200,200);
		}
		private function imgDeporteLoaded(event:Event):void{
			Util.posiciona(l_deporte,760,80,150,150);
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		 public function get BtnCreate(): TextImageButton { return btnCreate; }
		 public function get BtnBack(): TextImageButton { return btnBack; }
		 public function get deportes(): ComboBox { return combo_deportes; }
		 public function get tipos(): ComboBox { return combo_tipos; }
		 public function get nombre(): String { return txtNombre.text; }
		 public function get informacion(): String { return txtInformacion.text; }
		 public function get tipo(): String { return combo_tipos.selectedItem.Value; }
	}
}