﻿package org.pizarra.escenas.View{	

	import fl.containers.ScrollPane;
	import flash.display.MovieClip;
	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.*;
	import flash.net.URLRequest;
	import fl.controls.Label;
	import fl.controls.TextInput;
	import flash.text.TextField;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.util.Eventos;
	import org.pizarra.graficos.Alert;
	import org.pizarra.configuracion.Tema;
	import org.pizarra.video.Foto;
	import org.pizarra.util.*;
	import org.pizarra.Jugador;
	import fl.controls.ScrollPolicy;
	import org.pizarra.escenas.Controller.PlayersController;
	
	public class PlayersView extends Sprite{
		
		private const N_JUGADORES_FILA: uint = 3;
		private const PADDING: uint = 20;
		private const ANCHO_THUMB: uint = 120;
		private const ALTO_THUMB: uint = 120;
		private const ANCHO_FOTO: uint = 250;
		private const ALTO_FOTO: uint = 250;
		
		private var p: Pizarra;
		
		private var lblNombre: TextField;
		private var txtNombre: TextInput;
		private var btnVolver: CoolButton = new CoolButton();
		private var btnGuardar: CoolButton = new CoolButton();
		private var btnNuevo: CoolButton = new CoolButton();
		private var foto_mc: Sprite = new Sprite();
		private var disparador: MovieClip = new MovieClip();
		private var grande: MovieClip = new MovieClip();
		private var logic: PlayersController;
		private var f: Foto;
		private var panelJ: ScrollPane = new ScrollPane();
		private var loaders: Array = new Array();
		private var etiquetas: Array = new Array();
		private var closers: Array = new Array();
		private var fondo: Sprite = new Sprite();
		private var id: String;
		private var secuencia: int;
		private var fotoGrande: Loader = new Loader();
		
		public function PlayersView(piz: Pizarra): void{
			
			logic = new PlayersController(piz);
			this.p = piz;
			Alert.init(p.stage);
			this.dibujaFondo();
			posicionaElementos();
			posicionaBotones();
			posicionaJugadores();
			this.addChild(new Titulo("Libreta de Jugadores", p.pref));
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//		
		private function dibujaFondo(){
			this.graphics.beginFill(p.pref.bgColor);
            this.graphics.drawRect(0, 0, Constantes.APP_WIDTH, Constantes.APP_HEIGHT);
            this.graphics.endFill();
		}
		
		private function posicionaElementos(){
			
			//	Nombre del video
			lblNombre = new TextField();
			lblNombre.text = "Nombre: ";
			txtNombre = new TextInput();
			lblNombre.defaultTextFormat = Tema.formatoLabel;
			Util.posiciona(lblNombre,93,140,143,24);
			Util.posiciona(txtNombre,240,140,400,25);
			
			this.addChild(lblNombre);
			this.addChild(txtNombre);
		}
		private function dibujaFondoPanel() {
			fondo = new Sprite();
			fondo.graphics.beginFill(Tema.colorPanelJugadores);
			var altura = Math.floor(p.jugadores.length / N_JUGADORES_FILA) * (ALTO_THUMB + PADDING) + PADDING;
			if (altura < 500){ altura = 500;}
			fondo.graphics.drawRect(0, 0, 450, altura);
            fondo.graphics.endFill();
			panelJ.source = fondo;
		}
		private function posicionaJugadores() {
			
			var i: int = 0;
			//	Dibuja ScrollPanel
			panelJ = new ScrollPane();
			panelJ.move(50, 70);
			panelJ.setSize(450, 500);
			panelJ.verticalScrollPolicy = ScrollPolicy.ON;
			panelJ.horizontalScrollPolicy= ScrollPolicy.OFF;
			addChild(panelJ);
			dibujaFondoPanel();
			loaders = new Array();
			closers = new Array();
			etiquetas = new Array();
			//	Dibuja Jugadores
			for each(var j:Jugador in p.hJugadores ) {
				cargaImagenJugador(j, i);
				cargaEtiquetaJugador(j, i);
				cargaDeleter(j, i);
				i++;
			}
		}
		
		private function cargaImagenJugador(j: Jugador, i: int) {
			loaders[i] = new Loader();
			loaders[i].contentLoaderInfo.addEventListener(Event.COMPLETE, jugadorLoaded);
			loaders[i].load(new URLRequest(j.url));
			loaders[i].x = (i % N_JUGADORES_FILA) * (ANCHO_THUMB + PADDING) + PADDING;
			loaders[i].y = Math.floor(i / N_JUGADORES_FILA) * (ALTO_THUMB + PADDING) + PADDING
			fondo.addChild(loaders[i]);
		}
		
		private function cargaEtiquetaJugador(j: Jugador, i: int) {
			etiquetas[i] = new TextField();
			etiquetas[i].text = i;
			etiquetas[i].height = 20;
			etiquetas[i].width = ANCHO_THUMB - 16 ;
			etiquetas[i].background = true;
			etiquetas[i].backgroundColor = 0xCCCCCC;
			etiquetas[i].x = (i % N_JUGADORES_FILA) * (ANCHO_THUMB + PADDING) + PADDING + 8;
			etiquetas[i].y = (Math.floor(i / N_JUGADORES_FILA) + 1 ) * (ALTO_THUMB + PADDING) - 10;
			fondo.addChild(etiquetas[i]);
		}
		
		private function cargaDeleter(j: Jugador, i: int) {
			closers[i] = new Loader();
			closers[i].addEventListener(MouseEvent.CLICK, eliminaJugador);
			closers[i].load(new URLRequest(Ficheros.IMG_CERRAR_TOMA));
			closers[i].x = (i % N_JUGADORES_FILA) * (ANCHO_THUMB + PADDING) + PADDING;
			closers[i].y = Math.floor(i / N_JUGADORES_FILA) * (ALTO_THUMB + PADDING) + PADDING
			fondo.addChild(closers[i]);
		}
		
		
		private function posicionaBotones(){
			
			//btnVolver = new CoolButton();
			btnVolver.text = "Volver";
			this.addChild(btnVolver);	
			btnVolver.x = 900;	btnVolver.y = 550;
			
			//btnGuardar = new CoolButton();
			btnGuardar.text = "Guardar";
			this.addChild(btnGuardar);	
			btnGuardar.x = 700;	btnGuardar.y = 550;
			
			//	Nuevo
			btnNuevo.text = "Nuevo";
			addChild(btnNuevo);
			btnNuevo.x = 900;	btnNuevo.y = 500;
			
			btnNuevo.addEventListener(MouseEvent.CLICK,nuevoJugador);
			btnVolver.addEventListener(MouseEvent.CLICK, volverSettings);
			btnGuardar.addEventListener(MouseEvent.CLICK, guardarSettings);
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volverSettings(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		private function guardarSettings(event: Event){
			Alert.show("Datos guardados correctamente.", {background:"blur"});
		}
		
		private function nuevoJugador(e: Event){

			foto_mc = new Sprite();
			foto_mc.graphics.lineStyle( 2 , 0xFF00FF , 1 );
			foto_mc.graphics.beginFill(Tema.colorCamara,1);
			foto_mc.graphics.drawRect(0, 0, 400, 400);
			foto_mc.x = 550; foto_mc.y=70;
			this.addChild(foto_mc);
			
			//cierre
			var l: Loader = new Loader();
			var c: Sprite = new Sprite();
			c.x = 390, c.y = -10;
			l.load(new URLRequest(Ficheros.IMG_CERRAR_TOMA));
			c.addChild(l);
			foto_mc.addChild(c);
			c.addEventListener(MouseEvent.CLICK, cierra_foto);
			
			//fotografía
			f = new Foto(foto_mc,p.jugadores);
			
			//disparador
			disparador = new MovieClip();
			disparador.x = 150, disparador.y = 290; l = new Loader();
			l.load(new URLRequest(Ficheros.IMG_CAMARA));
			disparador.addChild(l);
			foto_mc.addChild(disparador);
			disparador.addEventListener(MouseEvent.CLICK, dispara);
		}
		
		private function cierra_foto(e: Event){
			
			this.removeChild(foto_mc);
			//tomando_foto = false;
			f.para_reconocimiento();
		}
		
		private function eliminaJugador(e: Event) {
			secuencia = closers.indexOf(e.target);
			id = p.jugadores[secuencia].id;
			Alert.show("¿Está seguro que desea eliminar el jugador?", {buttons:["Sí", "No"], callback:handleResponse});
		}
		
		function handleResponse(response:String):void {
			if (response == "Sí") {
				//	Elimina
				trace(secuencia + ") -> " + id)
				var i: uint = 0;
				for each(var j: Jugador in p.jugadores) {
					trace("i) " + i + " j: " + j.id);
					i++;
				}
				p.jugadores.splice(secuencia, 1);
				delete p.hJugadores[id];
				
				trace("quedan: ");
				i = 0;
				for each(var k: Jugador in p.jugadores) {
					trace("i) " + i + " j: " + k.id);
					i++;
				}
				
				//	Actualiza la pantalla
				removeChild(panelJ);
				posicionaJugadores();
				Alert.show("Jugador Eliminado", {background:"blur"});
			}
		}
		
		private function jugadorLoaded(event:Event):void{
			event.target.loader.width = ANCHO_THUMB;
			event.target.loader.height = ALTO_THUMB;
		}
		
		private function dispara(e: Event) {
			var id: String = Util.nuevoId()
			var j: Jugador = new Jugador( id , id ,txtNombre.text);
			f.toma_foto(grande, j.id);
			p.bd.nuevo_jugador(j.id,j.nombre,j.id);
			p.jugadores.push(j); 
			p.hJugadores[j.id] = j;
			cierra_foto(null);		//	Cierra la camara
			cargaFotoGrande(j);		//	Carga la nueva foto
			removeChild(panelJ);
			posicionaJugadores();
		}
		
		private function cargaFotoGrande(j: Jugador) {
			
			fotoGrande = new Loader();
			fotoGrande.contentLoaderInfo.addEventListener(Event.COMPLETE, fotoLoaded);
			fotoGrande.load(new URLRequest(j.url));
			addChild(fotoGrande);
			fotoGrande.x = 600;
			fotoGrande.y = 100;
		}
		private function fotoLoaded(event:Event):void {
			event.target.loader.width = ANCHO_FOTO;
			event.target.loader.height = ALTO_FOTO;
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get volver(): CoolButton{ return btnVolver; }
		public function get guardar(): CoolButton{ return btnGuardar; } 
		public function set input_video(texto: String): void{ txtNombre.text = texto; }
	}
}