﻿package org.pizarra.escenas.View{	

	import fl.controls.listClasses.ImageCell;
	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	import flash.display.Bitmap;
	import org.pizarra.configuracion.Tema;
	import org.pizarra.escenas.View;
	import org.pizarra.graficos.*;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.*;
	import org.pizarra.graficos.Titulo;
	import org.pizarra.helpers.SaveToBitmap;
	import flash.events.MouseEvent;
	import org.pizarra.Controls.SnapShotView;
	
	import fl.transitions.*;
	import fl.transitions.easing.*;
	import org.pizarra.Controls.ImageAnimator;
	
	public class MenuView extends View{
		
		private var SPAN_X: uint = 500;
		private var SPAN_Y: uint = 100;
		
		private var p: Pizarra;
		private var btn_salir: CoolButton;
		private var btn_ejs: CoolButton;
		private var btn_nuevo: CoolButton;
		private var btn_importar: CoolButton;
		private var btn_exportar: CoolButton;
		private var btn_jugadores: CoolButton;
		private var btn_free: CoolButton;
		
		private var sprSettings: Sprite = new Sprite();
		private var sprPlayer: Sprite = new Sprite();
		private var sprOpen: Sprite = new Sprite();
		private var settings_loader: Loader;
		private var player_loader: Loader;
		private var open_loader: Loader;
		private var BtnSalir, BtnTema, BtnHelp, BtnSettings, BtnPlayer, BtnOpen: TextImageButton;
		
		private var helpSpan: SnapShotView = new SnapShotView("Help");
		private var ejerciciosSpan: SnapShotView = new SnapShotView("Ejercicios");
		private var temaSpan: SnapShotView = new SnapShotView("Tema");
		private var nuevoSpan: SnapShotView = new SnapShotView("Nuevo");
		
		public function MenuView(piz: Pizarra): void{
			super("Menú");
			this.p = piz;
			posicionaBotones();
			cargaImagenesBotones();
			
			var animator: ImageAnimator = new ImageAnimator();
			animator.x = 750; animator.y = 100;
			this.addChild(animator);

			createOptionSnapshots();
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function posicionaBotones(){

			btn_ejs = new CoolButton(284,60);
			btn_ejs.text = "Mis Ejercicios";
			this.addChild(btn_ejs);
			btn_ejs.x = 52;	btn_ejs.y = 90;
			btn_ejs.addEventListener(MouseEvent.MOUSE_OVER, option_MouseOver);
		
			btn_nuevo = new CoolButton(284,60);
			btn_nuevo.text = "Nuevo";
			this.addChild(btn_nuevo);
			btn_nuevo.x = 52;	btn_nuevo.y = 180;
			btn_nuevo.addEventListener(MouseEvent.MOUSE_OVER, option_MouseOver);

			btn_importar = new CoolButton(284,60);
			btn_importar.text = "Importar";
			this.addChild(btn_importar);	
			btn_importar.x = 52;	btn_importar.y = 270;

			btn_exportar = new CoolButton(284,60);
			btn_exportar.text = "Exportar";
			this.addChild(btn_exportar);	
			btn_exportar.x = 52;	btn_exportar.y = 360;
			
			btn_jugadores = new CoolButton(284,60);
			btn_jugadores.text = "Jugadores";
			this.addChild(btn_jugadores);	
			btn_jugadores.x = 52;	btn_jugadores.y = 440;
			
			btn_free = new CoolButton(284,60);
			btn_free.text = "Free";
			//this.addChild(btn_free);	
			btn_free.x = 52;	btn_free.y = 540;
		}
		
		private function cargaImagenesBotones(){
			
			BtnHelp = new TextImageButton(Ficheros.IMG_HELP, "Ayuda" );
			BtnHelp.x = 470;	BtnHelp.y = 520;
			BtnHelp.addEventListener(MouseEvent.CLICK, BtnHelp_Click);
			BtnHelp.addEventListener(MouseEvent.MOUSE_OVER, option_MouseOver);
			this.addChild(BtnHelp);
			
			BtnTema = new TextImageButton(Ficheros.IMG_THEME, "Tema" );
			BtnTema.x = 560;	BtnTema.y = 520;
			BtnTema.addEventListener(MouseEvent.MOUSE_OVER, option_MouseOver);
			this.addChild(BtnTema);
			
			BtnPlayer = new TextImageButton(Constantes.IMG_MENU_PLAYER, "Reproductor" );
			BtnPlayer.x = 650;	BtnPlayer.y = 520;
			this.addChild(BtnPlayer);
			
			BtnOpen = new TextImageButton(Constantes.IMG_MENU_OPEN, "Abrir" );
			BtnOpen.x = 740;	BtnOpen.y = 520;
			this.addChild(BtnOpen);
			
			BtnSettings = new TextImageButton(Constantes.IMG_MENU_SETTINGS, "Preferencias" );
			BtnSettings.x = 830;	BtnSettings.y = 520;
			this.addChild(BtnSettings);
			
			BtnSalir = new TextImageButton(Ficheros.IMG_SALIR, "Salir" );
			BtnSalir.x = 920;	BtnSalir.y = 520;
			this.addChild(BtnSalir);
			
		}
		
		private function createOptionSnapshots(){
			helpSpan.x = this.SPAN_X;
			helpSpan.y = this.SPAN_Y;
			//this.addChild(helpSpan);
			
			ejerciciosSpan.x = this.SPAN_X;
			ejerciciosSpan.y = this.SPAN_Y;
			//this.addChild(ejerciciosSpan);
			
			temaSpan.x = this.SPAN_X;
			temaSpan.y = this.SPAN_Y;
			//this.addChild(temaSpan);
			
			nuevoSpan.x = this.SPAN_X;
			nuevoSpan.y = this.SPAN_Y;
			//this.addChild(nuevoSpan);
		}
		
		private function hideAllSnapShots(): void{
			/*new Tween(helpSpan,"alpha",None.easeNone,1,0,0.2,true); 
			new Tween(ejerciciosSpan,"alpha",None.easeNone,1,0,0.2,true);
			new Tween(temaSpan,"alpha",None.easeNone,1,0,0.2,true);*/
			helpSpan.alpha = 0;
			ejerciciosSpan.alpha = 0;
			temaSpan.alpha = 0;
			nuevoSpan.alpha = 0;
		}
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function imgLoaded(event:Event):void{
			switch(event.target.loader){
				case settings_loader:
					Util.posiciona(settings_loader,785,490,80,80);
					break;
				case player_loader:
					Util.posiciona(player_loader,557,490,80,80);
					break;
				case open_loader:
					Util.posiciona(open_loader,676,490,80,80);
					break;
				default:	trace("error");
			}
		}
		
		private function option_MouseOver(ev: MouseEvent): void{
			hideAllSnapShots();
			switch(ev.currentTarget){
				case btn_ejs:
					new Tween(ejerciciosSpan,"alpha",None.easeNone,0,1,0.2,true);
					break;
				case btn_nuevo:
					new Tween(nuevoSpan,"alpha",None.easeNone,0,1,0.2,true); 
					break;
				case BtnHelp:
					new Tween(helpSpan,"alpha",None.easeNone,0,1,0.2,true); 
					break;
				case BtnTema:
					new Tween(temaSpan,"alpha",None.easeNone,0,1,0.2,true); 
					break;
				default:
					trace("unknown");
			}
			
		}
		
		private function BtnHelp_Click(ev: MouseEvent): void {
			
			try{
				var url = "http://pfc.webpots.org/tutorials/index.html"; 
				var urlReq = new URLRequest(url); 
				navigateToURL(urlReq);
			}catch(err: Error){
				Util.subTrace(err.getStackTrace());
				Alert.show("Error Opening the help page");
			}
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get salir(): TextImageButton{ return BtnSalir; }
		public function get ejercicios(): CoolButton{ return btn_ejs; }
		public function get nuevo(): CoolButton{ return btn_nuevo; }
		public function get importar(): CoolButton{ return btn_importar; }
		public function get exportar(): CoolButton{ return btn_exportar; }
		public function get jugadores(): CoolButton{ return btn_jugadores; }
		public function get settings(): TextImageButton{ return this.BtnSettings; }
		public function get player(): TextImageButton{ return this.BtnPlayer; }
		public function get abrir(): TextImageButton { return this.BtnOpen; }
		public function get free(): CoolButton{ return btn_free; }
		public function get tema(): TextImageButton{ return BtnTema; }
	}
}