﻿package org.pizarra.escenas.View{	

	import fl.controls.TextArea;
	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.FileFilter;
	import flash.net.URLRequest;
	import fl.controls.Label;
	import fl.controls.TextInput;
	import flash.text.TextField;
	import org.pizarra.escenas.View;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.Titulo;		
	import org.pizarra.util.Eventos;
	import org.pizarra.configuracion.*;
	import flash.events.MouseEvent;	
	import flash.filesystem.*;
	import flash.display.GradientType;
	import flash.geom.Matrix;
	import org.pizarra.escenas.Controller.ImportController;
	import org.pizarra.graficos.TextImageButton;
	import org.pizarra.util.Ficheros;
	
	public class ImportView extends View{
		
		private var p: Pizarra;
		private var lblNombreVideo: Label;
		private var txtNombreVideo: TextInput;
		private var btnVolver: CoolButton;
		private var btnSeleccionar: CoolButton;
		private var btnProceder: CoolButton;
		
		private var btnBack, btnProceed, btnSelect: TextImageButton;
		
		private var logic: ImportController;
		private var file: File = File.desktopDirectory;
		private var filtro:FileFilter = new FileFilter("Data Pizarra", "*.pizd;*.piz;*.zip;*.db");
		private var panel: Sprite = new Sprite();
		
		private var tipo: int;
		
		//	Panel File
		private var pnFile: Sprite;
		private var imgNoSeleccionado: Loader = new Loader();
		private var imgDeporte: Loader = new Loader();
		private var imgEjercicio: Loader = new Loader();
		private var imgBaseDatos: Loader = new Loader();
		private var txtNombre: TextField = new TextField();
		private var txtFecha: TextField = new TextField();
		private var txtTamano: TextField = new TextField();
		
		//	Panel Info
		private var pnInfo: Sprite;
		private var txtInfo: TextArea = new TextArea();
		private var th: Loader = new Loader();
		
		public function ImportView(piz: Pizarra): void{
			super("Importar");
			this.p = piz;
			posicionaElementos();
			cargaImagenesTiposFicheros();
			posicionaTextos();
			posicionaBotones();
			logic = new ImportController(piz, pnInfo);
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		
		private function cargaImagenesTiposFicheros() {
			//	NoSeleccionado
			imgNoSeleccionado.load(new URLRequest(TemaImportador.IMG_NO_SELECCIONADO));
			imgNoSeleccionado.x = 10;
			imgNoSeleccionado.y = 10;
			pnFile.addChild(imgNoSeleccionado);
			//	File not selected default
			imgDeporte.load(new URLRequest(TemaImportador.IMG_DEPORTE));
			imgEjercicio.load(new URLRequest(TemaImportador.IMG_EXERCISE))
			imgBaseDatos.load(new URLRequest(TemaImportador.IMG_DB))
			
		}
		
		private function posicionaTextos() {
			//	Nombre
			txtNombre.text = "Fichero no seleccionado";
			txtNombre.setTextFormat(Tema.formatoLabel);
			Util.posiciona(txtNombre, 10, 200, 250, 30);
			pnFile.addChild(txtNombre);
			
			//	Fecha
			txtFecha.text = "Fecha";
			txtFecha.setTextFormat(Tema.formatoLabel);
			Util.posiciona(txtFecha, 10, 250, 250, 30);
			pnFile.addChild(txtFecha);
			
			//	Tamaño
			txtTamano.text = "0 Bytes";
			txtTamano.setTextFormat(Tema.formatoLabel);
			Util.posiciona(txtTamano, 10, 300, 250, 30);
			pnFile.addChild(txtTamano);
			
			//	TextArea de resultados
			txtInfo.text = "Ningún fichero cargado";
			txtInfo.editable = false;
			Util.posiciona(txtInfo, 15, 15, 500, 340);
			pnInfo.addChild(txtInfo);
		}
		
		private function posicionaElementos(){
			//	Panel Info
			
			super.dibujaSpan(	TemaImportador.PN_INFO_X, TemaImportador.PN_INFO_Y,
								TemaImportador.PN_INFO_W, TemaImportador.PN_INFO_H);
			pnInfo = new Sprite();
			pnInfo.x = TemaImportador.PN_INFO_X;
			pnInfo.y = TemaImportador.PN_INFO_Y;
			this.addChild(pnInfo);
			/*pnInfo.graphics.beginFill(TemaImportador.PN_INFO_COLOR);
			pnInfo.graphics.drawRoundRect(0, 
										0,
										TemaImportador.PN_INFO_W,
										TemaImportador.PN_INFO_H,
										20,
										20);
			pnInfo.graphics.endFill();
			*/
			//
			//	Panel Fichero
			pnFile = new Sprite();
			pnFile.graphics.beginFill(TemaImportador.PN_FILE_COLOR);
			pnFile.graphics.drawRoundRect(0, 
										0,
										TemaImportador.PN_FILE_W,
										TemaImportador.PN_FILE_H,
										20,
										20);
			pnFile.graphics.endFill();
			pnFile.x = TemaImportador.PN_FILE_X;
			pnFile.y = TemaImportador.PN_FILE_Y;
			this.addChild(pnFile);
		}
		
		private function posicionaBotones(){
			
			btnVolver = new CoolButton();
			btnVolver.text = "Volver";
			this.addChild(btnVolver);	
			btnVolver.x = 880;	btnVolver.y = 520;	
			btnVolver.addEventListener(MouseEvent.CLICK, volver);
			
			btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			btnBack.x = 940; btnBack.y = 4;
			btnBack.addEventListener(MouseEvent.CLICK, volver);
			addChild(btnBack);
			
			btnSeleccionar = new CoolButton();
			btnSeleccionar.text = "Examinar";
			this.addChild(btnSeleccionar);	
			btnSeleccionar.x = 80;	btnSeleccionar.y = 100;
			btnSeleccionar.addEventListener(MouseEvent.CLICK, selecciona);
			
			btnSelect = new TextImageButton(Ficheros.IMG_SELECT_DEFAULT, "Selecciona" );
			btnSelect.x = 780; btnSelect.y = 4;
			btnSelect.addEventListener(MouseEvent.CLICK, selecciona);
			addChild(btnSelect);
			
			btnProceder = new CoolButton();
			btnProceder.text = "Proceder";
			this.addChild(btnProceder);
			btnProceder.x = 200;	btnProceder.y = 100;
			btnProceder.addEventListener(MouseEvent.CLICK, procede);
			addChild(btnProceder);
			
			btnProceed = new TextImageButton(Ficheros.IMG_SALIR, "Proceder" );
			btnProceed.x = 860; btnProceed.y = 4;
			btnProceed.addEventListener(MouseEvent.CLICK, procede);
			addChild(btnProceed);
		}
		
		private function eliminaImagenTipo() {
			if (pnFile.contains(imgNoSeleccionado)) {
				pnFile.removeChild(imgNoSeleccionado);
			}
			if (pnFile.contains(imgBaseDatos)) {
				pnFile.removeChild(imgBaseDatos);
			}
			if (pnFile.contains(imgDeporte)) {
				pnFile.removeChild(imgDeporte);
			}
			if (pnFile.contains(imgEjercicio)) {
				pnFile.removeChild(imgEjercicio);
			}
		}
		
		private function cargadoDeporte() {
			//	Actualiza el texto
			txtInfo.text  = "\n\n\n\n\n\n\n\n";
			txtInfo.text += "------------------------------------------------------------------------------------------------------------------\n";
			txtInfo.text += "   ID\n";
			txtInfo.text += "------------------------------------------------------------------------------------------------------------------\n";
			txtInfo.text += "   " + logic.idDeporte + "\n";
			txtInfo.text += "------------------------------------------------------------------------------------------------------------------\n";
			txtInfo.text += "   NOMBRE\n" 
			txtInfo.text += "------------------------------------------------------------------------------------------------------------------\n";
			txtInfo.text += "   " + logic.nombreDeporte + "\n";
			txtInfo.text += "------------------------------------------------------------------------------------------------------------------\n";
			txtInfo.text += "   ELEMENTOS ASOCIADOS\n" 
			txtInfo.text += "------------------------------------------------------------------------------------------------------------------\n";
			txtInfo.text += "   " +  logic.elementosDeporte + "\n";
			//	Carga la imágen
			th.contentLoaderInfo.addEventListener(Event.COMPLETE, cargadoThumb);
			th.load(new URLRequest(logic.thumbDeporte));
		}
		
		private function cargadaBD() {
				
		}
		
		private function cargadoEjercicio() {
			
			
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volver(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		
		private function selecciona(event: Event){
			file.browseForOpen("Importar", [filtro]);
			file.addEventListener(Event.SELECT, fichero_sel);
		}
		
		//	Procede a la importación
		private function procede(event: Event){
			logic.procede(file.nativePath);
		}
		
		//	Se ha seleccionado un fichero
		function fichero_sel(e: Event){
			
			txtNombre.text = file.nativePath;
			txtFecha.text = file.modificationDate.toString();
			txtTamano.text = file.size + " Bytes";
			logic.addEventListener(Eventos.FINISHED_LOAD,cargadoFichero);
			tipo = logic.importaFichero(file.nativePath);
			//	Actuializa imagen del tipo de fichero
			eliminaImagenTipo();
			switch(tipo){	//tipo?
				case Constantes.IMP_EJERCICIO:	
							imgEjercicio.x = TemaImportador.IMG_TIPO_X;
							imgEjercicio.y = TemaImportador.IMG_TIPO_Y;
							pnFile.addChild(imgEjercicio);
							break;
				case Constantes.IMP_BD:	
							imgBaseDatos.x = TemaImportador.IMG_TIPO_X;
							imgBaseDatos.y = TemaImportador.IMG_TIPO_Y;
							pnFile.addChild(imgBaseDatos);
							break;
				case Constantes.IMP_DEPORTE: 
							imgDeporte.x = TemaImportador.IMG_TIPO_X;
							imgDeporte.y = TemaImportador.IMG_TIPO_Y;
							pnFile.addChild(imgDeporte);
							break;
				default:	imgNoSeleccionado.x = TemaImportador.IMG_TIPO_X;
							imgNoSeleccionado.y = TemaImportador.IMG_TIPO_Y;
							pnFile.addChild(imgNoSeleccionado);
			}
		}
		
		private function cargadoFichero(e: Event) {
			
			switch(tipo){	//tipo?
				case Constantes.IMP_EJERCICIO:	
							cargadoEjercicio();
							break;
				case Constantes.IMP_BD:	
							cargadaBD();
				case Constantes.IMP_DEPORTE: 
							cargadoDeporte();
							break;
			}
		}
		
		private function cargadoThumb(e: Event) {
			th.width = 100;
			th.height = 100;
			th.x = 200;
			th.y = 20;
			pnInfo.addChild(th);
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		//public function get volver(): CoolButton { return btnVolver; }
		//public function get seleccionar(): CoolButton { return btnSeleccionar; }
		//public function get proceder(): CoolButton { return btnProceder; }

	}
}