﻿package org.pizarra.escenas.View{	

	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLRequest;
	import fl.controls.*;
	import org.pizarra.configuracion.Tema;
	import org.pizarra.escenas.View;
	import org.pizarra.graficos.ImageButton;
	import org.pizarra.graficos.Separator;
	import org.pizarra.graficos.TextImageButton;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.Titulo;
	import fl.controls.DataGrid;
	import org.pizarra.graficos.*;
	import org.pizarra.BLL.*;
	import fl.controls.ProgressBar;
    import fl.controls.ProgressBarMode;
	import org.pizarra.util.Ficheros;
	import flash.text.*;
	import org.pizarra.Entity.EjercicioBE;
	import flash.events.MouseEvent;
	import flash.display.MovieClip;
	import org.pizarra.Animation.ExerciseAnimation;
	import org.pizarra.configuracion.Settings;
	import flash.filesystem.FileStream;
	import flash.filesystem.FileMode;
	import flash.filesystem.File;
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	import org.pizarra.Data.Exportador_PDF;
	import flash.display.BitmapData;
	import org.pizarra.video.SimpleFlvWriter;
	
	public class ExportView extends View{
		
		private var p: Pizarra;
		private var pnProgreso: Sprite;
		private var pb:ProgressBar;
		
		//	New Buttons
		private var txtBuscar: TextInput;
		private var BtnPdf, BtnVideo, BtnPiz, BtnServer, BtnDB, btnBack: TextImageButton
		
		private var QRImage, ThumbImage: Image;
		
		//=========================================================
		private var lblInfo: TextField = new TextField()
		,lblDeporte: TextField = new TextField()
		,lblFechaCreacion: TextField = new TextField()
		,lblBuscar: TextField = new TextField();
		
		private var txtDeporte: TextInput = new TextInput()
		,txtFechaCreacion: TextInput = new TextInput();
		
		private var txtInfo: TextArea = new TextArea();
		//=========================================================
		
		public var se: Selector_Ejercicios;
		
		//=========================================================
		private var preloadedImages: Array = new Array()
					, progressPanel: MovieClip = new MovieClip()
					, pdfProgressPanel: MovieClip = new MovieClip()
					, cbGenerateCover: CheckBox = new CheckBox()
					, cbGenerateIndex: CheckBox = new CheckBox()
					, txtPercent: Label = new Label()
					, ex :ExerciseAnimation
					, ej: EjercicioBE
					, miEj: EjercicioBE
					, pdf: Exportador_PDF;
		
		private var myWriter:SimpleFlvWriter = SimpleFlvWriter.getInstance();
	
		public function ExportView(piz: Pizarra): void {
			
			super("Exportar");
			p = piz;
			
			posicionaElementos();
			posicionaBotones();
			createPdfSelectionInterface();
			createVideoInterface();
			preloadedImages.push(new Image(Ficheros.IMG_ICON,128,128));
			addChild(new Separator(5, 540, 800, 70));	//	Right panel
			
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function posicionaElementos(){
			se = new Selector_Ejercicios();	
			se.DataSource = EjerciciosBL.GetExercisesForGrid();
			se.DataBind();
			se.x = 30;
			se.y = 100;
			addChild(se);
			
			lblBuscar.text = "Buscar: ";
			var sty: StyleSheet = new StyleSheet();
			sty.parseCSS("font-size: 20px; color: white; font-family: \"Lucida Sans Unicode\",\"Lucida Grande\",Sans-Serif;");
			lblBuscar.textColor = Tema.colorTitulo; 
			lblBuscar.styleSheet = sty;
			Util.posiciona(lblBuscar, 640, 30, 60, 25);
			this.addChild(lblBuscar);
			txtBuscar = new TextInput();
			Util.posiciona(txtBuscar, 720, 30, 200, 25);
			Util.setBackground(txtBuscar, p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			this.addChild(txtBuscar);
			
			//=========================================================
			lblInfo.text = "Info";
			SetElemento(lblInfo, txtInfo, 93, 440, 400, 25);
			
			lblDeporte.text = "Deporte";
			SetElemento(lblDeporte, txtDeporte, 93, 480, 400, 25);
			
			lblFechaCreacion.text = "Fecha de Creación";
			SetElemento(lblFechaCreacion, txtFechaCreacion, 93, 520, 400, 25);
			//=========================================================
			
			
		}
		
		private function SetElemento(lbl, obj, x, y, width, height) {
			Util.posiciona(lbl,x,y,140,24);
			Util.posiciona(obj,x + 150, y ,width,height);
			Util.setBackground(obj, p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			var sty: StyleSheet = new StyleSheet();
			sty.parseCSS("color: white; font-family: \"Lucida Sans Unicode\",\"Lucida Grande\",Sans-Serif;");
			lbl.styleSheet = sty;
			lbl.textColor = Tema.colorTitulo; 
			addChild(lbl);
			addChild(obj);
		}
		
		private function posicionaBotones(){
		
			// Nuevos botones
			BtnPdf = new TextImageButton(Ficheros.IMG_EXP_PDF, "Pdf" );
			BtnPdf.x = 360 - 130; BtnPdf.y = 4;
			addChild(BtnPdf);
			
			BtnVideo = new TextImageButton(Ficheros.IMG_EXP_VIDEO, "Vídeo" );
			BtnVideo.x = 440 - 130; BtnVideo.y = 4;
			addChild(BtnVideo);

			BtnPiz = new TextImageButton(Ficheros.IMG_EXP_PIZ, "Pizarra" );
			BtnPiz.x = 520 - 130; BtnPiz.y = 4;
			addChild(BtnPiz);
			
			BtnServer = new TextImageButton(Ficheros.IMG_EXP_SERVER, "Server" );
			BtnServer.x = 600 - 130; BtnServer.y = 4;
			addChild(BtnServer);
			
			BtnDB = new TextImageButton(Ficheros.IMG_EXP_DB, "DataBase" );
			BtnDB.x = 680 - 130; BtnDB.y = 4;
			addChild(BtnDB);
			
			btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			btnBack.x = 940; btnBack.y = 4;
			addChild(btnBack);

		}
		
		public function LoadQRImage(id: String) {
			QRImage = new Image("http://qrcode.kaywa.com/img.php?s=8&d=http%3A%2F%2Fpfc.webpots.org?id=" + id , 200.0, 200);
			QRImage.x = 812;
			QRImage.y = 100;
			addChild(QRImage);
		}
		
		public function LoadThumbImage(url: String) {
			
			ThumbImage = new Image(url, 200.0, 100);
			ThumbImage.x = 812;
			ThumbImage.y = 310;
			addChild(ThumbImage);
		}
		
		private function createPdfSelectionInterface(): void{
			//	Show progress
			pdfProgressPanel.graphics.beginFill(Tema.backgroundA, 1);
			pdfProgressPanel.graphics.drawRect(0, 0, 500, 200);
			pdfProgressPanel.graphics.endFill();
			pdfProgressPanel.x = 500; pdfProgressPanel.y = 100;
			pdfProgressPanel.alpha = 0;
			this.addChild(pdfProgressPanel);
			
			cbGenerateCover = new CheckBox();
			cbGenerateCover.label = "Genera Portada";
			cbGenerateCover.selected = Settings.GenerateCover;
			cbGenerateCover.setStyle("textFormat", Tema.formatoLabel);
			cbGenerateCover.x = 5; cbGenerateCover.y = 10;
			cbGenerateCover.width = 200;
			pdfProgressPanel.addChild(cbGenerateCover);
			
			cbGenerateIndex = new CheckBox();
			cbGenerateIndex.label = "Genera Índice";
			cbGenerateIndex.selected = Settings.GenerateIndex;
			cbGenerateIndex.setStyle("textFormat", Tema.formatoLabel);
			cbGenerateIndex.x = 5; cbGenerateIndex.y = 40;
			cbGenerateIndex.width = 200;
			pdfProgressPanel.addChild(cbGenerateIndex);
			
			//	Separator
			pdfProgressPanel.addChild(new Separator(500, 5, 0, 0));
			pdfProgressPanel.addChild(new Separator(500, 5, 0, 200));
			pdfProgressPanel.addChild(new Separator(5, 200, 0, 0));
			pdfProgressPanel.addChild(new Separator(5, 200, 495, 0));
			
			var b: Button = new Button();
			b.label = "Generate Pdf";
			b.x = 5; b.y = 70;
			b.addEventListener(MouseEvent.CLICK, function(ev: MouseEvent){
				ex.Stop();
				try{
					var ej_seleccionados: Array = new Array()
					, formato: XML = <pdf>
							<portada />
							<indice	/>
							<escena>
								<detalle />
							</escena>
						</pdf>;
					
					ej_seleccionados.push(ej);
					pdf = new Exportador_PDF(ej_seleccionados, formato, p.pref, ex);
					ex.CurrentProgress = 0.0;
					pdf.GeneratePDF(ej,ex, preloadedImages, cbGenerateCover.selected, cbGenerateIndex.selected );
					if(Settings.OpenPdfAfterGenerating){
						try{
							File.desktopDirectory.resolvePath(ej.nombre + ".pdf").openWithDefaultApplication();
						}catch(err: Error){
							Alert.show("No se puede abrir el fichero");
						}
					}
					new Tween(pdfProgressPanel,"alpha",None.easeNone,1,0,1,true);
				}catch(err: Error){
					Alert.show(err.getStackTrace());
				}
			});
			pdfProgressPanel.addChild(b);
		}
		
		private function createVideoInterface(): void{
			//	Show progress
			progressPanel.graphics.beginFill(Tema.backgroundA, 1);
			progressPanel.graphics.drawRect(0, 0, 500, 200);
			progressPanel.graphics.endFill();
			progressPanel.x = 500; progressPanel.y = 100;
			progressPanel.alpha = 0;
			
			//	Separator
			progressPanel.addChild(new Separator(500, 5, 0, 0));
			progressPanel.addChild(new Separator(500, 5, 0, 200));
			progressPanel.addChild(new Separator(5, 200, 0, 0));
			progressPanel.addChild(new Separator(5, 200, 495, 0));
				
			var txtMessage: Label = new Label();
			txtMessage.text = "Generación del Vídeo en progreso";
			txtMessage.x = 60; txtMessage.y = 30;
			txtMessage.width = 300;
			txtMessage.setStyle("textFormat", Tema.formatoLabel);
			progressPanel.addChild(txtMessage);
			
			var txtMessage2: Label = new Label();
			txtMessage2.text = "La operación puede tardar varios minutos";
			txtMessage2.x = 60; txtMessage2.y = 60;
			txtMessage2.width = 400;
			txtMessage2.setStyle("textFormat", Tema.formatoLabel);
			progressPanel.addChild(txtMessage2);
				
			txtPercent.text = "Generación en progreso";
			txtPercent.x = 200; txtPercent.y = 90;
			txtPercent.setStyle("textFormat", Tema.formatoLabel);
			progressPanel.addChild(txtPercent);
			
			this.addChild(progressPanel);
		}
		
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function muestraBarra() {
			pnProgreso = new Sprite();
			pnProgreso.graphics.beginFill(0x000000,0.2);
            pnProgreso.graphics.drawRect(0, 0, Constantes.APP_WIDTH, Constantes.APP_HEIGHT);
            pnProgreso.graphics.endFill();
			pnProgreso.graphics.beginFill(0x00FF00,1);
            pnProgreso.graphics.drawRect(100, 100, 300, 300);
            pnProgreso.graphics.endFill();
			pb = new ProgressBar();
			pb.width = 400;
			pb.height = 50;
            pb.move(10, 10);
            pb.mode = ProgressBarMode.MANUAL;
            pnProgreso.addChild(pb);
			this.addChild(pnProgreso);
		}
		
		
		public function eliminaBarra() {
			this.removeChild(pnProgreso);
		}
		
		public function IniciaAnimacion(ej: EjercicioBE){
			this.ej = ej;
			ex = new ExerciseAnimation();
			ex.Init(ej, p.hFondos[ej.fondo], p.hElementos, p.UnsortedAcciones);
		}
		
		public function MuestraPdf(): void{
			if(pdfProgressPanel.alpha == 0){
				//new Tween(pdfProgressPanel,"alpha",None.easeNone,0,1,1,true);
				pdfProgressPanel.alpha = 1;
				this.addChild(pdfProgressPanel);
				
			}else{
				if(pdfProgressPanel.alpha == 1){
					//new Tween(pdfProgressPanel,"alpha",None.easeNone,1,0,1,true);
					pdfProgressPanel.alpha = 0;
				}
			}
		}
		
		public function MuestraVideo(): void{
			if(progressPanel.alpha == 0){
				this.addChild(progressPanel);
				progressPanel.alpha = 1;
				//new Tween(progressPanel,"alpha",None.easeNone,0,1,1,true);
			}else{
				if(progressPanel.alpha == 1){
					this.addChild(progressPanel);
					progressPanel.alpha = 0;
					//new Tween(progressPanel,"alpha",None.easeNone,1,0,1,true);
				}
			}
		}
		
		public function UpdateInfoEjercicio(ej: Object) {
			
			txtInfo.text = ej.info;
			txtFechaCreacion.text = ej.fechaCreacion.toString();
			txtDeporte.text = ej.deporte;
		}
		
		public function IniciaGeneracionVideo(ej: EjercicioBE): void{
			
			var calidad: int = Settings.Calidad
				, duracion: int = 0
			 	, paso: Number = 1/calidad
				, act: Number = paso
				, bData: BitmapData = new BitmapData(800, 400, true);
			
			progressPanel.alpha = 1;
			txtPercent.text = "0%";
			ex = new ExerciseAnimation();
			ex.Init(ej, p.hFondos[ej.fondo], p.hElementos, p.UnsortedAcciones);
			ex.Speed = 0.25;
			this.addChild(progressPanel);
			
			myWriter.createFile(File.desktopDirectory.resolvePath(ej.nombre + ".flv"), 800, 400, calidad, ex.Length);
			ex.addEventListener(Event.CHANGE, function(ev: Event){
				txtPercent.text = (100 * ex.CurrentProgress / ex.Length).toString().split(".")[0] + "%";
				bData.draw(ex);
				myWriter.saveFrame( bData );
			});
			
			ex.addEventListener("Finish", function(ev: Event){
				myWriter.closeFile();
				txtPercent.text = "100%";
				File.desktopDirectory.resolvePath(ej.nombre + ".flv").openWithDefaultApplication();
				new Tween(progressPanel,"alpha",None.easeNone,1,0,1,true);
			});
			
			ex.CurrentProgress = ex.Length;

		}
		
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//

		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		//public function get volver(): CoolButton { return btnVolver; }
		public function get BtnBack(): TextImageButton { return btnBack; }
		public function get btnPdf(): TextImageButton { return BtnPdf; }
		public function get video(): TextImageButton { return BtnVideo; }
		public function get piz(): TextImageButton { return BtnPiz; }
		public function get server(): TextImageButton { return BtnServer; }
		public function get db(): TextImageButton { return BtnDB; }
		public function get grid(): DataGrid { return se.get_grid(); }
		public function get gridEjercicios(): Selector_Ejercicios { return se; }
		public function get query(): TextInput { return txtBuscar }
	}
}