﻿package org.pizarra.escenas.View{	

	import fl.controls.TextArea;
	import flash.display.Sprite;	
	import flash.display.Loader;
	import flash.events.*;
	import fl.events.ListEvent;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import fl.controls.Label;
	import fl.controls.TextInput;
	import fl.controls.DataGrid;
	import flash.text.TextField;
	import org.pizarra.Entity.EjercicioBE;
	import org.pizarra.escenas.View;
	import org.pizarra.graficos.ImageButton;
	import org.pizarra.graficos.Selector_Libres;
	import org.pizarra.graficos.TextImageButton;
	import org.pizarra.Util;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.*;
	import org.pizarra.util.*;
	import org.pizarra.events.*;
	import org.pizarra.configuracion.Tema;
	import org.pizarra.BLL.*;
	import flash.text.*;
	
	public class EjerciciosView extends View{
		
		private var p: Pizarra;
		private var lblBuscar: TextField;
		private var txtBuscar: TextInput;
	
		private var ejsSel, ejsDes, dibSel, dibDes: Sprite;
		
		private var se: Selector_Ejercicios;
		private var sDibujos: Selector_Libres;
		
		private var btnVariante, btnVer, btnEditar, btnDelete, btnBack: TextImageButton;
		private var panel:ModalPanel;
		
		private var QRImage, ThumbImage: Image;
		
		//=========================================================
		private var lblInfo: TextField = new TextField()
		,lblDeporte: TextField = new TextField()
		,lblFechaCreacion: TextField = new TextField();
		
		private var txtDeporte: TextInput = new TextInput()
		,txtFechaCreacion: TextInput = new TextInput();
		
		private var txtInfo: TextArea = new TextArea();
		//=========================================================
		
		public function EjerciciosView(piz: Pizarra): void{
			
			super("Mis Ejercicios");
			this.p = piz;
			
			posicionaElementos();
			posicionaBotones();

			se = new Selector_Ejercicios();	
			//	Prepare datasource
			
			se.DataSource = EjerciciosBL.GetExercisesForGrid();
			se.DataBind();
			se.x = 30; se.y = 100;
			addChild(se);
			
			try 
			{
				panel = new ModalPanel(500, 500);
				
				var img: Image = new Image("http://qrcode.kaywa.com/img.php?s=8&d=http%3A%2F%2Fpfc.webpots.org" , 300.0, 300);
				panel.addChild(img);
				panel.Show();
				addChild(panel);
				panel.x = 200;
				panel.y = 400;
			}catch(error: Error) {
				trace(error.message);
				trace(error.getStackTrace());
			}
			
			addChild(new Separator(5, 540, 800, 70));	//	Right panel
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//		
		private function posicionaElementos(){
			
			lblBuscar = new TextField();
			lblBuscar.defaultTextFormat = Tema.formatoLabel;
			txtBuscar = new TextInput();
			Util.posiciona(txtBuscar, 790 - 80, 20, 200, 25);
			Util.setBackground(txtBuscar, p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			this.addChild(txtBuscar);
			
			//=========================================================
			lblInfo.text = "Info";
			SetElemento(lblInfo, txtInfo, 93, 440, 400, 25);
			
			lblDeporte.text = "Deporte";
			SetElemento(lblDeporte, txtDeporte, 93, 480, 400, 25);
			
			lblFechaCreacion.text = "Fecha de Creación";
			SetElemento(lblFechaCreacion, txtFechaCreacion, 93, 520, 400, 25);
			//=========================================================
		}
		
		private function SetElemento(lbl, obj, x, y, width, height) {
			Util.posiciona(lbl,x,y,140,24);
			Util.posiciona(obj,x + 150, y ,width,height);
			Util.setBackground(obj, p.pref.bgText, p.pref.borderWidth, p.pref.borderColor, true);
			var sty: StyleSheet = new StyleSheet();
			sty.parseCSS("color: white; font-family: \"Lucida Sans Unicode\",\"Lucida Grande\",Sans-Serif;");
			lbl.styleSheet = sty;
			lbl.textColor = Tema.colorTitulo; 
			addChild(lbl);
			addChild(obj);
		}
		
		private function posicionaBotones(){

			btnVariante = new TextImageButton(Ficheros.IMG_VARIANTE, "Variante" );
			btnVariante.x = 450 -80; btnVariante.y = 4;
			this.addChild(btnVariante);
			btnVariante.Enable = false;
			
			btnEditar = new TextImageButton(Ficheros.IMG_EDIT, "Editar" );
			btnEditar.x = 530-80; btnEditar.y = 4;
			this.addChild(btnEditar);
			btnEditar.Enable = false;
			
			btnVer = new TextImageButton(Ficheros.IMG_VER, "Ver" );
			btnVer.x = 610-80;	btnVer.y = 4;
			this.addChild(btnVer);
			btnVer.Enable = false;
			
			btnDelete = new TextImageButton(Ficheros.IMG_DELETE, "Borrar" );
			btnDelete.x = 690-80; btnDelete.y = 4;
			this.addChild(btnDelete);
			btnDelete.Enable = false;
			
			btnBack = new TextImageButton(Ficheros.IMG_SALIR, "Volver" );
			btnBack.x = 940; btnBack.y = 4;
			this.addChild(btnBack);
			
		}

		public function LoadQRImage(id: String) {
			QRImage = new Image("http://qrcode.kaywa.com/img.php?s=8&d=http%3A%2F%2Fpfc.webpots.org?id=" + id , 200.0, 200);
			QRImage.x = 812; QRImage.y = 100;
			addChild(QRImage);
		}
		
		public function LoadThumbImage(url: String) {
			ThumbImage = new Image(url, 200.0, 100);
			ThumbImage.x = 812;
			ThumbImage.y = 310;
			this.addChild(ThumbImage);
		}
		
		public function UpdateInfoEjercicio(ej: Object) {
			
			txtInfo.text = ej.info;
			txtFechaCreacion.text = ej.fechaCreacion.toString();
			txtDeporte.text = ej.deporte;
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		public function get BtnBack(): TextImageButton { return btnBack; }
		public function get grid(): DataGrid { return se.get_grid(); }
		public function get gridEjercicios(): Selector_Ejercicios { return se; }
		public function get gridDibujos():Selector_Libres { return sDibujos; }
		public function get query(): TextInput { return txtBuscar }
		
		public function get Variante(): TextImageButton { return btnVariante; }
		public function get Ver(): TextImageButton { return btnVer; }
		public function get Editar(): TextImageButton { return btnEditar; }
		public function get Delete(): TextImageButton { return btnDelete; }
	}
}