﻿package org.pizarra.escenas.View{	

	import fl.controls.*;
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.utils.Dictionary;
	import org.pizarra.escenas.View;
	import org.pizarra.escenas.Controller.EditorController;
	import org.pizarra.escenas.Model.EditorModel;
	import org.pizarra.graficos.*;
	import org.pizarra.graficos.trayectoria.Bezier;
	import org.pizarra.graficos.trayectoria.BezierDiscontinuo;
	import org.pizarra.graficos.trayectoria.Linea;
	import org.pizarra.graficos.trayectoria.LineaDiscontinua;
	import org.pizarra.graficos.trayectoria.Punto;
	import org.pizarra.Util;
	import org.pizarra.Pizarra;
	import org.pizarra.util.*;
	import org.pizarra.events.*;
	import flash.ui.*;
	import org.pizarra.helpers.*;
	import flash.text.*;
	import org.pizarra.configuracion.*;
	import org.pizarra.Animation.TransformationManager.*;
	import org.pizarra.Controls.ImageToggleButton;
	import org.pizarra.escenas.editor.PanelEscena;
	import org.pizarra.escenas.editor.PanelBotones;
	import fl.data.DataProvider;
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	import fl.transitions.TweenEvent;
	import org.pizarra.Animation.ExerciseAnimation;
	import org.pizarra.Entity.EjercicioBE;
	
	
	public class EditorView extends View{
		
		//	Controlador
		private var logic: EditorController;
		//	Modelo
		private var m: EditorModel;
		//	Buttons
		private var BtnGuardar: TextImageButton;
		
		private var bitmap: BitmapData;
		//	Components
		private var selectorElementos: ElementSelector;	//	Selector lateral
		private var LT: Linea_Tiempo;					//	Linea del tiempo
		
		private var fondo: Loader = new Loader(); 
		//	Panels
		private var pnEdicion: Sprite = new Sprite();
		private var pnEscena: PanelEscena = new PanelEscena();
		private var pnEjercicio: Sprite = new Sprite();
		
		private var tabPaneles: TabPaneles;
		private var panelBotones: PanelBotones;
		
		//	Others
		private var contextual: ContextMenu = new ContextMenu();
		private var rotacion: Slider = new Slider();
		private var cierre: Sprite = new Sprite();
		private var cierreLoader: Loader = new Loader();
		private var pathManager: PathManager;
		
		//	Elements
		private var elements: Dictionary = new Dictionary();
		private var pathSprite: Dictionary = new Dictionary(); 
		private var pointSprites: Dictionary = new Dictionary();
		private var actionSprites: Dictionary = new Dictionary();
		private var lineSprites: Dictionary = new Dictionary();
		
		private var activeElement: Elemento_Concreto;
		private var currentAction: int;
		private var currentTrayectoria: Array = new Array();
		
		private var fts: FreeTransformManager = new FreeTransformManager(false);
		
		private var tbZigzagCon, tbZigzagDis, tbBezierCon, tbBezierDis: ImageToggleButton;
		private var tbDeletePrev, tbDeletePost, tbDelete, tbDeleteScene: ImageToggleButton;
		private var tbContinuePath, tbRemovePath: ImageToggleButton;
		private var cbPreActions, cbPostActions: ComboBox;
		
		private var txtElementName: TextInput = new TextInput();
		
		private var btnDownload: ImageToggleButton;
		
		private var pnPreview: MovieClip = new MovieClip();
		private var ex: ExerciseAnimation;
		
		//	Constructor
		public function EditorView( modelo: EditorModel): void {
			Alert.init(modelo.p.stage);
			try {
				if (modelo.p.ejercicioSeleccionado != null) {
					trace(modelo.p.ejercicioSeleccionado);
				}
			}catch (err:Error)
			{
				Alert.show(err.message, {background:"blur"});
			}
			super("");
			m = modelo;
			
			//	Add Panel Separators
			addChild(new Separator(Constantes.APP_WIDTH, 5, 0, 62));	//	Header
			addChild(new Separator(Constantes.APP_WIDTH, 5, 0, 495));	//	Timeline
			addChild(new Separator(5, 440, 200, 60));					//	Elements	
			addPaneles();
			setContextElements();
			addElementSelector();	//	Add the element selector
			addTopButtons();		//	Add top buttons
			addTimeline();			//	Add Timeline
			dibujaTerreno();
		
			AddToggleButtonsAndComboBox();
			addTabs();
			
			pnPreview.graphics.beginFill(Tema.backgroundA, 1);
			pnPreview.graphics.drawRect(0, 0, 900, 500);
            pnPreview.graphics.endFill();
			pnPreview.x = 10; pnPreview.y = 70;
			pnPreview.alpha = 0;
			pnPreview.visible = false;
			this.addChild(pnPreview);
			panelBotones.addEventListener(Eventos.BTN_PREVIEW,preview);
			//	Separator
			pnPreview.addChild(new Separator(900, 5, 0, 0));
			pnPreview.addChild(new Separator(900, 5, 0, 500));
			pnPreview.addChild(new Separator(5, 500, 0, 0));
			pnPreview.addChild(new Separator(5, 500, 895, 0));
		}
		
		//	Crea panel de edición
		private function addPaneles() {
			addChild(pnEdicion);
			pnEdicion.x = 210;
			pnEdicion.y = 90;
			m.pnEdicion = pnEdicion;
			
			pnEscena.addEventListener(Eventos.PNESCENA_CHANGE, cambioPanelEscena);
			addChild(pnEscena);
			pnEscena.x = 210
			pnEscena.y = 90;
			
			txtElementName.text = "";
			txtElementName.width = 200;
			txtElementName.move(820, 69);
			pnEdicion.addChild(txtElementName);
		}
		
		//	Adds tabs and sets the listeners
		private function addTabs() {
			tabPaneles = new TabPaneles();
			tabPaneles.addEventListener(Eventos.TAB_EDICION, tabChange);
			tabPaneles.addEventListener(Eventos.TAB_ESCENA, tabChange);
			tabPaneles.addEventListener(Eventos.TAB_EJERCICIO, tabChange);
			tabPaneles.x = 210; tabPaneles.y = 70;
			this.addChild(tabPaneles);
			tabChange(new Event(Eventos.TAB_EDICION));
		}
		
		//	Set the visibility for the tab
		private function tabChange(ev: Event){
			if(ev != null){
				this.pnEdicion.visible = (ev.type == Eventos.TAB_EDICION);
				this.pnEscena.visible = (ev.type == Eventos.TAB_ESCENA);
				this.pnEjercicio.visible = (ev.type == Eventos.TAB_EJERCICIO);
				if(ev.type == Eventos.TAB_ESCENA || ev.type == Eventos.TAB_EJERCICIO){
					selectorElementos.disable();
					this.disableAllButtons();
				}
				if(ev.type == Eventos.TAB_EDICION){
					selectorElementos.enable();  
					this.enableAllButtons();
				}
			}
		}
				
		//	Adds the element selector to the scene
		private function addElementSelector() {
			//	Create the selector element
			selectorElementos = new ElementSelector(m);
			//	Configure the element
			selectorElementos.dinamicosDataSource = m.p.dinamicos[m.p.dep_select];
			selectorElementos.playersDataSource = m.p.jugadores;
			selectorElementos.estaticosDataSource = m.p.estaticos[m.p.dep_select];
			//	Listen to events
			selectorElementos.addEventListener(ElementAddedEvent.ADDED_ELEMENT, addedElement);
			//selectorElementos.addEventListener(ElementMoveEvent.MOVED_ELEMENT, movedElement);
			//	Add the element
			addChild(selectorElementos);
			selectorElementos.x = 20;
			selectorElementos.y = 70;
		}
		
		//	Adds the timeline
		private function addTimeline() {
			LT = new Linea_Tiempo((95 * 800 / 400), m.preferencias, m.p.fondoSeleccionado.url);
			LT.addEventListener(LTPosicionesClickEvent.POSICIONES_CLICK, clickPosiciones);
			//	sets the first element
			this.addChild(LT);
		}
		
		private function addTopButtons() {
			panelBotones = new PanelBotones();
			panelBotones.x = 10;
			panelBotones.y = 5;
			addChild(panelBotones);
		}
	
		//	Fondo y terrenos
		private function dibujaTerreno(){
			var urlReq:URLRequest = new URLRequest(m.p.fondoSeleccionado.url);
			fondo.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
			fondo.load(urlReq);
		}
		
		private function AddToggleButtonsAndComboBox(){
			
			this.tbZigzagCon = new ImageToggleButton(Ficheros.IMG_ZIGZAG_CONT);
			this.tbZigzagCon.x = 500; this.tbZigzagCon.y = 30;
			this.tbZigzagCon.addEventListener(Event.CHANGE, onCurve_Toggled);
			this.addChild(tbZigzagCon);
			
			this.tbZigzagDis = new ImageToggleButton(Ficheros.IMG_ZIGZAG_DISC);
			this.tbZigzagDis.x = 532; this.tbZigzagDis.y = 30;
			this.tbZigzagDis.addEventListener(Event.CHANGE, onCurve_Toggled);
			this.addChild(tbZigzagDis);
			
			this.tbBezierCon = new ImageToggleButton(Ficheros.IMG_BEZIER_CONT);
			this.tbBezierCon.x = 564; this.tbBezierCon.y = 30;
			this.tbBezierCon.addEventListener(Event.CHANGE, onCurve_Toggled);
			this.addChild(tbBezierCon);
			
			this.tbBezierDis = new ImageToggleButton(Ficheros.IMG_BEZIER_DISC);
			this.tbBezierDis.x = 596; this.tbBezierDis.y = 30;
			this.tbBezierDis.addEventListener(Event.CHANGE, onCurve_Toggled);
			this.addChild(tbBezierDis);
			
			this.tbDeletePrev = new ImageToggleButton(Ficheros.IMG_EDITOR_REMOVE_PREV);
			this.tbDeletePrev.x = 628; this.tbDeletePrev.y = 30;
			this.tbDeletePrev.Enabled = false;
			this.addChild(tbDeletePrev);
			
			this.tbDeletePost = new ImageToggleButton(Ficheros.IMG_EDITOR_REMOVE_POST);
			this.tbDeletePost.x = 660; this.tbDeletePost.y = 30;
			this.tbDeletePost.Enabled = false;
			this.addChild(tbDeletePost);
			
			this.tbDelete = new ImageToggleButton(Ficheros.IMG_EDITOR_REMOVE);
			this.tbDelete.x = 692; this.tbDelete.y = 30;
			this.tbDelete.Enabled = true;
			this.addChild(tbDelete);
			
			this.tbDeleteScene = new ImageToggleButton(Ficheros.IMG_EDITOR_REMOVE_SCENE);
			this.tbDeleteScene.x = 692+32; this.tbDeleteScene.y = 30;
			this.tbDeleteScene.Enabled = true;
			this.addChild(tbDeleteScene);
			
			this.tbContinuePath = new ImageToggleButton(Ficheros.IMG_EDITOR_CONTINUE_PATH);
			this.tbContinuePath.x = 724 +32; this.tbContinuePath.y = 30;
			this.tbContinuePath.Enabled = true;
			this.addChild(tbContinuePath);
			
			this.tbRemovePath = new ImageToggleButton(Ficheros.IMG_EDITOR_REMOVE_PATH);
			this.tbRemovePath.x = 756 + 32; this.tbRemovePath.y = 30;
			this.tbRemovePath.Enabled = true;
			this.addChild(tbRemovePath);
			
			
			this.btnDownload = new ImageToggleButton(Ficheros.IMG_GUARDAR);
			this.btnDownload.x = 900; this.btnDownload.y = 30;
			this.btnDownload.Enabled = true;
			this.btnDownload.addEventListener(MouseEvent.CLICK, download_Click);
			this.addChild(btnDownload);
			
		 	this.cbPreActions = new ComboBox();
			this.cbPreActions.width = 200;
			this.cbPreActions.x = 500;
			this.cbPreActions.y = 4;
			this.addChild(cbPreActions);
			
			this.cbPostActions = new ComboBox();
			this.cbPostActions.width = 200;
			this.cbPostActions.x = 730;
			this.cbPostActions.y = 4;
			this.addChild(cbPostActions);
		}
		
		//	Pasa a escena de tipo Posiciones
		function clickPosiciones(e: LTPosicionesClickEvent) {
	
			doneHandler(null);
			logic.posiciona(e.posicion, Constantes.POSICIONAMIENTO);
			repaint();
			removePathSprites();	//	Elimina las trayectorias
			addPathSprites();
			updatePnEscena();
			
			if(!Util.IsDictionaryEmpty(elements)){
				fts.updateAfterChange();
			}
		}
		
		//	Repaint
		public function repaint() {
			var escena: Dictionary = logic.escenaActual;
			for each (var el: Elemento_Concreto in elements) {
				el.x = escena[el.Id].posicion.x;
				el.y = escena[el.Id].posicion.y;
				el.rotation = escena[el.Id].rotacion;
			}
			if(!Util.IsDictionaryEmpty(elements)){
				fts.updateAfterChange();
			}
		}
	
		//	Repaint Escena
		private function repaintEscena(escena: Dictionary) {
			for each (var el: Elemento_Concreto in elements) {
				el.x = escena[el.Id].posicion.x;
				el.y = escena[el.Id].posicion.y;
				el.rotation = escena[el.Id].rotacion;
			}
		}
		
		//	A new element has been added to the scene
		private function addedElement(e: ElementAddedEvent) {
			doneHandler(null);
			fts.registerSprite(e.element);
			logic.addElement(e.element);
			elements[e.element.Id] = e.element;
			pathSprite[e.element.Id] = new TrayectoriaSprite(pnEdicion, e.element);
			pathSprite[e.element.Id].x = 210;
			pathSprite[e.element.Id].y = 90;
			addChild(pathSprite[e.element.Id]);
			
			e.element.dispatchEvent(new MouseEvent(MouseEvent.CLICK));	//	Select recently added element
			
			//	Add the listeners for the context menus
			//elements[e.element.Id].addEventListener(Elemento_Concreto.CONTINUE, continueHandler);
			elements[e.element.Id].addEventListener(Elemento_Concreto.ACTION, actionHandler);
			elements[e.element.Id].addEventListener(Elemento_Concreto.DELETE, deleteElement);
			elements[e.element.Id].addEventListener(Elemento_Concreto.DELETE_ANTERIORES, deleteElement);
			elements[e.element.Id].addEventListener(Elemento_Concreto.DELETE_POSTERIORES, deleteElement);
		}
		
		private function setContextElements() {
			rotacion.maximum = 360;	rotacion.minimum = 0;
			rotacion.liveDragging = true;
			//rotacion.addEventListener(Event.CHANGE,cambio_rotacion);
						
			cierreLoader.load(new URLRequest(Ficheros.IMG_DONE));
			cierre.addChild(cierreLoader);
			cierre.buttonMode = true;
			cierre.addEventListener(MouseEvent.CLICK, doneHandler);
			cierre.x = 850; cierre.y = 4;
			pathManager = new PathManager(pnEdicion, cierreLoader);
		}
		
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function imgLoaded(event:Event):void{
			pnEdicion.addChild(fondo);
			fondo.x = 0;
			fondo.y = 0;
			fondo.width = 800;
			fondo.height = 400;
			//LT.add();
			LT.CreateNewScene();
		}
		
		
		//	Removes all the paths from the screen
		private function removePathSprites() {
			for each(var e: Elemento_Concreto in elements) {
				pathSprite[e.Id].CleanDisplay();
			}
		}
		
		//	Adds the paths for all the elements
		private function addPathSprites() {
			for each(var e: Elemento_Concreto in elements) {
				pathSprite[e.Id].CleanDisplay();
				pathSprite[e.Id] = new TrayectoriaSprite(pnEdicion, e);
				pathSprite[e.Id].x = 210;
				pathSprite[e.Id].y = 90;
				pathSprite[e.Id].SetPath(logic.getPath(e.Id));
				addChild(pathSprite[e.Id]);
			}
		}
		
		public function AddIndividualPathSprite(el: Elemento_Concreto){
			if(pathSprite[el.Id] != null){
				pathSprite[el.Id].CleanDisplay();
				pathSprite[el.Id] = new TrayectoriaSprite(pnEdicion, el);
				pathSprite[el.Id].x = 210;
				pathSprite[el.Id].y = 90;
				pathSprite[el.Id].SetPath(logic.getPath(el.Id));
				addChild(pathSprite[el.Id]);
			}
		}
		
		private function actionHandler(e: Event) {
			activeElement = e.target as Elemento_Concreto;
			var actionName: String = e.target.accion.nombre;
			pathSprite[activeElement.Id].SetAction(actionName);
		}
		
		
		//	</TRAYECTORIAS>
		//	<DONE>
		private function doneHandler(e: Event) {
			if(logic.lastElement != null && pathSprite[logic.lastElement.Id] != null){
				var pathSprite: TrayectoriaSprite = pathSprite[logic.lastElement.Id];
				trace(pathSprite);
				pathSprite.StopPath();
				pathSprite.Disable();
				try{
					this.removeChild(cierre);
					logic.setPath(pathSprite.Path, logic.lastElement.Id);
				}catch(er: Error){}
			}
			
		}
		
		/*private function continueHandler(e: Event) {
			activeElement = e.target as Elemento_Concreto;
			pnEdicion.addChild(cierre);	//	Allow close
			pathSprite[activeElement.Id].ContinuePath();
		}*/
		
		public function eliminaElemento(id: String) {
			pnEdicion.removeChild(elements[id]);
			delete elements[id];
		}

		public function UpdateCombosAcciones(acciones: Array, selectedPre: String, selectedPost: String){
			//	Pre Acciones
			cbPreActions.dataProvider = new DataProvider();
			cbPreActions.addItem({label:"Ninguna Acción",data:GUID.Empty});
			if(acciones != undefined && acciones != null){
				for(var i = 0; i < acciones.length; i++){
					cbPreActions.addItem({label:acciones[i].nombre,data:acciones[i].id});
				}
			}
			
			cbPreActions.selectedIndex = Util.findItemIndex(cbPreActions, selectedPre);
			
			//	PostAcciones
			cbPostActions.dataProvider = new DataProvider();
			cbPostActions.addItem({label:"Ninguna Acción",data:GUID.Empty});
			if(acciones != undefined && acciones != null){
				for(var i = 0; i < acciones.length; i++){
					cbPostActions.addItem({label:acciones[i].nombre,data:acciones[i].id});
				}
			}
			
			cbPostActions.selectedIndex = Util.findItemIndex(cbPostActions, selectedPost);
		}
		
		public function UpdateElementName(name: String): void{
			this.txtElementName.text = name;
		}
		
		private function onCurve_Toggled(e: Event) {
			
			doneHandler(null);
			logic.ClearPath();
			
			if(logic.lastElementId != ""){
				switch(e.target) {
					case tbBezierDis:
						currentAction = Acciones.CIRCULAR_DIS;
						Util.subTrace("== Initiated Dotted Bezier Path on element " + logic.lastElement.Id);
						break;
					case tbBezierCon:
						currentAction = Acciones.CIRCULAR;
						Util.subTrace("== Initiated Bezier Path on element " + logic.lastElement.Id);
						break;
					case tbZigzagCon:
						currentAction = Acciones.ZIGZAG;
						Util.subTrace("== Initiated ZigZag Path on element " + logic.lastElement.Id);
						break;
					case tbZigzagDis:
						currentAction = Acciones.ZIGZAG_DIS;
						Util.subTrace("== Initiated Dotted ZigZag Path on element " + logic.lastElement.Id);
						break;
				}
				//	Remove the current path
				if (pathSprite[logic.lastElement.id] != null && contains(pathSprite[logic.lastElement.Id])) {
					removeChild(pathSprite[logic.lastElement.Id]);
				}
				pathSprite[logic.lastElement.Id].StartPath(currentAction);
				this.addChild(cierre);	//	Allow close
			}
		}
		
		
		/*	DELETE
		 =================================================================*/
		private function deleteElement(e:Event) {
			var el:Elemento_Concreto = e.target as Elemento_Concreto;
			switch(e.type) {
				case Elemento_Concreto.DELETE:
					logic.DeleteElement(el.Id);
					pnEdicion.removeChild(elements[el.Id]);
					delete elements[el.Id];
					repaint();
					break;
				case Elemento_Concreto.DELETE_ANTERIORES:
					logic.DeleteAnteriores(el.Id);
					repaint();
					break;
				case Elemento_Concreto.DELETE_POSTERIORES:
					logic.DeletePosteriores(el.Id);
					repaint();
					break;
			}
		}
		
		public function CleanElemento(el: Elemento_Concreto){
			pnEdicion.removeChild(elements[el.Id]);
			delete elements[el.Id];
			fts.deregisterSprite(el);
			repaint();
			LT.Reload();
			LT.Update();
		}
		
		
		/*	PANEL UPDATES
		 ========================================================================*/
		private function cambioPanelEscena(e:Event) {
			logic.actualizaGeneralesEscena(pnEscena.duracion, pnEscena.tipo, pnEscena.audio, pnEscena.texto);
		}
		
		private function updatePnEscena() {
			pnEscena.audio = logic.getAudio();
			pnEscena.texto = logic.getTexto();
			pnEscena.tipo = logic.getTipo();
			pnEscena.duracion = logic.getDuracion();
		}
		
		
		public function FinishEdition(): void{
			doneHandler(null);
		}
		
		/*	BUTTON HANDLERS
		 ========================================================================*/
		//	Video preview
		function preview(ev: Event) {
			
			if(pnPreview.alpha == 0){
				pnPreview.visible = true;
				new Tween(pnPreview,"alpha",None.easeNone,0,1,1,true);
				if(ex != null){
					pnPreview.removeChild(ex);
				}
				ex = new ExerciseAnimation();
				ex.x = 40; ex.y = 40;
				var e: EjercicioBE = logic.GetExercise();
				ex.Init(e, m.p.hFondos[e.fondo], m.p.hElementos, m.p.UnsortedAcciones);
				pnPreview.addChild(ex);
			}else{
				trace(ex.Length);
				var tw: Tween = new Tween(pnPreview,"alpha",None.easeNone,1,0,1,true);
				tw.addEventListener(TweenEvent.MOTION_FINISH, function(ev: Event){
					pnPreview.visible = false;
				});
			}
		}
		
		//	Undo
		function undo(e: Event) {
			Util.subTrace("Undo");
			logic.undo();
			repaint();
		}
		
		//	Redo
		function redo(e: Event) {
			Util.subTrace("Redo");
		}
		
		
		public function UpdateButtonsOnSelection(el: Elemento_Concreto){
			
			//	Path Buttons
			this.tbBezierCon.Enabled = (el.elemento.tipo == Constantes.TIPO_DINAMICO || el.elemento.tipo == "dinamico" );
			this.tbBezierDis.Enabled = (el.elemento.tipo == Constantes.TIPO_DINAMICO || el.elemento.tipo == "dinamico");
			this.tbZigzagCon.Enabled = (el.elemento.tipo == Constantes.TIPO_DINAMICO || el.elemento.tipo == "dinamico");
			this.tbZigzagDis.Enabled = (el.elemento.tipo == Constantes.TIPO_DINAMICO || el.elemento.tipo == "dinamico");
			this.tbRemovePath.Enabled = true;
			this.tbContinuePath.Enabled = true;
			
			//	Remove Buttons
			this.tbDelete.Enabled = true;
			this.tbDelete.Enabled = true;
			this.tbDelete.Enabled = true;
		}
		
		public function ContinuePath(): void{
			if(logic.lastElementId != ""){
				pathSprite[logic.lastElement.Id].Enable();
				pathSprite[logic.lastElement.Id].ContinuePath();
				this.addChild(cierre);	//	Allow close
			}
		}
		
		
		/**************************************
		 *		HANDLERS
		 **************************************/
		//	Disable all buttons
		private function disableAllButtons(): void{
			tbBezierCon.Enabled = false;
			tbBezierDis.Enabled = false;
			tbZigzagCon.Enabled = false;
			tbZigzagDis.Enabled = false;
			
			tbDelete.Enabled = false;
			tbDeletePost.Enabled = false;
			tbDeletePrev.Enabled = false;
			tbDeleteScene.Enabled = false;
			tbContinuePath.Enabled = false;
			tbRemovePath.Enabled = false;
		}
		
		//	Enable all buttons
		private function enableAllButtons(): void{
			tbBezierCon.Enabled = true;
			tbBezierDis.Enabled = true;
			tbZigzagCon.Enabled = true;
			tbZigzagDis.Enabled = true;
			
			tbDelete.Enabled = true;
			tbDeletePost.Enabled = true;
			tbDeletePrev.Enabled = true;
			tbDeleteScene.Enabled = true;
			tbContinuePath.Enabled = true;
			tbRemovePath.Enabled = true;
		}
		
		/**************************************
		 *		GETTERS AND SETTERS
		 **************************************/ 
		public function get volver(): TextImageButton{ return panelBotones.Salir; }
		public function get guardar(): TextImageButton{ return panelBotones.Guardar; }
		
		public function get TbDelete(): ImageToggleButton { return tbDelete; }
		public function get TbDeletePrev(): ImageToggleButton { return tbDeletePrev; }
		public function get TbDeletePost(): ImageToggleButton { return tbDeletePost; }
		public function get TbDeleteScene(): ImageToggleButton { return tbDeleteScene; }
		public function get TbRemovePath(): ImageToggleButton { return tbRemovePath; }
		public function get TbContinuePath(): ImageToggleButton { return tbContinuePath; }
		
		public function get LineaTiempo(): Linea_Tiempo { return this.LT; }
		public function setController(controlador: EditorController) { logic = controlador; }
		public function get TransformManager():FreeTransformManager { return this.fts;}
		public function get ButtonPanel(): PanelBotones { return this.panelBotones; }
		
		public function get CbPreActions(): ComboBox { return cbPreActions; }
		public function get CbPostActions(): ComboBox { return cbPostActions; }
		
		public function get PnEscena(): PanelEscena { return pnEscena; }
		
		public function get Elements(): Dictionary { return this.elements; }
		
		private function download_Click(ev: Event): void{
			logic.saveExerciseToFile();
		}
		
	}
}