﻿package org.pizarra.escenas {	
	
	import org.pizarra.graficos.Titulo;
	import flash.display.Sprite;
	import org.pizarra.util.Constantes;
	import org.pizarra.configuracion.Tema;
	import flash.display.GradientType;
	import flash.geom.Matrix;
	
	public class View extends Sprite {
		
		private var tit: Titulo;
		
		public function View(titulo: String) {
			if(titulo != ""){
				posicionaTitulo(titulo);
			}
			dibujaFondoLineal();
		}
		
		private function posicionaTitulo(titulo: String) {
			tit = new Titulo(titulo, null);
			tit.x = 0; tit.y = 0;
			this.addChild(tit);
		}
		
		public function dibujaFondoLineal() {
			//	Fondo
			this.graphics.beginFill(Tema.backgroundB, 1);
			this.graphics.drawRect(0, 0, Constantes.APP_WIDTH, Constantes.APP_HEIGHT);
            this.graphics.endFill();
		}
		
		public function dibujaFondoGradiente() {
			//	Fondo
			var matrix:Matrix = new Matrix(); 
			var boxWidth:Number = 50; 
			var boxHeight:Number = 100; 
			var boxRotation:Number = Math.PI/2; // 90° 
			var tx:Number = 25; 
			var ty:Number = 0; 
			matrix.createGradientBox(boxWidth, boxHeight, boxRotation, tx, ty); 
			this.graphics.beginGradientFill(
				GradientType.LINEAR,
				[Tema.backgroundA, Tema.backgroundB],
				[1, 1],
				[0, 255],
				matrix,"pad",flash.display.InterpolationMethod.LINEAR_RGB);
            this.graphics.drawRect(0, 0, Constantes.APP_WIDTH, Constantes.APP_HEIGHT);
            this.graphics.endFill();
			//	Segundo fondo
			
			//this.graphics.beginFill(0xFFFFFF);
            this.graphics.beginGradientFill(
				GradientType.LINEAR,
				[Tema.secondBgA, Tema.secondBgB],
				[1, 1],
				[0, 255],
				matrix);
			this.graphics.drawRoundRect(20, 
										20, 
										Constantes.APP_WIDTH - 40, 
										Constantes.APP_HEIGHT - 40,
										20,
										20);
            this.graphics.endFill();
		}
		
		public function dibujaSpan(x:int, y: int, width: int, height:int) {
			//	Fondo
			var matrix:Matrix = new Matrix(); 
			var boxWidth:Number = 50; 
			var boxHeight:Number = 100; 
			var boxRotation:Number = Math.PI/2; // 90° 
			var tx:Number = 25; 
			var ty:Number = 0; 
			matrix.createGradientBox(boxWidth, boxHeight, boxRotation, tx, ty); 
			this.graphics.beginGradientFill(
				GradientType.LINEAR,
				[Tema.spanBgA, Tema.spanBgB],
				[1, 1],
				[0, 255],
				matrix,"pad",flash.display.InterpolationMethod.LINEAR_RGB);
            this.graphics.drawRoundRect(x, y, width, height,20,20);
            this.graphics.endFill();
			//	Border
			this.graphics.lineStyle(Tema.spanBorderWidth, Tema.spanBorderColor,1,true, "normal", "square");
			this.graphics.beginFill(Tema.spanBgA, 0);
			this.graphics.drawRoundRect(x, y, width, height, 20, 20);
			this.graphics.endFill();
		}
		
		protected function set Title(val: String): void {
			if(tit != null){
				this.removeChild(this.tit);
			}
			tit = new Titulo(val, null);
			tit.x = 0; tit.y = 0;
			this.addChild(tit);
		}
	}
}