﻿package org.pizarra.escenas.Controller{	

	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.Event;
	import org.pizarra.io.ImportadorSettings;
	import org.pizarra.Pizarra;
	import org.pizarra.graficos.Alert;
	import flash.net.*;
	import org.pizarra.io.*;
	import org.pizarra.DAL.*;
	import org.pizarra.Entity.*;
	import org.pizarra.util.Eventos;
	import org.pizarra.escenas.View.ThemeView;
	import flash.filesystem.*;
	import org.pizarra.configuracion.Tema;

	public class ThemeController extends EventDispatcher{
		
		private var p: Pizarra;
		private var imp: ImportadorSettings;
		private var view: ThemeView;
		private var file: File = File.desktopDirectory;

		public function ThemeController(piz: Pizarra, view: ThemeView): void{
			
			this.p = piz;
			this.view = view;
			imp = new ImportadorSettings();
			Alert.init(p.stage);
			//	Bind listeners
			this.view.BtnDelete.addEventListener(MouseEvent.CLICK, btnDelete_Click);
			this.view.BtnMakeDefault.addEventListener(MouseEvent.CLICK, btnMakeDefault_Click);
			this.view.BtnImport.addEventListener(MouseEvent.CLICK, btnImport_Click);
			this.view.BtnSave.addEventListener(MouseEvent.CLICK, btnSave_Click);
			this.view.BtnNew.addEventListener(MouseEvent.CLICK, btnNew_Click);
			this.view.CbThemes.addEventListener(Event.CHANGE, cbThemes_SelectedIndexChanged);
			this.view.CpMainBg.addEventListener(Event.CHANGE, colorPicker_Changed);
			this.view.CpSecondBg.addEventListener(Event.CHANGE, colorPicker_Changed);
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init(){
		}
		
		public function seleccionaTema(indice: int) {
			p.temas[indice].select();
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function volverSettings(event: Event){
			dispatchEvent(new Event("volver"));
		}
		private function guardarSettings(event: Event){
			Alert.show("Datos guardados correctamente.", {background:"blur"});
		}
		
		//	Delete Clicked
		private function btnDelete_Click(e: MouseEvent){
			var tema: TemaBE;
			tema = p.temas[view.CbThemes.selectedIndex];
			var DA: TemaDA = new TemaDA(p.bd.conexion);
			var res: String = DA.deleteTema(tema.id);
			p.temas = DA.getTemas();
			view.refreshComboTemas();
			Alert.show(res);
		}
		
		//	Make Default Clicked
		private function btnMakeDefault_Click(e: MouseEvent){
			Alert.show("Make default");
		}
		
		//	Make Default Clicked
		private function btnImport_Click(e: MouseEvent){
			file.browseForOpen("Importar tema");
			file.addEventListener(Event.SELECT, selectedFile);
		}
		
		//	A file was selected
		function selectedFile(e: Event) {
			
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE, doLoadFile);
			loader.load(new URLRequest(file.nativePath));
		}
		
		function doLoadFile(e:Event):void{
			try{
				var xml: XML = new XML(e.target.data);
				if (xml.theme.length() == 0) {
					Alert.show("El fichero no es un tema");
				}else {
					var resultado = imp.importaSettings(xml);
					var DA: TemaDA = new TemaDA(p.bd.conexion);
					resultado = DA.escribe(imp.tema);
					resultado = (resultado != "") ? resultado : "Tema insertado correctamente";
					if(DA.tema != null){
						p.temas.push(DA.tema);
						view.refreshComboTemas();
					}
				}	
			}catch(err: Error){
				trace(err.getStackTrace());
				Alert.show("El fichero no es un tema");
			}
		}
		
		
		//	Selecteion changed
		private function cbThemes_SelectedIndexChanged(e: Event){
			var tema: TemaBE = p.temas[view.CbThemes.selectedIndex];
			// do select theme 
			tema.secondBgA
			// change values
			view.UpdateForm(tema);
		}
		
		private function btnSave_Click(e: Event){
			
			//Save the theme
			try{
				view.UpdateTema();
				var t: TemaBE = new TemaBE();
				t.ImportFromTema();
				var DA: TemaDA = new TemaDA(p.bd.conexion);
				DA.updateTema(t);
				Alert.show("Tema Guardado correctamente");
			}catch(err: Error){
				trace(err.getStackTrace());
				Alert.show("Error guardando tema");
			}
			
		}
		
		private function btnNew_Click(e: Event){
			Alert.show("New");
		}
		
		private function colorPicker_Changed(e: Event){
			switch(e.target){
				case view.CpMainBg:
					p.temas[view.CbThemes.selectedIndex].backgroundA = view.CpMainBg.selectedColor;
					break;
				case view.CpSecondBg:
					p.temas[view.CbThemes.selectedIndex].secondBgA = view.CpSecondBg.selectedColor;
					break;
				default:
					break;
			}
			p.temas[view.CbThemes.selectedIndex];
			view.UpdateForm(p.temas[view.CbThemes.selectedIndex]);
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
	}
}