﻿package org.pizarra.escenas.Controller{	

	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.Event;
	import org.pizarra.io.ImportadorSettings;
	import org.pizarra.Pizarra;
	import org.pizarra.escenas.View.*;
	import org.pizarra.graficos.Alert;
	import flash.net.*;
	import org.pizarra.io.*;
	import org.pizarra.DAL.*;
	import org.pizarra.Entity.*;
	import org.pizarra.util.Eventos;
	import org.pizarra.util.Constantes;
	import org.pizarra.configuracion.Settings;
	import flash.xml.XMLDocument;

	public class SettingsController extends EventDispatcher{
		
		private var p: Pizarra;
		private var imp: ImportadorSettings;
		private var view: SettingsView;

		public function SettingsController(piz: Pizarra, view: SettingsView): void{
			
			this.p = piz;
			this.view = view;
			Alert.init(p.stage);
			imp = new ImportadorSettings();
			this.view.BtnPing.addEventListener(MouseEvent.CLICK, btnPing_Click);
			this.view.BtnUpdate.addEventListener(MouseEvent.CLICK, btnUpdate_Click);
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		
		public function importSettingsFile(url: String) {
			var loader:URLLoader = new URLLoader();
			loader.addEventListener(Event.COMPLETE, loadXML);
			loader.load(new URLRequest(url));
		}
		
		public function seleccionaTema(indice: int) {
			p.temas[indice].select();
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		public function Comprueba_conexion(verbose: Boolean = true){
						
			var loader:URLLoader = new URLLoader();
			trace(Settings.Server + "/" + Constantes.PING_URL);
			loader.load(new URLRequest(Settings.Server + "/" + Constantes.PING_URL));
			loader.addEventListener(Event.COMPLETE,
				function(evt: Event):void {
					if(evt.target.data == Constantes.PING_OK_ANSWER){
						if(verbose) Alert.show("Conexión con el servidor establecida correctamente");
						view.ImgPingError.visible = false;
						view.ImgPingOk.visible = true;
					}else{
						if(verbose) Alert.show("Ping Erróneo");
						view.ImgPingError.visible = true;
						view.ImgPingOk.visible = false;
					}
				}
			);
			loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR, io_error);
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		function loadXML(e:Event):void
		{
			var xml = new XML(e.target.data);
			//	Parse
			var resultado = imp.importaSettings(xml);
			//	Write
			var DA: TemaDA = new TemaDA(p.bd.conexion);
			resultado = DA.escribe(imp.tema);
			resultado = (resultado != "") ? resultado : "tema insertado correctamente";
			//	Update list
			if(DA.tema != null){
				p.temas.push(DA.tema);
			}
			dispatchEvent(new Event(Eventos.THEME_IMPORT));
			//	Select Show results
			Alert.show(resultado, { background:"blur" } );
		}
		
		private function volverSettings(event: Event){
			dispatchEvent(new Event("volver"));
		}
		private function guardarSettings(event: Event){
			Alert.show("Datos guardados correctamente.", {background:"blur"});
		}
		
		private function btnPing_Click(ev: MouseEvent): void{
			Comprueba_conexion();
		}
		
		private function btnUpdate_Click(ev: MouseEvent): void{
			var loader:URLLoader = new URLLoader();
			loader.load(new URLRequest(Settings.Server + "/" + Constantes.UPDATE_URL));
			loader.addEventListener(Event.COMPLETE,
				function(evt: Event):void {
					var res: XML = new XML(evt.target.data);
					if(evt.target.data == Constantes.PING_OK_ANSWER){
						Alert.show("Conexión con el servidor establecida correctamente");
					}else{
						Alert.show("Ping Erróneo");
					}
				}
			);
			loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR, io_error);
		}
		
		
		private function io_error(evt: Event):void {
			Alert.show("Error de conexión");
			view.ImgPingError.visible = true;
			view.ImgPingOk.visible = false;
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
	}
}