﻿package org.pizarra.escenas.Controller{	

	import flash.display.Sprite;
	import flash.events.EventDispatcher;
	import flash.events.Event;
	import org.pizarra.Data.Base_Datos;
	import org.pizarra.io.ImportadorDeportes;
	import org.pizarra.Pizarra;
	import org.pizarra.escenas.View.ImportView;
	import org.pizarra.graficos.Alert;
	import org.pizarra.util.Eventos;
	import flash.events.MouseEvent;	
	import deng.fzip.FZip;
	import deng.fzip.FZipFile;
	import flash.net.*;
	import flash.filesystem.*;
	import org.pizarra.util.Constantes;

	public class ImportController extends EventDispatcher{
		
		private var p: Pizarra;
		private var panel: Sprite;
		private var impDeportes: ImportadorDeportes;

		public function ImportController(piz: Pizarra,panel: Sprite): void{
			this.panel = panel;
			p = piz;
			Alert.init(p.stage);
			impDeportes = new ImportadorDeportes(p.bd.conexion, panel);
			init();
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init() {
			/*if (p.urlEjercicio != "") {
				trace("load from file");
			}*/
		}
		public function importaFichero(fichero: String): int {
			
			switch(fichero.split(".")[fichero.split(".").length-1]){	//tipo?
				case "piz":	trace('piz');
							return Constantes.IMP_EJERCICIO;
							break;
				case "db":	importaBD(fichero);
							return Constantes.IMP_BD;
							break;
				case "pizd": importaDeporte(fichero);
							return Constantes.IMP_DEPORTE;
							break;
				case "zip": trace("paquete " + fichero);
							importaDeporte(fichero);
							return Constantes.IMP_DEPORTE;
							break;
				default:	trace("Formato desconocido");
							return Constantes.IMP_DESCONOCIDO;
			}
			
		}
		
		public function importaDeporte(fichero: String) {
			impDeportes.addEventListener(Eventos.FINISHED_LOAD, finCargaDeporte);
			impDeportes.carga(fichero);
		}
		
		public function importaBD(fichero: String) {
			
			try{
				//	Realiza Copia de seguridad de la base de datos actual
				var sourceFile:File = File.documentsDirectory;
				sourceFile = sourceFile.resolvePath("piz/pizarra.db");
				var destination:File = File.documentsDirectory;
				destination = destination.resolvePath("piz/pizarra.db.bak");
				sourceFile.copyTo(destination, true);
				
				//	Cierra la base de datos
				p.bd.close();
				
				//	Copia al lugar de la base de datos
				sourceFile = File.documentsDirectory;
				sourceFile = sourceFile.resolvePath(fichero);
				destination = File.documentsDirectory;
				destination = destination.resolvePath("piz/pizarra.db");
				trace(destination.nativePath);
				sourceFile.copyTo(destination, true);
				
				//	Recarga la información
				p.bd = new Base_Datos("pizarra.db", null);
				p.recarga();
				
			}catch (error) {
				Alert.show("Error :"+ error.message +" Details: "+ error.details);
				return "Error :"+ error.message +" Details: "+ error.details;
			}
		}
		
		public function procede(fichero: String) {
			impDeportes.addEventListener(Eventos.FINISHED_IMPORT, finImportacionDeporte);
			impDeportes.importa(fichero);
		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		public function finCargaDeporte(e: Event) {
			
			if (impDeportes.msg == "") {
				dispatchEvent(new Event(Eventos.FINISHED_LOAD));
			}else{
				Alert.show(impDeportes.msg);
			}
		}
		
		public function finImportacionDeporte(e: Event) {
			
			if (impDeportes.msg == "") {
				p.recarga();
				Alert.show("Deporte Insertado Correctamente");
				dispatchEvent(new Event(Eventos.FINISHED_IMPORT));
			}else{
				Alert.show(impDeportes.msg);
			}
		}
		
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
		//	DEPORTE
		public function get idDeporte():String { return impDeportes.id; }
		public function get nombreDeporte():String { return impDeportes.nombre; }
		public function get thumbDeporte():String { return impDeportes.file; }
		public function get elementosDeporte():String { return impDeportes.elementos; }
	}
}