﻿package org.pizarra.escenas.Controller{	

	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.Event;
	import fl.events.ListEvent;
	import org.pizarra.Data.DibujoLibre;
	import org.pizarra.Ejercicio;
	import org.pizarra.Pizarra;
	import org.pizarra.escenas.View.ExportView;
	import org.pizarra.graficos.Alert;
	import org.pizarra.util.Eventos;
	import fl.events.ListEvent;
	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import org.pizarra.Data.Convert;
	import org.pizarra.util.Constantes;
	import flash.net.*;
	import org.pizarra.Common.Util;
	import org.pizarra.Entity.*;
	import org.pizarra.Animation.*;
	import flash.display.BitmapData;
	import org.pizarra.video.SimpleFlvWriter;
	import org.pizarra.Data.Exportador_PDF;
	import org.pizarra.configuracion.*;
	import flash.events.KeyboardEvent;
	import org.pizarra.Converters.ExerciseConverter;
	

	public class ExportController extends EventDispatcher{
		
		private var p: Pizarra;
		private var vista: ExportView;
		private var fileChooser: File = File.desktopDirectory;;
		private var loader: URLLoader;
		private var ejSeleccionado: String;
		private var ej: EjercicioBE;
		private var ex: ExerciseAnimation;
		private var bData:BitmapData;
		private var myWriter:SimpleFlvWriter = SimpleFlvWriter.getInstance();
		
		//	Filters
		private var videoFilter:FileFilter = new FileFilter("Vídeos", "*.flv");
		private var dbFilter:FileFilter = new FileFilter("Bases de Datos", "*.db");
		
		public function ExportController(piz: Pizarra, vist: ExportView): void{
			
			p = piz; vista = vist;
			Alert.init(p.stage);
			vista.BtnBack.addEventListener(MouseEvent.CLICK, volver);
			vista.btnPdf.addEventListener(MouseEvent.CLICK, pdf);
			vista.video.addEventListener(MouseEvent.CLICK, video);
			vista.db.addEventListener(MouseEvent.CLICK, exportDb);
			vista.piz.addEventListener(MouseEvent.CLICK, aPiz);
			vista.server.addEventListener(MouseEvent.CLICK, server);
			vista.grid.addEventListener(ListEvent.ITEM_CLICK, item_click);
			vista.query.addEventListener(KeyboardEvent.KEY_UP, txtBuscar_keyDown);
			init();
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init() {

		}
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		private function txtBuscar_keyDown(e: KeyboardEvent) {
			var query: String = vista.query.text;
			vista.gridEjercicios.Filter = query;
			vista.gridEjercicios.DataBind();
		}
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		private function item_click(e: ListEvent):void {
			
			//	Select the element
			var i: uint = e.rowIndex as uint;
			ejSeleccionado = vista.grid.dataProvider.getItemAt(i).ID;
			var tipo: String = vista.grid.dataProvider.getItemAt(i).Tipo;
			trace(vista.grid.dataProvider.getItemAt(i).Nombre);
			var isEjercicio:Boolean = (tipo == Constantes.S_JUGADA || tipo == Constantes.S_EJERCICIO);
			p.ejercicioSeleccionado = ejSeleccionado;
			
			vista.LoadQRImage(ejSeleccionado);
			var urlTerreno:String;
			if(isEjercicio){
				urlTerreno = p.hFondos[p.hEjercicios[p.ejercicioSeleccionado].fondo].url;
			}else {
				urlTerreno = p.hFondos[p.hDibujos[p.ejercicioSeleccionado].fondo].url;
			}
			vista.LoadThumbImage(urlTerreno);
			var obj: Object = new Object;
			if (isEjercicio) {
				var tmpEj: EjercicioBE = p.hEjercicios[p.ejercicioSeleccionado];
				obj.info = tmpEj.info;
				obj.fechaCreacion = tmpEj.fechaCreacion;
				obj.deporte = p.GetDeporteFromId(tmpEj.deporte).nombre;
			}else {
				var tmpDib:DibujoLibre = p.hDibujos[p.ejercicioSeleccionado];
				obj.info = tmpDib.info;
				obj.fechaCreacion = tmpDib.fechaCreacion;
				obj.deporte = p.GetDeporteFromId(tmpDib.deporte).nombre;
			}
			vista.UpdateInfoEjercicio(obj);
		}
		
		private function volver(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		
		private function pdf(event: Event){
			if(ejSeleccionado != null && ejSeleccionado != "" && p.hEjercicios[ejSeleccionado] != null){
				vista.IniciaAnimacion(p.hEjercicios[ejSeleccionado]);
				vista.MuestraPdf();
			}else{
				Alert.show("Ejercicio no seleccionado");
			}
		}
		
		private function video(event: Event){
			if(ejSeleccionado != null && ejSeleccionado != "" && p.hEjercicios[ejSeleccionado] != null){
				/*ej = p.hEjercicios[ejSeleccionado];
				ej.imprime_ejercicio();
				fileChooser.browseForSave("Video name");
				fileChooser.addEventListener(Event.SELECT,seleccionado);*/
				
				vista.MuestraVideo();
				vista.IniciaGeneracionVideo(p.hEjercicios[ejSeleccionado]);
				//ex = new ExerciseAnimation(ej, p.hFondos[ej.fondo], p.hElementos);
			}else{
				Alert.show("Ejercicio no seleccionado");
			}
		}
		
		public function seleccionado(ev:Event){
			
			var calidad: int = Settings.Calidad
				, duracion: int = 0
			 	, paso: Number = 1/calidad
				, act: Number = paso;
				
				
			bData = new BitmapData(800, 400, true);
			fileChooser.nativePath += ".flv";
			myWriter.createFile(fileChooser, 800, 400, calidad, duracion);
			
			ex = new ExerciseAnimation();
			ex.x = 40; ex.y = 40; 
			ex.Init(ej, p.hFondos[ej.fondo], p.hElementos, p.UnsortedAcciones);
			
			duracion = ex.Length
			vista.addChild(ex);
		}
		
		private function exportDb(e: Event): void {
			fileChooser.browseForSave("Database file");
			fileChooser.addEventListener(Event.SELECT,selForDb);
		}
		
		private function selForDb(e:Event):void {
			//var local:File = File.applicationDirectory.resolvePath("piz");
			var docs:File = File.documentsDirectory.resolvePath("piz/pizarra.db");
			docs.copyTo(new File(fileChooser.nativePath + ".db"), false);
		}
		
		private function aPiz(event: Event) {
			if(vista.grid.selectedIndex != -1){
				if(ejSeleccionado != null && ejSeleccionado != "" && p.hEjercicios[ejSeleccionado] != null){
					trace("nombre: " + p.hEjercicios[ejSeleccionado].nombre);
					var ej: XML;
					try{
						ej = ExerciseConverter.EjericioBeToXml(p.hEjercicios[ejSeleccionado]);
						escribeFichero(ej, p.hEjercicios[ejSeleccionado].nombre + ".piz");
					}catch(e: Error){
						Alert.show("Error exportado fichero" , { background:"blur" } );
						trace(e.getStackTrace());
					}
				}
				//fileChooser.browseForSave("Nombre del Ejercicio");
				//fileChooser.addEventListener(Event.SELECT, seleccionadoPiz);
			}else {
				Alert.show("Debe seleccionar primero un ejercicio", {background:"blur"});
			}
		}
		private function seleccionadoPiz(ev: Event) {
			var c: Convert = new Convert();
			var ej: XML;
			p.urlEjercicio = ev.target.nativePath;
			
			try{
				ej = ExerciseConverter.EjericioBeToXml(p.ejercicios[p.idEjercicio]);
				//ej =  c.ejericioAXML(p.ejercicios[p.idEjercicio]);
				escribeFichero(ej, p.urlEjercicio );
				Alert.show("Exportado Fichero " + vista.grid.selectedIndex + " a " + p.urlEjercicio , { background:"blur" } );
			}catch(e: Error){
				Alert.show("Error exportado fichero" , { background:"blur" } );
				trace(e.getStackTrace());
			}
		}
		private function escribeFichero(ej: XML, fichero: String) {
			
			var file:File = File.desktopDirectory.resolvePath( fichero);
			var stream:FileStream = new FileStream();
			stream.open( file, FileMode.WRITE );
			stream.writeUTFBytes( ej.toXMLString());
			stream.close();
			file = null; stream = null; 
			Alert.show("Fichero creado correctamente en:" + fichero, {background:"blur"});
		}
		private function server(event: Event) {
			comprueba_conexion();
		}
		private function comprueba_conexion(){
						
			var loader:URLLoader = new URLLoader();
			loader.load(new URLRequest(Settings.Server + "/" + Constantes.PING_URL));
			loader.addEventListener(Event.COMPLETE,
				function(evt: Event):void {
					if(evt.target.data == Constantes.PING_OK_ANSWER){
						exportaEjercicios();
					}else{
						Alert.show("Respuesta incorrecta");
					}
				}
			);
			loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR, io_error);			
						
			/*var loader:URLLoader = new URLLoader();
			loader.load(new URLRequest(Constantes.PING_URL));
			loader.addEventListener(Event.COMPLETE,
				function(evt: Event):void {
					if(evt.target.data == Constantes.PING_OK_ANSWER){
						
						
					}else{
						
					}
				}
			);
			loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR, io_error);*/
		}
		
		private function io_error(evt: Event):void {
			Alert.show("Error de conexión");
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
		
		//	EXPORTACIÓN
		private function exportaEjercicios() {
			
			var id: String = vista.se.SelectedId;
			
			if (id != null && id.length != 0) {
				
				//var ej: EjercicioBE = p.hEjercicios[id];
				//var data: XML = Util.EjercicioToXml(ej);
				var data: XML = ExerciseConverter.EjericioBeToXml(p.hEjercicios[ejSeleccionado]);
				trace("xml - " + data);
				trace(p.ejercicios[p.idEjercicio].nombre);
				// Point the request to the script that will handle the XML
				var request: URLRequest = new URLRequest( Constantes.EXERCISE_SERVICE_URL);
				// Set the data property to the dataToSave XML instance to send the XML
				// data to the server
				request.data = data;
				//request.data = variables;
				// Set the contentType to signal XML data being sent
				request.contentType = "text/xml";
				// Use the post method to send the data
				request.method = URLRequestMethod.POST;
			  
				// Create a URLLoader to handle sending and loading of the XML data
				loader= new URLLoader(  );
				// When the server response is finished downloading, invoke handleResponse
				loader.addEventListener( Event.COMPLETE, handleResponse );
				// Finally, send off the XML data to the URL
				loader.load( request );
			}
			
		}
		
		private function handleResponse(e: Event){
			trace("Loader.data");
			if (loader.data == "OK") {
				Alert.show("Ejercicio Exportado correctamente");
			}else {
				Alert.show("Error Exportando Ejercicio");
			}
			
		}
	}
}