﻿package org.pizarra.escenas.Controller{	

	import fl.accessibility.DataGridAccImpl;
	import flash.events.EventDispatcher;
    import flash.events.MouseEvent;	
	import flash.events.*;
	import fl.events.*;
	import org.pizarra.*;
	import org.pizarra.Data.*;
	import org.pizarra.util.*;
	import org.pizarra.graficos.Alert;
	import org.pizarra.util.Constantes;
	import org.pizarra.Entity.*;
	import org.pizarra.DAL.*;
	import org.pizarra.BLL.*;
	import org.pizarra.graficos.*;
	import org.pizarra.escenas.View.EjerciciosView;

	public class EjerciciosController extends EventDispatcher{
		
		private var p: Pizarra;
		private var ejercicios: EjerciciosView;
		private var ejSeleccionado: String;
		private var isEjercicio: Boolean;

		public function EjerciciosController(piz: Pizarra, ejer: EjerciciosView): void{
			
			this.p = piz;
			this.ejercicios = ejer;
			Alert.init(p.stage);
			ejercicios.BtnBack.addEventListener(MouseEvent.CLICK, volver);
			ejercicios.Delete.addEventListener(MouseEvent.CLICK, eliminar);
			ejercicios.Editar.addEventListener(MouseEvent.CLICK, editar);
			ejercicios.Variante.addEventListener(MouseEvent.CLICK, variante);
			ejercicios.Ver.addEventListener(MouseEvent.CLICK, ver);
			ejercicios.grid.addEventListener(ListEvent.ITEM_CLICK, item_click);
			ejercicios.grid.addEventListener(ListEvent.ITEM_DOUBLE_CLICK, item_dblclick);
			ejercicios.query.addEventListener(KeyboardEvent.KEY_UP, txtBuscar_keyDown);
		}
		//---------------------------------------------------------------------------------------//
		//		PUBLIC METHODS
		//---------------------------------------------------------------------------------------//
		public function init(){

		}
		
		//---------------------------------------------------------------------------------------//
		//		PRIVATE METHODS
		//---------------------------------------------------------------------------------------//
		
		
		
		//---------------------------------------------------------------------------------------//
		//		HANDLERS
		//---------------------------------------------------------------------------------------//
		//	Return
		private function volver(event: Event){
			dispatchEvent(new Event(Eventos.BACK));
		}
		private function buscar(event: Event) {
			var query: String = ejercicios.query.text;
			trace(query);
			ejercicios.gridEjercicios.Filter = query;
			ejercicios.gridEjercicios.DataBind();
		}
		
		private function eliminar(event: Event){
			var error: Boolean = false;
			if (isEjercicio) {
				error = eliminaEjercicio();
			}else {
				error = eliminaDibujo();
			}
			if (!error) {
				ejercicios.gridEjercicios.DataSource = EjerciciosBL.GetExercisesForGrid();
				ejercicios.gridEjercicios.DataBind();
				Alert.show("Ejercicio eliminado", {background:"blur"});
			}else {
				Alert.show("Error Eliminando Ejercicio", {background:"blur"});
			}
		}
		private function editar(event: Event) {
			dispatchEvent(new Event(Eventos.EDIT_EXERCISE));
		}
		private function variante(event: Event){
			//	Get the exercise
			var myEj:EjercicioBE = p.hEjercicios[p.ejercicioSeleccionado];
			var ej: EjercicioBE = EjerciciosBL.GetVariante(myEj);
			var DA = new EjercicioDA(p.bd.conexion);
			var msg = DA.writeExercise(ej);
			if (msg == "Ejercicio Insertado correctamente"){
				p.ejercicios.push(ej);
				p.hEjercicios[ej.id] = ej;
			}
			Alert.show(msg, {background:"blur"});
		}
		
		
		private function ver(event: Event) {
			//	Simulate double click event
			item_dblclick(null);
		}
		
		private function txtBuscar_keyDown(e: KeyboardEvent) {
			buscar(null);
		}
		
		//	EJERCICIOS
		private function item_click(e: ListEvent):void {
			//	Enable buttons
			ejercicios.Ver.Enable = true;
			ejercicios.Editar.Enable = true;
			ejercicios.Variante.Enable = true;
			ejercicios.Delete.Enable = true;
			p.urlEjercicio = "";
			
			//	Select the element
			var i: uint = e.rowIndex as uint;
			ejSeleccionado = ejercicios.grid.dataProvider.getItemAt(i).ID;
			var tipo: String = ejercicios.grid.dataProvider.getItemAt(i).Tipo;
			isEjercicio = (tipo == Constantes.S_JUGADA || tipo == Constantes.S_EJERCICIO);
			p.ejercicioSeleccionado = ejSeleccionado;
			
			//	Show Information
			ejercicios.LoadQRImage(ejSeleccionado);
			LoadTerrainThumb();
			
			var obj: Object = new Object;
			if (isEjercicio) {
				var tmpEj: EjercicioBE = p.hEjercicios[p.ejercicioSeleccionado];
				obj.info = tmpEj.info;
				obj.fechaCreacion = tmpEj.fechaCreacion;
				obj.deporte = p.GetDeporteFromId(tmpEj.deporte).nombre;
			}else {
				var tmpDib:DibujoLibre = p.hDibujos[p.ejercicioSeleccionado];
				obj.info = tmpDib.info;
				obj.fechaCreacion = tmpDib.fechaCreacion;
				obj.deporte = p.GetDeporteFromId(tmpDib.deporte).nombre;
			}
			ejercicios.UpdateInfoEjercicio(obj);
		}
		
		private function item_dblclick(e: ListEvent):void {
			//	Select Exercise
			p.ejercicioSeleccionado = ejSeleccionado;
			if (isEjercicio) {
				dispatchEvent(new Event(Eventos.SEE_EXERCISE));
			}else {
				dispatchEvent(new Event(Eventos.SEE_DRAWING));
			}
		}
		
		private function itemDib_click(e: ListEvent) {
			var i: uint = e.rowIndex as uint;
			//var id: String = sDibujos.dataGrid.dataProvider.getItemAt(i).ID;
			//p.seleccionaDibujo(id);
		}
		

		
		private function LoadTerrainThumb() {
			var urlTerreno:String;
			if(isEjercicio){
				urlTerreno = p.hFondos[p.hEjercicios[p.ejercicioSeleccionado].fondo].url;
			}else {
				urlTerreno = p.hFondos[p.hDibujos[p.ejercicioSeleccionado].fondo].url;
			}
			ejercicios.LoadThumbImage(urlTerreno);
			/*var img: Image 
				= new Image(urlTerreno, 100.0, 100);
			img.x = 750;
			img.y = 200;
			ejercicios.addChild(img);*/
		}
		//---------------------------------------------------------------------------------------//
		//		GETTERS AND SETTERS
		//---------------------------------------------------------------------------------------//
		
		
		private function eliminaEjercicio():Boolean {
			try {
				
				var ejerciciosDA: EjercicioDA = new EjercicioDA(p.bd.conexion);
				var ej:EjercicioBE = p.hEjercicios[ejSeleccionado];
				ejerciciosDA.removeExercise(ej);
				//	Elimina el ejercicio seleccionado de la base de datos
				//p.bd.elimina_ejercicio(p.ejercicioSeleccionado);
				//	Lo elimina del array de ejercicios
				//var ej:Ejercicio = p.hEjercicios[p.ejercicioSeleccionado];
				p.ejercicios.splice( p.ejercicios.indexOf(ej) , 1);
				//	Lo elimina del hash de ejercicios
				delete p.hEjercicios[p.ejercicioSeleccionado];
				//	Lo elimina del grid
				//ejercicios.gridEjercicios.nuevos_datos(p.ejercicios);
				//	Update Grid
				return false;
			}
			catch (error) {
				trace("Error :" + error.message +" Details: " + error.details);	
				return true;
			}
			return true;
		}
		
		private function eliminaDibujo():Boolean {
			try{
				//	Elimina el ejercicio seleccionado de la base de datos
				p.bd.deleteDibujoLibre(ejSeleccionado);

				//	Lo elimina del array de dibujos
				var dib: DibujoLibre = p.hDibujos[p.ejercicioSeleccionado];
				p.dibujos.splice( p.dibujos.indexOf(dib) , 1);
				//	Lo elimina del hash de dibujos
				delete p.hDibujos[p.ejercicioSeleccionado];
				//	Lo elimina del grid
				//ejercicios.gridDibujos.nuevos_datos(p.dibujos);
				return false;
			}
			catch (error) {
				trace("Error :" + error.message +" Details: " + error.details);	
				return true;
			}
			return true;
		}
		
		
	}
}