﻿package org.pizarra{	
	
	import fl.controls.ComboBox;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.geom.Point;
	import org.pizarra.util.GUID;
	import org.pizarra.util.Constantes;
	import org.pizarra.util.Ficheros;
	import flash.filesystem.*;
	import flash.utils.Dictionary;
	
	public class Util{
		
		
		public static function posiciona(obj: Object, x: int, y: int, ancho: int, alto: int){
			obj.x = x;
			obj.y = y;
			obj.width = ancho;
			obj.height = alto;
		}
		
		public static function setBackground(obj: Object, color: int,borderWidth: int, borderColor: int, rounded: Boolean = false){
			
			//obj.graphics.lineStyle(borderWidth, borderColor);
			obj.graphics.beginFill(color);
			if(rounded)
            	obj.graphics.drawRoundRect(0, 
										   0, 
										   obj.width, 
										   obj.height, 
										   Constantes.ROUND, 
										   Constantes.ROUND);
            else
				obj.graphics.drawRect(0, 0, obj.width, obj.height);
			obj.graphics.endFill();
		}
		//	"macro" that writes in the terminal the message passed as a paremter depending of DEBUG value
		public static function subTrace(mensaje: String){	
			
			//	Output message
			if (Constantes.DEBUG) trace(mensaje);
			//	Write to log
			/*var str:String = "Hello\n" + 
					"World\n";
			str = str.replace(/\n/g, File.lineEnding);*/
			var output: String = new Date().toString() + " -> " + mensaje + File.lineEnding;
			var file:File = File.documentsDirectory.resolvePath("piz/log.txt");
			var fileStream:FileStream = new FileStream();
			fileStream.open(file, FileMode.APPEND);
			fileStream.writeUTF(output);
			fileStream.close();
		}
		
		public static function alert(mensaje:String, elemento):void {
			//Alert.show("Select a color:", "Color Selection", Alert.YES|Alert.NO|Alert.CANCEL, elemento);
		}
		
		public static function nuevoId():String {
			return GUID.create();
		}
		
		public static function loadAndAssignButton(url: String, container: Sprite, p: Point) {
			var l: Loader = new Loader();
			l.load(new URLRequest(url));
			container = new Sprite();
			container.addChild(l);
			container.buttonMode = true;
			container.x = p.x;
			container.y = p.y;
		}
		
		public static function toUrl(url: String):String {
			return Ficheros.BASE_URL + url;
		}
		
		public static function IsDictionaryEmpty(dict: Dictionary): Boolean{
			for (var key:Object in dict){ return false; }
			return true;
		}
		
		public static function findItemIndex (element: ComboBox, dataString:String):int {
			var index:int = 0;
			for (var i = 0; i < element.length; i++) {
				if (element.getItemAt(i).data.toString() == dataString) {
					index = i;
					break;
				}
			}
			return index;
		}
		
	}
	
}