﻿package org.pizarra{	

	import flash.text.TextFormat;
	import flash.utils.Dictionary;
	import org.pizarra.configuracion.Preferencias;
	import org.pizarra.Data.Base_Datos;
	import org.pizarra.Data.DibujoLibre;
	import org.pizarra.Util;
	import org.pizarra.util.Constantes;
	import org.pizarra.graficos.Fondo;
	import org.pizarra.Ejercicio;
	import flash.filesystem.File;
	import flash.display.Stage;
	import org.pizarra.configuracion.Tema;
	//import org.pizarra.io.*;
	import org.pizarra.DAL.*;
	import org.pizarra.Entity.*;
	
	public class Pizarra{
		
		private var _pref: Preferencias;			//	Preferencias del usuario
		private var _bd : Base_Datos;				//	Objeto de la base de datos
		private var _deportes :Array;				//	Almacena los deportes disponibles
		public static var _ejercicios: Array; 			//	Almacena las cabeceras de los ejercicios
		private var _el_estaticos_deportes: Array;	//	Elementos asociados a los deportes
		private var _el_dinamicos_deportes: Array;
		private var _fondos_deportes: Array;		//	Fondos asociados a los deportes
		private var _elementos: Array;
		private var _jugadores: Array;
		private var _stage: Stage;
		public static var _dibujosLibres: Array;
		private var _hashDibujos: Dictionary;
		private var _hashFondos: Dictionary;
		private var _hashElementos: Dictionary;
		private var _hashEjercicios: Dictionary;
		private var _hashJugadores: Dictionary;
		private var _hashAcciones: Dictionary;
		private var _hashUnsortedActions: Dictionary;
		private var _ej: Ejercicio;
		private var _temas: Array;
	//	preEdicion
		//	Ejercicio
		private var _dep_select: uint;
		private var _terr_select: uint;
		private var _deporteSeleccionado: String;
		private var _nombre: String;
		private var _informacion: String;
		private var _tipo_ejercicio: String;
		//	Dibujo
		private var _nuevoDibujo: DibujoLibre = new DibujoLibre();
		private var _nuevoEjercicio: Ejercicio;
		
		//	visor
		private var _url_fichero: String;
		private var _id_ejercicio: uint;
		private var _dibujoSeleccionado: String;
		private var _ejercicioSeleccionado: String;
		
		//	Settings
		private var _environment: String;
		private var _log: String;
		private var _exceptionLog: String;
		
		//	settings
		
		public function Pizarra(base: Base_Datos): void{
			this._bd = base;
			_deportes = new Array();
			_el_estaticos_deportes = new Array();
			_el_dinamicos_deportes = new Array();
			_fondos_deportes = new Array();
			_elementos = new Array();
			_jugadores = new Array();
			_dibujosLibres = new Array();
			_temas = new Array();
		}
		
		public function init():Boolean{
			
			var error: Boolean = true;
			try{
				pref = _bd.get_preferencias();
				//_deportes = _bd.lee_deportes();		
				var deportesDA: DeporteDA = new DeporteDA(bd.conexion);
				_deportes = deportesDA.getDeportes();	//	Retrieve sports
				_hashFondos = deportesDA.leeHFondos();
				/*_ejercicios = _bd.lee_ejercicios();	//	Retrieve exercises
				for each (var ej in ejercicios) {	//
					ej = _bd.lee_ejercicio(ej.id,ej);	
					//ej.imprime_ejercicio();
				}*/
				var ejerciciosDA: EjercicioDA = new EjercicioDA(bd.conexion);
				_ejercicios = ejerciciosDA.selectEjercicios();
				
				var elementosDA: ElementoDA = new ElementoDA(bd.conexion);
				_el_estaticos_deportes = elementosDA.getElementosEstaticos(_deportes);
				_el_dinamicos_deportes = elementosDA.getElementosDinamicos(_deportes);
				_elementos = _bd.lee_elementos(_deportes);						//
				_jugadores = _bd.lee_jugadores();								//
				_fondos_deportes = _bd.lee_fondos(deportes);						//
				_dibujosLibres = bd.lee_dibujosLibres();
				parseDibujos();

				
				parseEjercicios();
				var temasDA: TemaDA = new TemaDA(_bd.conexion);
				_temas = temasDA.getTemas();
				cargaTema();
				var accionesDA: AccionDA = new AccionDA(_bd.conexion);
				_hashAcciones = accionesDA.GetAccionesDictionary();
				_hashUnsortedActions = accionesDA.GetUnsortedAccionesDictionary();
			}
			catch ( error:Error ){
				Util.subTrace(error.message + ' ' + error.getStackTrace());
				throw new Error(error.message); 
				return false;
			}
			
			Util.subTrace("Objeto pizarra inicializado correctamente");
			return error;
		}
		
		//***		PUBLIC FUNCTIONS		**//
		
		public function GetDeporteFromId(id: String): DeporteBE {
			for (var i = 0; i < _deportes.length; i += 1) {
				if (_deportes[i].id == id) {
					return _deportes[i];
				}
			}
			return null;
		}
		
		public function resuelveConflictosenImagenes(): void{
			
			var i: int;
			_hashElementos = new Dictionary();
			for(i=0; i < deportes.length; i++){
				resuelveConflictosEstaticos(i);
				resuelveConflictosDinamicos(i);
				resuelveConflictosFondos(i);				
			}
			parseJugadores();
		}
		
		public function recarga() {
			_deportes = new Array();
			_el_estaticos_deportes = new Array();
			_el_dinamicos_deportes = new Array();
			_fondos_deportes = new Array();
			_elementos = new Array();
			_jugadores = new Array();
			_dibujosLibres = new Array();
			trace("todo borrado");
			init();
		}
		
		//***		PRIVATE FUNCTIONS		**//
		
		//	stores the default static object image in the dataSet if the file doesn't exist
		private function resuelveConflictosEstaticos(i: int){
			
			var fichero_aux: File;
			var j: int;
			
			for (j=0; j< _el_estaticos_deportes[i].length; j++){
				fichero_aux = new File( _el_estaticos_deportes[i][j].imagen);
				//Util.subTrace("Loading: " + _el_estaticos_deportes[i][j].imagen);
				if(!fichero_aux.exists){
					Util.subTrace("sustituye " + _el_estaticos_deportes[i][j].imagen);
					_el_estaticos_deportes[i][j].imagen = Constantes.ELEMENTO_GENERICO;
				}
				_hashElementos[_el_estaticos_deportes[i][j].id] = _el_estaticos_deportes[i][j];
				//trace("id: " + _el_estaticos_deportes[i][j].id);
			}
		}
		
		//	stores the default static object image in the dataSet if the file doesn't exist
		private function resuelveConflictosDinamicos(i: int){
			
			var fichero_aux: File;
			var j: int;
			
			for (j=0; j< _el_dinamicos_deportes[i].length; j++){
				fichero_aux = new File(_el_dinamicos_deportes[i][j].imagen);
				//Util.subTrace("Loading: " + _el_dinamicos_deportes[i][j].imagen);
				if(!fichero_aux.exists){
					Util.subTrace("sustituye " + _el_dinamicos_deportes[i][j].imagen);
					_el_dinamicos_deportes[i][j].imagen = Constantes.ELEMENTO_GENERICO;
				}
				_hashElementos[_el_dinamicos_deportes[i][j].id] = _el_dinamicos_deportes[i][j];
				//trace("id: " + _el_dinamicos_deportes[i][j].id);
			}
		}
		
		private function resuelveConflictosFondos(i: int){
			
			var i, j: int;
			var fichero_aux, fichero_aux2: File;
			
			for (j=0; j< _fondos_deportes[i].length; j++){
				
				fichero_aux = new File(_fondos_deportes[i][j].url);
				fichero_aux2 = new File(_fondos_deportes[i][j].url_thumb);
				if(!fichero_aux.exists || !fichero_aux2.exists){
					trace("sustituyo fondo por generico");
					_fondos_deportes[i][j].url = Constantes.FONDO_GENERICO;
				}
			}
		}
		
		public function parseJugadores() {
			
			_hashJugadores = new Dictionary();
			for each(var j: Jugador in _jugadores) {
				_hashJugadores[j.id] = j;
				var e: ElementoBE = new ElementoBE(	j.id,
												j.nombre,
												Constantes.TIPO_ESTATICO,
												j.url,
												Constantes.ANCHO_JUGADOR,
												Constantes.ALTO_JUGADOR);
				_hashElementos[e.id] = e;
			}
		}
		
		public function parseEjercicios() {
			_hashEjercicios = new Dictionary;
			for each(var ej: EjercicioBE in _ejercicios) {
				_hashEjercicios[ej.id] = ej;
			}
		}
		public function get hJugadores(): Dictionary {	return _hashJugadores; }
		public function get hEjercicios(): Dictionary {	return _hashEjercicios; }
		public function set ejercicioSeleccionado(ejId: String) { _ejercicioSeleccionado = ejId; }
		public function get ejercicioSeleccionado():String { return _ejercicioSeleccionado; }
		
		public function get Acciones(): Dictionary { return _hashAcciones; }
		public function get UnsortedAcciones(): Dictionary { return _hashUnsortedActions; }
		
		//***		GETTERS Y SETTERS		**//
		public function get bd(): Base_Datos { return _bd; }
		public function set bd(base: Base_Datos){ _bd = base; }
		public function get pref(): Preferencias{ return _pref; }
		public function set pref(p: Preferencias): void{ _pref = p; }
		public function get deportes(): Array{ return _deportes; }
		public function get ejercicios(): Array{ return _ejercicios; }
		public function get elementos(): Array{ return _elementos; }
		public function get estaticos(): Array{ return _el_estaticos_deportes; }
		public function get dinamicos(): Array{ return _el_dinamicos_deportes; }
		public function get fondos(): Array{ return _fondos_deportes; }
		public function get jugadores(): Array { return _jugadores; }
		public function get dibujos(): Array { return _dibujosLibres; }
		public function get temas(): Array{ return _temas; }
		public function set temas(value: Array): void{ _temas = value; }
		
		public function get ej(): Ejercicio { return _ej; }
		public function set ej( ejer: Ejercicio): void { _ej = ejer; }
		
		//	PreEditor
		public function get dep_select(): uint{ return _dep_select; }
		public function set dep_select(n: uint): void { _dep_select = n; }
		
		public function get deporteSeleccionado(): String{ return _deporteSeleccionado; }
		public function set deporteSeleccionado(val : String): void{ _deporteSeleccionado = val; }
		
		public function get terr_select(): uint{ return _terr_select; }
		public function set terr_select(n: uint): void{ _terr_select = n; }
		public function get nombre(): String { return _nombre; }
		public function set nombre(n: String): void { _nombre = n; }
		public function get informacion(): String { return _informacion; }
		public function set informacion(info: String): void{ _informacion = info; }
		public function get tipo_ejercicio(): String{ return _tipo_ejercicio; }
		public function set tipo_ejercicio(n: String): void{ _tipo_ejercicio = n; }
		
		//	Settings
		public function get Environment(): String { return _environment; }
		public function set Environment(value: String): void{ _environment = value; }
		public function get Log():String { return _log; }
		public function set Log(value: String): void{ _log = value; }
		public function get ExceptionLog(): String { return _exceptionLog; }
		public function set ExceptionLog(value: String): void { _exceptionLog = value; }
		
		//	For the alerts
		public function set stage(s: Stage): void{ _stage = s; }
		public function get stage(): Stage{ return _stage; }
		
		//	Editor
		public function get fondoSeleccionado(): FondoBE {
			//return fondos[_dep_select][_terr_select];
			return _deportes[_dep_select].fondos[_terr_select];
		}
		
		/*
		 *	STATIC 
		 **/
		//public static function get Ejercicios(): Array { return _ejercicios; }
		
		///////////////////
		//	<FONDOS>
		///////////////////
		public function parseFondos() {
			
			_hashFondos = new Dictionary();
			/*for each(var fondos: Array in _fondos_deportes) {
				for each(var fondo: Fondo in fondos) {
					_hashFondos[fondo.id] = fondo;
					trace("nuevo id fondo: " +fondo.id + fondo.url);
				}
			}*/
			trace("l1 " + _fondos_deportes.length);
			trace(_fondos_deportes[0]);
			for(var i: int = 0; i < _fondos_deportes.length; i++ ) {
				var fondos = _fondos_deportes[i];
				trace("l2 " + fondos.length);
				for (var j: int = 0; j < fondos.length; j++ ) {
					var fondo: Fondo = fondos[j];
					_hashFondos[fondo.id] = fondo;
					trace("nuevo id fondo: " +fondo.id + fondo.url);
				}
			}
		}
		public function get hFondos(): Dictionary {
			return _hashFondos;
		}
		
		///////////////////
		//	</FONDOS>
		///////////////////
		
		///////////////////
		//	<DIBUJOS>
		///////////////////
		public function parseDibujos() {
			
			_hashDibujos = new Dictionary();
			for each(var d: DibujoLibre in _dibujosLibres) {
				_hashDibujos[d.id] = d;
			}
		}
		
		/*public function get dibujoSeleccionado(): DibujoLibre {
			return _hashDibujos[_dibujoSeleccionado];
		}*/
		
		public function get hDibujos(): Dictionary {
			return _hashDibujos;
		}
		
		public function seleccionaDibujo(id: String):void {
			_dibujoSeleccionado = id;
		}
		///////////////////
		//	</DIBUJOS>
		///////////////////
		public function get hElementos(): Dictionary {
			return _hashElementos;
		}
		
		public function cargaTema() {
			_temas[0].select();
			
			//	carga el formato de las labels
			var myFormat: TextFormat = new TextFormat();
			myFormat.size = Tema.lblSize;
			myFormat.color = Tema.lblColor;
			myFormat.font = "Arial Bold";
			Tema.formatoLabel = myFormat;
		}
		
		//	Visor
		public function set urlEjercicio(url: String): void {_url_fichero = url;}
		public function get urlEjercicio(): String {return _url_fichero; }
		public function set idEjercicio(id: uint): void {_id_ejercicio = id; }
		public function get idEjercicio(): uint {return _id_ejercicio;}
		public function get fondoEjercicio(): Fondo {return _fondos_deportes[_ej.nDeporte][_ej.fondo];}
		public function GetFondoDeDibujo(deporte: String, fondo:String):Fondo {
			return _fondos_deportes[deporte][fondo];
		}
		
		//	PRE
		public function get nuevoDibujo():DibujoLibre { return _nuevoDibujo;  }
	}
	
}