﻿/*
 * 		MAIN  MAIN
 * */

package org.pizarra
{
	import flash.display.Sprite;
	import flash.filesystem.File;
	import flash.net.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.InvokeEvent;
	import flash.desktop.NativeApplication;
		
	//	importo clases propias
	import org.pizarra.Data.Base_Datos;
	import org.pizarra.util.Registrador_Interfaz;
	import org.pizarra.Data.Importador;
	import org.pizarra.Data.Importador_DB;
	import org.pizarra.configuracion.Preferencias;
	import org.pizarra.Ejercicio;
	import org.pizarra.graficos.Selector_Ejercicios;
	import org.pizarra.graficos.CoolButton;
	import org.pizarra.Pizarra;
	import org.pizarra.Util;
	import org.pizarra.util.Eventos;
	import org.pizarra.graficos.Alert;
	
	import org.pizarra.escenas.View.*;
	import org.pizarra.escenas.Controller.*;
	import org.pizarra.escenas.Model.*;
	import org.pizarra.escenas.editor.*;
	
	import org.pizarra.Exceptions.PizarraException;
	import org.pizarra.escenas.View.ThemeView;
	import org.pizarra.escenas.Controller.ThemeController;
	
	public class Main extends Sprite 
	{
		private var flvVisorView: FlvVisorView;
		private var flvVisorController: FlvVisorController;
		private var visorView: VisorView;
		private var visorController: VisorController;
		private var visorDibujosView: VisorDibujosView;
		private var visorDibujosController: VisorDibujosController;
		private var settingsView: SettingsView;
		private var settingsController: SettingsController;
		private var themeView: ThemeView;
		private var themeController: ThemeController;
		private var ejerciciosView: EjerciciosView;
		private var ejerciciosController: EjerciciosController;
		private var preEditorView: PreEditorView;
		private var preEditorController: PreEditorController;
		private var editorView: EditorView;
		private var editorController: EditorController;
		private var editorModel: EditorModel;
		private var freeEditorView: FreeEditorView;
		private var freeEditorController: FreeEditorController;
		private var freeEditorModel: FreeEditorModel;
		private var exportController: ExportController;
		private var exportView: ExportView;
		private var importController: ImportController;
		private var importView: ImportView;
		private var jugadoresView: PlayersView;
		
		private var fichero_data: String;
		
		var cargaVista: CargaView = new CargaView();
		var p: Pizarra;
		var bd : Base_Datos;			//	Objeto de la base de datos
		var menuView: MenuView;
			
		public function Main()
		{
			Init();
			
			
			//---------------------------------------------------------------------------------------//
			//		Pizarra model object
			//---------------------------------------------------------------------------------------//
			cargaVista.texto = "Inicializando datos de la aplicación";
			//	We crate the p object as a model for most of the data of the aplication
			p = new Pizarra(bd);	
			p.init();			//	Initialize the component with data from database
			cargaVista.texto = "Cargados los datos de la aplicación";
			cargaVista.texto = "Resolviendo conflictos";
			p.resuelveConflictosenImagenes();
			p.stage = stage;
			cargaVista.texto = "Conflictos Resueltos";
				//---------------------------------------------------------------------------------------//
			//		Create and load menu view
			//---------------------------------------------------------------------------------------//
			//	If we reached that point means that the loading went well and we must display the menu
			cargaVista.texto = "Carga completada";
			removeChild(cargaVista);	//	Remove the loading view
			cargaVista = null;			//	Dispose memory from the loading view
			menuView = new MenuView(p);
			menuView.salir.addEventListener(MouseEvent.CLICK, salir);
			menuView.ejercicios.addEventListener(MouseEvent.CLICK , ejercicios);
			menuView.nuevo.addEventListener(MouseEvent.CLICK , nuevo);
			menuView.player.addEventListener(MouseEvent.CLICK , player);
			menuView.jugadores.addEventListener(MouseEvent.CLICK , jugadores);
			menuView.abrir.addEventListener(MouseEvent.CLICK , abrir);
			menuView.exportar.addEventListener(MouseEvent.CLICK , exportar);
			menuView.importar.addEventListener(MouseEvent.CLICK , importar);
			menuView.free.addEventListener(MouseEvent.CLICK , freeEdit);
			menuView.settings.addEventListener(MouseEvent.CLICK , settings);
			menuView.tema.addEventListener(MouseEvent.CLICK, BtnTema_Click);
			addChild(menuView);
			Alert.init(p.stage);
			NativeApplication.nativeApplication.addEventListener(InvokeEvent.INVOKE, onInvoke);	
		}
		
/*
 *	<PRIVATE_FUNCTIONS> 
 */
	//	Init the App
	private function Init() {
		
		NativeApplication.nativeApplication.addEventListener(InvokeEvent.INVOKE, onInvoke);
		//	Create the loading view
		createLoadingView();
		checkReferences();
		startDatabase();
	}
	//		Create and load loading view
	private function createLoadingView() {
		addChild(cargaVista);
		cargaVista.texto = "Creando variables del programa";
	}
	//	Check paths to the files to create the app filesystem structure
	private function checkReferences() {
		cargaVista.texto = "Comprobando referencias de directorios y ficheros";
		if(! File.documentsDirectory.resolvePath("piz").exists){	//	Folder doesn't exist	
			//	Se debe copiar los elementos de la aplicación
			var local:File = File.applicationDirectory.resolvePath("piz");
			var docs:File = File.documentsDirectory.resolvePath("piz");
			local.copyTo(docs,false);
			Util.subTrace("Copiados los documentos");
		}else{							//	Aplicación ya inicializada
			Util.subTrace("existe el directorio " + File.documentsDirectory.resolvePath("piz").nativePath);
		}
		//	Load preferences
			var myLoader:URLLoader = new URLLoader();
			myLoader.load(new URLRequest(File.documentsDirectory.resolvePath("piz").resolvePath("App.Config").nativePath));
			myLoader.addEventListener(Event.COMPLETE, processXML);
			
			cargaVista.texto = "Referencias de directorios y ficheros correctas";		
	}
	
	private function processXML(e:Event):void {
		try{
			var myXML:XML = new XML(e.target.data);
			p.Environment = myXML.Environment;
			p.Log = myXML.Log;
			p.ExceptionLog = myXML.ExceptionLog;
		} catch (e: PizarraException) {
			trace("Error loading preferences");
		}
	}	
	//	Connects to the database
	private function startDatabase() {
		cargaVista.texto = "Conectando con la base de datos";
		try{
			bd = new Base_Datos("pizarra.db",cargaVista);
		}catch(error: Error){
			Util.subTrace("Error al iniciar la base de datos");
			cargaVista.texto = "Error fatal, no se pudo acceder a la base de datos."
			return ;
		}
		cargaVista.texto = "Conexión realizada correctamente";	
	}
	
	
/*
 *	</PRIVATE FUNCTIONS> 
 */
		 	 
/*
 *	<HANDLERS> 
 */
		function salir(event:Event) {	NativeApplication.nativeApplication.exit(0);	}
		 
/*
 *	</HANDLERS> 
 */
		  
		
	
	function player(event:Event){	
		removeChild(menuView);
		flvVisorView = new FlvVisorView(p);
		flvVisorController = new FlvVisorController(p,flvVisorView);
		flvVisorController.init();
		flvVisorController.addEventListener("volver", volverflvVisor);
		addChild(flvVisorView);
	}
	function abrir(event:Event){	
		var f: File = File.desktopDirectory;
		var filtro:FileFilter = new FileFilter("Ejercicios", "*.piz");
		f.browseForOpen("Ejercicios de pizarra",[filtro]);
		f.addEventListener(Event.SELECT, seleccionado_piz);
	}
	function seleccionado_piz(e:Event){
		p.urlEjercicio = e.target.nativePath;
		removeChild(menuView);
		visorView = new VisorView(p);
		visorView.addEventListener(Eventos.BACK, volverVisor);
		visorController = new VisorController(p,visorView);
		//visorController.addEventListener(Eventos.BACK, volverVisor);
		addChild(visorView);
	}
	function visor(event: Event){
		removeChild(ejerciciosView);
		visorView = new VisorView(p);
		visorView.addEventListener(Eventos.BACK, volverVisor);
		visorController = new VisorController(p,visorView);
		//visorController.addEventListener(Eventos.BACK, volverVisor);
		addChild(visorView);
	}
	function visorDibujos(event: Event){
		removeChild(ejerciciosView);
		visorDibujosView = new VisorDibujosView(p);
		visorDibujosController = new VisorDibujosController(p,visorDibujosView);
		visorDibujosView.addEventListener(Eventos.BACK, volverVisorDibujos);
		addChild(visorDibujosView);
	}
	function settings(event:Event){	
		removeChild(menuView);
		settingsView = new SettingsView(p); 
		settingsView.addEventListener(Eventos.BACK, volverSettings);
		addChild(settingsView);
	}
	
	function BtnTema_Click(e: MouseEvent){
		this.removeChild(menuView);
		themeView = new ThemeView(p);
		themeView.addEventListener(Eventos.BACK, volverTheme);
		this.addChild(themeView);
	}
	
	function ejercicios(event:Event){	
		removeChild(menuView);
		ejerciciosView = new EjerciciosView(p);
		ejerciciosController = new EjerciciosController(p,ejerciciosView);
		ejerciciosController.init();
		ejerciciosController.addEventListener(Eventos.BACK, volverEjercicios);
		ejerciciosController.addEventListener(Eventos.SEE_EXERCISE, visor);
		ejerciciosController.addEventListener(Eventos.SEE_DRAWING, visorDibujos);
		ejerciciosController.addEventListener(Eventos.EDIT_EXERCISE, editaDesdeEjercicios);
		addChild(ejerciciosView);
	}
	function nuevo(event:Event){	
		removeChild(menuView);
		preEditorView = new PreEditorView(p);
		preEditorController = new PreEditorController(p, preEditorView);
		preEditorController.init();
		preEditorController.addEventListener("volver", volverPreEditor);
		preEditorController.addEventListener(Eventos.CREAR_EJERCICIO, crearEditor);
		preEditorController.addEventListener(Eventos.CREAR_DIBUJO, crearFreeEditor);
		addChild(preEditorView);
	}
	function editaDesdeEjercicios(event:Event) {	
		removeChild(ejerciciosView);
		editorModel = new EditorModel(p);
		editorView = new EditorView(editorModel);
		editorController = new EditorController(p, editorView);
		editorController.init();
		editorController.addEventListener("volver", volverEditor);
		addChild(editorView);
		addChild(ejerciciosView);
	}
	
	function freeEdit(event:Event){	
		removeChild(menuView);
		editorModel = new EditorModel(p);
		freeEditorView = new FreeEditorView(editorModel);
		freeEditorController = new FreeEditorController(p, freeEditorView);
		freeEditorController.init();
		freeEditorController.addEventListener("volver", volverFreeEditor);
		freeEditorController.addEventListener("crear", crearFreeEditor);
		addChild(freeEditorView);
	}
	function exportar(event: Event){
		removeChild(menuView);
		exportView = new ExportView(p);
		exportController = new ExportController(p,exportView);
		exportController.addEventListener(Eventos.BACK, volverExportar);
		addChild(exportView);
	}
	function importar(event: Event){
		removeChild(menuView);
		importView = new ImportView(p);
		//importController = new ImportController(p,importView);
		importView.addEventListener(Eventos.BACK, volverImportar);
		addChild(importView);
	}
	function jugadores(event:Event){	
		removeChild(menuView);
		jugadoresView = new PlayersView(p); 
		jugadoresView.addEventListener(Eventos.BACK, volverJugadores);
		addChild(jugadoresView);
	}
	//---------------------------------------------------------------------------------------//
	//		Swap views
	//---------------------------------------------------------------------------------------//
	function volverflvVisor(event: Event){
		removeChild(flvVisorView);
		addChild(menuView);
	}
	function volverVisor(event: Event){
		removeChild(visorView);
		addChild(menuView);
	}
	function volverVisorDibujos(event: Event){
		removeChild(visorDibujosView);
		addChild(menuView);
	}
	function volverSettings(event: Event){
		removeChild(settingsView);
		addChild(menuView);
	}
	function volverTheme(event: Event){
		this.removeChild(themeView);
		addChild(menuView);
	}
	function volverEjercicios(event: Event){
		removeChild(ejerciciosView);
		addChild(menuView);
	}
	function volverPreEditor(event: Event){
		removeChild(preEditorView);
		addChild(menuView);
	}
	function volverEditor(event: Event){
		removeChild(editorView);
		addChild(menuView);
	}
	function volverFreeEditor(event: Event){
		removeChild(freeEditorView);
		addChild(menuView);
	}
	function volverJugadores(event: Event){
		removeChild(jugadoresView);
		addChild(menuView);
	}
	function crearEditor(event: Event){
		removeChild(preEditorView);
		editorModel = new EditorModel(p);
		editorView = new EditorView(editorModel);
		editorController = new EditorController(p, editorView);
		editorController.init();
		editorController.addEventListener("volver", volverEditor);
		addChild(editorView);
	}
	function crearFreeEditor(event: Event){
		removeChild(preEditorView);
		editorModel = new EditorModel(p);
		freeEditorView = new FreeEditorView(editorModel);
		freeEditorController = new FreeEditorController(p, freeEditorView);
		freeEditorController.init();
		freeEditorController.addEventListener("volver", volverFreeEditor);
		addChild(freeEditorView);
	}
	function volverExportar(event: Event){
		removeChild(exportView);
		addChild(menuView);
	}
	function volverImportar(event: Event){
		removeChild(importView);
		addChild(menuView);
	}
	//	Gestión de la llamada de la aplicación
	function onInvoke(event:InvokeEvent):void{
		
		fichero_data = "C:/Users/Pots/Desktop/bbb.piz8888";
		if(event.arguments.length > 0){
			fichero_data = event.arguments[0];
			switch(fichero_data.split(".")[fichero_data.split(".").length-1]){
				case "piz":	Util.subTrace("Argumento: fichero piz");
							Alert.show("Desea importar el fichero?", {background:"blur", buttons:["Sí", "No"], callback:handleResponse});
							//p.urlEjercicio = fichero_data;
							//removeChild(menuView);
							//visorView = new VisorView(p);
							//visorView.addEventListener(Eventos.BACK, volverVisor);
							//visorController.addEventListener(Eventos.BACK, volverVisor);
							//addChild(visorView);
							break;
				case "pizd": Util.subTrace("Argumento: fichero pizd");
							p.urlEjercicio = fichero_data;
							break;
				case "flv":	Util.subTrace("Argumento: fichero flv");
							break;
				default:	Util.subTrace("Argumento: fichero no soportado");
							Alert.show("Fichero Incorrecto", {background:"blur"});
							
			}
		}
	}
	
	function handleResponse(response:String):void {
		if (response == "Sí") {
			trace("si");
		}
		
		if (response == "No") {
			p.urlEjercicio = fichero_data;
			removeChild(menuView);
			visorView = new VisorView(p);
			visorView.addEventListener(Eventos.BACK, volverVisor);
			//visorController.addEventListener(Eventos.BACK, volverVisor);
			addChild(visorView);
		}
	}
	}
}