﻿package org.pizarra.data{	

	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import flash.net.*;
	import flash.events.*;
	import org.pizarra.data.Base_Datos;
	import org.pizarra.Elemento;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	import org.pizarra.graficos.Fondo;
	
	public class Importador_DB extends EventDispatcher{
		
		private var db: Base_Datos;
		private var base: int;
		private var deporte: String;
		private var _errores: String;
		private var ej: Ejercicio;
		private var _fichero: String;
		
		public function Importador_DB( base: Base_Datos ): void{
			db = base;
		}
		
		public function carga(fichero: String){
			_fichero = fichero;
			var myLoader:URLLoader = new URLLoader();
			myLoader.load(new URLRequest(fichero));
			myLoader.addEventListener(Event.COMPLETE, procesa_XML);	
		}
		
		function procesa_XML(e:Event):void {
		
			var xml: XML;
			try{
				xml = new XML(e.target.data);
				switch(String(xml.type)){
					case "deporte": trace("importamos deporte");
									importa_deporte(xml.deporte);
									break;
					case "Ejercicio": trace("importa ejercicio");
									importa_ejercicio(xml.ejercicio);
									break;
					default:		trace("erroneo");
				}
			} catch (e:TypeError) {
            	_errores = "No se pudo parsear el XML\n" + e.message;
				this.dispatchEvent(new Event("error_XML"));
         	}
		}
		
		
		//		DEPORTE
		private function importa_deporte(dep: XMLList){
			if(db.existe_deporte(dep.nombre) == false){
				importa_meta(dep);
				importa_imagenes(dep);
				importa_elementos(dep.elementos);
				importa_fondos(dep.fondos);
				this.dispatchEvent(new Event("cargado"));
			}else{
				this.dispatchEvent(new Event("error_importacion"));
			}
			
		}
		
		private function importa_meta(dep: XMLList){
			db.inserta_deporte(String(dep.nombre));
			deporte = String(dep.nombre);
			base = dep.base;
		}
		
		private function importa_imagenes(dep: XMLList){

			var dest: File = File.documentsDirectory.resolvePath("piz/img/"+dep.nombre);
			var fuente: File = new File(to_base(_fichero)+"/"+dep.nombre);
			trace("de " + fuente.nativePath);
			trace("a " + dest.nativePath);
			if(fuente.exists){
				fuente.copyTo(dest,false);
			}
		}
		
		private function importa_elementos(elems: XMLList){
			
			var el: Elemento;
			for(var i= 0; i< elems.elemento.length(); i++){
				trace(elems.elemento[0].nombre);
				el = new Elemento(base*100+i,
								  elems.elemento[i].nombre,
								  elems.elemento[i].tipo,
								  elems.elemento[i].url,
								  elems.elemento[i].altura,
								  elems.elemento[i].anchura);
				db.inserta_elemento(el);
				db.inserta_relacion_elemento(deporte, el.id);
			}
		}
		private function copia_imagen(url: String){
			var dest: File = File.documentsDirectory.resolvePath("img/" + url + ".png");
			var fuente: File = new File(to_base(_fichero)+url +".png");
			trace("de " + fuente.nativePath);
			trace("a " + dest.nativePath);
			fuente.copyTo(dest,false);
		}
		
		private function to_base(url: String): String{
			var ruta: String = new String();
			var trozos: Array;
			
			trozos = url.split("\\");
			for(var i=0; i< trozos.length - 1; i++){
				ruta += trozos[i] + "\\";
			}
			return ruta;
		}
		
		private function importa_fondos(fondos: XMLList){
			var fondo: Fondo;
			for(var i= 0; i< fondos.fondo.length(); i++){
				fondo = new Fondo(base*100+i,
								  fondos.fondo[i].url,
								  fondos.fondo[i].nombre,
								  fondos.fondo[i].altura_m,
								  fondos.fondo[i].anchura_m,
								  fondos.fondo[i].altura,
								  fondos.fondo[i].anchura);
				//db.inserta_fondo(fondo);
				//db.inserta_relacion_fondo(deporte, fondo.id);
			}
		}
		
		//			EJERCICIO
		private function importa_ejercicio(ej: XMLList){
			monta_ejercicio(ej);
			this.dispatchEvent(new Event("cargado"));
		}
		
		private function monta_ejercicio(e: XMLList){
			
			var es: Escena;
			var esc: Array = new Array();
			var mov: Movimiento;
			var movs: Array = new Array();
			var aux_e: XMLList;
			var aux_m: XMLList;
						
			ej = new Ejercicio(-1, e.nombre, e.info, e.fecha, e.tipo, e.deporte, e.fondo);
			//ej.imprime_ejercicio();
			for(var i=1; i< e.escenas.escena.length(); i++){
				aux_e = e.escenas.escena[i];
				trace(aux_e.movimientos.movimiento[0]);
				es = new Escena(aux_e.id_escena, aux_e.tipo, aux_e.duracion, aux_e.texto, aux_e.audio);
				es.escribe_escena();
				for(var j=0; j< aux_e.movimientos.movimiento.length(); j++){
					aux_m = aux_e.movimientos.movimiento[j];
					trace(aux_m);
				}
			}
		}
		
		public function get error():String{
			return _errores;
		}
	}
}