﻿package org.pizarra.data{	

	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	import flash.events.Event;
	import org.pizarra.data.Base_Datos;
	import flash.net.*;
	import flash.geom.Point;
	import flash.events.EventDispatcher;
	
	public class Importador extends EventDispatcher{
		
		var file:File;
		var stream:FileStream = new FileStream();	
		var ejercicios: Array;
		var xml: XML;
		private var ej: Ejercicio = null;
		var esc: Escena;
		var mov: Movimiento;
		var bd: Base_Datos;
		var myXML:XML;
		private var _preparado: Boolean = false;
		private var _inicializado:Boolean = false;
		private var _error: String;
		private var id: int;
		
		public function Importador( id: int): void{
			this.id = id;
		}
		
		public function get error():String{
			return _error;
		}
		
		public function ejercicio_correcto(fichero: String){
			trace("cargando: " + fichero);
			_inicializado = true;
			var myLoader:URLLoader = new URLLoader();
			myLoader.load(new URLRequest(fichero));
			myLoader.addEventListener(Event.COMPLETE, processXML);			
		}
		
		function processXML(e:Event):void {
			try{
				myXML = new XML(e.target.data);
				procesa_ej();
				_preparado = true;
			} catch (e:TypeError) {
            	trace("No se pudo parsear el XML\n" + e.message);
				_error = "Fichero corrupto \n" + e.message;
				this.dispatchEvent(new Event("error_XML"));
         	}
		}
		
		function procesa_ej(){
			
			var i,j,k: int = 0;
			var esc_xml: XML;
			var esc: Escena;
			var escs: Array = new Array();
			var mov_xml: XML;
			var mov: Movimiento;
			var tra_xml: XML;
			var tr: Array = new Array();
			var movs:Array = new Array();
			var p, p2: Point;
			//var ej: Ejercicio;
			
			xml = myXML.ejercicio[0];
			escs.push(0);	//	completa el hueco
			ej = new Ejercicio(int(xml.id),xml.nombre,String(xml["info"]),String(xml.fecha),int(xml.tipo),xml.deporte,xml.audio);
			
			for(i = 0; i< xml.escena.length(); i++){		// para cada escena
				esc_xml = xml.escena[i];
				esc = new Escena(esc_xml.id_escena, esc_xml.tipo,esc_xml.duracion , esc_xml.texto, "");
				movs = new Array();
				for(j=0; j<esc_xml.movimiento.length(); j++){		//	para cada movimiento
					mov_xml = esc_xml.movimiento[j];
					p = new Point(mov_xml.iniciox,mov_xml.inicioy);
					mov = new Movimiento(j,mov_xml.tipo,p,p,0,mov_xml.elemento,mov_xml.etiqueta,0);
					tr = new Array();
					for(k = 0; k<mov_xml.trayectoria.punto.length(); k++){//	para cada punto
						tra_xml = mov_xml.trayectoria.punto[k];
						p2 = new Point(tra_xml.x, tra_xml.y);
						tr.push(p2);
					}
					mov.set_trayectorias(tr);
					movs.push(mov);
				}
				esc.set_movimientos(movs);
				escs.push(esc);
			}
			ej.set_escenas(escs);
			ej.set_id(id);
			this.dispatchEvent(new Event("cargado"));
		}
		
		
		public function get preparado(){
			return _preparado;
		}
		
		public function get init(){
			return _inicializado;
		}
		
		public function get ejercicio(): Ejercicio{
			return ej;
		}
	}
}