﻿package org.pizarra.data{	
	
	import org.pizarra.configuracion.Preferencias;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	import flash.events.Event;
	import flash.net.*;

	public class Exportador_Servidor{
		
		private var _ejs: Array;
		private var _prefs: Preferencias;
		private var PING_PAGE: String = "ping.php";
		private var EXER_PAGE: String = "escribe_ejercicio.php";
		private var ESC_PAGE: String = "escribe_escena.php";
		private var MOV_PAGE: String = "escribe_movimiento.php";
		private var TRA_PAGE: String = "escribe_trayectoria.php";
		private var PING_OK_ANSWER: String = "ACK";
		
		public function Exportador_Servidor(ejs: Array,prefs: Preferencias){
			
			_ejs = ejs;
			_prefs = prefs;
			comprueba_conexion();
		}
		
		function comprueba_conexion(){
			
			var url_ping = "http://" + _prefs.server +"/"+ PING_PAGE ;
			var loader:URLLoader = new URLLoader();
			
			loader.load(new URLRequest(url_ping));
			loader.addEventListener(Event.COMPLETE,
				function(evt: Event):void {
					if(evt.target.data == PING_OK_ANSWER){
						exporta();
					}else{
						trace("no se puede conectar");
					}
				}
			);
			loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR,io_error	);
		}
		function io_error(evt: Event):void {
			trace("error de conexión");
		}
		
		function ex_complete(evt: Event):void {
			
			for(var i = 0; i< _ejs.length; i++){
				if(_ejs[i].get_id() == int(evt.target.data)){
					escribe_escenas(_ejs[i]);
				}
			}
		}
		
		function exporta(){
			var url:String;
			
			for(var i=0; i< _ejs.length; i++){
				url = "http://" + _prefs.server +"/"+ EXER_PAGE;
				url +="?id=" + _ejs[i].get_id();
				url +="&titulo=" + _ejs[i].get_nombre();
				url +="&info=" + _ejs[i].get_info();
				url +="&fecha=" + _ejs[i].get_fecha();
				url +="&tipo=" + _ejs[i].get_tipo();
				url +="&deporte=" + _ejs[i].get_deporte();
				url +="&fondo=" + _ejs[i].fondo;
				url +="&usuario=pots";
				
				var loader:URLLoader = new URLLoader();
				loader.load(new URLRequest(url));
				loader.addEventListener(Event.COMPLETE,ex_complete);
				loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR,io_error	);
			}
		}
		
		private function escribe_escenas(ej: Ejercicio){
			
			var url:String;
			for(var i=1; i< ej.num_escenas(); i++){
				url = "http://" + _prefs.server +"/"+ ESC_PAGE;
				url +="?id_escena=" + ej.get_escena(i).get_id();
				url +="&id_ejercicio=" + ej.get_id();
				url +="&tipo=" +  ej.get_escena(i).tipo;
				url +="&duracion=" +  ej.get_escena(i).duracion;
				url +="&texto=" +  ej.get_escena(i).get_texto();
				url +="&audio=" +  ej.get_escena(i).audio;
				var loader:URLLoader = new URLLoader();
				loader.load(new URLRequest(url));
				loader.addEventListener(Event.COMPLETE,es_complete);
				loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR,io_error	);
			}
		}
		
		private function es_complete(e: Event){
			//escribe_movimientos(e.target.data.split("-")[0],e.target.data.split("-")[1]);
			for(var i = 0; i< _ejs.length; i++){
				if(_ejs[i].get_id() == int(e.target.data.split("-")[1])){
					escribe_movimientos(e.target.data.split("-")[0],_ejs[i]);
				}
			}
		}
		
		private function escribe_movimientos(esc: int, ej: Ejercicio){
			
			var url:String;

			for(var i=0; i< ej.get_escena(esc).num_movimientos(); i++){
				url = "http://" + _prefs.server +"/"+ MOV_PAGE;
				url +="?id_escena=" + esc;
				url +="&id_ejercicio=" + ej.get_id();
				url +="&id_movimiento=" + i;
				url +="&x_ini=" +  ej.get_escena(esc).get_movimiento(i).get_x_ini();
				url +="&x_fin=" +  ej.get_escena(esc).get_movimiento(i).get_x_fin();
				url +="&y_fin=" +  ej.get_escena(esc).get_movimiento(i).get_y_fin();
				url +="&y_ini=" +  ej.get_escena(esc).get_movimiento(i).get_y_ini();
				url +="&tipo=" +  ej.get_escena(esc).get_movimiento(i).get_tipo();
				url +="&elemento=" +  ej.get_escena(esc).get_movimiento(i).get_elemento();
				url +="&rotacion=" +  ej.get_escena(esc).get_movimiento(i).get_rotacion();
				url +="&etiqueta=" +  ej.get_escena(esc).get_movimiento(i).get_etiqueta();
				
				var loader:URLLoader = new URLLoader();
				loader.load(new URLRequest(url));
				loader.addEventListener(Event.COMPLETE,mov_complete);
				loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR,io_error	);
			}
		}
		
		private function mov_complete(e:Event){
			/*trace(e.target.data);
			trace(e.target.data.split("-")[0]);
			trace(e.target.data.split("-")[1]);
			trace(e.target.data.split("-")[2]);*/
			for(var i = 0; i< _ejs.length; i++){
				if(_ejs[i].get_id() == int(e.target.data.split("-")[0])){
					for(var j = 1; j< _ejs[i].num_escenas(); j++){
						if(_ejs[i].get_escena(j).get_id() == int(e.target.data.split("-")[1])){
							for(var k = 0; k< _ejs[i].get_escena(j).num_movimientos(); k++){
								if(_ejs[i].get_escena(j).get_movimiento(k).id == int(e.target.data.split("-")[2])){
									escribe_trayectorias(_ejs[i].get_escena(j).get_movimiento(k),_ejs[i].get_id(),j);
								}
							}
						}
					}
				}
			}
		}
		
		private function escribe_trayectorias(m: Movimiento, ej: int, esc: int){
			
			var url:String;
			m.escribe_movimiento();
			for(var i=0; i< m.get_trayectorias().length; i++){
				
				url = "http://" + _prefs.server +"/"+ TRA_PAGE;
				url +="?id_escena=" + esc;
				url +="&id_ejercicio=" + ej;
				url +="&id_movimiento=" + m.id;
				url +="&x=" + m.get_trayectoria(i).x;
				url +="&y=" + m.get_trayectoria(i).y;
				
				var loader:URLLoader = new URLLoader();
				loader.load(new URLRequest(url));
				loader.addEventListener(Event.COMPLETE,tra_complete);
				loader.addEventListener(flash.events.IOErrorEvent.IO_ERROR,io_error	);
			}
		}
		
		private function tra_complete(e: Event){
			
			trace(e.target.data);

		}
	}
}
