﻿package org.pizarra.data{	

	import flash.filesystem.File;
	import flash.filesystem.FileMode;
	import flash.filesystem.FileStream;
	import org.pizarra.Ejercicio;
	import org.pizarra.Escena;
	import org.pizarra.Movimiento;
	
	public class Exportador{
		
		var file:File;
		var stream:FileStream = new FileStream();	
		var ejercicios: Array;
		var xml: XML;
		var ej: Ejercicio;
		var esc: Escena;
		var mov: Movimiento;
		var bd: Base_Datos;

		public function Exportador(fichero: String, bd: Base_Datos ): void{
			xml= <data>
					<type>Ejercicio</type>
				</data>;
			file = File.desktopDirectory.resolvePath( fichero);
			this.bd = bd;
		}
	
		public function set_ejercicios(ejs: Array){
			this.ejercicios = ejs;
			ejs[0] = bd.lee_ejercicio(ejs[0].get_id(),ejs[0]);
			ej = ejs[0];
			escribe_ejercicios();
		}
		
		private function escribe_ejercicios(){
			var i,j: int;
			var xml_ej: XML;
		
			xml_ej = ej_to_XML(ej); 
			for(j=1; j< ej.num_escenas(); j++){
				xml_ej.appendChild(esc_to_XML(ej.get_escena(j)));
			}
			xml.appendChild(xml_ej);
		}
		
		private function ej_to_XML(e: Ejercicio): XML{
			var item:XML = <ejercicio>
						</ejercicio>
			item.id = e.get_id();
			item.tipo = e.get_tipo();
			item.deporte = e.get_deporte(); 
			item.nombre = e.get_nombre();
			item.fecha = e.get_fecha();
			item.info = e.get_info();
			item.fondo = e.fondo;
			return item;
		}
		
		private function escribe_escena(esc: Escena){
			var i: int;
			for(i=0; i< ejercicios.length; i++){		//	Para todos los ejercicios
				xml.ejercicios.appendChild(ej_to_XML(ejercicios[i]));  
			}
		}
		
		private function esc_to_XML(esc: Escena): XML{
			
			var i: int;
			var item:XML = 	<escena>
							</escena>
			var mov: Movimiento;
			item.id_escena = esc.get_id();
			item.id_ejercicio = ej.get_id();
			item.tipo = esc.tipo;
			item.duracion = esc.duracion; 
			item.texto = esc.get_texto();
			item.audio = esc.audio;
			for(i=0; i< esc.num_movimientos(); i++){
				mov = esc.get_movimiento(i);
				//mov.escribe_movimiento();
				item.appendChild(mov_to_XML(mov,i,esc.get_id()));
			}
			return item;
		}
		
		private function mov_to_XML(mov: Movimiento,n: int,m: int): XML{
			var item:XML = 	<movimiento>
							</movimiento>
			var tray:XML = 	<trayectoria>
							</trayectoria>
			var punto: XML =	<punto>
								</punto>
			var tr: Array = mov.get_trayectorias();
			
			item.id_ejercicio = ej.get_id();
			item.id_escena = m;
			item.id_movimiento = n; 
			item.tipo = mov.get_tipo();
			item.iniciox = mov.get_x_ini();
			item.inicioy = mov.get_y_ini();
			item.elemento = mov.get_elemento();
			item.etiqueta = mov.get_etiqueta();
			
			for(var i: int = 0; i<tr.length; i++){
				tray.appendChild(punto_xml(tr[i].x,tr[i].y));
			}
			item.appendChild(tray);
			return item;
		}
		
		public function punto_xml(x: int, y: int): XML{
			var punto: XML =	<punto>
								</punto>
			punto.x = x;
			punto.y  =y;
			return punto;
		}
		
		public function escribe_fichero(){
		
			stream.open( file, FileMode.WRITE );
			stream.writeUTFBytes( xml.toXMLString());
			stream.close();
			file = null;
			stream = null; 
		}
		
	}
}